<?php
namespace App;

use Ratchet\Client\Connector as RatchetConnector;
use Ratchet\Client\WebSocket;
use Ratchet\RFC6455\Messaging\MessageInterface;
use React\EventLoop\Factory;
use React\EventLoop\LoopInterface;
use React\Socket\Connector as SocketConnector;
//use Exceptions\BusinessException;
//use Exceptions\NoAvailableWebSocketServerException;


class WebSocketApi
{
    /** @var LoopInterface */
    protected $loop;
    protected $i = 0;
    protected static $isDebugMode = false;
    /**
     * Get the event loop instance, default return Factory::create()
     * @return LoopInterface
     */
    public function getLoop()
    {
        if ($this->loop === null) {
            $this->loop = Factory::create();
        }
        return $this->loop;
    }

    /**
     * Set the event loop instance
     * @param LoopInterface $loop
     */
    public function setLoop(LoopInterface $loop)
    {
        $this->loop = $loop;
    }

    /**
     * Subscribe multiple channels by url
     * @param array $server
     * @param array $channels
     * @param callable $onMessage
     * @param callable|null $onClose
     * @param array $options
     * @throws \Exception|\Throwable
     */
    public function subscribeChannels(array $server, array $channels, callable $onMessage, callable $onClose = null, array $options = [])
    {
        if (!isset($options['tls']['verify_peer'])) {
            $options['tls']['verify_peer'] = true;
        }

        $loop = $this->getLoop();
        $reactConnector = new SocketConnector($loop, $options);
        $connector = new RatchetConnector($loop, $reactConnector);
/* binance
        $loop = \React\EventLoop\Factory::create();
        $react = new \React\Socket\Connector($loop);
        $connector = new \Ratchet\Client\Connector($loop, $react);
*/
        /**
         * @var \Exception|\Throwable $exception
         */
        $exception = null;
        $connector($server['connectUrl'])->then(function (WebSocket $ws) use ($server, $channels, $onMessage, $onClose, $loop) {
            // Add timer to send ping message
            $pingTimer = $loop->addPeriodicTimer($server['pingInterval'] / 1000 - 1, function () use ($ws) {
                try {
                    $ping = $this->createPingMessage();
                    $pingStr = json_encode($ping);
                     if (self::$isDebugMode) {
                        static::getLogger()->debug(sprintf('Sent a WebSocket message: %s', $pingStr));
                    }
                    // fputs(STDIN, print_r($ping, true));
                    $ws->send($pingStr);
                } catch (\Exception $e) {
                    // Ignore this exception
                }
            });

            $ws->on('message', function (MessageInterface $msg) use ($server, $ws, $channels, $onMessage, $loop, $pingTimer) {
                $msgStr = $msg->__toString();
                if (self::$isDebugMode) {
                    static::getLogger()->debug(sprintf('Received a WebSocket message: %s', $msgStr));
                }

                $msgArray = json_decode($msgStr, true);

                if (!isset($msgArray['type'])) {
                    var_dump('Invalid format of message without type: ' . $msgStr); //quitar
                    //throw new BusinessException('Invalid format of message without type: ' . $msgStr);
                }
                switch ($msgArray['type']) {
                    case 'welcome':
                        // Do subscribe

                        if (!isset($msgArray['id']) || $msgArray['id'] === $server['connectId']) {
                            foreach ($channels as $channel) {
                                $ws->send(json_encode($channel));
                            }
                        }
                        break;
                    case 'ack':
                    case 'ping':
                    case 'pong':
                        // fputs(STDIN, print_r($msgArray, true));
                        break;
                    case 'error':
                        $loop->cancelTimer($pingTimer);
                        //throw new BusinessException('Error: ' . $msg);
                        var_dump('**********************+Error**************: ' . $msg);
                    case 'message':
                        $this->i = $this->i + 1;
                        $i = $this->i * 1;
                        call_user_func($onMessage, $msgArray, $ws, $loop, $pingTimer, $i);
                        break;
                    default:
                        //throw new BusinessException('Unknown type: ' . $msgArray['type']);
                        var_dump('Unknown type: ' . $msgArray['type']);
                }
            });
            $ws->on('close', function ($code = null, $reason = null) use ($onClose, $loop, $pingTimer) {
                if (is_callable($onClose)) {
                    call_user_func($onClose, $code, $reason);
                }
                $loop->cancelTimer($pingTimer);
            });
        }, function ($e) use ($loop, &$exception) {        
            $exception = $e;
        });

        $loop->run();

        if ($exception !== null) {
            throw $exception;
        }
    }

    /**
     * Subscribe multiple public channels
     * @param array $channels
     * @param callable $onMessage
     * @param callable|null $onClose
     * @param array $options
     * @throws \Exception|\Throwable
     */
    public function subscribePublicChannels($server, array $channels, callable $onMessage, callable $onClose = null, array $options = [])
    {
        if (!isset($channels[0])) {
            $channels = [$channels];
        }
        array_walk($channels, function (&$channel) {
            if (!isset($channel['id'])) {
                $channel['id'] = uniqid('', true);
            }
            $channel['type'] = 'subscribe';
            $channel['privateChannel'] = false;
        });
        $this->subscribeChannels($server, $channels, $onMessage, $onClose, $options);
    }

    /**
     * Subscribe multiple private channels
     * @param array $channels
     * @param callable $onMessage
     * @param callable|null $onClose
     * @param array $options
     * @throws \Exception|\Throwable
     */
    public function subscribePrivateChannels($server, array $channels, callable $onMessage, callable $onClose = null, array $options = [])
    {
        if (!isset($channels[0])) {
            $channels = [$channels];
        }
        array_walk($channels, function (&$channel) {
            if (!isset($channel['id'])) {
                $channel['id'] = uniqid('', true);
            }
            $channel['type'] = 'subscribe';
            $channel['privateChannel'] = true;
        });
        $this->subscribeChannels($server, $channels, $onMessage, $onClose, $options);
    }


    /**
     * Create a ping message
     * @param string $id
     * @return array
     */
    public function createPingMessage($id = null)
    {
        return ['id' => $id ?: uniqid('', true), 'type' => 'ping'];
    }

    /**
     * Create a subscription message
     * @param string $topic
     * @param bool $privateChannel
     * @param bool $response
     * @param string $id
     * @return array
     */
    public function createSubscribeMessage($topic, $privateChannel = false, $response = true, $id = null)
    {
        return ['id' => $id ?: uniqid('', true), 'type' => 'subscribe', 'topic' => $topic, 'privateChannel' => $privateChannel, 'response' => $response];
    }

    /**
     * Create an unsubscribe message
     * @param string $topic
     * @param bool $privateChannel
     * @param bool $response
     * @param string $id
     * @return array
     */
    public function createUnsubscribeMessage($topic, $privateChannel = false, $response = true, $id = null)
    {
        return ['id' => $id ?: uniqid('', true), 'type' => 'unsubscribe', 'topic' => $topic, 'privateChannel' => $privateChannel, 'response' => $response];
    }
}
