<?php
namespace App;


class TelegramTemplate
{
    /**
     * @var string
     */
    protected $alert = '
<b>
*******  "Alerta ********
*** intervalo: 15m DMI ***
</b>{accion}
';
    /**
     * @var string
     */
    protected $openorder = '
<b>**** Apertura de ordenes con DMI (Kucoin) ****</b>
<b>**** {accion} ****</b>
UTC - Apertura: {fechaope} Cierre: {fechaclo}
{locale} 
<b>*** intervalo: {interval} ***
DMI3: {dmi3}
DMI15: {dmi15} 
*** intervalo: {interlow} *** 
ADX3m: {adx3m} ADX3ma: {adx3ma}
ape. precio: {open} | ult. precio: {close}</b>
';
    /**
     * @var string
     */
    protected $closeorder = '
<b>**** Cierre de ordenes (Kucoin) ****</b>
{locale}
<b>******* {accion} ordenada ********</b> 
95 % balance diponible: {avBal} 
precio: {price} 
cantidad: {qty} 
total ordenado: {ordenado} 
Apalancamiento: {porLe} 
{headpro}
TP: % {porTp} precio: {impTp} 
SL: % {porSm} precio: {impSm} 
balance diponible al final: {enBal} 
';
        /**
     * @var string
     */
    protected $cancelorder = '
<b>**** Cierre de ordenes (Kucoin) ****</b>
{locale}
{cancel}
'; 
    private function getContent($replace = [], $template)
    {
        $content = strtr($template, $replace);
        return $content;
    }


    private function setOpenOrder($valret)
    {
        $orgDate = intval($valret['tim']);        
        $date = new \DateTime(date('m/d/Y H:i:s',$orgDate));
        $date->setTimeZone(new \DateTimeZone($valret['timezone']));
        $content_replace = array(
            '{accion}'   => $valret["accion"] ,
            '{fechaope}' => $valret["fechaope"],
            '{fechaclo}' => $valret["fechaclo"],
            '{locale}' => $valret['locale'] . $date->format('Y-m-d H:i:s'),
            '{interval}' => $valret['interval'],
            '{dmi3}' => $valret["dmi3"],
            '{dmi15}' => $valret["dmi15"],  
            '{interlow}' =>  $valret['interlow'],
            '{adx3m}' => $valret["adx3m"],
            '{adx3ma}' => $valret["adx3ma"],
            '{open}' => number_format($valret["open"], 2, ',', '.'),
            '{close}' => number_format($valret["close"], 2, ',', '.')
        );
        $content = $this->getContent($content_replace, $this->openorder);
        return $content;
    }
    private function setCloseOrder($valret)
    {
        $resCV = $valret['resCV'];
        $date = new \DateTime('now');
        $date->setTimeZone(new \DateTimeZone($valret['timezone']));
        if($resCV['doit'] === 1){
            if ($resCV["Tp"]){
                $headpro = "****** Tp Protegido ******";
            }else{
                if ($resCV["camSm"]){
                    $headpro = "****** Sl Protegido ******";
                }else{
                    $headpro = " ****** Sl Perdida ******";                
                }
            }
            $content_replace = array(
                '{locale}' => $valret['locale'] . '- Cierre : ' . $date->format('Y-m-d H:i:s'),
                '{cierre}' => $date->format('Y-m-d H:i:s'),
                '{accion}' => $valret["accion"],
                '{avBal}' => $resCV["avBal"],
                '{price}'=> $resCV["price"],
                '{qty}' => $resCV["qty"],
                '{ordenado}' => ($resCV["price"] * $resCV["porLe"]),
                '{porLe}' => $resCV["porLe"],
                '{headpro}' => $headpro,
                '{porTp}' => $resCV["porTp"],
                '{impTp}' => $resCV["impTp"],
                '{porSm}' => $resCV["porSm"],
                '{impSm}' => $resCV["impSm"],
                '{enBal}' => $resCV["enBal"],
            ); 
            $content = $this->getContent($content_replace, $this->closeorder);           
        }else{
            $content_replace = array(
                '{locale}' => $valret['locale'] . '- Cierre : ' . $date->format('Y-m-d H:i:s'),
                '{cancel}' => "<b>****" . $valret["accion"] . " cancelada" .  " ****</b>"
            ); 
            $content = $this->getContent($content_replace, $this->cancelorder);  
        }
        return $content;
    }

    public function getTemplateAlert($valret)
    {
        $content_replace = array(
            '{accion}'   => $valret
        );
        $content = $this->getContent($content_replace, $this->alert);
        return $content;
    }

    public function getTemplateOrder($valret)
    {
        if($valret["init"] === 0){
            $template = $this->setOpenOrder($valret);
        }else{
            $template = $this->setCloseOrder($valret);    
        };
        return $template;
    }
}

