<?php
namespace App;
use App\ResponseApi;
use App\SendTelegram;
include  'OrdersModel.php';
class SetOrdersBuySel
{
    /**
     * @var ResponseApi
     */
    protected $apiResponse;
    /**
     * @var SendTelegram
     */
     protected $apiTelegram;
    /**
     * @var OneMaOrder
     */
    protected $oneMaOrder;
    protected $maOrderId;

    protected $oneTpOrder;
    protected $tpOrderId;
    protected $oneSlOrder;
    protected $slOrderId;
    protected $avaBalance;
    protected $maOrderPrice;
    protected $currentPrice;
    protected $orderQty;
    protected $orderLev;
    protected $maSide;
    protected $otSide;
    protected $symbol = '';
    protected $porIni = [];
    protected $retval = [
        "price" => 0,
        "avBal" => 0,    
        "qty" => 0,
        "porLe" => 1,
        "porAv" => 0,
        "porTp"  => 0,
        "porSm"  => 0,
        "impTp" => 0,
        "impSm" => 0,
        "camSm" => false,
        "doit" => 0,
        "delor" => 0,
        "enBal" => 0,
        "Tp" => false,
        "Sm" => false
    ];
    /**
     * @var OneMaOrder $marorder
     */
    protected $maorder;
    /**
     * @var OneTpOrder $tporder
     */
    protected $tporder;
    /**
     * @var OneSlOrder $slorder
     */
    protected $slorder;
    protected $config;
     public function __construct($order)
     {
        //$order['leverage'] = 4;
        //$order['size'] = 4;
        $this->apiResponse = new ResponseApi();
        $this->apiTelegram = new SendTelegram();
        $this->maorder = (array) new \OneMaOrder($order);
        $this->tporder = (array) new \OneTpOrder($order);
        $this->slorder = (array) new \OneSlOrder($order);
        $settings = require  __DIR__ . '/../../settings.php';
        $this->config = $settings['settings']['config'];

     }
     private function getOrderById($orderId){
        $times = 0;
        while(true){
            $result = $this->apiResponse->getOrderById($orderId, $times);
            if (array_key_exists("id", $result)) {
                return $result['dealValue']; 
                break;
            }else{
                $times = $times + 1;
                if ($times > 5){
                    return 0; 
                    break;
                }
            }            
        }        
     }     
     private function createMaOrder(){
        $times = 0;
        while(true){

            $result = $this->apiResponse->createOrder($this->maorder, $times);
            if (array_key_exists("orderId", $result)) {
                $this->maOrderId = $result['orderId'];
                sleep(5);
                $price = $this->getOrderById($this->maOrderId);
                if($price > 0){
                    $this->retval['doit'] = 1;   
                    $this->retval['price'] = $price  / $this->retval['porLe']; 
                }else{
                    $this->retval['doit'] = 0;   
                    $this->retval['price'] = 0; 
                }
                break;
            }else{
                $times = $times + 1;
                if ($times > 5){
                    $this->retval['doit'] = 0;   
                    $this->retval['price'] = 0; 
                    break;
                }
            }
        }
        return $this->retval;
     }
     private function createTpOrder(){
        $times = 0;
        $resp = false;
        while(true){
            $result = $this->apiResponse->createOrder($this->tporder, $times);
            if (array_key_exists("orderId", $result)) {
                $this->tpOrderId = $result['orderId'];
                $resp = true;
                break;
            }else{
                $times = $times + 1;
                if ($times > 5){
                    $resp = false;
                    break;
                }
            }
        }
        return $resp;
     }
     private function createSlOrder(){
        $times = 0;
        $resp = false;
        while(true){
            $result = $this->apiResponse->createOrder($this->slorder, $times);
            if (array_key_exists("orderId", $result)) {
                $this->slOrderId = $result['orderId'];
                $resp = true;
                break;
            }else{
                $times = $times + 1;
                if ($times > 5){
                    $resp = false;
                    break;
                }
            }
        }
        return $resp;
     }
     private function getOrderStatusMa(){
        $times = 0;
        $status = 1;
        while(true){
            $result = $this->apiResponse->getStatus(['symbol' => $this->symbol], $times);
            if (array_key_exists("currentQty", $result)) {
                $status = $result['currentQty'];
                break;
            }else{
                $times = $times + 1;
                if ($times > 5){
                    $status = 1;
                    break;
                }
            }
        }
        return $status;        
     }
     private function getOrderStatusTp(){
        $times = 0;
        $status= 'open';
        while(true){
            $result = $this->apiResponse->getOrderById($this->tpOrderId, $times);
            if (array_key_exists("stop", $result)) {
                $status = $result['status'];
                break;
            }else{
                $times = $times + 1;
                if ($times > 5){
                    $status= 'false';
                    break;
                }
            }
        }
        return $status;
     }
     private function getOrderStatusSl(){
        $times = 0;
        $status= 'open';
        while(true){
            $result = $this->apiResponse->getOrderById($this->slOrderId, $times);
            if (array_key_exists("stop", $result)) {
                $status = $result['status'];
                break;
            }else{
                $times = $times + 1;
                if ($times > 5){
                    $status= 'false';
                    break;
                }
            }
        }
        return $status;
     }
     private function calcVaria($CV, $statusTp = 'open', $statusSm = 'open'){
        $priceNow = $this->getPrice();
        if ($priceNow > 0) {  
            if($CV === 1){ //Compras
                //SI EL PRECIO ES>= PRECIO DE ENTRADA + 0,5% CAMBIA EL SL DE -0,5% A PRECIO DE ENTRADA (FILTRO PROTECCION DE SL)
                //CAMBIO A 1% EL 27/12/2023
                $preOpe = number_format(round($this->maOrderPrice +  (($this->maOrderPrice * 1) / 100),3), 3, '.', ',');
                if($priceNow  >= $preOpe){
                    print(' Compras - priceNow:' . $priceNow . ' preOpe:' . $preOpe .chr(10)); 
                    $resp = $this->delOneOrder($this->slOrderId);
                    if ($resp){
                        $this->printLog(" Eliminada slOrderId:" . $this->slOrderId  . chr(10)); 
                        $this->slorder['stopPrice'] = $this->maOrderPrice;
                        $this->slorder['clientOid'] = str_replace("SL", "SLC", $this->slorder['clientOid']);
                        $respSl = $this->createSlOrder();
                        if($respSl){
                            $this->printLog(" Nueva slOrderId:" . $this->slOrderId  . chr(10)); 
                            $this->apiTelegram->sendAlertTelegram("Cambia precio de Sl en Compras a $this->maOrderPrice");
                            $this->retval["porSm"] = 1.0;
                            $this->retval['camSm'] = true;
                            $this->retval['impSm'] = $this->maOrderPrice;
                            $this->printLog(" Comp.- preOpe:" . $preOpe . chr(10)); 
                        }else{
                            $this->retval['camSm'] = false;
                            $this->sendAlertTelegram("No es posible cambiar precio de Sl en Compras a $this->maOrderPrice");                                
                        }
                    }
                }
            }else{ //Ventas
                //SI EL PRECIO ES<= PRECIO DE ENTRADA - 0,5% CAMBIA EL SL DE +0,5% A PRECIO DE ENTRADA (FILTRO PROTECCION DE SL)
                //CAMBIO A 1% EL 27/12/2023
                $preOpe = number_format(round($this->maOrderPrice -  (($this->maOrderPrice * 1) / 100),3), 3, '.', ',');
                if($priceNow  <= $preOpe){
                    print(' Ventas - priceNow:' . $priceNow . ' preOpe:' . $preOpe .chr(10)); 
                    $statusLi = $this->getOrderStatusMa();
                    $resp = $this->delOneOrder($this->slOrderId);
                    if ($resp){
                        $this->printLog(" Eliminada slOrderId:" . $this->slOrderId  . chr(10));  
                        $this->slorder['stopPrice'] = $this->maOrderPrice;
                        $this->slorder['clientOid'] = str_replace("SL", "SLC", $this->slorder['clientOid']);
                        $respSl = $this->createSlOrder();
                        if($respSl){
                            $this->printLog(" Nueva slOrderId:" . $this->slOrderId  . chr(10)); 
                            $this->apiTelegram->sendAlertTelegram("Cambia precio de Sl en Ventas a $this->maOrderPrice");
                            $this->retval["porSm"] = 1.0;
                            $this->retval['camSm'] = true;
                            $this->retval['impSm'] = $this->maOrderPrice;
                            $this->printLog(" Vent.-  preOpe:" . $preOpe . chr(10));
                        }else{
                            $this->retval['camSm'] = false;
                            $this->apiTelegram->sendAlertTelegram("No es posible cambiar precio de Sl en Ventas a $this->maOrderPrice");                                
                        }
                    }
                }                                             
            }
        }
    }
    private function cntrOrders($CV){
        $resp = false;
        $resp = $this->apiResponse->getPrivateBullet(['connectId' => uniqid('', true)], $this->symbol);
        if($resp['stop'] === 'up'){
            $this->retval['Tp'] = true;
            $this->retval['Sm'] = false; 
            $this->setLastLeverage(1);                   
        }else{
            $this->retval['Sm'] = true;                      
            $this->retval['Tp'] = false;   
            if(!$this->retval["camSm"]){
                $this->setLastLeverage(10);
            }else{
                $this->setLastLeverage(1);
            }                    
        }
        $statusLi = $this->getOrderStatusMa();
        $statusTp = $this->retval['Tp']?'done':'close';
        $statusSm = $this->retval['Sm']?'done':'close';
        $this->printLog("now:".  date("Y-m-d H:i:s") . " 4.-B statusTp:" . $statusTp . " statusSm:" . $statusSm . " statusLi:" . $statusLi . chr(10));        
        if($statusLi !== 0){
            $this->delMaOrder();
        }
        $this->printLog("now:".  date("Y-m-d H:i:s") . " 4.- statusTp:" . $statusTp . " statusSm:" . $statusSm . " statusLi:" . $statusLi . chr(10));         
        $this->retval['doit'] = 1;
    }

    private function cntrOrdersOrg($CV){
        $this->printLog("in cntlOrders" .chr(10));
        while(true){
            $statusLi = $this->getOrderStatusMa();
            $statusTp = $this->getOrderStatusTp();
            $statusSm = $this->getOrderStatusSl(); 
            $this->printLog(" 3.- statusTp:" . $statusTp . " statusSm:" . $statusSm . " statusLi:" . $statusLi . chr(10)); 
            if($statusTp ===  'done' or $statusSm === "done"){ 
                if($statusTp === 'done'){
                    $this->retval['Tp'] = true;
                    $this->retval['Sm'] = false;
                    $this->setLastLeverage(1);
                }else{
                    $this->retval['Sm'] = true;                      
                    $this->retval['Tp'] = false; 
                    if(!$this->retval["camSm"]){
                        $this->setLastLeverage(10);
                    }else{
                        $this->setLastLeverage(1);
                    }                    
                }
                if($statusTp === 'done' and $statusSm !== 'done'){
                    $resp = $this->delOneOrder($this->slOrderId);
                    $this->printLog(" 3.OK - statusTp:" . $statusTp . " statusSm:" . $statusSm . chr(10));
                }elseif($statusSm ===  'done'  and $statusTp !== 'done'){
                    $resp = $this->delOneOrder($this->tpOrderId);
                    $this->printLog(" 3.OK - statusTp:" . $statusTp . " statusSm:" . $statusSm . chr(10));
                }elseif($statusSm ===  'done'  and $statusTp == 'done'){
                    $this->printLog(" 3.OK - statusTp:" . $statusTp . " statusSm:" . $statusSm . chr(10));
                }else{
                    $this->delAllOrders(false);
                }
                sleep(5);
                $statusLi = $this->getOrderStatusMa();
                if($statusLi === 0){
                    $this->printLog(" 4.- statusTp:" . $statusTp . " statusSm:" . $statusSm . " statusLi:" . $statusLi . chr(10));
                    $this->retval['doit'] = 1;
                    break;
                }else{
                    $this->printLog(" 4.KO- statusTp:" . $statusTp . " statusSm:" . $statusSm . " statusLi:" . $statusLi . chr(10));
                    //$this->sendAlert(2, $statusTp, $statusSm, "cntlOrders");  
                    $this->retval['doit'] = 1;
                    $this->delMaOrder();
                    break;
                }
            }elseif($statusTp === "false"){ 
                $this->printLog(" TP 2.- statusTp:" . $statusTp . " statusSm:" . $statusSm . chr(10));
                $statusLi = $this->getOrderStatusMa();
                if($statusLi === 0){
                    $this->delAllOrders(false);
                    $this->sendAlert(0, $statusTp, $statusSm, "cntlOrders");
                    $this->retval['doit'] = 1;
                    break;
                }else{
                    $this->sendAlert(1, $statusTp, $statusSm, "cntlOrders");
                    //$this->retval['doit'] = 0;
                    //break;                  
                }
            }elseif($statusSm === "false"){
                $this->printLog("SL 2.- statusTp:" . $statusTp . " statusSm:" . $statusSm . chr(10));
                $statusLi = $this->getOrderStatusMa();
                if($statusLi === 0){
                    $this->delAllOrders(false);
                    $this->sendAlert(0, $statusTp, $statusSm, "cntlOrders");
                    $this->retval['doit'] = 1;
                    break;
                }else{
                    $this->sendAlert(1, $statusTp, $statusSm, "cntlOrders");
                    //$this->retval['doit'] = 0;
                    //break;                  
                }
            }else{
                if(!$this->retval['camSm']){
                    $resp = $this->calcVaria($CV, $statusTp, $statusSm);
                    sleep(5);
                }
            }
        }
        //}
    }
    private function sendAlert($type, $statusTp, $statusSm, $from){
        $date = new \DateTime('now');
        $tokentel = "UTC: " . $date->format('Y-m-d H:i:s') . chr(10);
        $date->setTimeZone(new \DateTimeZone($this->config['timezone']));
        $tokentel = $tokentel . $this->config['locale'] . $date->format('Y-m-d H:i:s') . chr(10);
        switch ($type) {
            case 0:
                $tokentel = $tokentel . "Se ha detectado una respuesta erronea, " . chr(10);
                $tokentel = $tokentel . " statusTp: " . $statusTp . " statusSm: " . $statusSm . chr(10);
                $tokentel = $tokentel . "proceda a controlar  la orden desde la app" . chr(10);
                $tokentel = $tokentel . "<b>**** position 0 **** </b>" . chr(10);
                break;
            case 1:
                $tokentel = $tokentel . "Se ha detectado una respuesta erronea, " . chr(10);
                $tokentel = $tokentel . " statusTp: " . $statusTp . " statusSm: " . $statusSm . chr(10);
                $tokentel = $tokentel . "proceda a controlar  la orden desde la app" . chr(10);
                $tokentel = $tokentel . "<b>**** position > 0 **** </b>" . chr(10);
                break;
            case 2:
                $tokentel = $tokentel . "No ha sido posible cerrar orden MARKET, " . chr(10);
                $tokentel = $tokentel . "proceda a cerrarla desde la App" . chr(10);
                $tokentel = $tokentel . "<b>**** el bot se ha parado **** </b>" . chr(10);
                $tokentel = $tokentel . "Una vez cerrada la orden, pulse sobre este enlace:" . chr(10);
                $tokentel = $tokentel . "<b>https://glotratecres.com/proces/s15mdmi</b>" . chr(10);
                break; 
            case 3:
                $tokentel = $tokentel . "Se ha detectado una respuesta erronea, " . chr(10);
                $tokentel = $tokentel . "No se podido generar orden MARKET" . chr(10);
                $tokentel = $tokentel . "proceda a controlar  la orden desde la app" . chr(10);
                break;  
            case 4:
                $date->setTimeZone(new \DateTimeZone('America/Argentina/Buenos_Aires'));
                $tokentel = $tokentel . "Argentina-Buenos Aires : " . $date->format('Y-m-d H:i:s') . chr(10);
                $tokentel = $tokentel . "<b>No hay Balance suficiente</b>" . chr(10);
                $tokentel = $tokentel . "No se podido generar orden MARKET" . chr(10);
                $tokentel = $tokentel . "proceda a controlar  la orden desde la app" . chr(10);
                break;                                            
        }  
        $this->apiTelegram->sendAlertTelegram($tokentel);
        if($type === 2){
            exit;
        }
    }
    private function delMaOrder(){
        $this->maorder['clientOid'] = $this->maorder['clientOid'] . 'D';
        $this->maorder['side'] = $this->maorder['side'] === 'buy'?'sell':'buy';
        $this->maorder['closeOrder'] = true;
        $result = $this->createMaOrder();
    }
    private function delAllOrders($init){
        $times = 0;
        while(true){
            $result = $this->apiResponse->cancelAllOrders(['symbol' => $this->symbol],$times);
            if (array_key_exists("cancelledOrderIds", $result)) {
                if($init){
                    $this->maorder['clientOid'] = $this->maorder['clientOid'] . 'D';
                    $this->maorder['side'] = $this->maorder['side'] === 'buy'?'sell':'buy';
                    //$this->maorder['type'] = 'limit';
                    //$this->maorder['price'] = $this->maOrderPrice;
                    $this->maorder['closeOrder'] = true;
                    $result = $this->createMaOrder();
                    //unset($this->maorder['price']);
                    //$this->maorder['type'] = 'market';
                }
            }else{
                $times = $times + 1;
                if ($times > 5){
                    $status= 'false';
                    break;
                } 
            }
        }
    }
    private function delOneOrder($orderid){
        $times = 0;
        $result = false;
        while(true){
            $result = $this->apiResponse->cancelOrderById($orderid, $times);
            if (array_key_exists("cancelledOrderIds", $result)) {
                $result = true;
                break;
            }else{
                $times = $times + 1;
                if ($times > 5){
                    $result = false; 
                    break;
                }                
            }
        }
        return $result;
    } 
    private function getPrice(){
        $times = 0;
        while(true){
            $result = $this->apiResponse->getPrice($this->symbol, $times);
            if (array_key_exists("indexPrice", $result)) {
                $this->currentPrice = $result["indexPrice"];
                break;
            }else{
                $times = $times + 1;
                if ($times > 5){
                    $this->currentPrice = 0; 
                    break;
                }
            }
        } 
        return $this->currentPrice;              
    }  
    private function setLastLeverage($leverage){
        $filename = __DIR__ . "/lastLeveragedmi.txt";
        $file = fopen( $filename, "w" );
        fwrite($file, $leverage);
        fclose( $file );
    }
    
    private function getLastLeverage(){
        $filename = __DIR__ . "/lastLeveragedmi.txt";
        $file = fopen($filename, "r" );
        $filesize = filesize( $filename );
        $leverage = intval(fread( $file, $filesize));
        fclose( $file );
        return ($leverage);
    }
    private function printLog($from){
        $date = (new \DateTime('now'))->format('Y-m-d H:i:s');
        print( $date . ": " . $from );
    }
         
     public function getStatus($symbol){
        $times = 0;
        $status = 1;
        while(true){
            $result = $this->apiResponse->getStatus(['symbol'    => $symbol], $times);
            if (array_key_exists("currentQty", $result)) {
                $status = $result['currentQty'];
                break;
            }else{
                $times = $times + 1;
                if ($times > 5){
                    $status = 1;
                    break;
                }
            }
        }
        return $status;        
     }

     public function setSide($maside, $otside){
        $this->maorder['side'] = $maside;
        $this->tporder['side'] = $otside;
        $this->slorder['side'] = $otside;
        $this->maSide = $maside;
        $this->otSide = $otside;
    }
    public function setQty(){
        $this->maorder['size'] = $this->orderQty;
        $this->tporder['size'] = $this->orderQty;
        $this->slorder['size'] = $this->orderQty;
        $this->retval['qty'] = $this->orderQty;
    }
    public function setLev(){
        $this->maorder['leverage'] = $this->orderLev;
        //$this->tporder['leverage'] = $this->orderLev;
        //$this->slorder['leverage'] = $this->orderLev;
        $this->retval['porLe'] = $this->orderLev;
    }
    public function setSymbol($symbol){
        $this->symbol = $symbol;
    }
    public function setPorIni($porini){
        $this->porIni = $porini;
    }
    public function setStopPrice($CV,$price){
        if($CV === 1){
            $this->tporder['stopPrice'] = round($price +  (($price * $this->porIni['porTp']) / 100),3);
            $this->slorder['stopPrice'] = round($price -  (($price * $this->porIni['porSm']) / 100),3);
        }else{
            $this->tporder['stopPrice'] = round($price -  (($price * $this->porIni['porTp']) / 100),3);
            $this->slorder['stopPrice'] = round($price +  (($price * $this->porIni['porSm']) / 100),3); 
        }
        $this->retval['porAv'] = $this->porIni['porAv'];
        $this->retval['porTp'] = $this->porIni['porTp'];
        $this->retval['porSm'] = $this->porIni['porSm'];
        $this->retval['impTp'] = $this->tporder['stopPrice'];
        $this->retval['impSm'] = $this->slorder['stopPrice'];
        var_dump('impTp'. $this->tporder['stopPrice']);
        var_dump('impSm'. $this->slorder['stopPrice']);
    }
    public function getBalanceAva(){
        $times = 0;
        while(true){
            $result = $this->apiResponse->getBalance(['currency' => 'USDT'], $times);
            if (array_key_exists("availableBalance", $result)) {
                $this->avaBalance = $result["availableBalance"];
                $this->retval['avBal'] = $this->avaBalance;
                $this->retval['enBal'] = $this->avaBalance;                
                $this->avaBalance = round(($this->avaBalance * $this->porIni['porAv']),3);
                $locprice =  $this->getPrice();
                $this->orderLev = $this->getLastLeverage();
                //$actBal = $this->avaBalance * $this->orderLev;
                if ($locprice > 0) {
                    $this->orderQty = intval( $this->avaBalance / $locprice);
                    if($this->orderQty === 0){
                        $this->avaBalance = 0;
                    };
                    $this->orderQty = $this->orderQty * $this->orderLev;
                    break;
                }else{
                    $this->currentPrice = 0;
                    $this->orderQty = 0;
                    $this->avaBalance = 0; 
                    break;
                }
            }else{
                $times = $times + 1;
                if ($times > 5){
                    $this->avaBalance = 0;
                    $this->orderQty = 0;
                    break;
                }
            }
        }
        if( $this->avaBalance === 0){
            $this->sendAlert(4, false, false, "getBalanceAva");
        }
        $this->retval['avBal'] = $this->avaBalance;
        return $this->avaBalance;
    }
    public function optTrade($CV, $togetData){
        if($togetData['qstat'] === 0){
            $respMa = $this->createMaOrder();
            $doitli = $respMa['doit'];
            if($doitli === 1){
                $this->maOrderPrice = $respMa['price'];
                $this->setStopPrice($CV, $this->maOrderPrice);
                $respTp = $this->createTpOrder();
                if($respTp){
                    $respSl = $this->createSlOrder();
                    if($respSl){
                         $this->printLog("En proceso" . chr(10));
                        $this->calcVaria($CV,'open', 'open');
                        $this->cntrOrders($CV);
                        $doit = $this->retval['doit'];
                        if($doit === 1){
                            $times = 0;
                            while(true){
                                $result = $this->apiResponse->getBalance(['currency' => 'USDT'], $times);
                                if (array_key_exists("availableBalance", $result)) {
                                    $this->retval['enBal'] = $result["availableBalance"];
                                    break;
                                }else{
                                    $times = $times + 1;
                                    if ($times > 5){
                                        $this->avaBalance = 0;
                                        $this->orderQty = 0;
                                        break;
                                    }
                                }
                            }
                        }
                    }else{
                        $this->delAllOrders(true);
                        $this->retval['doit'] = 0;
                    }
                }else{
                    $this->delAllOrders(true);
                    $this->retval['doit'] = 0;
                }
            }else{
                $this->sendAlert(3, false, false, "Inicio");
                $this->retval['doit'] = 0;
                $doitli = 0;
            }
        }else{
            $doitli = 1; 
            $this->maOrderId = $togetData['orderid'];
            $this->orderQty = $togetData['quantity']; 
            $this->currentPrice = $togetData['price']; 
            $this->maSide = $togetData['sideli'];
            $this->otSide = $togetData['side'];   
        }
        return $this->retval;
    }

}