<?php
namespace App;

use App\Response;
use App\MustResponse;
use App\FuTrperm;
use App\WebSocketApi;
use Ratchet\Client\WebSocket;
use React\EventLoop\Factory;
use React\EventLoop\LoopInterface;
use GuzzleHttp\Client;
use Psr\Http\Message\ResponseInterface;
use GuzzleHttp\Exception\RequestException;
use App\Exceptions\ResponseApiException;
class ResponseApi
{
    /**
     * @var Request
     */
    protected $request;

    /**
     * @var array
     */
    protected $keys = [];
        /**
     * @var array
     */
    protected $headers = [];

    /**
     * @var string
     */
    protected $body;
    /**
     * @var FuTrperm  $auth
     */
    protected $auth;
    protected $websocket;
    const METHOD_GET    = 'GET';
    const METHOD_POST   = 'POST';
    const METHOD_PUT    = 'PUT';
    const METHOD_DELETE = 'DELETE';
    protected $statusCode;
    protected $i = 0;
    protected $client;
    protected static $config = [
        'base_uri'        => 'https://api-futures.kucoin.com', 
        'timeout' => 30,
        'connect_timeout' => 30,
        'http_errors'     => true,
        'verify'          => 1,
        'skipVerifyTls' => false
    ];
    protected $ressock;

    public function __construct()
    {
        $this->auth = new FuTrperm();
        $this->websocket = new WebSocketApi();
        $this->client = $this->getClient(static::$config);

    }
    public function getRequest()
    {
        return $this->request;
    }
    /**
     * @param array $config
     * @return Client
     */
    private function buildQuery($params = [])
    {
        $new_arr = array();
        $query_add = '';
        foreach ($params as $label=>$item) {
            if ( gettype($item) == 'array' ) {
                foreach ($item as $arritem) {
                    $query_add = $label . '=' . $arritem . '&' . $query_add;
                }
            } else {
                $new_arr[$label] = $item;
            }
        }
        $query = http_build_query($new_arr, '', '&');
        $query = $query_add . $query;
        return $query;
    } 
    private function getClient(array $config)
    {
        $key = md5(json_encode($config));
        if (isset($clients[$key])) {
            return $clients[$key];
        }
        $clients[$key] = new Client($config);
        return $clients[$key];
    }
    private function getApiData($result)
    {
        $httpResponse = new Response($result->getBody());
        $body = $httpResponse->getBody(true);
        if (!isset($body['data'])) {
            //var_dump($body);
            return null;
        }
        return $body['data'];
    }
    public function getKlines($interval)
    {
        $toDate = new \DateTimeImmutable('now');
        $datetime = date("Y-m-d H:i:s");
        $timestamp = strtotime($datetime);
        $time = $timestamp - (200 * 1800);
        $datetime = date("Y-m-d H:i:s", $time);
        $fromDate = new \DateTimeImmutable($datetime);
        $from = (int)$fromDate->format('Uv');
        $to = (int)$toDate->format('Uv');
        try {
            $i=0;
            $output = [];
            $result = $this->client->request(self::METHOD_GET, '/api/v1/kline/query', [
                'headers' => ['User-Agent' => 'KuCoin-Futures-PHP-SDK/1.0.22'],
                'query' => [
                'symbol' => 'DOTUSDTM',
                'granularity' => $interval,
                //'from' => $from,
                'to' => $to],
        
            ]);
            $mustresp = new Response($result,self::METHOD_GET, '/api/v1/kline/query');
            $data = $mustresp->getApiData(true);
            $plustime = (($interval - 1) * 60000)  + 59000;
            foreach ($data as $tick) {
               list($openTime, $open, $high, $low, $close, $volact) = $tick;
               $output[$i] = [
                    "openTime" => $openTime,
                    "closeTime" => $openTime + $plustime,
                    "open" => $open,
                    "high" => $high,
                    "low" => $low,
                    "close" => $close,
                    "volact" => $volact
                ];
               $i = $i + 1;
            }       
            return $output;
        } catch (RequestException $exp) {
            print($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        } catch (ResponseApiException $exp) {
            print($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        }               
    }

    public function getAccount(array $params = [])
    {
        $query = '?' . http_build_query($params);
        $config['base_uri'] = 'https://api.kucoin.com';
        try{
            $result = $this->client->request(self::METHOD_GET, '/api/v1/accounts'. $query, [
                'headers' => $this->auth->getHeaders('/api/v1/accounts'. $query, self::METHOD_GET, $params),
                'json' => $params
            ]);
            $mustresp = new Response($result,self::METHOD_GET, '/api/v1/accounts'. $query);
            return $mustresp->getApiData(true);
        } catch (RequestException $exp) {
            print($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        } catch (ResponseApiException $exp) {
            print($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        }  
    }
    public function getOverview(array $params = [])
    {
        $query = '?' . http_build_query($params);
        //$config['base_uri'] = 'https://api.kucoin.com';
        try{
            $result = $this->client->request(self::METHOD_GET, '/api/v1/account-overview-all'. $query, [
                'headers' => $this->auth->getHeaders('/api/v1/account-overview-all'. $query, self::METHOD_GET, $params),
                'json' => $params
            
            ]);
            $mustresp = new Response($result,self::METHOD_GET, '/api/v1/account-overview-all'. $query);
            return $mustresp->getApiData(true);
        } catch (RequestException $exp) {
            print($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        } catch (ResponseApiException $exp) {
            print($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        }  
    }

    public function getBalance($params, $times)
    {
        //$config['base_uri'] = 'https://api.kucoin.com';
        $query = '?' . http_build_query($params);
        //if($times === 0){
            $this->headers = $this->auth->getHeaders('/api/v1/account-overview' . $query, self::METHOD_GET, $params);
        //}
        try{
            $result = $this->client->request(self::METHOD_GET, '/api/v1/account-overview' . $query, [
                'headers' => $this->headers, //$this->auth->getHeaders('/api/v1/account-overview' . $query, self::METHOD_GET, $params),
                'json' => $params 
            ]);
            $mustresp = new Response($result,self::METHOD_GET, '/api/v1/account-overview' . $query);
            return $mustresp->getApiData(true);
        } catch (RequestException $exp) {
            print($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        } catch (ResponseApiException $exp) {
            print($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        }  
    }
    public function getBalanceNew(array $params = [])
    {
        $query = '?' . http_build_query($params);
        $config['base_uri'] = 'https://api.kucoin.com';
        try{
            $result = $this->client->request(self::METHOD_GET, '/api/v1/accounts'. $query, [
                'headers' => $this->auth->getHeaders('/api/v1/accounts'. $query, self::METHOD_GET, $params),
                'json' => $params
            ]);
            $mustresp = new Response($result,self::METHOD_GET, '/api/v1/accounts'. $query);
            $data = $mustresp->getApiData(true);
            $output = [];
            foreach ($data as $balance) {
                var_dump($balance);
                if($balance['type'] === 'main'){
                    $output = $balance;
                }
             }       
             return $output;
        } catch (RequestException $exp) {
            print($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        } catch (ResponseApiException $exp) {
            print($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        }  
    }
    public function getLeveragePosible(array $params = [])
    {
        $query = '?' . http_build_query($params);
        $config['base_uri'] = 'https://api.kucoin.com';
        try{
            $result = $this->client->request(self::METHOD_GET, '/api/v3/etf/info'. $query, [
                'headers' => $this->auth->getHeaders('/api/v3/etf/info'. $query, self::METHOD_GET, $params),
                'json' => $params
            ]);
            $mustresp = new Response($result,self::METHOD_GET, '/api/v3/etf/info'. $query);
            $data = $mustresp->getApiData(true);
            return $data;
            /*
            $output = [];
            foreach ($data as $currency) {
                if($currency['currency'] === 'USDT'){
                    $output = $currency;
                }
             }       
             return $output;*/
        } catch (RequestException $exp) {
            print($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        } catch (ResponseApiException $exp) {
            print($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        }  
    }
    public function getLeverage($symbol){
        try{
            $result = $this->client->request(self::METHOD_GET, '/api/v1/contracts/risk-limit/' . $symbol, [
                'headers' => $this->auth->getHeaders('/api/v1/contracts/risk-limit/' . $symbol, self::METHOD_GET,[]),
            ]);
            $mustresp = new Response($result,self::METHOD_GET, '/api/v1/contracts/risk-limit/' . $symbol);
            return $mustresp->getApiData(true);
        } catch (RequestException $exp) {
            print($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        } catch (ResponseApiException $exp) {
            print($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        } 

    }
    public function getPrice($symbol, $times)
    {
        //if($times === 0){
            $this->headers = $this->auth->getHeaders("/api/v1/mark-price/$symbol/current", self::METHOD_GET,[]);
        //}
        try{
            $result = $this->client->request(self::METHOD_GET, "/api/v1/mark-price/$symbol/current", [
                'headers' => $this->headers //$this->auth->getHeaders("/api/v1/mark-price/$symbol/current", self::METHOD_GET,[]),
            ]);
            $mustresp = new Response($result,self::METHOD_GET,"/api/v1/mark-price/$symbol/current");
            return $mustresp->getApiData(true);
        } catch (RequestException $exp) {
            print($exp->getMessage() .chr(10));
            return 0;
        } catch (ResponseApiException $exp) {
            print($exp->getMessage() .chr(10));
            return 0;
        } 
        // take ["indexPrice"]
    }

    /**
     * Place a new order.
     *
     * @param array $order
     * @return array
     */
    public function createOrder(array $params = [], $times)
    {
        //if($times === 0){
            $this->headers = $this->auth->getHeaders('/api/v1/orders', self::METHOD_POST, $params);
        //}
        try{
            $result = $this->client->request(self::METHOD_POST, '/api/v1/orders', [
                'headers' => $this->headers,
                'json' => $params
            ]);
            $mustresp = new Response($result,self::METHOD_POST, '/api/v1/orders');
            return $mustresp->getApiData(true);
        } catch (RequestException $exp) {
            print($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        } catch (ResponseApiException $exp) {
            print($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        } 
    } 
    /**
     * Cancel an order.
     *
     * @param array $orderID
     * @return array
     */    
    public function cancelOrderById($orderId, $times)
    {
        //if($times === 0){
            $this->headers = $this->auth->getHeaders('/api/v1/orders/' . $orderId, self::METHOD_DELETE,'');
        //}
        try {
            $result = $this->client->request(self::METHOD_DELETE, '/api/v1/orders/' . $orderId, [
                'headers' => $this->headers,
            ]);
            $mustresp = new Response($result,self::METHOD_DELETE, '/api/v1/orders/' . $orderId);
            return $mustresp->getApiData(true);
        } catch (RequestException $exp) {
            print($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        } catch (ResponseApiException $exp) {
            print($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        }  
    }
    public function cancelAllOrders($params, $times)
    {
        //if($times === 0){
            $this->headers = $this->auth->getHeaders('/api/v1/stopOrders', self::METHOD_DELETE,$params);
        //}
        try{
            $result = $this->client->request(self::METHOD_DELETE, '/api/v1/stopOrders', [
                'headers' => $this->headers,
                'json' => $params
            ]);
            $mustresp = new Response($result,self::METHOD_DELETE, '/api/v1/stopOrders');
            return $mustresp->getApiData(true);
        } catch (RequestException $exp) {
            print($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        } catch (ResponseApiException $exp) {
            print($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        } 
    }
    public function getOrderById($orderId, $times)
    {
        //if($times === 0){
            $this->headers = $this->auth->getHeaders('/api/v1/orders/' . $orderId, self::METHOD_GET,[]);
        //}
        try {
            $result = $this->client->request(self::METHOD_GET, '/api/v1/orders/' . $orderId, [
                'headers' => $this->headers,
            ]);
            $mustresp = new Response($result,self::METHOD_GET, '/api/v1/orders/' . $orderId);
            return $mustresp->getApiData(true);
        } catch (RequestException $exp) {
            print($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        } catch (ResponseApiException $exp) {
            print($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        }  
    }
    /**
     * List orders.
     *
     * @param array $params -> status
     * @param array $pagination
     * @return array
     */
    public function getListOrder(array $params = [], array $pagination = [])
    {
        try{
            $result = $this->client->request(self::METHOD_GET, '/api/v1/recentDoneOrders', [
                'headers' => $this->auth->getHeaders('/api/v1/recentDoneOrders', self::METHOD_GET, $params),
                'json' => $params
            ]);
            $items  = new Response($result,self::METHOD_GET, '/api/v1/recentDoneOrders');
            $mustresp = new Response($items,self::METHOD_GET, '/api/v1/recentDoneOrders' . '');
            $items = $mustresp->getApiData(true);
            foreach ($items as $item) {
                $id = $item['id'];
                $side = $item['side'];
                $value = $item['value'];
                $stop = $item['stop'];
                $createdAt = $item['createdAt'];
                $updatedAt = $item['updatedAt'];
                $endAt = $item['endAt']; 
                $stat =   $item['status'];         
                if($stop === ''){
                    $created = (new \DateTime(date('m/d/Y H:i:s',intval($createdAt)/1000)))->format('Y-m-d H:i:s');
                    $update = (new \DateTime(date('m/d/Y H:i:s',intval($updatedAt)/1000)))->format('Y-m-d H:i:s');
                    $end = (new \DateTime(date('m/d/Y H:i:s',intval($endAt)/1000)))->format('Y-m-d H:i:s');

                    var_dump('id:'.$id. ' side:' . $side . ' stop:' . $stop. ' status:' . $stat . ' value:' . $value . ' create:' . $created . ' update: ' . $update . ' end:' . $end);
                }

            }
        } catch (RequestException $exp) {
            print($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        } catch (ResponseApiException $exp) {
            print($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        }       
    }
    /**
     * List orders TP & SL.
     *
     * @param array $params -> Symbol
     * @param array $pagination
     * @return array
     */
    public function getStopOrderOrg(array $params = [])
    {
        try{
            $result = $this->client->request(self::METHOD_GET, '/api/v1/stopOrders', [
                'headers' => $this->auth->getHeaders('/api/v1/stopOrders', self::METHOD_GET, $params),
                'json' => $params
            ]);
            $mustresp = new Response($result,self::METHOD_GET, '/api/v1/stopOrders');
            return $mustresp->getApiData(true);
        } catch (RequestException $exp) {
            print($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        } catch (ResponseApiException $exp) {
            print($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        }        
    }    

    public function getStopOrder($params)
    {
        //$config['base_uri'] = 'https://api.kucoin.com';
        $query = '?' . http_build_query($params);
        try{
            $result = $this->client->request(self::METHOD_GET, '/api/v1/stopOrders' . $query, [
                'headers' => $this->auth->getHeaders('/api/v1/stopOrders' . $query, self::METHOD_GET, $params),
                'json' => $params 
            ]);
            $mustresp = new Response($result,self::METHOD_GET, '/api/v1/stopOrders' . $query);
            $items = $mustresp->getApiData(true);
            foreach ($items['items'] as $item) {
                $id = $item['id'];
                $side = $item['side'];
                $value = $item['stopPrice'];
                $stop = $item['stop'];
                $createdAt = $item['createdAt'];
                $updatedAt = $item['updatedAt'];
                $endAt = $item['endAt']; 
                $stat =   $item['status'];         
                if($stat === 'open'){
                    $created = (new \DateTime(date('m/d/Y H:i:s',intval($createdAt)/1000)))->format('Y-m-d H:i:s');
                    $update = (new \DateTime(date('m/d/Y H:i:s',intval($updatedAt)/1000)))->format('Y-m-d H:i:s');
                    $end = (new \DateTime(date('m/d/Y H:i:s',intval($endAt)/1000)))->format('Y-m-d H:i:s');

                    var_dump('id:'.$id. ' side:' . $side . ' stop:' . $stop. ' status:' . $stat . ' value:' . $value . ' create:' . $created . ' update: ' . $update . ' end:' . $end);
                }

            }
        } catch (RequestException $exp) {
            print($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        } catch (ResponseApiException $exp) {
            print($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        }  
    }

    function getStatus(array $params = [], $times){ 
        $query = '?' . http_build_query($params);
        //if($times === 0){
            $this->headers = $this->auth->getHeaders('/api/v1/position' . $query, self::METHOD_GET, $params);
        //}
        try{
            $result = $this->client->request(self::METHOD_GET, '/api/v1/position' .$query, [
                'headers' => $this->headers, //$this->auth->getHeaders('/api/v1/position' . $query, self::METHOD_GET, $params),
                'json' => $params            
            ]);
            $mustresp = new Response($result,self::METHOD_GET, '/api/v1/position' .$query);
            return $mustresp->getApiData(true);
        } catch (RequestException $exp) {
            print($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        } catch (ResponseApiException $exp) {
            print($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        } 

    }
    
    public function getPosition(array $params = [], $times){ 
        $query = '?' . http_build_query($params);
        //if($times === 0){
            $this->headers = $this->auth->getHeaders('/api/v1/position' . $query, self::METHOD_GET, $params);
        //}
        try{
            $result = $this->client->request(self::METHOD_GET, '/api/v1/position' .$query, [
                'headers' => $this->headers, //$this->auth->getHeaders('/api/v1/position' . $query, self::METHOD_GET, $params),
                'json' => $params            
            ]);
            $mustresp = new Response($result,self::METHOD_GET, '/api/v1/position' .$query);
            return $mustresp->getApiData(true);
        } catch (RequestException $exp) {
            print($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        } catch (ResponseApiException $exp) {
            print($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        } 
    }
    public function getPublicBullet(array $params = [], $symbol)
    {
        $result = $this->client->request(self::METHOD_POST, '/api/v1/bullet-public', [
            'headers' => $this->auth->getHeaders('/api/v1/bullet-public', self::METHOD_POST, $params),
            'json' => $params            
        ]);
        $mustresp = new Response($result,self::METHOD_POST, '/api/v1/bullet-public');
        $data = $mustresp->getApiData(true);
        $server = $data['instanceServers'][0];
        var_dump('******** STart');
        var_dump($server);
        var_dump('******** END');
        if (array_key_exists("endpoint", $server)) {
            $channels = [
                ['topic' => '/contractMarket/tickerV2:' . $symbol], // Subscribe multiple channels
            ];

            $params = [
                'connectId' => uniqid('', true),
                'token' => $data['token'],
            ];


            $url = sprintf('%s%s%s', $server['endpoint'], strpos($server['endpoint'], '?') === false ? '?' : '&', http_build_query($params));
            $server['connectUrl'] = $url;
            $server['connectId'] = $params['connectId'];
            $sockapi = new WebSocketApi();
            $sockapi->subscribePublicChannels($server, $channels, function (array $message, WebSocket $ws, LoopInterface $loop, $pingTimer, $i) use ($sockapi) {
                $actPrice = $message['data']["bestAskPrice"] * 1;
$miprice = 7.440;
                if ($actPrice >= $miprice) {
                    $loop->cancelTimer($pingTimer);
                    $loop->stop();
                    $this->ressock = 'i:' . $i . ' symbol:' . $message['data']["symbol"] . ' price:' . $message['data']["bestAskPrice"];

                }
                //var_dump($message['data']["bestAskPrice"]);

            }, function ($code, $reason) {
                echo "OnClose: {$code} {$reason}\n";
            });
    
        }
        return $this->ressock;
    }
    public function getPrivateBullet(array $params = [], $symbol)
    {
        $result = $this->client->request(self::METHOD_POST, '/api/v1/bullet-private', [
            'headers' => $this->auth->getHeaders('/api/v1/bullet-private', self::METHOD_POST, $params),
            'json' => $params            
        ]);
        $mustresp = new Response($result,self::METHOD_POST, '/api/v1/bullet-private');
        $data = $mustresp->getApiData(true);
        $server = $data['instanceServers'][0];
        if (array_key_exists("endpoint", $server)) {
            $channels = [
                ['topic' => '/contractMarket/advancedOrders'], // Subscribe multiple channels
                ['topic' => '/contractMarket/tradeOrders:'. $symbol],
            ];
            $params = [
                'connectId' => uniqid('', true),
                'token' => $data['token'],
            ];

            $url = sprintf('%s%s%s', $server['endpoint'], strpos($server['endpoint'], '?') === false ? '?' : '&', http_build_query($params));
            $server['connectUrl'] = $url;
            $server['connectId'] = $params['connectId'];
            $sockapi = new WebSocketApi();
            $sockapi->subscribePrivateChannels($server, $channels, function (array $message, WebSocket $ws, LoopInterface $loop, $pingTimer, $i) use ($sockapi, $symbol) {
                $data = $message['data'];
                var_dump('Now:' . date("Y-m-d H:i:s") . ' subject:' . $message['subject']);
                switch ($message['subject']) {
                    case 'stopOrder':
                        if ($data['type'] === 'triggered') {
                            var_dump('Proc end in stop order: ' . $data['orderId']. ' stop:'  . $data['stop'] . ' type:' . $data['type']);
                            $loop->cancelTimer($pingTimer);
                            $loop->stop();
                            $this->ressock = [
                                'msg' => 'Proc end in stop order: ' . $data['orderId'],
                                'stop' => $data['stop'] ,
                                'type' => $data['type'],
                                'action' => true,
                            ];                 
                        };
                        break;
                    case 'symbolOrderChange':
                        if ($data['type'] !== 'open') {
                            var_dump('Proc end in main order: ' . $data['orderId']. 'type: ' . $data['type'] . ' status:' . $data['type']);
                            //$loop->cancelTimer($pingTimer);
                            //$loop->stop();
                        };
                        break;
                }
            }, function ($code, $reason) {
                echo "OnClose: {$code} {$reason}\n";
            });
    
        }
        return $this->ressock;
    }
}