<?php

namespace App;

class FuTrperm
{
    private $apiKey;

    private $secret;

    private $passwd;

    private $apiKeyVersion;

    const API_KEY_VERSION_V1 = '1';

    const API_KEY_VERSION_V2 = '2';

    public function __construct($apiKeyVersion = self::API_KEY_VERSION_V1)
    {

        $publickey = openssl_pkey_get_public("file://app/src/Public_key");
        $filename = "./app/src/encrypted.txt";
        $encrypted = file_get_contents($filename);
        openssl_public_decrypt(file_get_contents($filename), $decrypted, $publickey);
        $keys = json_decode($decrypted);
        openssl_free_key($publickey);
        $this->apiKey = $keys->APIKey;
        $this->secret = $keys->SecKey;
        $this->passwd= $keys->Passwd;
        $this->apiKeyVersion = $apiKeyVersion;
    }

    public function signature($path, $method, $parameters)
    {


        // Decode $requestUri
        $parts = parse_url($path);
        if (isset($parts['query'])) {
            parse_str($parts['query'], $queries);
            $queryString = '';
            foreach ($queries as $key => $value) {
                $queryString .= sprintf('%s=%s&', $key, $value);
            }
            $queryString = rtrim($queryString, '&');
            $path = $parts['path'] . '?' . $queryString;
            if (isset($parts['fragment'])) {
                $requestUri .= '#' . $parts['fragment'];
            }
        }
        $timestamp = floor(microtime(true) * 1000);
        //$timestamp = $this->getTime();
        if (is_array($parameters)) {
            $body = empty($parameters) ? '' : json_encode($parameters, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
        } else {
            $body = (string)$parameters;
        }
        $auth = $timestamp . $method. $path . $body;
        return base64_encode(hash_hmac('sha256', $auth , $this->secret, true));
    }

    public function getHeaders($path, $method, $parameters)
    {
        $timestamp = floor(microtime(true) * 1000);
        $headers = [
            'KC-API-KEY'        => $this->apiKey,
            'KC-API-TIMESTAMP'  => $timestamp,
            'KC-API-PASSPHRASE' => $this->passwd,
            'KC-API-SIGN'       => $this->signature($path, $method, $parameters),
            //'KC-API-KEY-VERSION' => '2',
            'User-Agent' => 'KuCoin-Futures-PHP-SDK/1.0.22',
            'Content-Type' => 'application/json'

        ];
        return $headers;
    }
}