<?php
namespace App;
use App\ResponseApi;
class AlgoritApi30m
{
    public $algResp = [];
    public function getAlgoritResult(array $config = [])
    {
        $CV = 0;
        $apiResponse = new ResponseApi();
        $varinter  = $config['varint'];
        $lcv = $config['cv'];
        $adx = 0;        
        for ($i = 1; $i <= 2; $i++) {
            $json = $apiResponse->getKlines($varinter[$i]['interval']);
            /* calculo ema's y adx */ 
            $varinter[$i]["valret"] = $this->getEmaAdx($json, $config['emalo'], $config['emahi'], $varinter[$i]['interval']);
        }
        $emitir = 0;
        $may = "";
        if (
            $varinter[1]["valret"]["emalo"] > $varinter[1]["valret"]["emahi"]  and 
            $varinter[2]["valret"]["emalo"] > $varinter[2]["valret"]["emahi"] and   
            $varinter[1]["valret"]["adx"] > 20 and $varinter[2]["valret"]["adx"] > 20 and
            $varinter[1]["valret"]['close'] > $varinter[1]["valret"]['open']){
            $varinter[1]["valret"]['opetype'] = 1; //compra
        }elseif (
            $varinter[1]["valret"]["emalo"] < $varinter[1]["valret"]["emahi"]  and 
            $varinter[2]["valret"]["emalo"] < $varinter[2]["valret"]["emahi"] and 
            $varinter[1]["valret"]["adx"] > 20 and $varinter[2]["valret"]["adx"] > 20 and
            $varinter[1]["valret"]['close'] < $varinter[1]["valret"]['open']){
            $varinter[1]["valret"]['opetype'] = 2;   // venta      
        }else{
            $varinter[1]["valret"]['opetype'] = 0;
        }   
        if($varinter[1]["valret"]["opetype"] >= 0){
            $emalow = "[" . $varinter[1]["valret"]["emalo"] . "," . $varinter[2]["valret"]["emalo"] .  "]";
            $emahigh = "[" . $varinter[1]["valret"]["emahi"] . "," . $varinter[2]["valret"]["emahi"] .  "]";
            $interarry = "[" . $varinter[1]["valret"]["interval"] . "," . $varinter[2]["valret"]["interval"]  . "]";
            $fechaope = (new \DateTime(date('m/d/Y H:i:s',intval($varinter[1]["valret"]["openTime"])/1000)))->format('Y-m-d H:i:s');
            $fechaclo = (new \DateTime(date('m/d/Y H:i:s',intval($varinter[1]["valret"]["closeTime"])/1000)))->format('Y-m-d H:i:s');   
            $emitir = 0;     
            if($varinter[1]["valret"]['opetype'] === 0){
                $accion = "Mantener"; 
                if($CV === 2){
                    //$emitir = ($varinter[1]["valret"]["emalo"] > $varinter[1]["valret"]["emahi"])?1:0;
                    $emitir = 0;
                    $CV = ($varinter[1]["valret"]["emalo"] > $varinter[1]["valret"]["emahi"])?0:2;
                    $may = ($varinter[1]["valret"]["emalo"] > $varinter[1]["valret"]["emahi"])?"rompe en V":"menor"; 
                }elseif($CV === 1){
                    //$emitir = ($varinter[1]["valret"]["emalo"] < $varinter[1]["valret"]["emahi"])?1:0;
                    $emitir = 0;                
                    $CV = ($varinter[1]["valret"]["emalo"] < $varinter[1]["valret"]["emahi"])?0:1;   
                    $may = ($varinter[1]["valret"]["emalo"] < $varinter[1]["valret"]["emahi"])?"rompe en C":"mayor";
                }
            }elseif($varinter[1]["valret"]['opetype'] === 1){
                $may = "";
                $accion = "Comprar"; 
                $emitir = ($CV === 1)?0 :1 ;
                $CV = 1;          
            }else{
                $may = "";
                $accion = "Vender"; 
                $emitir = ($CV === 2 )?0:1;   
                $CV = 2;           
            }
            $tokentel = [
                "fechaope" => $fechaope,
                "fechaclo" => $fechaclo,
                "emalow" => $emalow,
                "emahigh" => $emahigh,            
                "close" => $varinter[1]["valret"]['close'],
                "open" => $varinter[1]["valret"]['open'],
                "interval" => $interarry ,
                "interlow" => $varinter[1]["valret"]["interval"],
                "adx30m" => $varinter[1]["valret"]["adx"],
                "adx2h" => $varinter[2]["valret"]["adx"],
                "accion" => $accion,
                "may" => $may,
                "tim" => $varinter[1]["valret"]["closeTime"]/1000,
                "init" => 0,
                "resCV" => []
            ];
            $tokentelp = "openTime:". $fechaope . "|closeTime:" . $fechaclo . "|low:" . $emalow . "|high:" . $emahigh . "|adx:" . $varinter[1]["valret"]["adx"] .
            "|adx2:" . $varinter[2]["valret"]["adx"] ."|close:" .  $varinter[1]["valret"]['close'] . "|open:" . $varinter[1]["valret"]['open'] . "| interv:"
             . $interarry . "|acción:". $accion . "|emitir:" . $emitir . "|may:" . $may . "|cv:" . $lcv . chr(10);
             if ($emitir === 1){
                $this->printLog($tokentelp);
             }
             $this->algResp = [
                "CV" => $CV,
                "emitir" => $emitir,
                "tokentel" => $tokentel
             ];
                
        }  
         
    }

    private function getEmaAdx($json, $emalo = 5, $emahi = 60, $interval = 30)
    {
        $i=0;
        //$json = [];
        $time_period = 14;        
        $ema_name = "ema_" . $emalo ;
        $highs = [];
        $lows = [];
        $closes = [];
        $vol_med = 0;
        for ($x = 0; $x < count($json); $x++) {
            array_push($highs, $json[$x]["high"]);
            array_push($lows, $json[$x]["low"]);
            array_push($closes, $json[$x]["close"]);
            $vol_med = $vol_med + $json[$x]['volact'];
        }
        $adx = trader_adx($highs, $lows, $closes, 14);
        $mdi = trader_minus_di($highs, $lows, $closes, 14);
        $pdi = trader_plus_di($highs, $lows, $closes, 14);   
        $ema_vallo =  trader_ema($closes, $emalo); 
        $ema_valhi =  trader_ema($closes, $emahi);
    
        $retval = [
            "emalo" => 0,
            "emahi" => 0,    
            "adx" => 0,    
            "mdi" => 0, 
            "pdi" => 0,                                                         
            "volmed" => 0,
            "volact" => $json[count($json) - 2]['volact'],
            "open" => $json[count($json) - 2]['open'],    
            "close" => $json[count($json) - 2]['close'],    
            "openTime" => $json[count($json) - 2]['openTime'],            
            "closeTime" => $json[count($json) - 2]['closeTime'],
            "opetype" => 0, 
            "interval" =>  $interval           
        ];
    
    
        $i = count($json) - 2;
        $retval["emalo"] = (!empty($ema_vallo[$i]))?$ema_vallo[$i]:0;
        $retval["emahi"] = (!empty($ema_valhi[$i]))?$ema_valhi[$i]:0;  
        $retval["adx"] = (!empty($adx[$i]))?$adx[$i]:0;   
        $retval["mdi"] = (!empty($mdi[$i]))?$mdi[$i]:0; 
        $retval["pdi"] = (!empty($pdi[$i]))?$pdi[$i]:0;
        $retval["volmed"] = $vol_med / (($i > 0)?$i:1);
        return $retval;
    }    
    private function printLog($from){
        $date = (new \DateTime('now'))->format('Y-m-d H:i:s');
        print( "Now: " . $date . "|" . $from );
    }
}