<?php
namespace App;
use App\ResponseApi;
class AlgoritApi
{
    public $algResp = [];
    public function getAlgoritResult(array $config = [])
    {
        $CV = 0;
        $apiResponse = new ResponseApi();
        $varinter  = $config['varint'];
        $lcv = $config['cv'];
        $adx = 0;        
        for ($i = 1; $i <= 2; $i++) {
            $json = $apiResponse->getKlines($varinter[$i]['interval']);
            /* calculo ema's y adx */ 
            $varinter[$i]["valret"] = $this->getEmaAdx($json, $config['emalo'], $config['emahi'], $varinter[$i]['interval']);
        }
        $emitir = 0;
        $may = "";
        if (
            $varinter[1]["valret"]["pdi"] > $varinter[1]["valret"]["mdi"] and 
            $varinter[2]["valret"]["pdi"] > $varinter[2]["valret"]["mdi"] and   
            $varinter[1]["valret"]["adx"] > $varinter[1]["valret"]["adxa"]){
            $varinter[1]["valret"]['opetype'] = 1; //compra
    //SI EN 15m $pdi>$mdi, EN 3m $pdi>$mdi, ADX3m ULT VELA> ADX3m PENULTIMA VELA, ENTONCES COMPRA.
        }elseif (
            $varinter[1]["valret"]["mdi"] > $varinter[1]["valret"]["pdi"] and 
            $varinter[2]["valret"]["mdi"] > $varinter[2]["valret"]["pdi"] and   
            $varinter[1]["valret"]["adx"] > $varinter[1]["valret"]["adxa"]){
            $varinter[1]["valret"]['opetype'] = 2;   // venta  
    //SI EN 15m $mdi>$pdi, EN 3m $mdi>$pdi, ADX3m ULT VELA> ADX3m PENULTIMA VELA, ENTONCES VENTA.            
        }else{
            $varinter[1]["valret"]['opetype'] = 0;
        }  
        if($varinter[1]["valret"]["opetype"] >= 0){
            $dmi3 = "[pdi:" . $varinter[1]["valret"]["pdi"] . ", mdi:" . $varinter[1]["valret"]["mdi"] .  "]";
            $dmi15 = "[pdi:" . $varinter[2]["valret"]["pdi"] . ", mdi:" . $varinter[2]["valret"]["mdi"] .  "]";
            $interarry = "[" . $varinter[1]["valret"]["interval"] . "," . $varinter[2]["valret"]["interval"]  . "]";
            $fechaope = (new \DateTime(date('m/d/Y H:i:s',intval($varinter[1]["valret"]["openTime"])/1000)))->format('Y-m-d H:i:s');
            $fechaclo = (new \DateTime(date('m/d/Y H:i:s',intval($varinter[1]["valret"]["closeTime"])/1000)))->format('Y-m-d H:i:s');   
            $emitir = 0;     
            if($varinter[1]["valret"]['opetype'] === 0){
                $accion = "Mantener"; 
                if($CV === 2){
                    $emitir = 0;
                    if ($varinter[1]["valret"]["mdi"] < $varinter[1]["valret"]["pdi"])
                    {
                        $CV = 0;
                        $may = "rompe en V"; 
                    }else{
                        $CV = 2;
                        $may = "menor";
                    }
                }elseif($CV === 1){
                    $emitir = 0;      
                    if ($varinter[1]["valret"]["pdi"] < $varinter[1]["valret"]["mdi"] )
                    {
                        $CV = 0;
                        $may = "rompe en C"; 
                    }else{
                        $CV = 1;
                        $may = "mayor";
                    }                
                }
            }elseif($varinter[1]["valret"]['opetype'] === 1){
                $may = "";
                $accion = "Comprar"; 
                $emitir = ($CV === 1)?0 :1 ;
                $CV = 1;          
            }else{
                $may = "";
                $accion = "Vender"; 
                $emitir = ($CV === 2 )?0:1;   
                $CV = 2;           
            }            
            $tokentel = [
                "fechaope" => $fechaope,
                "fechaclo" => $fechaclo,  
                "dmi3" => $dmi3,
                "dmi15" => $dmi15,  
                "close" => $varinter[1]["valret"]['close'],
                "open" => $varinter[1]["valret"]['open'],
                "interval" => $interarry ,
                "interlow" => $varinter[1]["valret"]["interval"],
                "adx3m" => $varinter[1]["valret"]["adx"],
                "adx3ma" => $varinter[1]["valret"]["adxa"],
                "accion" => $accion,
                "may" => $may,
                "tim" => $varinter[1]["valret"]["closeTime"]/1000,
                "init" => 0,
                'timezone' => $config['timezone'],
                'locale' => $config['locale'],
                'telusers' => $config['telusers'],
                "resCV" => []
            ];
            $tokentelp = $fechaope . "|" . $fechaclo . "|dmi3:" . $dmi3 . "|dmi15:" . $dmi15 . "|adx3m:" . $varinter[1]["valret"]["adx"] .
            "|adx3ma:" . $varinter[1]["valret"]["adxa"] ."|close:" .  $varinter[1]["valret"]['close'] . "|open:" . $varinter[1]["valret"]['open'] . "| interv:"
             . $interarry . "|acción:". $accion . "|emitir:" . $emitir . "|may:" . $may . "|cv:" . $lcv . chr(10);
             if ($emitir === 1){
                var_dump($tokentelp);
             }
             $this->algResp = [
                "CV" => $CV,
                "emitir" => $emitir,
                "tokentel" => $tokentel
             ];
                
        }  
         
    }

    private function getEmaAdx($json, $emalo = 5, $emahi = 60, $interval = 30)
    {
        $i=0;
        //$json = [];
        $time_period = 14;        
        $ema_name = "ema_" . $emalo ;
        $highs = [];
        $lows = [];
        $closes = [];
        $vol_med = 0;
        for ($x = 0; $x < count($json); $x++) {
            array_push($highs, $json[$x]["high"]);
            array_push($lows, $json[$x]["low"]);
            array_push($closes, $json[$x]["close"]);
            $vol_med = $vol_med + $json[$x]['volact'];
        }
        $adx = trader_adx($highs, $lows, $closes, 14);
        $mdi = trader_minus_di($highs, $lows, $closes, 14);
        $pdi = trader_plus_di($highs, $lows, $closes, 14);      
        $retval = [  
            "adx" => 0,   
            "adxa" => 0,             
            "mdi" => 0, 
            "pdi" => 0,                                                         
            "volact" => $json[count($json) - 2]['volact'],
            "open" => $json[count($json) - 2]['open'],    
            "close" => $json[count($json) - 2]['close'],    
            "openTime" => $json[count($json) - 2]['openTime'],            
            "closeTime" => $json[count($json) - 2]['closeTime'],
            "opetype" => 0, 
            "interval" =>  $interval           
        ];
    
    
        $i = count($json) - 2;
        $retval["adx"] = (!empty($adx[$i]))?$adx[$i]:0; 
        $retval["adxa"] = (!empty($adx[$i]))?$adx[$i-1]:0;           
        $retval["mdi"] = (!empty($mdi[$i]))?$mdi[$i]:0; 
        $retval["pdi"] = (!empty($pdi[$i]))?$pdi[$i]:0;
        return $retval;
    }    
    private function printLog($from){
        $date = (new \DateTime('now'))->format('Y-m-d H:i:s');
        print( "Now: " . $date . "|" . $from );
    }
}