<?php
include './vendor/autoload.php';
require_once './app/src/Response.php';
use GuzzleHttp\Client;
use App\Response;

static $clients = [];
//$httpResponse = new MyResponse\Response();
$config = [
	'base_uri'        => 'https://api-futures.kucoin.com',
	'timeout' => 30,
	'connect_timeout' => 30,
	'http_errors'     => false,
	'verify'          => 1,
	'skipVerifyTls' => false
];



/**
 * @param array $config
 * @return Client
 */
function getClient(array $config)
{
	$key = md5(json_encode($config));
	if (isset($clients[$key])) {
		return $clients[$key];
	}
	$clients[$key] = new GuzzleHttp\Client($config);
	return $clients[$key];
}
function getApiData($result)
{
	//$httpResponse = new GuzzleHttp\Response($result->getBody());
	$httpResponse = new App\Response($result->getBody());
	echo 'statuscode: ' . $result->getStatusCode() ."\n";

	$body = $httpResponse->getBody(true);

	//$body = json_decode($result->getBody(), true);
	if (!isset($body['data'])) {
		return null;
	}
	return $body['data'];
}

$client = getClient($config);
$toDate = new DateTimeImmutable('now');
$datetime = date("Y-m-d H:i:s");
$timestamp = strtotime($datetime);
$time = $timestamp - (200 * 1800);
$datetime = date("Y-m-d H:i:s", $time);
$fromDate = new DateTimeImmutable($datetime);
$from = (int)$fromDate->format('Uv');
$to = (int)$toDate->format('Uv');
print('from:' . $from . '  to:' . $to . chr(10));
echo $fromDate->format("Y-m-d H:i:s") . "\n";
echo $toDate->format("Y-m-d H:i:s") . "\n";
try {
	$i=0;
    $output = [];
	$result = $client->request('GET', '/api/v1/kline/query', [
		'headers' => ['User-Agent' => 'KuCoin-Futures-PHP-SDK/1.0.22'],
		'query' => [
		'symbol' => 'DOTUSDTM',
		'granularity' => '30',
		//'from' => $from,
		'to' => $to],

	]);
	$data = getApiData($result);

	foreach ($data as $tick) {
	   list($openTime, $open, $high, $low, $close, $volact) = $tick;
	   $output[$i] = [
	      "openTime" => (new DateTime(date('m/d/Y H:i:s',intval($openTime)/1000)))->format('Y-m-d H:i:s'),	   
              "open" => $open,
              "high" => $high,
              "low" => $low,
              "close" => $close,
              "volume" => $volact];
	   $i = $i + 1;
	}

    var_dump($output);

} catch (HttpException $e) {
    var_dump($e->getMessage());
} catch (BusinessException $e) {
    var_dump($e->getMessage());
}

// symbol=.KXBT&granularity=480&from=1535302400000&to=1559174400000