<?php


function getStatus(){
    $parameters['symbol'] = 'DOTUSDT';
    $response = signedRequest('GET', 'fapi/v1/openOrders','fapi', $parameters);   
    if(empty($response)){
        return 0;
    }else{
        return 1;
    }
}

function getPrice(){
    $parameters['symbol'] = 'DOTUSDT';
    $porAv = 0.95;
    $porTp = 0.36;
    $porSm = 0.12;
    $retval = [
      "price" => 0,
      "avBal" => 0,    
      "qty" => 0,
      "porAv" => 0,
      "porTp"  => 0,
      "porSm"  => 0,
      "impTp" => 0,
      "impSm" => 0,
      "doit" => 0,
      "delor" => 0
    ];
    $response = signedRequest('GET', 'fapi/v1/ticker/price','fapi', $parameters); 
    if (array_key_exists('price', $response)) {
      $price = $response["price"];
      $response = signedRequest('GET', 'fapi/v2/account', 'fapi'); 
      if (array_key_exists('availableBalance', $response)) {
        $avBal = $response['availableBalance'] * $porAv;
        //$qty = intval($avBal/$price );
        $qty = round($avBal/$price, 1);
        $retval = [
            "price" => $price,
            "avBal" => number_format(round($avBal  ,3), 3, '.', ','),    
            "qty" => $qty,
            "porAv" => $porAv,
            "porTp"  => $porTp,
            "porSm"  => $porSm,
            "impTp" => 0,
            "impSm" => 0,            
            "doit" => 0,
            "delor" => 0
        ];
      }
    }
    return $retval;
}
function getOrderStatusById($cliOrderId){
    $parameters['symbol'] = 'DOTUSDT';
    $parameters['origClientOrderId'] = $cliOrderId;
    $response = signedRequest('GET', 'fapi/v1/order','fapi', $parameters); 
    if (array_key_exists("status", $response)) {
        return  $response['status'];
    }else{
        return  "FALSE";
    }

}
function getOrderPosition(){
    $status = 0;
    $response = signedRequest('GET', 'fapi/v2/account', 'fapi');
    foreach($response['positions'] as $posit)  {
        if($posit['symbol'] === "DOTUSDT"){
          if($posit['initialMargin'] > 0){
            $status = 1;
          }
        }
    }
    return $status;
}
function optTrade($opttrade,$togetData){
    $resval = getPrice();
    print_r($resval);
    $resval['doit'] = 0;
    $cntrl = 1;
    $orderId = round(microtime(true) * 1000);
    if($opttrade === 1){
        // lo comentado es en caso de LI se LIMIT
        //$impTP = round($resval['price'] +  (($resval['price'] * $resval['porTp']) / 100),3);
        //$impSM = round($resval['price'] -  (($resval['price'] * $resval['porSm']) / 100),3);
        $side = "SELL";
        $sideLI = "BUY";
    }else{
        //$impTP = round($resval['price'] -  (($resval['price'] * $resval['porTp']) / 100),3);
        //$impSM = round($resval['price'] +  (($resval['price'] * $resval['porSm']) / 100),3);    
        $side = "BUY";
        $sideLI = "SELL";
    }
    //$resval['impTp'] = $impTP;
    //$resval['impSm'] = $impSM;
       $orParams = [
        'price' => $resval['price'],
        'qty' => $resval['qty'],
        'imptp' => 0,   
        'impsm' => 0, 
        'porsm' => $resval['porSm'],
        'side' => $side,
        'sideli' => $sideLI,        
        'orderId' => "1m" . $orderId,
        'orderIdLi' => "1m" . $orderId,        
        'opttrade'  => $opttrade
    ];
    if($togetData['qstat'] === 0){
        $doitli = liOrder($orParams);
    }else{
        $doitli = 1; 
        $orParams['orderIdLi'] = $togetData['orderid'];
        $orParams['qty'] = $togetData['quantity']; 
        $resval['price'] = $togetData['price']; 
        $side = $togetData['side'];
        $sideLI = $togetData['sideli'];    
    }

    if($doitli  === 1){
        print("START LI = MARKET" . chr(10));
        //START LI = MARKET
        if($togetData['qstat'] === 0){
            $cliOrderIdLi = $orParams['orderIdLi'] . "LI";
            //setLastOrder($cliOrderIdLi);
            $priceli = oneOrderLi($cliOrderIdLi);
            $resval['price'] = $priceli['price'];
        }
        if($opttrade === 1){
            $impTP = round($resval['price'] +  (($resval['price'] * $resval['porTp']) / 100),3);
            $impSM = round($resval['price'] -  (($resval['price'] * $resval['porSm']) / 100),3);
        }else{
            $impTP = round($resval['price'] -  (($resval['price'] * $resval['porTp']) / 100),3);
            $impSM = round($resval['price'] +  (($resval['price'] * $resval['porSm']) / 100),3);    
        }
        $resval['impTp'] = $impTP;
        $resval['impSm'] = $impSM;
        $orParams = [
            'price' => $resval['price'],
            'qty' => $resval['qty'],
            'imptp' => $impTP,   
            'impsm' => $impSM, 
            'porsm' => $resval['porSm'],
            'side' => $side,
            'sideli' => $sideLI,        
            'orderId' => "1m" . $orderId,
            'orderIdLi' => "1m" . $orderId,            
            'opttrade'  => $opttrade
        ];
 
        // END LI = MARKET       
        tpOrder($orParams);
        slOrder($orParams);
    }
    return $orParams;
}
function liOrder($orParams){
    $quantity = $orParams['qty'];
    $impTP = $orParams['imptp'];
    $side = $orParams['sideli'];
    $orderId = $orParams['orderIdLi'];
    $price = $orParams['price'];
    $cliOrderId = "";
    $doit = 0;
    $response = signedRequest('POST', 'fapi/v1/order', 'fapi',[
        'symbol' => 'DOTUSDT',
        'side' => $side, 
        'type' => 'MARKET',
        //'timeInForce' => 'GTC',
        'quantity' => $quantity,
        //'price' => $price,
        'workingType' =>  'CONTRACT_PRICE',
        'newClientOrderId' => $orderId . "LI", 
        'recvWindow' => "5000"
    ]);

    //if (array_key_exists("clientOrderId", $response)) {
        $cliOrderId = $orderId . "LI";
        sleep(5);
        while(true){
            $status = getOrderStatusById($cliOrderId);
            print("qpasa en liOrder" . chr(10));
            print($status .chr(10));
            if($status === "FILLED"){
                $doit = 1;
                break;
            }elseif($status === "NEW"){
                sleep(2);
            }else{
                $doit = 0;
                break;       
            }
        }
    //}else{
        //$doit = 0;
    //}
    return $doit;
}
function tpOrder($orParams){
    $quantity = $orParams['qty'];
    $impTP = $orParams['imptp'];
    $side = $orParams['side'];
    $orderId = $orParams['orderId'];
    $response = signedRequest('POST', 'fapi/v1/order', 'fapi',[
      'symbol' => 'DOTUSDT',
      'side' => $side, 
      'type' => 'TAKE_PROFIT_MARKET',
      'timeInForce' => 'GTC',
      'quantity' => $quantity,
      'stopPrice' => $impTP,
      'workingType' =>  'MARK_PRICE',
      'priceProtect' => 'true',
      'reduceOnly' => 'true',
      'newClientOrderId' => $orderId . "TP",
      'recvWindow' => "5000" 
    ]);
    $cliOrderId = $orderId . "TP";
    sleep(5);
    while(true){
        $status = getOrderStatusById($cliOrderId);
        if($status === "NEW"){
            break;
        }elseif($status !== "FALSE"){
            sleep(2);
        }else{
            break;       
        }
    }
    if (!array_key_exists("side", $response)) {
        print ("TP error START-" . $orderId . "TP" . chr(10));
        print_r($response);
        print ("TP error END-" . $orderId . "TP" . chr(10));
        sendAlertTelegram("TP error " . $orderId . "TP" . chr(10) . $response['msg'] . chr(10));
    }
}
function slOrder($orParams){
    $quantity = $orParams['qty'];
    $impSM = $orParams['impsm'];
    $side = $orParams['side'];
    $orderId = $orParams['orderId'];
    $response = signedRequest('POST', 'fapi/v1/order', 'fapi',[
      'symbol' => 'DOTUSDT',
      'side' => $side, 
      'type' => 'STOP_MARKET',
      'timeInForce' => 'GTC',
      'quantity' => $quantity,
      'stopPrice' => $impSM,
      'workingType' =>  'MARK_PRICE',
      'priceProtect' => 'true',
      'reduceOnly' => 'true',
      'newClientOrderId' => $orderId . "SM",
      'recvWindow' => "5000" 
    ]);
    $cliOrderId = $orderId . "SM";
    sleep(5);
    while(true){
        $status = getOrderStatusById($cliOrderId);
        if($status === "NEW"){
            break;
        }elseif($status !== "FALSE"){
            sleep(2);
        }else{
            break;       
        }
    }
    if (!array_key_exists("side", $response)) {
        print ("SM error START-" . $orderId . "SM" . chr(10));
        print_r($response);
        print ("SM error END-" . $orderId . "SM" . chr(10));
        sendAlertTelegram("SM error " . $orderId . "SM" . chr(10) . $response['msg'] . chr(10));
    }   
}

function cancelAll($orParams, $from){
    $cliOrderIdLi = $orParams['orderIdLi'] . "LI";
    $cliOrderIdTp = $orParams['orderId'] . "TP";
    $cliOrderIdSm = $orParams['orderId'] . "SM";
    $statusTp = getOrderStatusById($cliOrderIdTp);
    $statusSm = getOrderStatusById($cliOrderIdSm); 
    $opttrade = $orParams['opttrade'];
    $resp = 0;
    //if($statusTp === "FALSE" or $statusSm === "FALSE"){
        print("cancelAll(" .$from . ")- statusTp " . $statusTp . " statusSm " . $statusSm . chr(10));
        deleteOrder();
        $sideli = oneOrderLi($cliOrderIdLi);
        print("cancelAll(" . $from . ") - antes: " . $orParams['sideli'] . " despues: " . $sideli['side'] . chr(10));
        $statusLi = getOrderPosition();
        if($statusLi === 1){
            $orParams['sideli'] = $sideli['side'];
            $orParams['orderIdLi'] = $orParams['orderIdLi'] . "C";
            $doitli = liOrder($orParams);
        }
        $resp = 1;
    //}
    return $resp;
}
function oneOrderLi($cliOrderId){
    $liparams['symbol'] = 'DOTUSDT';
    $liparams['origClientOrderId'] = $cliOrderId;
    $response = signedRequest('GET', 'fapi/v1/order','fapi', $liparams); 
    if($response['side'] === 'SELL'){
        $resLi = [
            //number_format(round($response['avgPrice']  ,3), 3, '.', ',')
            'price' => $response['avgPrice'],
            'side' => "BUY"   
        ];
        return $resLi;
    }else{
        $resLi = [
            'price' => $response['avgPrice'],
            'side' => "SELL"   
        ];
        return $resLi;
    }
}
function getOrdeLi($cliOrderId){
    $oneOrder = [];
    $liparams['symbol'] = 'DOTUSDT';
    $liparams['origClientOrderId'] = $cliOrderId;
    $response = signedRequest('GET', 'fapi/v1/order','fapi', $liparams); 
    if (array_key_exists('avgPrice', $response)) {
        $oneOrder = $response;
    }  
    return $oneOrder; 
}
function deleteOrder(){
    $responDE = signedRequest('POST', 'fapi/v1/countdownCancelAll','fapi', [

    'symbol' => 'DOTUSDT',
    'countdownTime' => 1000
    ]);
}
function deleteBatchOrder(){
    global $ORDER_ID;
    $responDE = signedRequest('DELETE', 'fapi/v1/batchOrders','fapi', [
        'symbol' => 'DOTUSDT',
        'origClientOrderIdList' => [$ORDER_ID . "TP",$ORDER_ID . "SM"]
    ]);
}



function buildQuery($params = [])
{
    $new_arr = array();
    $query_add = '';
    foreach ($params as $label=>$item) {
        if ( gettype($item) == 'array' ) {
            foreach ($item as $arritem) {
                $query_add = $label . '=' . $arritem . '&' . $query_add;
            }
        } else {
            $new_arr[$label] = $item;
        }
    }
    $query = http_build_query($new_arr, '', '&');
    $query = $query_add . $query;

    return $query;
} 
function signatureRSA($data) {
    $pkeyid = openssl_pkey_get_private("file:///var/www/html/Private_keyAle");
    openssl_sign($data, $signature, $pkeyid, 'RSA-SHA256');
    openssl_free_key($pkeyid);
    return $signature;
}
function signedRequest($method, $path, $baseurl, $parameters = []) {
    global $SECRET;
    $parameters['timestamp'] = round(microtime(true) * 1000);
    $query = buildQuery($parameters);
    $signatureRSA =urlencode(base64_encode(signatureRSA($query)));
    return sendRequest($method, "${path}?${query}&signature=${signatureRSA}", $baseurl);
}
function sendRequest(string $method = "GET", $path, $baseurl, bool $signed = false)
{
    global $KEY;
    global $BASEF_URL;
    global $BASES_URL;
    switch ($baseurl) {
        case "fapi":
            $strUrl = "${BASEF_URL}${path}";
            break;
        case "sapi":
            $strUrl = "${BASES_URL}${path}";
            break;
        default:
        $strUrl = "${BASEF_URL}${path}";
    }
    $headers = array
    (
        'Content-Type: application/json',
        'X-MBX-APIKEY:' . $KEY
    );
    $ch = curl_init();
    
    curl_setopt($ch, CURLOPT_URL,$strUrl);
    curl_setopt($ch, CURLOPT_USERAGENT, "User-Agent: Mozilla/4.0 (compatible; PHP Binance API)");
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_POST, $method == "POST" ? true : false);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 60);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $result = curl_exec($ch);
    $json = json_decode($result, true);
    if (curl_errno($ch) > 0) {
        // should always output error, not only on httpdebug
        // not outputing errors, hides it from users and ends up with tickets on github
        echo 'Curl error: ' . curl_error($ch) . "\n";
    }
    curl_close($ch);
    return $json;        
} 
function setLastOrder($orderId){
    $filename = "lastOrder.txt";
    $file = fopen( $filename, "w" );
    fwrite($file, $orderId);
    fclose( $file );
}

function getLastOrder(){
    $filename = "lastOrder.txt";
    $file = fopen($filename, "r" );
    $filesize = filesize( $filename );
    $filetext = fread( $file, $filesize );
    fclose( $file );
    return $filetext;
}
function getRisk(){
    $prisk = signedRequest('GET', 'fapi/v2/positionRisk', 'fapi', ['symbol' => 'DOTUSDT']);
    $lev = $prisk['leverage'] > 0 ? $prisk['leverage'] : 1;
    $not = number_format(round(($prisk['notional'] / $lev) ,3), 3, '.', ',');
    print("risk" .chr(10));
    print_r($prisk);
    return $not;
}
// get orders information
function openOrders(){
    $parameters['symbol'] = 'DOTUSDT';
    $response = signedRequest('GET', 'fapi/v1/openOrders','fapi', ['symbol' => 'DOTUSDT']); 
    print_r($response);
    /*
    foreach($response as $posit)  {
      $posit['time'] = (new DateTime(date('m/d/Y H:i:s',intval($posit['time'])/1000)))->format('Y-m-d H:i:s');
      $posit['updateTime'] = (new DateTime(date('m/d/Y H:i:s',intval($posit['updateTime'])/1000)))->format('Y-m-d H:i:s');
      print('|orderId: ' . $posit['orderId'] . '|status: ' . $posit['status'] .  '|price: ' . $posit['price'] . '|origQty: ' . 
      $posit['origQty'] .  '|type: ' . $posit['type'] .  '|side: ' . $posit['side'] .  '|origType: ' . $posit['origType'] . 
      '|time: ' . $posit['time'] .  '|updateTime: ' .$posit['updateTime'] . chr(10));
    }
  */
}
function compare_two($a, $b)
{
  // sort by time
  $retval = strnatcmp($a['time'], $b['time']);
  // if time are identical, sort by clientOrderId
  if(!$retval) $retval = strnatcmp($a['clientOrderId'], $b['clientOrderId']);
  return $retval;
}

function allOrders(){
  $date = (new DateTime('now'));
  $h = ($date)->format('H');
  $m = ($date)->format('i');
  $tosub = new DateInterval('PT' . $h .'H' . $m . 'M'); // xH
  $date->sub($tosub);
  $from =  strtotime($date->format("Y-m-d H:i:s")) * 1000;
  $parameters['symbol'] = 'DOTUSDT';
  $response = signedRequest('GET', 'fapi/v1/allOrders','fapi', ['symbol' => 'DOTUSDT']);
  usort($response, 'compare_two');
  //sort($response);

  foreach($response as $posit)  {
    $timems = $posit['time'];
    if($timems > $from){
      if ($posit['origType'] === "MARKET"){
        $posit['price'] = $posit['avgPrice'];
        print(chr(10));
        //print_r($posit);
      }else{
        $posit['price'] = $posit['stopPrice'];
      }

      $posit['time'] = (new DateTime(date('m/d/Y H:i:s',intval($posit['time'])/1000)))->format('Y-m-d H:i:s');
      $posit['updateTime'] = (new DateTime(date('m/d/Y H:i:s',intval($posit['updateTime'])/1000)))->format('Y-m-d H:i:s');
      print('time: ' . $posit['time'] . '|orderId: ' . $posit['clientOrderId'] . ' |status: ' . $posit['status'] .  '|price: ' . $posit['price'] . '|origQty: ' . 
      $posit['origQty'] .  '|type: ' . $posit['type'] .  '|side: ' . $posit['side'] .  '|origType: ' . $posit['origType'] . 
       chr(10));

    }
   
  }
}
function getAllOrders(){
    print("openOrders" .chr(10));
    openOrders();
    print("allOrders" .chr(10));
    allOrders();
    $response = signedRequest('GET', 'fapi/v2/account', 'fapi'); 
  
    foreach($response['positions'] as $posit)  {
        if($posit['symbol'] === "SOLUSDT"){
          $posit['updateTime'] = (new DateTime(date('m/d/Y H:i:s',intval($posit['updateTime'])/1000)))->format('Y-m-d H:i:s');      
          print_r($posit);
          print(chr(10));
        }
    }

    $risk = getRisk();
}
function sendAlertTelegram($tokentel)
{
    $token = "296248250";
    $tokenall = array(0 => "1439504606", 1 => "1567169349");
    //$token = $tokentel;
    $body = "<b>******* " . "Alerta" . " ********</b>" . chr(10);      
    $body = $body . "<b>*** intervalo: 1m ***</b>" . chr(10);     
    $body = $body . $tokentel . chr(10);            
    $disable_web_page_preview = true;
    $reply_to_message_id = false;
    $reply_markup = null;
    $parse_mode = "HTML";  

    $data = array(
        'chat_id' => urlencode($token),
        'text' => $body,
        'disable_web_page_preview' => urlencode($disable_web_page_preview),
        'reply_to_message_id' => urlencode($reply_to_message_id),
        'reply_markup' => urlencode($reply_markup),
        'parse_mode' => urlencode($parse_mode)            
    );
    $con = createTrdTelegram(json_encode($data));  
     
    /*
    for ($i = 0; $i <= 1; $i++) {
        $data = array(
            'chat_id' => urlencode($tokenall[$i]),
            'text' => $body,
            'disable_web_page_preview' => urlencode($disable_web_page_preview),
            'reply_to_message_id' => urlencode($reply_to_message_id),
            'reply_markup' => urlencode($reply_markup),
            'parse_mode' => urlencode($parse_mode)            
        );
        $con = createTrdTelegram(json_encode($data));     
    }
    */ 

}
function createTrdTelegram($data) {
    $strUrl = "https://api.telegram.org/bot6296460900:AAF8ngZlKOpRm5iSR_-pkjbqkxqcIBLSgnk/sendMessage";
    $headers = array
    (
        'Content-Type: application/json'
    );
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL,$strUrl);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    $result = curl_exec($ch);
    curl_close($ch);    
    return $result;
} 

$opt = [
    "symbol" => "DOTUSDT",
    "interval" => "1m",
    "limit" => 1   
];
$parameters['symbol'] = 'DOTUSDT';
$CV = 1; 
$KEY= 'UlISjUlDik1Ho1G7Lbfw8xoEnCbZkMd5q80PjDZj4RdCpLhIJ23ExLHSmJ72uVVU';  // 
$BASEF_URL = 'https://fapi.binance.com/'; // production
$BASES_URL = 'https://api.binance.com/';
//$filetext  = strtotime("now");
$filetext  = 0;
$v = 0;
$togetData = [
    "cv" => 0,
    "price" => 0,
    'quantity' => 0,
    'orderid' => 0,
    'side' => "SELL",
    'sideli' => "BUY",
    'qstat' => 0 
];
/*
  $orParams = optTrade(1,$togetData);
  print("antes de cancel **********************" . chr(10));
  print_r($orParams);
  sleep(10);
  getAllOrders();
  $canceall = 0;
  sleep(10);
  $canceall = cancelAll($orParams, "Inicio");
  print("despues de cancel **********************" . chr(10));
  getAllOrders();
  */
  while(true){
    getAllOrders();
    sleep(10);
    $date = new \DateTime('now');

    $tokentel = "UTC: " . $date->format('Y-m-d H:i:s') . chr(10);
    $date->setTimeZone(new \DateTimeZone('America/Argentina/Buenos_Aires'));
    $tokentel = $tokentel . "Argentina-Buenos Aires : " . $date->format('Y-m-d H:i:s') . chr(10);
    $tokentel = $tokentel . "No ha sido posible cerrar orden MARKET, " . chr(10);
    $tokentel = $tokentel . "proceda a cerrarla desde la App" . chr(10);
    $tokentel = $tokentel . "<b>**** el bot se ha parado **** </b>" . chr(10);
    $tokentel = $tokentel . "Una vez cerrada la orden, pulse sobre este enlace:" . chr(10);
    $tokentel = $tokentel . "<b>https://glotratecres.com/proces/s1m</b>" . chr(10);
    sendAlertTelegram($tokentel);
    exit;
    //break;

  }

?>
