<?php

/*
Copyright 2010 Ludovico Fischer. All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:
1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice, this list
   of conditions and the following disclaimer in the documentation and/or other materials
   provided with the distribution.

THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

class ansTrade {
    public function gestresp() {
      
        $uri = $_SERVER['REQUEST_URI'];
        $method = $_SERVER['REQUEST_METHOD'];
        $paths = explode('/', $this->paths($uri));
        array_shift($paths); // Hack; get rid of initials empty string
        $resource = array_shift($paths);
      
        if ($resource == 'proces') {
            $name = array_shift($paths);
	
            if (empty($name)) {
                $this->handle_base($method);
            } else {
                $this->handle_name($method, $name);
            }
          
        } else {
            // We only handle resources under 'proces'
            echo "<p>No autorizado</p>";
            header('HTTP/1.1 404 Not Found');
        } 
    }
        
    private function handle_base($method) {
        switch($method) {
        case 'GET':
            $this->result();
            break;
        default:
            header('HTTP/1.1 405 Method Not Allowed');
            header('Allow: GET');
            break;
        }
    }

    private function handle_name($method, $name) {
        switch($name) {
            case 'k1m':
            case 'k15m':
            case 'k15mdmi':
            case 'k30m':
                $this->killproc($name);
                break;
            case 's1m':
            case 's15m':      
            case 's15mdmi':
            case 's30m':
                $this->startproc($name);
                break;
            case 'h1m':
            case 'h15m':
            case 'h15mdmi':
            case 'h30m':
                $this->showhist($name);
                break;
            case 'spot':
                $output = shell_exec("php ./spot.php");
                echo "<p>$output</p>";
            default:
                header('HTTP/1.1 400 Bad Request');
                echo 'Solo se permite: k1m, k15m, k30m, s1m, s15m, s30m, spot';
                break;
        }
    }

    private function killproc($name){
        switch($name) {
            case 'k1m':
                $procn = shell_exec("ps -aux|grep gesttrade1m|grep php|grep -v grep| awk '{print $2}'");
                //$output = shell_exec("sudo kill -9 " . $procn);
                $output = posix_kill($procn, 9);
                echo "<p>kill Proc: $procn Response:$output</p>";
                break;
            case 'k15m':
                $procn = shell_exec("ps -aux|grep gesttrade15m|grep php|grep -v grep| awk '{print $2}'");
                //$output = shell_exec("sudo kill -9 " . $procn);
                $output = posix_kill($procn, 9);
                echo "<p>kill Proc: $procn Response:$output</p>";
		        break; 
             case 'k15mdmi':
                $procn = shell_exec("ps -aux|grep botdmi15|grep php|grep -v grep| awk '{print $2}'");
                //$output = shell_exec("sudo kill -9 " . $procn);
                $output = posix_kill($procn, 9);
                echo "<p>kill Proc: $procn Response:$output</p>";
                break;
            case 'k30m':
                $procn = shell_exec("ps -aux|grep gesttrade30m|grep php|grep -v grep| awk '{print $2}'");
                //$output = exec("skill -9 -uroot" . $procn);
                $output = posix_kill($procn, 9);
                echo "<p>kill Proc: $procn Response:$output</p>";
                break;
        }
    }
    private function startproc($name){
        switch($name) {
            case 's1m':
                $proex = shell_exec("ps -aux|grep gesttrade1m|grep php|grep -v grep| awk '{print $2}'");
                if($proex > 0){
                    echo "<p>Hay un proceso en curso Proc: $proex</p>";
                }else{
                    $procn = exec("nohup php gesttrade1m.php > trade1m.out &");
                }
                break;
            case 's15m':
                $proex = shell_exec("ps -aux|grep gesttrade15m|grep php|grep -v grep| awk '{print $2}'");
                if($proex > 0){
                    echo "<p>Hay un proceso en curso Proc: $proex</p>";
                }else{
                    $procn = exec("nohup php gesttrade15m.php > trade1m.out &");
                }
		        break;                
            case 's15mdmi':
                $proex = shell_exec("ps -aux|grep botdmi15|grep php|grep -v grep| awk '{print $2}'");
                if($proex > 0){
                    echo "<p>Hay un proceso en curso Proc: $proex</p>";
                }else{
                    $procn = exec("nohup php gesttrade15m.php > trade1m.out &");
                }
                break;
            case 's30m':
                $proex = shell_exec("ps -aux|grep gesttrade30m|grep php|grep -v grep| awk '{print $2}'");
                if($proex > 0){
                    echo "<p>Hay un proceso en curso Proc: $proex</p>";
                }else{
                    $procn = exec("nohup php gesttrade30m.php > trade30m.out &");
                }
                break;
        }
    }
    private function showhist($name){
        switch($name) {
            case 'h1m':
                $output = shell_exec("cat ./trade1m.out");
                echo "<pre style='font-size: 1.1em'>$output</pre>";
                break;
            case 'h15m':
                $output = shell_exec("cat ./trade15m.out");
                echo "<pre style='font-size: 1.1em'>$output</pre>";
		        break;   
           case 'h15mdmi':
                $output = shell_exec("cat ./botdmi15.out");
                echo "<pre style='font-size: 1.1em'>$output</pre>";
                break;
            case 'h30m':
                $output = shell_exec("cat ./trade30m.out");
                echo "<pre style='font-size: 1.1em'>$output</pre>";
                break;
        }
    }    
    private function paths($url) {
        $uri = parse_url($url);
        return $uri['path'];
    }
    
    /**
     * Displays a list of all contacts.
     */
    private function result() {
        header('HTTP/1.1 404 Not Found');
        echo "<p>Petición incompleta</p>";
    }
  }

$server = new ansTrade;
$server->gestresp();

?>
