<?php
function getData($togetData)
{
    $symbol = "DOTUSDT";
    $interval = "15m";
    $limit = 21;
    $opt = [
        "symbol" => $symbol,
        "interval" => $interval,
        "limit" => $limit   
    ];

   $varinter = [];
    for ($i = 1; $i <= 3; $i++) {
        $varinter[$i] = [
        "interval" => 0,
        "valret" => []       
                
        ];
    }
    $varinter[1]['interval'] = '15m';
    $varinter[2]['interval'] = '15m';
    $varinter[3]['interval'] = '15m';
    $adx = 0;        
    $opt["interval"] = $varinter[1]['interval'];
    $query = buildQuery($opt);
    $json = sendRequest("GET","fapi/v1/klines?${query}",  "fapi"); 

    $valret = candleSticks($json, $varinter[1]['interval']);

    $res = $valret["valret"];
    $CV = "C";
    $emitir = "** No **";
    $mensaje = 0;
    $may = "";
    $fechaope = (new DateTime(date('m/d/Y H:i:s',intval($res[19]["openTime"])/1000)))->format('Y-m-d H:i:s');
    $fechaclo = (new DateTime(date('m/d/Y H:i:s',intval($res[19]["closeTime"])/1000)))->format('Y-m-d H:i:s');   
    if (
        $res[19]["volact"] >= ($valret["volmed"] * 6)  and  //se baja de 6 a 4 para pruebas -vuelto a 4 el 08/08/2023
        $res[18]["close"] < $res[14]["open"]){
        $mensaje = 1; //compra
        $accion = "Comprar";
    }elseif (
        $res[19]["volact"] >= ($valret["volmed"] * 6)  and  //se baja de 6 a 4 para pruebas -vuelto a 4 el 08/08/2023
        $res[18]["close"] > $res[14]["open"]){
        $mensaje = 2;   // venta  
        $accion = "Vender";    
    }else{
        $mensaje = 0;
        $accion = "Mantener"; 
    }
    if($togetData['cv'] > 0){
        $mensaje = $togetData['cv'];
    }
    if($mensaje > 0){
        printLog( $fechaope . "|" . $fechaclo . "|vol-act: " . $res[19]["volact"] . "|vol-med: " . ($valret["volmed"] * 6).   //se baja de 6 a 4 para pruebas -vuelto a 4 el 08/08/2023
        "|Cierre PENULTIMA:" .  $res[18]["close"] . "|Apertura 5 ATRAS:" . $res[14]["open"] . "|" . 
        "|". $accion . chr(10));
    } 
    $tokentel = [
        "fechaope" => $fechaope,
        "fechaclo" => $fechaclo,
        "volact" => $res[19]["volact"],
        "volmed" => $valret["volmed"],
        "close" => $res[18]["close"],
        "open" => $res[14]["open"],  
        "interval" => "15m",              
        "accion" => $accion,
        "tim" => $res[19]["closeTime"]/1000,
        "init" => 0,
        "resCV" => [
            "price" => 0,
            "avBal" => 0,    
            "qty" => 0,
            "porAv" => 0,
            "porTp"  => 0,
            "porSm"  => 0,
            "impTp" => 0,
            "impSm" => 0,
            "doit" => 0 
        ]
    ];

    
    if ($mensaje > 0){
        sendTrdTelegram($tokentel);
        $status = getStatus();
        if($status === 0){
            $tokentel['init'] = 1;
            if($mensaje === 1){
                $tokentel['resCV']  = optTrade($mensaje, $togetData);

                sendTrdTelegram($tokentel); 
            }elseif($mensaje === 2){
                $tokentel['resCV']  = optTrade($mensaje, $togetData);
                sendTrdTelegram($tokentel);
            }
        }

    }


}
function candleSticks($json,  $interval = "15m")
{
    $i=0;
    $output = [];
    foreach ($json as $tick) {
        list($openTime, $open, $high, $low, $close, $volact, $closeTime, $baseVolume, $trades, $assetBuyVolume, $takerBuyVolume, $ignored) = $tick;
        $output[$i] = [
            "open" => $open,
            "high" => $high,
            "low" => $low,
            "close" => $close,
            "volume" => $baseVolume,
            "openTime" => $openTime, 
            "closeTime" => $closeTime, 
            "volact" => $volact,
            "ignored" => 0
        ];
        $i = $i + 1;
    } 
    $vol_med = 0;
    for ($i = 0; $i < (count($output)-1); $i++) {
        $vol_med = $vol_med + $output[$i]['volact'];
    }
    $vol_med = $vol_med / 20;
    $retval = [
        "volmed" => $vol_med,
        "valret" => $output,
    ];
    return $retval;
}
function printLog($from){
    $date = (new DateTime('now'))->format('Y-m-d H:i:s');
    print( $date . ": " . $from );
}
function getStatus(){
    $parameters['symbol'] = 'DOTUSDT';
    $response = signedRequest('GET', 'fapi/v1/openOrders','fapi', $parameters);   
    if(empty($response)){
        return 0;
    }else{
        return 1;
    }
}

function getPrice(){
    $parameters['symbol'] = 'DOTUSDT';
    $porAv = 0.95;
    $porTp = 3.0;
    $porSm = 1.0;
    $apala = 1;
    $retval = [
      "price" => 0,
      "avBal" => 0,    
      "qty" => 0,
      "porAv" => 0,
      "porTp"  => 0,
      "porSm"  => 0,
      "impTp" => 0,
      "impSm" => 0,
      "doit" => 0,
      "delor" => 0
    ];
    $response = signedRequest('GET', 'fapi/v1/ticker/price','fapi', $parameters); 
    if (array_key_exists('price', $response)) {
      $price = $response["price"];
      $response = signedRequest('GET', 'fapi/v2/account', 'fapi'); 
      if (array_key_exists('availableBalance', $response)) {
        $avBal = $response['availableBalance'] * $porAv;
        $apala = getLeverage();
        $qty = (round($avBal/$price, 1)) * $apala;
        $retval = [
            "price" => $price,
            "avBal" => number_format(round($avBal  ,3), 3, '.', ','),    
            "qty" => $qty,
            "porAv" => $porAv,
            "porTp"  => $porTp,
            "porSm"  => $porSm,
            "impTp" => 0,
            "impSm" => 0,            
            "doit" => 0,
            "delor" => 0
        ];
      }
    }
    return $retval;
}
function getOrderStatusById($cliOrderId){
    $parameters['symbol'] = 'DOTUSDT';
    $parameters['origClientOrderId'] = $cliOrderId;
    $status = "";
    $mytry = 0;
    while(true){
        $response = signedRequest('GET', 'fapi/v1/order','fapi', $parameters); 
        if (array_key_exists("status", $response)) {
            $status = $response['status'];
            break;
        }else{
            sleep(5);
            $mytry = $mytry  + 1;
            if ($mytry >= 10){
                $status = "FALSE";
                break;
            }
        }
    }
    return $status;
}
function printPosition(){
    printLog("positions" . chr(10));
    $response = signedRequest('GET', 'fapi/v2/account', 'fapi');
    foreach($response['positions'] as $posit)  {
        if($posit['symbol'] === "DOTUSDT"){
            $posit['updateTime'] = (new DateTime(date('m/d/Y H:i:s',intval($posit['updateTime'])/1000)))->format('Y-m-d H:i:s');      
            //print_r($posit);
            printLog("symbol:" . $posit['symbol'] . " | updateTime:" . $posit['updateTime'] . " | initialMargin:" . $posit['initialMargin'] . " | leverage:" . 
                    $posit['leverage'] . " | entryPrice:" . $posit['entryPrice'] . " | notional:" . $posit['notional'] . chr(10));
            //printLog(chr(10));
        }
    }
}
function getLeverage(){
    $apala = 1;
    $mytry = 0;
    while(true){
        $response = signedRequest('GET', 'fapi/v2/account', 'fapi', ['recvWindow' => "8000"]);
        if (array_key_exists("positions", $response)) {
            foreach($response['positions'] as $posit)  {
                if($posit['symbol'] === "DOTUSDT"){
                    if($posit['leverage'] > 0){
                        $apala = $posit['leverage'];
                    }
                    if($mytry === 1){
                        printLog("REC in getLeverage from: getPrice" . " leverage: " . $posit['leverage'] . chr(10));
                    }           
                }
            }
            break;
        }else{
            printLog("ERROR in getLeverage from: getPrice" . chr(10));
            printLog($response['code']. " " . $response['msg'] .chr(10));
            $mytry = 1;
            sleep(10);
        }
    }
    return $apala;

}
function getOrderPosition($from){
    $status = 0;
    $mytry = 0;
    while(true){
        $response = signedRequest('GET', 'fapi/v2/account', 'fapi', ['recvWindow' => "8000"]);
        if (array_key_exists("positions", $response)) {
            foreach($response['positions'] as $posit)  {
                if($posit['symbol'] === "DOTUSDT"){
                    if($posit['initialMargin'] > 0){
                        $status = 1;
                    }
                    if($mytry === 1){
                        printLog("REC in getOrderPosition from: " . $from . " status: " . $status . " margin: " . $posit['initialMargin'] . chr(10));
                    }           
                }
            }
            break;
        }else{
            printLog("ERROR in getOrderPosition from: " . $from . chr(10));
            printLog($response['code']. " " . $response['msg'] .chr(10));
            $mytry = 1;
            sleep(10);
        }
    }
    return $status;
}
function optTrade($opttrade,$togetData){
    $resval = getPrice();
    $resval['doit'] = 0;
    $cntrl = 1;
    $orderId = round(microtime(true) * 1000);
    if($opttrade === 1){
        // lo comentado es en caso de LI se LIMIT
        //$impTP = round($resval['price'] +  (($resval['price'] * $resval['porTp']) / 100),3);
        //$impSM = round($resval['price'] -  (($resval['price'] * $resval['porSm']) / 100),3);
        $side = "SELL";
        $sideLI = "BUY";
    }else{
        //$impTP = round($resval['price'] -  (($resval['price'] * $resval['porTp']) / 100),3);
        //$impSM = round($resval['price'] +  (($resval['price'] * $resval['porSm']) / 100),3);    
        $side = "BUY";
        $sideLI = "SELL";
    }
    //$resval['impTp'] = $impTP;
    //$resval['impSm'] = $impSM;
       $orParams = [
        'price' => $resval['price'],
        'qty' => $resval['qty'],
        'imptp' => 0,   
        'impsm' => 0, 
        'porsm' => $resval['porSm'],
        'side' => $side,
        'sideli' => $sideLI,        
        'orderId' => "15m" . $orderId,
        'orderIdLi' => "15m" . $orderId,        
        'opttrade'  => $opttrade
    ];
    if($togetData['qstat'] === 0){
        $doitli = liOrder($orParams);
    }else{
        $doitli = 1; 
        $orParams['orderIdLi'] = $togetData['orderid'];
        $orParams['qty'] = $togetData['quantity']; 
        $resval['price'] = $togetData['price']; 
        $side = $togetData['side'];
        $sideLI = $togetData['sideli'];    
    }

    if($doitli  === 1){
        //START LI = MARKET
        if($togetData['qstat'] === 0){
            $cliOrderIdLi = $orParams['orderIdLi'] . "LI";
            setLastOrder($cliOrderIdLi);
            $priceli = oneOrderLi($cliOrderIdLi);
            $resval['price'] = $priceli['price'];
        }
        if($opttrade === 1){
            $impTP = round($resval['price'] +  (($resval['price'] * $resval['porTp']) / 100),3);
            $impSM = round($resval['price'] -  (($resval['price'] * $resval['porSm']) / 100),3);
        }else{
            $impTP = round($resval['price'] -  (($resval['price'] * $resval['porTp']) / 100),3);
            $impSM = round($resval['price'] +  (($resval['price'] * $resval['porSm']) / 100),3);    
        }
        $resval['impTp'] = $impTP;
        $resval['impSm'] = $impSM;
        $orParams = [
            'price' => $resval['price'],
            'qty' => $resval['qty'],
            'imptp' => $impTP,   
            'impsm' => $impSM, 
            'porsm' => $resval['porSm'],
            'side' => $side,
            'sideli' => $sideLI,        
            'orderId' => "15m" . $orderId,
            'orderIdLi' => "15m" . $orderId,            
            'opttrade'  => $opttrade
        ];
 
        // END LI = MARKET       
        slOrder($orParams);
        tpOrder($orParams);
        $canceall = 0;
        $canceall = cancelAll($orParams, "Inicio");
        if($canceall === 1){
            $resval['doit'] = 0;
        }else{
            $retres = calcVaria($orParams);
            $resval['impSm'] =  $retres['impSm'];
            $resval["porSm"] =  $retres['porSm'];
            $resval["delor"] =  $retres['doit'];  
            $orParams['orderId'] = $retres['ordnewId'];
            $cntrl = $retres["docntrl"];
            if($cntrl === 1){
                $resval['doit'] = cntlOrders($orParams);
            }else{
                $resval['doit'] = 0;
            }

        }

    }
    return $resval;
}
function liOrder($orParams){
    $quantity = $orParams['qty'];
    $side = $orParams['sideli'];
    $orderId = $orParams['orderIdLi'];
    $price = $orParams['price'];
    $cliOrderId = "";
    $doit = 0;
    $response = signedRequest('POST', 'fapi/v1/order', 'fapi',[
        'symbol' => 'DOTUSDT',
        'side' => $side, 
        'type' => 'MARKET',
        //'timeInForce' => 'GTC',
        'quantity' => $quantity,
        //'price' => $price,
        'workingType' =>  'CONTRACT_PRICE',
        'newClientOrderId' => $orderId . "LI", 
        'recvWindow' => "5000"
    ]);

    //if (array_key_exists("clientOrderId", $response)) {
        $cliOrderId = $orderId . "LI";
        sleep(5);
        while(true){
            $status = getOrderStatusById($cliOrderId);
            if($status === "FILLED"){
                $doit = 1;
                break;
            }elseif($status === "NEW"){
                sleep(2);
            }else{
                $doit = 0;
                break;       
            }
        }
    //}else{
        //$doit = 0;
    //}
    return $doit;
}
function tpOrder($orParams){
    $quantity = $orParams['qty'];
    $impTP = $orParams['imptp'];
    $side = $orParams['side'];
    $orderId = $orParams['orderId'];
    $trycount = 0;
    $response = signedRequest('POST', 'fapi/v1/order', 'fapi',[
      'symbol' => 'DOTUSDT',
      'side' => $side, 
      'type' => 'TAKE_PROFIT_MARKET',
      'timeInForce' => 'GTC',
      'quantity' => $quantity,
      'stopPrice' => $impTP,
      'workingType' =>  'MARK_PRICE',
      'priceProtect' => 'true',
      'reduceOnly' => 'true',
      'newClientOrderId' => $orderId . "TP",
      'recvWindow' => "5000" 
    ]);
    $cliOrderId = $orderId . "TP";
    sleep(5);
    while(true){
        $status = getOrderStatusById($cliOrderId);
        printLog("create TP cliorderId: $cliOrderId status: $status" . chr(10));
        if($status === "NEW"){
            break;
        }elseif($status === "FALSE"){
            sleep(5);
            $trycount = $trycount  + 1;
            if ($trycount >= 10){
                break;
            }
        }else{
            break;       
        }
    }
    if (!array_key_exists("side", $response)) {
        printLog ("TP error START-" . $orderId . "TP" . chr(10));
        print_r($response);
        printLog ("TP error END-" . $orderId . "TP" . chr(10));
        sendAlertTelegram("TP error " . $orderId . "TP" . chr(10) . $response['msg'] . chr(10));
    }
}
function slOrder($orParams){
    $quantity = $orParams['qty'];
    $impSM = $orParams['impsm'];
    $side = $orParams['side'];
    $orderId = $orParams['orderId'];
    $trycount = 0;
    $response = signedRequest('POST', 'fapi/v1/order', 'fapi',[
      'symbol' => 'DOTUSDT',
      'side' => $side, 
      'type' => 'STOP_MARKET',
      'timeInForce' => 'GTC',
      'quantity' => $quantity,
      'stopPrice' => $impSM,
      'workingType' =>  'MARK_PRICE',
      'priceProtect' => 'true',
      'reduceOnly' => 'true',
      'newClientOrderId' => $orderId . "SM",
      'recvWindow' => "5000" 
    ]);
    $cliOrderId = $orderId . "SM";
    sleep(5);
    while(true){
        $status = getOrderStatusById($cliOrderId);
        printLog("create SL cliorderId: $cliOrderId status: $status" . chr(10));
        if($status === "NEW"){
            break;
        }elseif($status === "FALSE"){
            sleep(5);
            $trycount = $trycount  + 1;
            if ($trycount >= 10){
                break;
            }
        }else{
            break;       
        }
    }
    if (!array_key_exists("side", $response)) {
        printLog ("SM error START-" . $orderId . "SM" . chr(10));
        print_r($response);
        printLog ("SM error END-" . $orderId . "SM" . chr(10));
        sendAlertTelegram("SM error " . $orderId . "SM" . chr(10) . $response['msg'] . chr(10));
    }   
}
function calcVaria($orParams){
    printLog("in calcVaria" .chr(10));
    $cliOrderIdTp = $orParams['orderId'] . "TP";
    $cliOrderIdSm = $orParams['orderId'] . "SM";
    $preAct = $orParams['price'];
    $impSM = $orParams['impsm'];
    $porSM = $orParams['porsm'];
    $CV = $orParams['opttrade'];
    $muestra = [];
    $x = 1;
    $parameters['symbol'] = 'DOTUSDT';
    $retres = [
        "impSm" => $preAct,
        "porSm" => $porSM,
        "doit" => 0,
        "docntrl" => 1,
        "ordnewId" => $orParams['orderId']
    ];
    $ext = 0;
    $resnew = [];
    while(true){
      $response = signedRequest('GET', 'fapi/v1/ticker/price','fapi', $parameters);
      if (array_key_exists('price', $response)) {
          $price = $response["price"];
          $statusTp = getOrderStatusById($cliOrderIdTp);
          $statusSm = getOrderStatusById($cliOrderIdSm); 
          if(
            $statusTp === "FILLED" or $statusTp === "EXPIRED" or $statusTp === "CANCELED" or $statusTp === "FALSE" or
            $statusSm === "FILLED" or $statusSm === "EXPIRED" or $statusSm === "CANCELED" or $statusSm === "FALSE")
          { 
            $ext = 1; 
            break;
            $retres["docntrl"] = 1;
          }else{
            if($CV === 1){ //Compras
                $preOpe = number_format(round($preAct +  (($preAct * 1.0) / 100),3), 3, '.', ',');
                if($price  >= $preOpe){
                  $statusLi = getOrderPosition("calcVaria - C");
                  if($statusLi === 0){
                    $retres["docntrl"] = 1;
                  }else{
                    deleteOrder();
                    
                    $orParams['impsm'] = $preAct;  
                    $orParams['orderId'] = $orParams['orderIdLi']  . "V";  
                    slOrder($orParams); 
                    tpOrder($orParams);
                   /*
                    $canceall = 0;
                    $canceall = cancelAll($orParams, "Cambio SM");
                    if($canceall === 1){
                        $retres["docntrl"] = 0;
                    }else{
                        $retres["docntrl"] = 1;
                    }
                    */
                  }
                  $retres["docntrl"] = 1;
                  $ext = 1;
                  $retres["porSm"] = 1.0;
                  $retres["doit"] = 1;  
                  $retres['ordnewId'] = $orParams['orderId'];
                  printLog(" Comp.- statusLi:" . $statusLi . " preOpe:" . $preOpe . chr(10));  
                  break;                            
                }
            }else{ //Ventas
                $preOpe = number_format(round($preAct -  (($preAct * 1.0) / 100),3), 3, '.', ',');
                if($price  <= $preOpe){
                  $statusLi = getOrderPosition("calcVaria - V");
                  if($statusLi === 0){
                    $retres["docntrl"] = 1;
                  }else{
                    deleteOrder();
                    $orParams['impsm'] = $preAct;         
                    $orParams['orderId'] = $orParams['orderIdLi']  . "V"; 
                    slOrder($orParams); 
                    tpOrder($orParams);
                    /*
                    $canceall = 0;
                    $canceall = cancelAll($orParams, "Cambio SM");
                    if($canceall === 1){
                        $retres["docntrl"] = 0;
                    }else{
                        $retres["docntrl"] = 1;
                    }
                    */
                  }
                  $retres["docntrl"] = 1;
                  $ext = 1;
                  $retres["porSm"] = 1.0;
                  $retres["doit"] = 1; 
                  $retres['ordnewId'] =  $orParams['orderId'];                 
                  printLog(" Vent.- statusLi:" . $statusLi . " preOpe:" . $preOpe . chr(10));    
                  break;                                               
                }
            }
          }

  
      } 
      sleep(5); 
      //if ($ext === 1) {
          //break;
      //}
        
    }
    return $retres;
}
function cntlOrders($orParams){
    $cliOrderIdTp = $orParams['orderId'] . "TP";
    $cliOrderIdSm = $orParams['orderId'] . "SM";
    $doit = 1;
    $breakE = 0;
    printLog("in cntlOrders" .chr(10));
    $statusLi = getOrderPosition("cntlOrders - Init");
    $statusTp = getOrderStatusById($cliOrderIdTp);
    $statusSm = getOrderStatusById($cliOrderIdSm);
    printLog(" 3.- statusTp:" . $statusTp . " statusSm:" . $statusSm . " statusLi:" . $statusLi . chr(10));

    if($statusTp === "FILLED" or $statusSm === "FILLED"){
        printPosition();
        if($statusLi === 0){
            deleteOrder();
            $statusTp = getOrderStatusById($cliOrderIdTp);
            $statusSm = getOrderStatusById($cliOrderIdSm);
            printLog(" 4.- statusTp:" . $statusTp . " statusSm:" . $statusSm . " statusLi:" . $statusLi . chr(10));
        }
    }else{
        while(true){
            $statusTp = getOrderStatusById($cliOrderIdTp);
            $statusSm = getOrderStatusById($cliOrderIdSm);
            if($statusTp === "FILLED" or $statusTp === "EXPIRED" or $statusTp === "CANCELED" or $statusTp === "FALSE"){ 
                printLog(" TP 2.- statusTp:" . $statusTp . " statusSm:" . $statusSm . chr(10));
                if($statusTp === "FALSE" or $statusSm === "FALSE"){
                    $canceall = 0;
                    $canceall = cancelAll($orParams, "cntlOrders");
                    if($canceall === 1){
                        $doit = 0;
                        break;
                    }
                }else{
                    deleteOrder();
                    $statusLi = getOrderPosition("cntlOrders - TP");
                    if($statusLi === 0){
                        break;
                    }else{
                        if($statusSm === "FILLED" or $statusSm === "EXPIRED" or $statusSm === "CANCELED"){
                            $actqty = getRisk($orParams['qty']);
                            $orParams['qty'] = $actqty > 0 ? getRisk($orParams['qty']) : $orParams['qty'];
                        }
                        $orParams['orderId'] = $orParams['orderIdLi']  . "C"; 
                        slOrder($orParams); 
                        tpOrder($orParams);
                    }                    
                }

            }elseif($statusSm === "FILLED" or $statusSm === "EXPIRED" or $statusSm === "CANCELED" or $statusSm === "FALSE"){
                printLog("SL 2.- statusTp:" . $statusTp . " statusSm:" . $statusSm . chr(10));
                if($statusSm === "FALSE" or $statusTp === "FALSE"){
                    $canceall = 0;
                    $canceall = cancelAll($orParams, "cntlOrders");
                    if($canceall === 1){
                        $doit = 0;
                        break;
                    }
                }else{
                    deleteOrder();
                    $statusLi = getOrderPosition("cntlOrders - SM");
                    if($statusLi === 0){
                        break;
                    }else{
                        if($statusTp === "FILLED" or $statusTp === "EXPIRED" or $statusTp === "CANCELED"){
                            $actqty = getRisk($orParams['qty']);
                            $orParams['qty'] = $actqty > 0  ? getRisk($orParams['qty']) : $orParams['qty'];
                        }
                        $orParams['orderId'] = $orParams['orderIdLi']  . "C"; 
                        slOrder($orParams); 
                        tpOrder($orParams);
                    }                    
                }
            }else{
                sleep(5);
            }
        }
    }

    return $doit;
}
function cancelAll($orParams, $from){
    printLog("in cancelAll in $from" .chr(10));
    $cliOrderIdLi = $orParams['orderIdLi'] . "LI";
    $cliOrderIdTp = $orParams['orderId'] . "TP";
    $cliOrderIdSm = $orParams['orderId'] . "SM";
    $statusTp = getOrderStatusById($cliOrderIdTp);
    $statusSm = getOrderStatusById($cliOrderIdSm); 
    printLog(" cancelAll.- cliOrderIdTp:" . $cliOrderIdTp . " cliOrderIdSm:" . $cliOrderIdSm . " cliOrderIdLi:" . $cliOrderIdLi . chr(10));
    printLog(" cancelAll.- statusTp:" . $statusTp . " statusSm:" . $statusSm . chr(10));
    $opttrade = $orParams['opttrade'];
    $resp = 0;
    if($statusTp === "FALSE" or $statusSm === "FALSE"){
        printLog("cancelAll(" .$from . ")- statusTp " . $statusTp . " statusSm " . $statusSm . chr(10));
        deleteOrder();
        $sideli = oneOrderLi($cliOrderIdLi);
        printLog("cancelAll(" . $from . ") - antes: " . $orParams['sideli'] . " despues: " . $sideli['side'] . chr(10));
        $statusLi = getOrderPosition("cancelAll");
        if($statusLi === 1){
            if($sideli['side'] === "FALSE"){
                $date = new \DateTime('now');
                $tokentel = "UTC: " . $date->format('Y-m-d H:i:s') . chr(10);
                $date->setTimeZone(new \DateTimeZone('America/Argentina/Buenos_Aires'));
                $tokentel = $tokentel . "Argentina-Buenos Aires : " . $date->format('Y-m-d H:i:s') . chr(10);
                $tokentel = $tokentel . "No ha sido posible cerrar orden MARKET, " . chr(10);
                $tokentel = $tokentel . "proceda a cerrarla desde la App" . chr(10);
                $tokentel = $tokentel . "<b>**** el bot se ha parado **** </b>" . chr(10);
                $tokentel = $tokentel . "Una vez cerrada la orden, pulse sobre este enlace:" . chr(10);
                $tokentel = $tokentel . "<b>https://glotratecres.com/proces/s15m</b>" . chr(10);
                sendAlertTelegram($tokentel);
                exit;
            }else{
                $orParams['sideli'] = $sideli['side'];
                $orParams['orderIdLi'] = $orParams['orderIdLi'] . "C";
                $doitli = liOrder($orParams);
                setLastOrder($orParams['orderIdLi']);
            }
        }
        $resp = 1;
    }
    return $resp;
}
function oneOrderLi($cliOrderId){
    $liparams['symbol'] = 'DOTUSDT';
    $liparams['origClientOrderId'] = $cliOrderId;
    $response = signedRequest('GET', 'fapi/v1/order','fapi', $liparams); 
    if (array_key_exists('avgPrice', $response)) {
        if($response['side'] === 'SELL'){
            $resLi = [
                //number_format(round($response['avgPrice']  ,3), 3, '.', ',')
                'price' => $response['avgPrice'],
                'side' => "BUY"   
            ];
            return $resLi;
        }else{
            $resLi = [
                'price' => $response['avgPrice'],
                'side' => "SELL"   
            ];
            return $resLi;
        }
    }else{
        print_r($response);
        $cliOrderIdLi = getLastOrder();
        $lastOrder = getOrdeLi($cliOrderIdLi);
        if (array_key_exists('avgPrice', $lastOrder)) {
            if($lastOrder['side'] === 'SELL'){
                $resLi = [
                    //number_format(round($response['avgPrice']  ,3), 3, '.', ',')
                    'price' => $lastOrder['avgPrice'],
                    'side' => "BUY"   
                ];
                return $resLi;
            }else{
                $resLi = [
                    'price' => $lastOrder['avgPrice'],
                    'side' => "SELL"   
                ];
                return $resLi;
            }
        }else{
            $resLi = [
                'price' => 0,
                'side' => "FALSE"   
            ];
            return $resLi;
        }
    }


}
function getOrdeLi($cliOrderId){
    $oneOrder = [];
    $liparams['symbol'] = 'DOTUSDT';
    $liparams['origClientOrderId'] = $cliOrderId;
    $response = signedRequest('GET', 'fapi/v1/order','fapi', $liparams); 
    if (array_key_exists('avgPrice', $response)) {
        $oneOrder = $response;
    }  
    return $oneOrder; 
}
function deleteOrder(){
    $responDE = signedRequest('POST', 'fapi/v1/countdownCancelAll','fapi', [

    'symbol' => 'DOTUSDT',
    'countdownTime' => 100
    ]);
}
function deleteBatchOrder(){
    global $ORDER_ID;
    $responDE = signedRequest('DELETE', 'fapi/v1/batchOrders','fapi', [
        'symbol' => 'DOTUSDT',
        'origClientOrderIdList' => [$ORDER_ID . "TP",$ORDER_ID . "SM"]
    ]);
}
function testWaitTime($opt){
    global $filetext;
    global $v;
    $query = buildQuery($opt);
    $json = sendRequest("GET","fapi/v1/klines?${query}",  "fapi"); 

    $date =  new \DateTime(date('m/d/Y H:i:s',intval($json[count($json)-2][6])/1000));
    $datef = new \DateTime(date('m/d/Y H:i:s',intval($filetext )));
    $datea = $datef ->format('Y-m-d H:i:s');
    $date1 = $date ->format('Y-m-d H:i:s');
    if($filetext ===  ($json[count($json)-2][6])/1000){
    $v = $v + 1;
    }else{
        $v = 0;
        $filetext = ($json[count($json)-2][6])/1000;
        getData();
    }
    
}


function buildQuery($params = [])
{
    $new_arr = array();
    $query_add = '';
    foreach ($params as $label=>$item) {
        if ( gettype($item) == 'array' ) {
            foreach ($item as $arritem) {
                $query_add = $label . '=' . $arritem . '&' . $query_add;
            }
        } else {
            $new_arr[$label] = $item;
        }
    }
    $query = http_build_query($new_arr, '', '&');
    $query = $query_add . $query;

    return $query;
} 
function signatureRSA($data) {
    $pkeyid = openssl_pkey_get_private("file:///var/www/html/Private_keyAle");
    openssl_sign($data, $signature, $pkeyid, 'RSA-SHA256');
    openssl_free_key($pkeyid);
    return $signature;
}
function signedRequest($method, $path, $baseurl, $parameters = []) {
    global $SECRET;
    $parameters['timestamp'] = round(microtime(true) * 1000);
    $query = buildQuery($parameters);
    $signatureRSA =urlencode(base64_encode(signatureRSA($query)));
    return sendRequest($method, "${path}?${query}&signature=${signatureRSA}", $baseurl);
}
function sendRequest(string $method = "GET", $path, $baseurl, bool $signed = false)
{
    global $KEY;
    global $BASEF_URL;
    global $BASES_URL;
    switch ($baseurl) {
        case "fapi":
            $strUrl = "${BASEF_URL}${path}";
            break;
        case "sapi":
            $strUrl = "${BASES_URL}${path}";
            break;
        default:
        $strUrl = "${BASEF_URL}${path}";
    }
    $headers = array
    (
        'Content-Type: application/json',
        'X-MBX-APIKEY:' . $KEY
    );
    $ch = curl_init();
    
    curl_setopt($ch, CURLOPT_URL,$strUrl);
    curl_setopt($ch, CURLOPT_USERAGENT, "User-Agent: Mozilla/4.0 (compatible; PHP Binance API)");
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_POST, $method == "POST" ? true : false);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 60);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $result = curl_exec($ch);
    $json = json_decode($result, true);
    if (curl_errno($ch) > 0) {
        // should always output error, not only on httpdebug
        // not outputing errors, hides it from users and ends up with tickets on github
        echo 'Curl error: ' . curl_error($ch) . "\n";
    }
    curl_close($ch);
    return $json;        
} 

function sendAlertTelegram($tokentel)
{
    $token = "296248250";
    $tokenall = array(0 => "1439504606", 1 => "1567169349", 2 => "296248250");
    //$token = $tokentel;
    $body = "<b>******* " . "Alerta" . " ********</b>" . chr(10);      
    $body = $body . "<b>*** intervalo: 15m ***</b>" . chr(10);     
    $body = $body . $tokentel . chr(10);            
    $disable_web_page_preview = true;
    $reply_to_message_id = false;
    $reply_markup = null;
    $parse_mode = "HTML";  
    /*
    $data = array(
        'chat_id' => urlencode($token),
        'text' => $body,
        'disable_web_page_preview' => urlencode($disable_web_page_preview),
        'reply_to_message_id' => urlencode($reply_to_message_id),
        'reply_markup' => urlencode($reply_markup),
        'parse_mode' => urlencode($parse_mode)            
    );
    $con = createTrdTelegram(json_encode($data));  
    */      
    for ($i = 0; $i <= 2; $i++) {
        $data = array(
            'chat_id' => urlencode($tokenall[$i]),
            'text' => $body,
            'disable_web_page_preview' => urlencode($disable_web_page_preview),
            'reply_to_message_id' => urlencode($reply_to_message_id),
            'reply_markup' => urlencode($reply_markup),
            'parse_mode' => urlencode($parse_mode)            
        );
        $con = createTrdTelegram(json_encode($data));     
    }


}

function sendTrdTelegram($valret)
{
    $formato = 'Y-m-d';
    $token = "296248250";
    $delor = "";
    //    $tokenall = array(0 => "1439504606", 1 => "1982512292", 2 => "296248250");
    $tokenall = array(0 => "1439504606", 1 => "1982512292", 2 => "1567169349");
    if($valret["init"] === 0){
        $body = "<b>**** " . "Apertura de ordenes". " ****</b>" . chr(10);
        $body = $body . "<b>**** " . $valret["accion"] . " ****</b>" . chr(10);
        $body = $body . "UTC - Apertura: " . $valret["fechaope"] . "  Cierre:" . $valret["fechaclo"] . chr(10);
        $orgDate = intval($valret['tim']);        
        $date = new \DateTime(date('m/d/Y H:i:s',$orgDate));
        $date->setTimeZone(new \DateTimeZone('America/Argentina/Buenos_Aires'));
        $body = $body . 'Argentina-Buenos Aires - Cierre : '.$date->format('Y-m-d H:i:s') . chr(10);        
        $body = $body . "<b>*** intervalo: ". $valret['interval'] . " ***" . chr(10); 
        $body = $body . "apertura 5 atrás: " . number_format($valret["open"], 3, ',', '.') . " |" .         
        "cierre penúltima: " . number_format($valret["close"], 3, ',', '.') . "</b>" . chr(10);
    }else{
        $date = new \DateTime('now');
        $date->setTimeZone(new \DateTimeZone('America/Argentina/Buenos_Aires'));
        $body = "<b>**** " . "Cierre de ordenes" . " ****</b>" . chr(10);
        $body = $body . 'Argentina-Buenos Aires - Cierre : '.$date->format('Y-m-d H:i:s') . chr(10);
        $resCV = $valret['resCV'];
        if($resCV['doit'] === 1){
            $delor =  $resCV['delor'] === 1 ? "<b>**** cambio a precio actual orden SM ****</b>" .chr(10):"";
            $body = $body . "<b>**** " . $valret["accion"] . " ordenada" .  " ****</b>" . chr(10);
            $body = $body . "95 % balance diponible * : " . $resCV["avBal"] . chr(10);        
            $body = $body . "precio: " . $resCV["price"] . chr(10);
            $body = $body . "cantidad: " . $resCV["qty"] . chr(10);
            $body = $body . "total ordenado: " . ($resCV["qty"] * $resCV["price"]) . chr(10);
            $body = $body . "TP: %" . $resCV["porTp"] . " precio: " . $resCV["impTp"] . chr(10);
            $body = $body . "SM: %" . $resCV["porSm"] . " precio: " . $resCV["impSm"] . chr(10);
            $body = $body . $delor;
        }else{
            $body = $body . "<b>**** " . $valret["accion"] . " cancelada" .  " ****</b>" . chr(10);  
        }
    }

    $disable_web_page_preview = true;
    $reply_to_message_id = false;
    $reply_markup = null;
    $parse_mode = "HTML";  
    /*
    $data = array(
        'chat_id' => urlencode($token),
        'text' => $body,
        'disable_web_page_preview' => urlencode($disable_web_page_preview),
        'reply_to_message_id' => urlencode($reply_to_message_id),
        'reply_markup' => urlencode($reply_markup),
        'parse_mode' => urlencode($parse_mode)            
    );
    $con = createTrdTelegram(json_encode($data));  
    */      
    for ($i = 0; $i <= 2; $i++) {
        $data = array(
            'chat_id' => urlencode($tokenall[$i]),
            'text' => $body,
            'disable_web_page_preview' => urlencode($disable_web_page_preview),
            'reply_to_message_id' => urlencode($reply_to_message_id),
            'reply_markup' => urlencode($reply_markup),
            'parse_mode' => urlencode($parse_mode)            
        );
        $con = createTrdTelegram(json_encode($data));  
    }                     
}

function createTrdTelegram($data) {
    $strUrl = "https://api.telegram.org/bot6296460900:AAF8ngZlKOpRm5iSR_-pkjbqkxqcIBLSgnk/sendMessage";
    $headers = array
    (
        'Content-Type: application/json'
    );
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL,$strUrl);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    $result = curl_exec($ch);
    curl_close($ch);    
    return $result;
} 
function setLastOrder($orderId){
    $filename = "lastOrder15m.txt";
    $file = fopen( $filename, "w" );
    fwrite($file, $orderId);
    fclose( $file );
}

function getLastOrder(){
    $filename = "lastOrder15m.txt";
    $file = fopen($filename, "r" );
    $filesize = filesize( $filename );
    $filetext = fread( $file, $filesize );
    fclose( $file );
    return $filetext;
}
function getRisk($qty){
    $not = $qty;
    $prisk = signedRequest('GET', 'fapi/v2/positionRisk', 'fapi', ['symbol' => 'DOTUSDT']);
    if (array_key_exists("notional", $prisk)) {
        $lev = $prisk['leverage'] > 0 ? $prisk['leverage'] : 1;
        $not = number_format(round(($prisk['notional'] / $lev) ,3), 3, '.', ',');  
    }
    return $not;
}
$opt = [
    "symbol" => "DOTUSDT",
    "interval" => "15m",
    "limit" => 1   
];
$parameters['symbol'] = 'DOTUSDT';
$CV = 1; 
$KEY= 'UlISjUlDik1Ho1G7Lbfw8xoEnCbZkMd5q80PjDZj4RdCpLhIJ23ExLHSmJ72uVVU';  // 
$BASEF_URL = 'https://fapi.binance.com/'; // production
$BASES_URL = 'https://api.binance.com/';
//$filetext  = strtotime("now");
$filetext  = 0;
$v = 0;
$togetData = [
    "cv" => 0,
    "price" => 0,
    'quantity' => 0,
    'orderid' => 0,
    'side' => "SELL",
    'sideli' => "BUY",
    'qstat' => 0 
];
while(true){

    $statusLi = getOrderPosition("Start");
    $status = getStatus();
    //printLog ("statusLi:" . $statusLi . " status:" . $status .chr(10));
    if($statusLi === 0){
        if($status === 0){

            getData($togetData);
        }else{
            deleteOrder();
            getData($togetData);
        }
    }else{
        deleteOrder();
        $cliOrderIdLi = getLastOrder();
        $lastOrder = getOrdeLi($cliOrderIdLi);
        if (array_key_exists('avgPrice', $lastOrder)) {
            $togetData['cv'] = $lastOrder['side'] == "BUY" ? 1 : 2;
            $togetData['price'] = $lastOrder['avgPrice'];   
            $togetData['orderid'] = substr($cliOrderIdLi, 0, strlen($cliOrderIdLi)-2);         
            $actqty = getRisk($lastOrder['origQty']);        
            $togetData['quantity'] = $actqty > 0 ? getRisk($lastOrder['origQty']) : $lastOrder['origQty'];
            $togetData['side'] = $lastOrder['side'] == "BUY" ? "SELL" : "BUY";
            $togetData['sideli'] = $lastOrder['side'];            
            $togetData['qstat'] = 1;
        }  
        getData($togetData);
    }
    sleep(60);
 }
?>
