<?php
function getData($togetData)
{
    global $CV;
    $symbol = "DOTUSDT";
    $interval = "15m";
    $limit = 300;
    $opt = [
        "symbol" => $symbol,
        "interval" => $interval,
        "limit" => $limit   
    ];
      if ($limit) {
        $opt["limit"] = $limit;
    }
    if ($limit) {
        $opt["limit"] = $limit;
    }
    $varinter = [];
    for ($i = 1; $i <= 2; $i++) {
        $varinter[$i] = [
        "interval" => 0,
        "valret" => [],       
                
        ];
    }
    $varinter[1]['interval'] = '3m';
    $varinter[2]['interval'] = '15m';
    $adx = 0;        
    for ($i = 1; $i <= 2; $i++) {
        $opt["interval"] = $varinter[$i]['interval'];
        $query = buildQuery($opt);
        $json = sendRequest("GET","fapi/v1/klines?${query}",  "fapi"); 
        /* calculo ema's y adx */ 
        $varinter[$i]["valret"] = candleSticks($json, 5, 60,$varinter[$i]['interval']);
    }
    $emitir = 0;
    $may = "";
    if (
        $varinter[1]["valret"]["pdi"] > $varinter[1]["valret"]["mdi"] and 
        $varinter[2]["valret"]["pdi"] > $varinter[2]["valret"]["mdi"] and   
        $varinter[1]["valret"]["adx"] > $varinter[1]["valret"]["adxa"]){
        $varinter[1]["valret"]['opetype'] = 1; //compra
    }elseif (
        $varinter[1]["valret"]["mdi"] > $varinter[1]["valret"]["pdi"] and 
        $varinter[2]["valret"]["mdi"] > $varinter[2]["valret"]["pdi"] and   
        $varinter[1]["valret"]["adx"] > $varinter[1]["valret"]["adxa"]){
        $varinter[1]["valret"]['opetype'] = 2;   // venta  
           
    }else{
        $varinter[1]["valret"]['opetype'] = 0;
    }
    if($varinter[1]["valret"]["opetype"] >= 0){
        $dmi3 = "[pdi:" . $varinter[1]["valret"]["pdi"] . ", mdi:" . $varinter[1]["valret"]["mdi"] .  "]";
        $dmi15 = "[pdi:" . $varinter[2]["valret"]["pdi"] . ", mdi:" . $varinter[2]["valret"]["mdi"] .  "]";
        $interarry = "[" . $varinter[1]["valret"]["interval"] . "," . $varinter[2]["valret"]["interval"]  . "]";
        $fechaope = (new DateTime(date('m/d/Y H:i:s',intval($varinter[1]["valret"]["openTime"])/1000)))->format('Y-m-d H:i:s');
        $fechaclo = (new DateTime(date('m/d/Y H:i:s',intval($varinter[1]["valret"]["closeTime"])/1000)))->format('Y-m-d H:i:s');   
        $emitir = 0;     
        if($varinter[1]["valret"]['opetype'] === 0){
            $accion = "Mantener"; 
            if($CV === 2){
                $emitir = 0;
                if ($varinter[1]["valret"]["pdi"] > $varinter[1]["valret"]["mdi"])
                {
                    $CV = 0;
                    $may = "rompe en V"; 
                }else{
                    $CV = 2;
                    $may = " pdi < mdi";
                }
            }elseif($CV === 1){
                $emitir = 0;      
                if ($varinter[1]["valret"]["mdi"] > $varinter[1]["valret"]["pdi"])
                {
                    $CV = 0;
                    $may = "rompe en C"; 
                }else{
                    $CV = 1;
                    $may = "mdi > pdi";
                }                
            }
        }elseif($varinter[1]["valret"]['opetype'] === 1){
            $may = "";
            $accion = "Comprar"; 
            $emitir = ($CV === 1)?0:1;
            $CV = 1;          
        }else{
            $may = "";
            $accion = "Vender"; 
            $emitir = ($CV === 2 )?0:1;   
            $CV = 2;           
        }
        $tokentel = [
            "fechaope" => $fechaope,
            "fechaclo" => $fechaclo,  
            "dmi3" => $dmi3,
            "dmi15" => $dmi15,  
            "close" => $varinter[1]["valret"]['close'],
            "open" => $varinter[1]["valret"]['open'],
            "interval" => $interarry ,
            "interlow" => $varinter[1]["valret"]["interval"],
            "adx3m" => $varinter[1]["valret"]["adx"],
            "adx3ma" => $varinter[1]["valret"]["adxa"],
            "accion" => $accion,
            "may" => $may,
            "tim" => $varinter[1]["valret"]["closeTime"]/1000,
            "init" => 0,
            "resCV" => []
        ];
        $tokentelp = $fechaope . "|" . $fechaclo . "|dmi3:" . $dmi3 . "|dmi15:" . $dmi15 . "|adx3m:" . $varinter[1]["valret"]["adx"] .
        "|adx3ma:" . $varinter[1]["valret"]["adxa"] ."|close:" .  $varinter[1]["valret"]['close'] . "|open:" . $varinter[1]["valret"]['open'] . "| interv:"
         . $interarry . "|acción:". $accion . "|emitir:" . $emitir . "|may:" . $may . "|cv:" . $togetData['cv'] . chr(10);
        /*
         if ($emitir === 1){
            printLog($tokentelp . chr(10));
        }else{
            $ahora = new \DateTime('now');
            $fechanow =  'Now: '. $ahora->format('Y-m-d H:i:s');
            printLog($fechanow . "|acción:". $accion . "|cv:" . $togetData['cv']  . chr(10)); 
        }
        */
        if($togetData['cv'] > 0){
            $emitir = 1;
            $CV = $togetData['cv'];
        }
        if ($emitir === 1){
            printLog($tokentelp);
            sendTrdTelegram($tokentel);
            $status = getStatus();
            if($status === 0){
                $tokentel['init'] = 1;
                if($CV  === 1){
                    $tokentel['resCV']  = optTrade($CV, $togetData);
                    sendTrdTelegram($tokentel); 
                }elseif($CV  === 2){
                    $tokentel['resCV']  = optTrade($CV, $togetData);
                    sendTrdTelegram($tokentel);
                }
            }
        }

    } 
}
function candleSticks($json, $emalo = 5, $emahi = 60, $interval = 30)
{
    $i=0;
    $output = [];
    $time_period = 14;        
    $ema_name = "ema_" . $emalo ;
    foreach ($json as $tick) {
        list($openTime, $open, $high, $low, $close, $volact, $closeTime, $baseVolume, $trades, $assetBuyVolume, $takerBuyVolume, $ignored) = $tick;
        $output[$i] = [
            "open" => $open,
            "high" => $high,
            "low" => $low,
            "close" => $close,
            "volume" => $baseVolume,
            "openTime" => $openTime, //(new DateTime(date('m/d/Y H:i:s',intval($openTime)/1000)))->format('Y-m-d H:i:s'),
            "closeTime" => $closeTime, //(new DateTime(date('m/d/Y H:i:s',intval($closeTime)/1000)))->format('Y-m-d H:i:s'),
            "volact" => $volact,
            "baseVolume" => $baseVolume,
            "trades" => $trades,
            "assetBuyVolume" => $assetBuyVolume,
            "takerBuyVolume" => $takerBuyVolume,
            "opetype" => 0,
            "interval" => $interval,
            "adx" => 0,
            "adxa" => 0,            
            "mdi" => 0,
            "pdi" => 0
        ];
        $i = $i + 1;
    }  

    $highs = [];
    $lows = [];
    $closes = [];
    for ($x = 0; $x < count($output); $x++) {
        array_push($highs, $output[$x]["high"]);
        array_push($lows, $output[$x]["low"]);
        array_push($closes, $output[$x]["close"]);
    }
    $adx = trader_adx($highs, $lows, $closes, 14);
    $mdi = trader_minus_di($highs, $lows, $closes, 14);
    $pdi = trader_plus_di($highs, $lows, $closes, 14);   
    $retval = [
        "adx" => 0,    
        "adxa" => 0,
        "mdi" => 0, 
        "pdi" => 0,                                                         
        "volact" => $output[count($output) - 2]['volact'],
        "open" => $output[count($output) - 2]['open'],    
        "close" => $output[count($output) - 2]['close'],    
        "openTime" => $output[count($output) - 2]['openTime'],            
        "closeTime" => $output[count($output) - 2]['closeTime'],
        "opetype" => 0, 
        "interval" =>  $interval           
    ];
    $i = count($output) - 2; 
    $retval["adx"] = (!empty($adx[$i]))?round($adx[$i], 3):0;   
    $retval["adxa"] = (!empty($adx[$i]))?round($adx[$i-1], 3):0; 
    $retval["mdi"] = (!empty($mdi[$i]))?round($mdi[$i], 3):0; 
    $retval["pdi"] = (!empty($pdi[$i]))?round($pdi[$i], 3):0; 
    return $retval;
}

function printLog($from){
    $date = (new DateTime('now'))->format('Y-m-d H:i:s');
    print( $date . ": " . $from );
}

function getStatus(){
    $parameters['symbol'] = 'DOTUSDT';
    $response = signedRequest('GET', 'fapi/v1/openOrders','fapi', $parameters);   
    if(empty($response)){
        return 0;
    }else{
        return 1;
    }
}

function getPrice(){
    //[leverage] => 10

    $parameters['symbol'] = 'DOTUSDT';
    $porAv = 0.95;
    $porTp = 4; //CAMBIO DE 1,5 A 4% EL 27/12/2023
    $porSm = 1; //CAMBIO DE 0,5 A 1% EL 27/12/2023
    $apala = 1;
    $retval = [
      "price" => 0,
      "avBal" => 0,    
      "qty" => 0,
      "porAv" => 0,
      "porTp"  => 0,
      "porSm"  => 0,
      "impTp" => 0,
      "impSm" => 0,
      "camSm" => false,
      "doit" => 0,
      "delor" => 0,
      "enBal" => 0,
      "Tp" => false,
      "Sm" => false
    ];
    $response = signedRequest('GET', 'fapi/v1/ticker/price','fapi', $parameters); 
    if (array_key_exists('price', $response)) {
      $price = $response["price"];
      $response = signedRequest('GET', 'fapi/v2/account', 'fapi'); 
      if (array_key_exists('availableBalance', $response)) {
        $avBal = $response['availableBalance'] * $porAv;
        $apala = getLeverage();
        //$apala = getLastLeverage();
        $qty = (round($avBal/$price, 1)) * $apala;
        $retval = [
            "price" => $price,
            "avBal" => number_format(round($avBal  ,3), 3, '.', ','),    
            "qty" => $qty,
            "porAv" => $porAv,
            "porTp"  => $porTp,
            "porSm"  => $porSm,
            "impTp" => 0,
            "impSm" => 0,  
            "camSm" => false,
            "doit" => 0,
            "delor" => 0,
            "enBal" => $response['availableBalance'],
            "Tp" => false,
            "Sm" => false
        ];
      }
    }

    return $retval;
}
function getOrderStatusById($cliOrderId){
    $parameters['symbol'] = 'DOTUSDT';
    $parameters['origClientOrderId'] = $cliOrderId;
    $status = "";
    $mytry = 0;
    while(true){
        $response = signedRequest('GET', 'fapi/v1/order','fapi', $parameters); 
        if (array_key_exists("status", $response)) {
            $status = $response['status'];
            break;
        }else{
            sleep(5);
            $mytry = $mytry  + 1;
            if ($mytry >= 10){
                $status = "FALSE";
                break;
            }
        }
    }
    return $status;
}
function printPosition(){
    printLog("positions");
    $response = signedRequest('GET', 'fapi/v2/account', 'fapi');
    foreach($response['positions'] as $posit)  {
        if($posit['symbol'] === "DOTUSDT"){
            $posit['updateTime'] = (new DateTime(date('m/d/Y H:i:s',intval($posit['updateTime'])/1000)))->format('Y-m-d H:i:s');      
            //print_r($posit);
            printLog("symbol:" . $posit['symbol'] . " | updateTime:" . $posit['updateTime'] . " | initialMargin:" . $posit['initialMargin'] . " | leverage:" . 
                    $posit['leverage'] . " | entryPrice:" . $posit['entryPrice'] . " | notional:" . $posit['notional'] . chr(10));
            //printLog(chr(10));
        }
    }
}
function setLeverage($leverage){
    $apala = 1;
    $mytry = 0;
    while(true){
        $response = signedRequest('POST', 'fapi/v1/leverage', 'fapi', [
            'symbol' => 'DOTUSDT',
            'leverage' => $leverage, 
            'recvWindow' => "5000"
        ]);
        if (array_key_exists("leverage", $response)) {
            printLog("setLeverage from: endProc" . " leverage: " . $response['leverage'] . chr(10));
            break;
        }else{
            sleep(5);
            $mytry = $mytry  + 1;
            if ($mytry >= 10){
                printLog("ERROR in setLeverage - code:" . $response['code'] . " msg:" . $response['msg'] .chr(10));
                break;
            }
        }
    }
}
function getLeverage(){
    $apala = 1;
    $mytry = 0;
    while(true){
        $response = signedRequest('GET', 'fapi/v2/account', 'fapi', ['recvWindow' => "8000"]);
        if (array_key_exists("positions", $response)) {
            foreach($response['positions'] as $posit)  {
                if($posit['symbol'] === "DOTUSDT"){
                    if($posit['leverage'] > 0){
                        $apala = $posit['leverage'];
                    }
                    if($mytry === 1){
                        printLog("REC in getLeverage from: getPrice" . " leverage: " . $posit['leverage'] . chr(10));
                    }           
                }
            }
            break;
        }else{
            printLog("ERROR in getLeverage from: getPrice" . chr(10));
            printLog($response['code']. " " . $response['msg'] .chr(10));
            $mytry = 1;
            sleep(10);
        }
    }
    return $apala;

}
function getOrderPosition($from){
    $status = 0;
    $mytry = 0;
    while(true){
        $response = signedRequest('GET', 'fapi/v2/account', 'fapi', ['recvWindow' => "8000"]);
        if (array_key_exists("positions", $response)) {
            foreach($response['positions'] as $posit)  {
                if($posit['symbol'] === "DOTUSDT"){
                    if($posit['initialMargin'] > 0){
                        $status = 1;
                    }
                    if($mytry === 1){
                        printLog("REC in getOrderPosition from: " . $from . " status: " . $status . " margin: " . $posit['initialMargin'] . chr(10));
                    }           
                }
            }
            break;
        }else{
            printLog("ERROR in getOrderPosition from: " . $from . chr(10));
            printLog($response['code']. " " . $response['msg'] .chr(10));
            $mytry = 1;
            sleep(10);
        }
    }
    return $status;
}
function optTrade($opttrade,$togetData){
    $resval = getPrice();
    $resval['doit'] = 0;
    $cntrl = 1;
    $orderId = round(microtime(true) * 1000);
    if($opttrade === 1){
        // lo comentado es en caso de LI se LIMIT
        //$impTP = round($resval['price'] +  (($resval['price'] * $resval['porTp']) / 100),3);
        //$impSM = round($resval['price'] -  (($resval['price'] * $resval['porSm']) / 100),3);
        $side = "SELL";
        $sideLI = "BUY";
    }else{
        //$impTP = round($resval['price'] -  (($resval['price'] * $resval['porTp']) / 100),3);
        //$impSM = round($resval['price'] +  (($resval['price'] * $resval['porSm']) / 100),3);    
        $side = "BUY";
        $sideLI = "SELL";
    }
    //$resval['impTp'] = $impTP;
    //$resval['impSm'] = $impSM;
       $orParams = [
        'price' => $resval['price'],
        'qty' => $resval['qty'],
        'imptp' => 0,   
        'impsm' => 0, 
        'porsm' => $resval['porSm'],
        'side' => $side,
        'sideli' => $sideLI,        
        'orderId' => "15m" . $orderId,
        'orderIdLi' => "15m" . $orderId,        
        'opttrade'  => $opttrade
    ];
    if($togetData['qstat'] === 0){
        $doitli = liOrder($orParams);
    }else{
        $doitli = 1; 
        $orParams['orderIdLi'] = $togetData['orderid'];
        $orParams['qty'] = $togetData['quantity']; 
        $resval['price'] = $togetData['price']; 
        $side = $togetData['side'];
        $sideLI = $togetData['sideli'];    
    }
    if($doitli  === 1){
        //START LI = MARKET
        if($togetData['qstat'] === 0){
            $cliOrderIdLi = $orParams['orderIdLi'] . "LI";
            setLastOrder($cliOrderIdLi);
            $priceli = oneOrderLi($cliOrderIdLi);
            $resval['price'] = $priceli['price'];
        }
        if($opttrade === 1){
            $impTP = round($resval['price'] +  (($resval['price'] * $resval['porTp']) / 100),3);
            $impSM = round($resval['price'] -  (($resval['price'] * $resval['porSm']) / 100),3);
        }else{
            $impTP = round($resval['price'] -  (($resval['price'] * $resval['porTp']) / 100),3);
            $impSM = round($resval['price'] +  (($resval['price'] * $resval['porSm']) / 100),3);    
        }
        $resval['impTp'] = $impTP;
        $resval['impSm'] = $impSM;
        $orParams = [
            'price' => $resval['price'],
            'qty' => $resval['qty'],
            'imptp' => $impTP,   
            'impsm' => $impSM, 
            'porsm' => $resval['porSm'],
            'side' => $side,
            'sideli' => $sideLI,        
            'orderId' => "15m" . $orderId,
            'orderIdLi' => "15m" . $orderId,            
            'opttrade'  => $opttrade
        ];
 
        // END LI = MARKET       
        slOrder($orParams);
        tpOrder($orParams);
        $canceall = 0;
        $canceall = cancelAll($orParams, "Inicio");
        if($canceall === 1){
            $resval['doit'] = 0;
        }else{
            $retres = calcVaria($orParams);
            $resval['impSm'] =  $retres['impSm'];
            $resval["porSm"] =  $retres['porSm'];
            $resval["doit"] =  $retres['doit'];  
            $resval["camSm"] =  $retres['camSm']; 
            $orParams['orderId'] = $retres['ordnewId'];
            $cntrl = $retres["docntrl"];
            print("vuelta de calcvaria docntrl" . $cntrl . chr(10));
            if($cntrl === 1){
                $rescnt = cntlOrders($orParams);
                print("vuelta de cntlOrders doit " . $rescnt['doit'] . chr(10));
                $resval['doit'] = $rescnt['doit'];
                $resval['Tp'] = $rescnt['Tp'];
                $resval['Sm'] = $rescnt['Sm']; 
                if($resval['Tp']){
                    setLeverage(1);
                }elseif(!$resval["camSm"]){
                    setLeverage(10);
                }  
                $response = signedRequest('GET', 'fapi/v2/account', 'fapi'); 
                if (array_key_exists('availableBalance', $response)) {
                    $resval["enBal"] = $response['availableBalance'];
                }                            
            }else{
                $resval['doit'] = 0;
            }

        }
    }
    return $resval;
}
function liOrder($orParams){
    $quantity = $orParams['qty'];
    $side = $orParams['sideli'];
    $orderId = $orParams['orderIdLi'];
    $price = $orParams['price'];
    $cliOrderId = "";
    $doit = 0;
    $response = signedRequest('POST', 'fapi/v1/order', 'fapi',[
        'symbol' => 'DOTUSDT',
        'side' => $side, 
        'type' => 'MARKET',
        //'timeInForce' => 'GTC',
        'quantity' => $quantity,
        //'price' => $price,
        'workingType' =>  'CONTRACT_PRICE',
        'newClientOrderId' => $orderId . "LI", 
        'recvWindow' => "5000"
    ]);
    //if (array_key_exists("clientOrderId", $response)) {
        $cliOrderId = $orderId . "LI";
        sleep(5);
        while(true){
            $status = getOrderStatusById($cliOrderId);
            if($status === "FILLED"){
                $doit = 1;
                break;
            }elseif($status === "NEW"){
                sleep(2);
            }else{
                $doit = 0;
                break;       
            }
        }
    //}else{
        //$doit = 0;
    //}
    return $doit;
}
function tpOrder($orParams){
    $quantity = $orParams['qty'];
    $impTP = $orParams['imptp'];
    $side = $orParams['side'];
    $orderId = $orParams['orderId'];
    $trycount = 0;
    $response = signedRequest('POST', 'fapi/v1/order', 'fapi',[
      'symbol' => 'DOTUSDT',
      'side' => $side, 
      'type' => 'TAKE_PROFIT_MARKET',
      'timeInForce' => 'GTC',
      'quantity' => $quantity,
      'stopPrice' => $impTP,
      'workingType' =>  'MARK_PRICE',
      'priceProtect' => 'true',
      'reduceOnly' => 'true',
      'newClientOrderId' => $orderId . "TP",
      'recvWindow' => "5000" 
    ]);
    $cliOrderId = $orderId . "TP";
    sleep(5);
    while(true){
        $status = getOrderStatusById($cliOrderId);
        printLog("create TP cliorderId: $cliOrderId status: $status" . chr(10));
        if($status === "NEW"){
            break;
        }elseif($status === "FALSE"){
            sleep(5);
            $trycount = $trycount  + 1;
            if ($trycount >= 10){
                break;
            }
        }else{
            break;       
        }
    }
    if (!array_key_exists("side", $response)) {
        printLog("TP error START-" . $orderId . "TP" . chr(10));
        print_r($response);
        printLog ("TP error END-" . $orderId . "TP" . chr(10));
        sendAlertTelegram("TP error " . $orderId . "TP" . chr(10) . $response['msg'] . chr(10));
    }
}
function slOrder($orParams){
    $quantity = $orParams['qty'];
    $impSM = $orParams['impsm'];
    $side = $orParams['side'];
    $orderId = $orParams['orderId'];
    $trycount = 0;
    $response = signedRequest('POST', 'fapi/v1/order', 'fapi',[
      'symbol' => 'DOTUSDT',
      'side' => $side, 
      'type' => 'STOP_MARKET',
      'timeInForce' => 'GTC',
      'quantity' => $quantity,
      'stopPrice' => $impSM,
      'workingType' =>  'MARK_PRICE',
      'priceProtect' => 'true',
      'reduceOnly' => 'true',
      'newClientOrderId' => $orderId . "SM",
      'recvWindow' => "5000" 
    ]);
    $cliOrderId = $orderId . "SM";
    sleep(5);
    while(true){
        $status = getOrderStatusById($cliOrderId);
        printLog("create SL cliorderId: $cliOrderId status: $status" . chr(10));
        if($status === "NEW"){
            break;
        }elseif($status === "FALSE"){
            sleep(5);
            $trycount = $trycount  + 1;
            if ($trycount >= 10){
                break;
            }
        }else{
            break;       
        }
    }
    if (!array_key_exists("side", $response)) {
        printLog ("SM error START-" . $orderId . "SM" . chr(10));
        print_r($response);
        printLog ("SM error END-" . $orderId . "SM" . chr(10));
        sendAlertTelegram("SM error " . $orderId . "SM" . chr(10) . $response['msg'] . chr(10));
    }   
}
function calcVaria($orParams){
    printLog("in calcVaria" .chr(10));
    $cliOrderIdTp = $orParams['orderId'] . "TP";
    $cliOrderIdSm = $orParams['orderId'] . "SM";
    $preAct = $orParams['price'];
    $impSM = $orParams['impsm'];
    $porSM = $orParams['porsm'];
    $CV = $orParams['opttrade'];
    $muestra = [];
    $x = 1;
    $parameters['symbol'] = 'DOTUSDT';
    $retres = [
        "impSm" => $preAct,
        "porSm" => $porSM,
        "doit" => 0,
        "docntrl" => 1,
        "ordnewId" => $orParams['orderId'],
        'camSm' => false
    ];
    $ext = 0;
    $resnew = [];
    while(true){
      $response = signedRequest('GET', 'fapi/v1/ticker/price','fapi', $parameters);
      if (array_key_exists('price', $response)) {
          $price = $response["price"];
          $statusTp = getOrderStatusById($cliOrderIdTp);
          $statusSm = getOrderStatusById($cliOrderIdSm); 
          if(
            $statusTp === "FILLED" or $statusTp === "EXPIRED" or $statusTp === "CANCELED" or $statusTp === "FALSE" or
            $statusSm === "FILLED" or $statusSm === "EXPIRED" or $statusSm === "CANCELED" or $statusSm === "FALSE")
          { 
            $ext = 1; 
            $retres["docntrl"] = 1;
            $retres["doit"] = 1;
            break;
          }else{
            if($CV === 1){ //Compras
                //SI EL PRECIO ES>= PRECIO DE ENTRADA + 0,5% CAMBIA EL SL DE -0,5% A PRECIO DE ENTRADA (FILTRO PROTECCION DE SL)
                //CAMBIO A 1% EL 27/12/2023
                $preOpe = number_format(round($preAct +  (($preAct * 1) / 100),3), 3, '.', ',');
                if($price  >= $preOpe){
                  $statusLi = getOrderPosition("calcVaria - C");
                  if($statusLi === 0){
                    $retres["docntrl"] = 1;
                    $retres["doit"] = 1;
                  }else{
                    deleteOrder();
                    
                    $orParams['impsm'] = $preAct;  
                    $orParams['orderId'] = $orParams['orderIdLi']  . "C";  
                    slOrder($orParams); 
                    tpOrder($orParams);
                    sendAlertTelegram("Cambia precio de Sl en Compras a $preAct");
                   /*
                    $canceall = 0;
                    $canceall = cancelAll($orParams, "Cambio SM");
                    if($canceall === 1){
                        $retres["docntrl"] = 0;
                    }else{
                        $retres["docntrl"] = 1;
                    }
                    */
                  }
                  $retres["docntrl"] = 1;
                  $ext = 1;
                  $retres["porSm"] = 1.0;
                  $retres["doit"] = 1;  
                  $retres['camSm'] = true;
                  $retres['ordnewId'] = $orParams['orderId'];
                  printLog(" Comp.- statusLi:" . $statusLi . " preOpe:" . $preOpe . chr(10));  
                  break;                            
                }
            }else{ //Ventas
                //SI EL PRECIO ES<= PRECIO DE ENTRADA - 0,5% CAMBIA EL SL DE +0,5% A PRECIO DE ENTRADA (FILTRO PROTECCION DE SL)
                //CAMBIO A 1% EL 27/12/2023
                $preOpe = number_format(round($preAct -  (($preAct * 1) / 100),3), 3, '.', ',');
                if($price  <= $preOpe){
                  $statusLi = getOrderPosition("calcVaria - V");
                  if($statusLi === 0){
                    $retres["docntrl"] = 1;
                    $retres["doit"] = 1;
                  }else{
                    deleteOrder();
                    $orParams['impsm'] = $preAct;         
                    $orParams['orderId'] = $orParams['orderIdLi']  . "V"; 
                    slOrder($orParams); 
                    tpOrder($orParams);
                    sendAlertTelegram("Cambia precio de Sl en Ventas a $preAct");

                    /*
                    $canceall = 0;
                    $canceall = cancelAll($orParams, "Cambio SM");
                    if($canceall === 1){
                        $retres["docntrl"] = 0;
                    }else{
                        $retres["docntrl"] = 1;
                    }
                    */
                  }
                  $retres["docntrl"] = 1;
                  $ext = 1;
                  $retres["porSm"] = 1.0;
                  $retres["doit"] = 1; 
                  $retres['ordnewId'] =  $orParams['orderId'];
                  $retres['camSm'] = true;                                   
                  printLog(" Vent.- statusLi:" . $statusLi . " preOpe:" . $preOpe . chr(10));    
                  break;                                               
                }
            }
          }

  
      } 
      sleep(5); 
      //if ($ext === 1) {
          //break;
      //}
        
    }
    return $retres;
}
function cntlOrders($orParams){
    $cliOrderIdTp = $orParams['orderId'] . "TP";
    $cliOrderIdSm = $orParams['orderId'] . "SM";
    $doit = 1;
    $breakE = 0;
    $retres = [
        "Tp" => false,
        "Sm" => false,
        "doit" => 0
    ];
    printLog("in cntlOrders" .chr(10));
    $statusLi = getOrderPosition("cntlOrders - Init");
    $statusTp = getOrderStatusById($cliOrderIdTp);
    $statusSm = getOrderStatusById($cliOrderIdSm);
    printLog(" 3.- statusTp:" . $statusTp . " statusSm:" . $statusSm . " statusLi:" . $statusLi . chr(10));

    if($statusTp === "FILLED" or $statusSm === "FILLED"){
        printPosition();
        if($statusLi === 0){
            deleteOrder();
            $statusTp = getOrderStatusById($cliOrderIdTp);
            $statusSm = getOrderStatusById($cliOrderIdSm);
            printLog(" 4.- statusTp:" . $statusTp . " statusSm:" . $statusSm . " statusLi:" . $statusLi . chr(10));
        }
        $retres["doit"] = 1;
    }else{
        while(true){
            $statusTp = getOrderStatusById($cliOrderIdTp);
            $statusSm = getOrderStatusById($cliOrderIdSm);
            if($statusTp === "FILLED" or $statusTp === "EXPIRED" or $statusTp === "CANCELED" or $statusTp === "FALSE"){ 
                printLog(" TP 2.- statusTp:" . $statusTp . " statusSm:" . $statusSm . chr(10));
                if($statusTp === "FALSE" or $statusSm === "FALSE"){
                    $canceall = 0;
                    $canceall = cancelAll($orParams, "cntlOrders");
                    if($canceall === 1){
                        $doit = 0;
                        break;
                    }
                }else{
                    deleteOrder();
                    $statusLi = getOrderPosition("cntlOrders - TP");
                    if($statusLi === 0){
                        $retres['Tp'] = true;
                        $retres['Sm'] = false;
                        $retres['doit'] = 1;
                        break;
                    }else{
                        if($statusSm === "FILLED" or $statusSm === "EXPIRED" or $statusSm === "CANCELED"){
                            $actqty = getRisk($orParams['qty']);
                            $orParams['qty'] = $actqty > 0 ? getRisk($orParams['qty']) : $orParams['qty'];
                        }
                        $orParams['orderId'] = $orParams['orderIdLi']  . "C"; 
                        slOrder($orParams); 
                        tpOrder($orParams);
                    }                    
                }

            }elseif($statusSm === "FILLED" or $statusSm === "EXPIRED" or $statusSm === "CANCELED" or $statusSm === "FALSE"){
                printLog("SL 2.- statusTp:" . $statusTp . " statusSm:" . $statusSm . chr(10));
                if($statusSm === "FALSE" or $statusTp === "FALSE"){
                    $canceall = 0;
                    $canceall = cancelAll($orParams, "cntlOrders");
                    if($canceall === 1){
                        $doit = 0;
                        break;
                    }
                }else{
                    deleteOrder();
                    $statusLi = getOrderPosition("cntlOrders - SM");
                    if($statusLi === 0){
                        $retres['Tp'] = false;
                        $retres['Sm'] = true;
                        $retres['doit'] = 1;
                        break;
                    }else{
                        if($statusTp === "FILLED" or $statusTp === "EXPIRED" or $statusTp === "CANCELED"){
                            $actqty = getRisk($orParams['qty']);
                            $orParams['qty'] = $actqty > 0  ? getRisk($orParams['qty']) : $orParams['qty'];
                        }
                        $orParams['orderId'] = $orParams['orderIdLi']  . "C"; 
                        slOrder($orParams); 
                        tpOrder($orParams);
                    }                    
                }
            }else{
                sleep(5);
            }
        }
    }

    return $retres;
}
function cancelAll($orParams, $from){
    printLog("in cancelAll in $from" .chr(10));
    $cliOrderIdLi = $orParams['orderIdLi'] . "LI";
    $cliOrderIdTp = $orParams['orderId'] . "TP";
    $cliOrderIdSm = $orParams['orderId'] . "SM";
    $statusTp = getOrderStatusById($cliOrderIdTp);
    $statusSm = getOrderStatusById($cliOrderIdSm); 
    printLog(" cancelAll.- cliOrderIdTp:" . $cliOrderIdTp . " cliOrderIdSm:" . $cliOrderIdSm . " cliOrderIdLi:" . $cliOrderIdLi . chr(10));
    printLog(" cancelAll.- statusTp:" . $statusTp . " statusSm:" . $statusSm . chr(10));
    $opttrade = $orParams['opttrade'];
    $resp = 0;
    if($statusTp === "FALSE" or $statusSm === "FALSE"){
        printLog("cancelAll(" .$from . ")- statusTp " . $statusTp . " statusSm " . $statusSm . chr(10));
        deleteOrder();
        $date = new \DateTime('now');
        $tokentel = "UTC: " . $date->format('Y-m-d H:i:s') . chr(10);
        $date->setTimeZone(new \DateTimeZone('America/Argentina/Buenos_Aires'));
        $tokentel = $tokentel . "Argentina-Buenos Aires : " . $date->format('Y-m-d H:i:s') . chr(10);
        $tokentel = $tokentel . "Se ha detectado una respuesta erronea, " . chr(10);
        $tokentel = $tokentel . " statusTp: " . $statusTp . " statusSm: " . $statusSm . chr(10);
        $tokentel = $tokentel . "proceda a controlar  la orden desde la app" . chr(10);
        //$tokentel = $tokentel . "<b>**** el bot ha abandonado esta orden **** </b>" . chr(10);
        sendAlertTelegram($tokentel);
        $sideli = oneOrderLi($cliOrderIdLi);
        printLog("cancelAll(" . $from . ") - antes: " . $orParams['sideli'] . " despues: " . $sideli['side'] . chr(10));
        $statusLi = getOrderPosition("cancelAll");
        if($statusLi === 1){
            if($sideli['side'] === "FALSE"){
                $date = new \DateTime('now');
                $tokentel = "UTC: " . $date->format('Y-m-d H:i:s') . chr(10);
                $date->setTimeZone(new \DateTimeZone('America/Argentina/Buenos_Aires'));
                $tokentel = $tokentel . "Argentina-Buenos Aires : " . $date->format('Y-m-d H:i:s') . chr(10);
                $tokentel = $tokentel . "No ha sido posible cerrar orden MARKET, " . chr(10);
                $tokentel = $tokentel . "proceda a cerrarla desde la App" . chr(10);
                $tokentel = $tokentel . "<b>**** el bot se ha parado **** </b>" . chr(10);
                $tokentel = $tokentel . "Una vez cerrada la orden, pulse sobre este enlace:" . chr(10);
                $tokentel = $tokentel . "<b>https://glotratecres.com/proces/s15m</b>" . chr(10);
                sendAlertTelegram($tokentel);
                exit;
            }else{
                $orParams['sideli'] = $sideli['side'];
                $orParams['orderIdLi'] = $orParams['orderIdLi'] . "C";
                $doitli = liOrder($orParams);
                setLastOrder($orParams['orderIdLi']);
            }
        }
        $resp = 1;
    }
    return $resp;
}
function oneOrderLi($cliOrderId){
    $liparams['symbol'] = 'DOTUSDT';
    $liparams['origClientOrderId'] = $cliOrderId;
    $response = signedRequest('GET', 'fapi/v1/order','fapi', $liparams); 
    if (array_key_exists('avgPrice', $response)) {
        if($response['side'] === 'SELL'){
            $resLi = [
                //number_format(round($response['avgPrice']  ,3), 3, '.', ',')
                'price' => $response['avgPrice'],
                'side' => "BUY"   
            ];
            return $resLi;
        }else{
            $resLi = [
                'price' => $response['avgPrice'],
                'side' => "SELL"   
            ];
            return $resLi;
        }
    }else{
        print_r($response);
        $cliOrderIdLi = getLastOrder();
        $lastOrder = getOrdeLi($cliOrderIdLi);
        if (array_key_exists('avgPrice', $lastOrder)) {
            if($lastOrder['side'] === 'SELL'){
                $resLi = [
                    //number_format(round($response['avgPrice']  ,3), 3, '.', ',')
                    'price' => $lastOrder['avgPrice'],
                    'side' => "BUY"   
                ];
                return $resLi;
            }else{
                $resLi = [
                    'price' => $lastOrder['avgPrice'],
                    'side' => "SELL"   
                ];
                return $resLi;
            }
        }else{
            $resLi = [
                'price' => 0,
                'side' => "FALSE"   
            ];
            return $resLi;
        }
    }


}
function getOrdeLi($cliOrderId){
    $oneOrder = [];
    $liparams['symbol'] = 'DOTUSDT';
    $liparams['origClientOrderId'] = $cliOrderId;
    $response = signedRequest('GET', 'fapi/v1/order','fapi', $liparams); 
    if (array_key_exists('avgPrice', $response)) {
        $oneOrder = $response;
    }  
    return $oneOrder; 
}
function deleteOrder(){
    $responDE = signedRequest('POST', 'fapi/v1/countdownCancelAll','fapi', [

    'symbol' => 'DOTUSDT',
    'countdownTime' => 100
    ]);
}
function deleteBatchOrder(){
    global $ORDER_ID;
    $responDE = signedRequest('DELETE', 'fapi/v1/batchOrders','fapi', [
        'symbol' => 'DOTUSDT',
        'origClientOrderIdList' => [$ORDER_ID . "TP",$ORDER_ID . "SM"]
    ]);
}
function testWaitTime($opt){
    global $filetext;
    global $v;
    $query = buildQuery($opt);
    $json = sendRequest("GET","fapi/v1/klines?${query}",  "fapi"); 

    $date =  new \DateTime(date('m/d/Y H:i:s',intval($json[count($json)-2][6])/1000));
    $datef = new \DateTime(date('m/d/Y H:i:s',intval($filetext )));
    $datea = $datef ->format('Y-m-d H:i:s');
    $date1 = $date ->format('Y-m-d H:i:s');
    if($filetext ===  ($json[count($json)-2][6])/1000){
    $v = $v + 1;
    }else{
        $v = 0;
        $filetext = ($json[count($json)-2][6])/1000;
        getData();
    }
    
}


function buildQuery($params = [])
{
    $new_arr = array();
    $query_add = '';
    foreach ($params as $label=>$item) {
        if ( gettype($item) == 'array' ) {
            foreach ($item as $arritem) {
                $query_add = $label . '=' . $arritem . '&' . $query_add;
            }
        } else {
            $new_arr[$label] = $item;
        }
    }
    $query = http_build_query($new_arr, '', '&');
    $query = $query_add . $query;

    return $query;
} 
function signatureRSA($data) {
    $pkeyid = openssl_pkey_get_private("file:///var/www/html/Private_keyAle");
    openssl_sign($data, $signature, $pkeyid, 'RSA-SHA256');
    openssl_free_key($pkeyid);
    return $signature;
}
function signedRequest($method, $path, $baseurl, $parameters = []) {
    global $SECRET;
    $parameters['timestamp'] = round(microtime(true) * 1000);
    $query = buildQuery($parameters);
    $signatureRSA =urlencode(base64_encode(signatureRSA($query)));
    return sendRequest($method, "${path}?${query}&signature=${signatureRSA}", $baseurl);
}
function sendRequest(string $method = "GET", $path, $baseurl, bool $signed = false)
{
    global $KEY;
    global $BASEF_URL;
    global $BASES_URL;
    switch ($baseurl) {
        case "fapi":
            $strUrl = "${BASEF_URL}${path}";
            break;
        case "sapi":
            $strUrl = "${BASES_URL}${path}";
            break;
        default:
        $strUrl = "${BASEF_URL}${path}";
    }

    $headers = array
    (
        'Content-Type: application/json',
        'X-MBX-APIKEY:' . $KEY
    );
    $ch = curl_init();
    
    curl_setopt($ch, CURLOPT_URL,$strUrl);
    curl_setopt($ch, CURLOPT_USERAGENT, "User-Agent: Mozilla/4.0 (compatible; PHP Binance API)");
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_POST, $method == "POST" ? true : false);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 60);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $result = curl_exec($ch);
    $json = json_decode($result, true);
    if (curl_errno($ch) > 0) {
        // should always output error, not only on httpdebug
        // not outputing errors, hides it from users and ends up with tickets on github
        echo 'Curl error: ' . curl_error($ch) . "\n";
    }
    curl_close($ch);
    return $json;        
} 

function sendAlertTelegram($tokentel)
{
    $token = "296248250";
    //$tokenall = array(0 => "296248250", 1 => "1439504606", 2 => "1567169349");
    $tokenall = array(0 => "1439504606", 1 => "1982512292", 2 => "1567169349");
    //$token = $tokentel;
    $body = "<b>******* " . "Alerta" . " ********</b>" . chr(10);      
    $body = $body . "<b>*** intervalo: 15m DMI***</b>" . chr(10);     
    $body = $body . $tokentel . chr(10);            
    $disable_web_page_preview = true;
    $reply_to_message_id = false;
    $reply_markup = null;
    $parse_mode = "HTML";  
    /*
    $data = array(
        'chat_id' => urlencode($token),
        'text' => $body,
        'disable_web_page_preview' => urlencode($disable_web_page_preview),
        'reply_to_message_id' => urlencode($reply_to_message_id),
        'reply_markup' => urlencode($reply_markup),
        'parse_mode' => urlencode($parse_mode)            
    );
    $con = createTrdTelegram(json_encode($data));  
    */      
    for ($i = 1; $i <= 1; $i++) {
        $data = array(
            'chat_id' => urlencode($tokenall[$i]),
            'text' => $body,
            'disable_web_page_preview' => urlencode($disable_web_page_preview),
            'reply_to_message_id' => urlencode($reply_to_message_id),
            'reply_markup' => urlencode($reply_markup),
            'parse_mode' => urlencode($parse_mode)            
        );
        $con = createTrdTelegram(json_encode($data));     
    }


}

function sendTrdTelegram($valret)
{
    $formato = 'Y-m-d';
    $token = "296248250";
    //    $tokenall = array(0 => "1439504606", 1 => "1982512292", 2 => "296248250");
    $tokenall = array(0 => "1439504606", 1 => "1982512292", 2 => "1567169349");
    if($valret["init"] === 0){
        $body = "<b>**** " . "Apertura de ordenes con DMI". " ****</b>" . chr(10);
        $body = $body . "<b>**** " . $valret["accion"] . " ****</b>" . chr(10);
        $body = $body . "UTC - Apertura: " . $valret["fechaope"] . "  Cierre:" . $valret["fechaclo"] . chr(10);
        $orgDate = intval($valret['tim']);        
        $date = new \DateTime(date('m/d/Y H:i:s',$orgDate));
        $date->setTimeZone(new \DateTimeZone('America/Argentina/Buenos_Aires'));
        $body = $body . 'Argentina-Buenos Aires - Cierre : '.$date->format('Y-m-d H:i:s') . chr(10);        
        $body = $body . "<b>*** intervalo: ". $valret['interval'] . " ***" . chr(10); 
        $body = $body . "DMI3: " . $valret["dmi3"] .  chr(10);
        $body = $body . "DMI15: " . $valret["dmi15"]  . " </b>" . chr(10);        
        $body = $body . "<b>*** intervalo: ". $valret['interlow'] . " ***</b>" . chr(10); 
        $body = $body . "<b>ADX3m: " . $valret["adx3m"] . " ADX3ma: " . $valret["adx3ma"] . chr(10);
        $body = $body . "ape. precio: " . number_format($valret["open"], 2, ',', '.') . " |" .         
        " ult. precio: " . number_format($valret["close"], 2, ',', '.') . "</b>" . chr(10);
    }else{
        $date = new \DateTime('now');
        $date->setTimeZone(new \DateTimeZone('America/Argentina/Buenos_Aires'));
        $body = "<b>**** " . "Cierre de ordenes" . " ****</b>" . chr(10);
        $body = $body . 'Argentina-Buenos Aires - Cierre : '.$date->format('Y-m-d H:i:s') . chr(10);
        $resCV = $valret['resCV'];
        if($resCV['doit'] === 1){
            $body = $body . "<b>******* " . $valret["accion"] . " ordenada" .  " ********</b>" . chr(10);
            $body = $body . "95 % balance diponible: " . $resCV["avBal"] . chr(10);        
            $body = $body . "precio: " . $resCV["price"] . chr(10);
            $body = $body . "cantidad: " . $resCV["qty"] . chr(10);
            $body = $body . "total ordenado: " . ($resCV["qty"] * $resCV["price"]) . chr(10);
            if ($resCV["Tp"]){
                $body = $body . " ****** Orden Tp  ******" . chr(10);
                $body = $body . "TP: %" . $resCV["porTp"] . " precio: " . $resCV["impTp"] . chr(10);
            }else{
                if ($resCV["camSm"]){
                    $body = $body . "****** Sl Protegido ******" . chr(10);
                    $body = $body . "SL: %" . $resCV["porSm"] . " precio: " . $resCV["impSm"] . chr(10);
                }else{
                    $body = $body . " ****** Orden Sl ******" . $resCV["impSm"] . chr(10);
                    $body = $body . "SL: %" . $resCV["porSm"] . " precio: " . $resCV["impSm"] . chr(10);                    
                }
            }
            $body = $body . "balance diponible al final: " . $resCV["enBal"] . chr(10);
         }else{
            $body = $body . "<b>**** " . $valret["accion"] . " cancelada" .  " ****</b>" . chr(10);  
        }
    }

    $disable_web_page_preview = true;
    $reply_to_message_id = false;
    $reply_markup = null;
    $parse_mode = "HTML";  
    /*
    $data = array(
        'chat_id' => urlencode($token),
        'text' => $body,
        'disable_web_page_preview' => urlencode($disable_web_page_preview),
        'reply_to_message_id' => urlencode($reply_to_message_id),
        'reply_markup' => urlencode($reply_markup),
        'parse_mode' => urlencode($parse_mode)            
    );
    $con = createTrdTelegram(json_encode($data));  
    */      
    for ($i = 0; $i <= 2; $i++) {
        $data = array(
            'chat_id' => urlencode($tokenall[$i]),
            'text' => $body,
            'disable_web_page_preview' => urlencode($disable_web_page_preview),
            'reply_to_message_id' => urlencode($reply_to_message_id),
            'reply_markup' => urlencode($reply_markup),
            'parse_mode' => urlencode($parse_mode)            
        );
        $con = createTrdTelegram(json_encode($data));  
    }                     
}

function createTrdTelegram($data) {
    $strUrl = "https://api.telegram.org/bot6296460900:AAF8ngZlKOpRm5iSR_-pkjbqkxqcIBLSgnk/sendMessage";
    $headers = array
    (
        'Content-Type: application/json'
    );
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL,$strUrl);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    $result = curl_exec($ch);
    curl_close($ch);    
    return $result;
} 
function setLastOrder($orderId){
    $filename = "lastOrderdmi.txt";
    $file = fopen( $filename, "w" );
    fwrite($file, $orderId);
    fclose( $file );
}

function getLastOrder(){
    $filename = "lastOrderdmi.txt";
    $file = fopen($filename, "r" );
    $filesize = filesize( $filename );
    $filetext = fread( $file, $filesize );
    fclose( $file );
    return $filetext;
}
function setLastLeverage($leverage){
    $filename = "lastLeveragedmi.txt";
    $file = fopen( $filename, "w" );
    fwrite($file, $leverage);
    fclose( $file );
}

function getLastLeverage(){
    $filename = "lastLeveragedmi.txt";
    $file = fopen($filename, "r" );
    $filesize = filesize( $filename );
    $leverage = fread( $file, $filesize );
    fclose( $file );
    return $leverage;
}
function getRisk($qty){
    $not = $qty;
    $prisk = signedRequest('GET', 'fapi/v2/positionRisk', 'fapi', ['symbol' => 'DOTUSDT']);
    if (array_key_exists("notional", $prisk)) {
        $lev = $prisk['leverage'] > 0 ? $prisk['leverage'] : 1;
        $not = number_format(round(($prisk['notional'] / $lev) ,3), 3, '.', ',');  
    }
    return $not;
}
$opt = [
    "symbol" => "DOTUSDT",
    "interval" => "15m",
    "limit" => 2   
];
$parameters['symbol'] = 'DOTUSDT';
$CV = 0; 
$KEY= 'UlISjUlDik1Ho1G7Lbfw8xoEnCbZkMd5q80PjDZj4RdCpLhIJ23ExLHSmJ72uVVU';  // 
$BASEF_URL = 'https://fapi.binance.com/'; // production
$BASES_URL = 'https://api.binance.com/';
//$filetext  = strtotime("now");
$filetext  = 0;
$v = 0;
$togetData = [
    "cv" => 0,
    "price" => 0,
    'quantity' => 0,
    'orderid' => 0,
    'side' => "SELL",
    'sideli' => "BUY",
    'qstat' => 0 
];
while(true){

    $statusLi = getOrderPosition("Start");
    $status = getStatus();
    if($statusLi === 0){
        if($status === 0){
            getData($togetData);
        }else{
            deleteOrder();
            getData($togetData);
        }
    }else{
        deleteOrder();
        $cliOrderIdLi = getLastOrder();
        $lastOrder = getOrdeLi($cliOrderIdLi);
        if (array_key_exists('avgPrice', $lastOrder)) {
            $togetData['cv'] = $lastOrder['side'] == "BUY" ? 1 : 2;
            $togetData['price'] = $lastOrder['avgPrice'];   
            $togetData['orderid'] = substr($cliOrderIdLi, 0, strlen($cliOrderIdLi)-2);         
            $actqty = getRisk($lastOrder['origQty']);        
            $togetData['quantity'] = $actqty > 0 ? getRisk($lastOrder['origQty']) : $lastOrder['origQty'];
            $togetData['side'] = $lastOrder['side'] == "BUY" ? "SELL" : "BUY";
            $togetData['sideli'] = $lastOrder['side'];            
            $togetData['qstat'] = 1;
        }  
        getData($togetData);
    }
    sleep(60);
}

?>
