#!/bin/bash

# Nombre del proceso de tu aplicación
NOMBRE_PROCESO="indexbi.php"

# Ruta completa al ejecutable de tu aplicación
RUTA_APLICACION=" php /var/www/html/bitradenes/indexbi.php "

# Ruta al script PHP para enviar notificaciones
RUTA_PHP_NOTIFICACION="/var/www/html/bitradenes/notifsiexec.php"
DIA=`date +"%d/%m/%Y"`
HORA=`date +"%H:%M"`

# Verificar si el proceso está en ejecución
if pgrep -f "$NOMBRE_PROCESO" > /dev/null; then
  echo "$DIA - $HORA:el bot de neskk $NOMBRE_PROCESO se está ejecutando."
else
  MESSAGE="$DIA - $HORA: El bot de neskk $NOMBRE_PROCESO NO se está ejecutando. Reiniciando..." 
  #MESSAGE="$MESSAGE La aplicación $NOMBRE_PROCESO se ha reiniciado."
  #echo "La aplicación $NOMBRE_PROCESO NO se está ejecutando. Reiniciando..."
  echo $MESSAGE
  # Reiniciar la aplicación
  cd /var/www/html/bitradenes
  nohup php indexbi.php > indexbi.out &
  # Enviar notificación vía PHP
  php $RUTA_PHP_NOTIFICACION "$MESSAGE"
fi