<?php
include './vendor/autoload.php';
$settings = require 'settings.php';
use App\ValidResponse;
use App\FuTrperm;
use App\WebSocketApi;
use GuzzleHttp\Client;
use Psr\Http\Message\ResponseInterface;
use GuzzleHttp\Exception\RequestException;
use App\Exceptions\ResponseApiException;
use Ratchet\Client\WebSocket;
use React\EventLoop\LoopInterface;
$configt = $settings['settings']['config'];
$config = [
    'base_uri'        => 'https://fapi.binance.com/', 
    'timeout' => 30,
    'connect_timeout' => 30,
    'http_errors'     => true,
    'verify'          => 1,
    'skipVerifyTls' => false
];

$auth = new FuTrperm($configt);
$websocket = new WebSocketApi($configt);
$ressock = [];
$client = new Client($config);
$server["endpoint"] =  'wss://fstream.binance.com/ws/';
$server["pingInterval"] = 3;
$server['maePrice'] = 0;
$server['countup'] = 1800;
$server['slp'] = false;
$server['isprice'] = false;
$server['symbol'] = 'DOTUSDT';
$orders = [
    'resulttp' => 'NEW',
    'istp' => false,
    'statustp' => false, 
    'resultsl' => 'NEW',
    'issl' => false,                   
    'statusma' => -1,
    'statussl' => false, 
    'camsm' => 0,
    'done' => true
];
$query = '?' . http_build_query(['connectId' => uniqid('', true)], 'DOTUSDT');
$headers = $auth->getHeaders();
try{
    $url = $auth->signature('/fapi/v1/listenKey', 'POST', []);

    $result = $client->request('POST', $url, [
        'headers' => $headers
    ]);
    $mustresp = new ValidResponse();
    $datakey = $mustresp->getApiData(true, $result);
    $listenKey = '';
    
    if (array_key_exists('listenKey', $datakey )) {

        $listenKey = $datakey['listenKey'];
        //$url = sprintf('%s%s%s', $server['endpoint'] . $listenKey, strpos($server['endpoint'], '?') === false ? '?' : '&', http_build_query($params));                       
        $server['connectUrl'] = $server['endpoint'] . $listenKey;
        $server['connectId'] = uniqid('', true);
        $server['listenKey'] = $listenKey;
        $sockapi = $websocket;
        $sockapi->getWsMessage($server, function (array $message, WebSocket $ws, LoopInterface $loop) use ($orders,$ressock) {
            $type = $message['e'];
            var_dump($message);
            //exit;
        }, function (array $message, LoopInterface $loop) {
            print("en close" . chr(10));
            $loop->stop();
            var_dump($message);
        });
        var_dump($ressock);
    }
} catch (RequestException $exp) {
    print($exp->getMessage() .chr(10));
    $message = json_decode(json_decode($exp->getMessage(),true)['summary'], true);
    return $message;
} catch (ResponseApiException $exp) {
    print($exp->getMessage() .chr(10));
    return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
} 
