#!/usr/bin/php
<?php
require __DIR__ . '/vendor/autoload.php';
use App\TradingBot;
/**
 * Clase principal del Bot de Trading con logging profesional
 */
class TradingBotLocal
{
    private const DEFAULT_ALGORITHM = 'ImpulseMacdEma100';
    private string $algorithm;
    private string $instanceName;
        /**
     * Constructor del Bot de Trading
     * @throws \RuntimeException Si la inicialización falla críticamente
     */
    public function __construct()
    {
        try {
            $this->loadConfiguration();
        } catch (\Throwable $e) {
            $errorMessage = "[FATAL] Fallo en la inicialización del bot: " . $e->getMessage();
            error_log($errorMessage);
            echo $errorMessage . "\n";
            exit(1);
        }
        print('TradingBot inicializado correctamente' . chr(10));
    }
    /**
     * Ejecuta el bot (punto de entrada principal)
     */
    public function run(): void
    {
        print("algorithm:{$this->algorithm} config_file:{$this->instanceName}" . chr(10));
        print('Bot iniciado exitosamente, entrando en loop principal' . chr(10));
    }
    /**
     * Carga y valida la configuración del bot
     *
     * @throws \RuntimeException Si la configuración es inválida o el archivo no existe
     */
    private function loadConfiguration(): void
    {
        $commandArgs = getopt(null, ["type::", "config::"]);
        $this->algorithm = $commandArgs['type'] ?? self::DEFAULT_ALGORITHM;
        $configFileName = $commandArgs['config'] ?? null;
        $this->instanceName = basename($configFileName, '.php');



    }    
}
try {
    $commandArgs = getopt(null, ["type::", "config::"]);
    $tradingBot = new TradingBot($commandArgs);
    $tradingBot->run();
} catch (\Throwable $e) {
    $errorMessage = "[FATAL] Error crítico al inicializar el bot: " . $e->getMessage();
    error_log($errorMessage);
    echo $errorMessage . "\n";
    exit(1);
}