<?php
include './vendor/autoload.php';
use App\SmartMoneyVolume;
use App\SmartMoneyFusionStrategy;
use App\ResponseApi;
$apiResponse = new ResponseApi();

$json = $apiResponse->getKlines('15m');
$lastIndex = count($json) - 2;
// Example usage (replace with your actual data)
$high = [ /* Your high price data */ ];
$low = [ /* Your low price data */ ];
$open = [ /* Your open price data */ ];
$close = [ /* Your close price data */ ];
$volume = [ /* Your close price data */ ];

for ($x = 0; $x < count($json)-1; $x++) {
    array_push($open, $json[$x]["open"]);
    array_push($close, $json[$x]["close"]);
    array_push($high, $json[$x]["high"]);
    array_push($low, $json[$x]["low"]);
    array_push($volume, $json[$x]["volact"]);
}
$data = [
    'high' => $high,
    'low' => $low,
    'open' => $open,
    'close' => $close,
    'volume' => $volume,
];

$smartMoneyVolume = new SmartMoneyVolume($data);
$smartMoneyFusionStrategy = new SmartMoneyFusionStrategy($smartMoneyVolume);

// Dentro de tu clase Algoritmo, después de obtener los datos y crear el SmartMoneyVolume y la estrategia...

// Asume que también creas instancias de tus otros indicadores/estrategias aquí
// $rsiAnalyzer = new RSI($volumeAnalyzer->prices); // O como funcione tu clase RSI
// $impulseMacd = new ImpulseMACD($volumeAnalyzer->prices, $volumeAnalyzer->volumes); // O como funcione tu MACD

// Si tu SmartMoneyFusionStrategy usa estos internamente, pásalos en el constructor:
// $strategy = new SmartMoneyFusionStrategy($volumeAnalyzer, $strategyConfig, $rsiAnalyzer, null, $impulseMacd);
// Si no los usa internamente, no los pases al constructor de SmartMoneyFusionStrategy.

// --- Obtener la señal potencial de SmartMoney ---
$smartMoneySignal = $smartMoneyFusionStrategy->getPotentialSignal();

if ($smartMoneySignal !== null) {
    echo "SmartMoneyFusionStrategy reporta una señal potencial.\n";
    echo "  Dirección: " . $smartMoneySignal['signal'] . "\n";
    echo "  Confianza (0-100): " . $smartMoneySignal['confidence'] . "\n";
    echo "  Ejecutable Internamente: " . ($smartMoneySignal['is_executable_suggestion'] ? 'Sí' : 'No') . "\n";
    echo "  Scores Ponderados: Long=" . $smartMoneySignal['smartmoney_long_score'] . ", Short=" . $smartMoneySignal['smartmoney_short_score'] . "\n";
    // print_r($smartMoneySignal); // Puedes imprimir todo el array para ver los niveles, etc.

    // --- Obtener señales o valores de otros indicadores ---
    // Ejemplo (asume que tus clases tienen estos métodos)
    // $rsiValue = $rsiAnalyzer->getValue();
    // $macdSignal = $impulseMacd->getSignalSuggestion(); // O isBullish(), isBearish()
    // $breakoutProb = $breakoutProbability->getBreakoutProbability();

    // echo "Otros Indicadores: RSI=" . $rsiValue . ", MACD Signal=" . $macdSignal . ", Breakout Prob=" . $breakoutProb . "...\n";


    // --- LÓGICA DE COMBINACIÓN Y DECISIÓN FINAL en tu clase Algoritmo ---
    $finalDecisionToExecute = false;

    // Ejemplo de lógica combinada:
    // Requerir que la señal de SmartMoney sea de al menos confianza X Y que ImpulseMACD confirme
    // if ($smartMoneySignal['confidence'] >= 50 && $smartMoneySignal['signal'] === $macdSignal) {
    //     $finalDecisionToExecute = true;
    // }

    // Ejemplo de lógica usando scores ponderados:
    // Requerir que la diferencia entre los scores ponderados sea significativa Y la confianza base no sea muy baja
    // if (($smartMoneySignal['smartmoney_long_score'] - $smartMoneySignal['smartmoney_short_score']) > 10 && $smartMoneySignal['confidence'] > 40) {
    //     $finalDecisionToExecute = true;
    //     // Asegurarse de que la dirección de la operación sea la correcta según la diferencia de scores
    //     $operationDirection = ($smartMoneySignal['smartmoney_long_score'] > $smartMoneySignal['smartmoney_short_score']) ? 'buy' : 'sell';
    //      // También verificar que signal['signal'] coincide con operationDirection si quieres consistencia
    // }


    // Ejemplo simple: Usar el flag interno de la estrategia como decisión final (similar al execute original)
     if ($smartMoneySignal['is_executable_suggestion']) {
         $finalDecisionToExecute = true;
         $operationDirection = $smartMoneySignal['signal']; // Usar la dirección determinada por la estrategia
     }


    if ($finalDecisionToExecute) {
        echo "Algoritmo decide ejecutar la operación!\n";
        try {
            // Calcular el tamaño de posición REAL
            $accountBalance = $this->trader->getBalance(); // Llama a tu Trader/setOrdersBySel real
            $positionSize = $this->calculatePositionSizeForExecution( // Método en tu Algoritmo
                $smartMoneySignal['entry'],
                $smartMoneySignal['stop_loss'],
                $smartMoneySignal['adjusted_risk_percent'], // Usar el riesgo ajustado de la señal
                $accountBalance
            );

            echo "Tamaño de posición REAL calculado: " . $positionSize . "\n";

            if ($positionSize > 0) {
                // --- ¡Llamar a tu clase centralizada setOrdersBySel! ---
                echo "Llamando a setOrdersBySel para colocar orden...\n";
                $orderResult = $this->trader->placeOrder( // Llama a tu Trader/setOrdersBySel
                    $operationDirection, // Usar la dirección final decidida por el Algoritmo
                    $smartMoneySignal['entry'],
                    $positionSize,
                    $smartMoneySignal['stop_loss'],
                    $smartMoneySignal['take_profit']
                );

                echo "Resultado de la orden: \n";
                print_r($orderResult);

                // Registrar, notificar, monitorear la posición, etc.

            } else {
                echo "Tamaño de posición calculado <= 0. No se coloca orden.\n";
            }

        } catch (\Exception $e) {
            echo "ERROR al preparar/ejecutar la orden vía setOrdersBySel: " . $e->getMessage() . "\n";
            // Manejar el error
        }

    } else {
        echo "Algoritmo decide NO ejecutar operación en este ciclo (combinación de señales no suficiente).\n";
    }

} else {
    echo "SmartMoneyFusionStrategy no reporta señal potencial básica.\n";
}