<?php
include './vendor/autoload.php';
use App\PivotCalculator;
use App\PivotPoints;
use App\ResponseApi;
use App\Trader;
$apiResponse = new ResponseApi();

$json = $apiResponse->getKlines('15m', 100);
$lastIndex = count($json) - 2;
// Example usage (replace with your actual data)
$high = [ /* Your high price data */ ];
$low = [ /* Your low price data */ ];
$close = [ /* Your close price data */ ];
$volume = [ /* Your close price data */ ];

for ($x = 0; $x < count($json); $x++) {
    array_push($close, $json[$x]["close"]);
    array_push($high, $json[$x]["high"]);
    array_push($low, $json[$x]["low"]);
    array_push($volume, $json[$x]["volact"]);
}

// Paso 1: Calcular pivotes clásicos
$pivotCalculator = new PivotCalculator($high, $low, $close, 14);
$pivotsData = $pivotCalculator->calculateClassicPivots();
 //var_dump($pivotsData);
 //exit;
// Opción 1: Usar R1 como high y S1 como low
$newHighR1 = $pivotsData['resistances'];
$newLowS1 = $pivotsData['supports'];

// Opción 2: Usar los pivotes clásicos como high y low
$newHighPivot = $pivotsData['pivots'];
$newLowPivot = $pivotsData['pivots'];

// Configurar el umbral de volatilidad (ATR)
$atr = end(Trader::ATR($high, $low, $close, 14));

// Crear instancias de PivotPoints para ambas opciones
/*
$pivotPointsR1S1 = new PivotPoints($newHighR1, $newLowS1, $atr);
// Determinar la tendencia para la opción R1/S1
echo "Tendencia usando R1 como high y S1 como low:\n";
if ($pivotPointsR1S1->isTrendBullish(2)) {
    echo "Tendencia Alcista\n";
} elseif ($pivotPointsR1S1->isTrendBearish(2)) {
    echo "Tendencia Bajista\n";
} else {
    echo "No hay tendencia clara\n";
}
*/
// Determinar la tendencia para la opción pivotes clásicos
echo "Tendencia usando pivotes clásicos como high y low:\n";
$pivotPointsPivot = new PivotPoints($newHighPivot, $newLowPivot, $atr);
if ($pivotPointsPivot->isTrendBullish(2)) {
    echo "Tendencia Alcista\n";
} elseif ($pivotPointsPivot->isTrendBearish(2)) {
    echo "Tendencia Bajista\n";
} else {
    echo "No hay tendencia clara\n";
}

