<?php
include './vendor/autoload.php';
use App\ResponseApi;
use App\ImpulseMACDWS;
$apiResponse = new ResponseApi();
$closes = [/* array de precios de cierre */];
$highs = [/* array de precios máximos */];
$lows = [/* array de precios mínimos */];
$volums = [/* array de volumenes */];
// Llenar con datos reales
$json = $apiResponse->getKlines('15m', 300);
$data = [];


for ($x = 0; $x < count($json); $x++) {
    array_push($closes, $json[$x]["close"]);
    array_push($highs, $json[$x]["high"]);
    array_push($lows, $json[$x]["low"]);
    array_push($volums, $json[$x]["volact"]);
}
$data = [
    'close' => $closes,
    'high' => $highs,
    'low' => $lows,
    'volum' => $volums
];
$impulseMacd = new ImpulseMACDWS(34,9,20);
$impulseMacd->calculate($data);
$resp = $impulseMacd->getMD();
$md = array_map(function($v) { return round($v, 3); }, array_slice($resp, -10, 10, true));
print_r($md);
$resp = $impulseMacd->getHistogram();
$hi = array_map(function($v) { return round($v, 3); }, array_slice($resp, -10, 10, true));
print_r($hi);
$resp = $impulseMacd->generateSignals(2);

//$bu = array_map(function($v) { if($v > 0)return $v; }, array_slice($resp['bullishCross'], -20, 20, true));
//$be = array_map(function($v) { if($v > 0)return $v; }, array_slice($resp['bearishCross'], -20, 20, true));

print_r($resp);


