<?php

// Asumiendo Autoloader de Composer o inclusión manual
require_once 'vendor/autoload.php'; // O ajusta las rutas de inclusión
// require_once 'app/src/ImpulseMACDWS.php';
// require_once 'app/src/Strategy/ImpulseMacdStrategy.php';

// Incluir la clase Trader si es personalizada, o asegurar que la extensión PECL esté activa
// require_once 'app/src/Trader.php'; // Ejemplo si es personalizada
use App\ResponseApi;
use App\ImpulseMACDWS;
use App\ImpulseMacdStrategy;

// --- PASO 1: Obtener Datos OHLCV ---
$closes = [/* array de precios de cierre */];
$highs = [/* array de precios máximos */];
$lows = [/* array de precios mínimos */];
$volums = [/* ... array de volúmenes (si SmartMoney se usara)... */];
$apiResponse = new ResponseApi();
$json = $apiResponse->getKlines('15m', 100);
for ($x = 0; $x < count($json); $x++) {
    array_push($closes, $json[$x]["close"]);
    array_push($highs, $json[$x]["high"]);
    array_push($lows, $json[$x]["low"]);
    array_push($volums, $json[$x]["volact"]);
}
$ohlcData = [
    'close' => $closes,
    'high' => $highs,
    'low' => $lows,
    'volum' => $volums
];

// ¡IMPORTANTE! Asegúrate que $ohlcData tenga suficientes velas

// --- PASO 2: Calcular Indicador Base ---
try {


    // Usar la clase ImpulseMACDWS simple
    $impulseMacd = new ImpulseMACDWS(
        lengthMA: 34,
        lengthSignal: 9,
        thresholdPeriod: 20 // Activar filtro dinámico
    );
    $impulseMacd->calculate($ohlcData); // Calcula MD, SB, SH, shThreshold

    echo "ImpulseMACDWS calculado exitosamente.\n";

    // Opcional: Ver algunos datos del MACD
    $md = $impulseMacd->getMD();
    echo "Último MD: " . round(end($md),3) . "\n";

} catch (\Exception $e) {
    die("Error calculando ImpulseMACDWS: " . $e->getMessage() . "\n");
}


// --- PASO 3: Crear y Ejecutar la Estrategia ---
try {
    // Pasar el ImpulseMACDWS simple a la estrategia
    $strategy = new ImpulseMacdStrategy(
        impulseMacd: $impulseMacd, // Pasar el objeto ya calculado
        ohlcData: $ohlcData,       // Pasar los datos OHLC de nuevo
        atrPeriod: 14,
        atrMultiplierSL: 2.0,
        rrRatio: 2.5
    );

    // Generar las señales finales (La estrategia calcula OB/OS, EMA, ATR y aplica filtros)
    $finalSignalsWithSLTP = $strategy->generateSignals(confirmationPeriods: 2); // Usar 2 barras de confirmación para MACD base

    echo "Señales de estrategia generadas exitosamente.\n";

} catch (\Exception $e) {
    die("Error ejecutando la estrategia: " . $e->getMessage() . "\n");
}

print_r(end($finalSignalsWithSLTP));
print(chr(10));
// --- PASO 4: Procesar y Mostrar Resultados ---
if ($finalSignalsWithSLTP !== null) {
    echo "\n--- Resultados de la Estrategia ---\n";

    $tradeCount = 0;
    // Mostrar las últimas 20 señales, por ejemplo
    $lastSignals = array_slice($finalSignalsWithSLTP, -20, 20, true);

    foreach ($lastSignals as $timestamp => $result) {
        $date = date('Y-m-d H:i', $timestamp); // Asume que las claves son timestamps
        if ($result['signal'] === 1) {
            $tradeCount++;
            echo "[$date] SEÑAL COMPRA -> SL: " . number_format($result['sl'] ?? NAN, 5) . ", TP: " . number_format($result['tp'] ?? NAN, 5) . "\n";
        } elseif ($result['signal'] === -1) {
            $tradeCount++;
            echo "[$date] SEÑAL VENTA -> SL: " . number_format($result['sl'] ?? NAN, 5) . ", TP: " . number_format($result['tp'] ?? NAN, 5) . "\n";
        } else {
            // Opcional: Mostrar barras sin señal
            // echo "[$date] Señal: 0\n";
        }
    }
     echo "\nTotal de señales generadas en las últimas 20 barras: $tradeCount\n";

} else {
    echo "No se generaron resultados de la estrategia.\n";
}

?>