<?php
include './vendor/autoload.php';
$settings = require 'settings.php';
$config = $settings['settings']['config'];
use App\ResponseApi;
$closes = [];
$highs = [];
$lows = [];
$pplh = [];
$apiResponse = new ResponseApi();
function array_key_last(array $arr) {
    $i = 0;
    foreach($arr as $key  => $unused) {
        $i = $i +1;
        //return $key;
    }
    return $key;
}
function array_key_first(array $arr) {
    foreach($arr as $key => $unused) {
        return $key;
    }
    return NULL;
}
// Sample data (replace with actual price data)
$json = $apiResponse->getKlines('15m');

for ($x = 0; $x < count($json); $x++) {
    array_push($closes, $json[$x]["close"]);
    array_push($highs, $json[$x]["high"]);
    array_push($lows, $json[$x]["low"]);
}
$prices = $closes;

// Function to calculate EMA
function calculateEMA($data, $period) {
    $k = 2 / ($period + 1);
    $ema = [];
    $ema[0] = $data[0]; // First EMA is the same as the first data point

    for ($i = 1; $i < count($data); $i++) {
        $ema[$i] = $data[$i] * $k + $ema[$i - 1] * (1 - $k);
    }

    return $ema;
}

// Function to calculate MACD
function calculateMACD($prices) {
    $ema12 = calculateEMA($prices, 12);
    $ema26 = calculateEMA($prices, 26);

    $macdLine = [];
    for ($i = 0; $i < count($prices); $i++) {
        $macdLine[$i] = $ema12[$i] - $ema26[$i];
    }

    $signalLine = calculateEMA($macdLine, 9);

    return ['macdLine' => $macdLine, 'signalLine' => $signalLine];
}

// Function to calculate RSI
function calculateRSI($prices, $period = 14) {
    $gains = [];
    $losses = [];

    for ($i = 1; $i < count($prices); $i++) {
        $change = $prices[$i] - $prices[$i - 1];
        if ($change >= 0) {
            $gains[] = $change;
            $losses[] = 0;
        } else {
            $gains[] = 0;
            $losses[] = abs($change);
        }
    }

    $avgGain = array_sum(array_slice($gains, 0, $period)) / $period;
    $avgLoss = array_sum(array_slice($losses, 0, $period)) / $period;

    $rs = $avgGain / $avgLoss;
    $rsi = 100 - (100 / (1 + $rs));

    return $rsi;
}

// Calculate MACD and RSI
$macd = calculateMACD($prices);
$rsi = calculateRSI($prices);

// Determine the trend
$lastIndex = count($prices) - 1;
$macdLine = $macd['macdLine'][$lastIndex];
$signalLine = $macd['signalLine'][$lastIndex];

if ($macdLine > $signalLine && $rsi > 50) {
    echo "Bullish Trend";
} elseif ($macdLine < $signalLine && $rsi < 50) {
    echo "Bearish Trend";
} else {
    echo "No clear trend";
}

?>