<?php
include './vendor/autoload.php';
use Psr\Log\LoggerInterface;
use Psr\Log\AbstractLogger;
use App\ResponseApi;

// Incluir las clases necesarias
require_once './app/src/BreakoutProbability.php';
//require_once 'NotificacionesAction.php'; // Asegúrate de que esta clase esté implementada correctamente

// Implementación de un Logger simple para demostración
class MyLogger extends AbstractLogger implements LoggerInterface
{
    public function log($level, $message, array $context = []): void
    {
        echo "[" . strtoupper($level) . "] " . $message . " " . json_encode($context) . PHP_EOL;
    }
}

// Crear una instancia del logger (opcional)
$logger = new MyLogger();
$logger->log('warning',"prueba");
// Crear una instancia de NotificacionesAction (asegúrate de que esté configurada correctamente)
//$notificacionesAction = new NotificacionesAction(/* ... parámetros necesarios ... */);

// Crear una instancia del indicador
$indicator = new BreakoutProbability(
    percentageStep: 1.0,
    numberOfLines: 5,
    upTrendColor: '#00FF00',
    downTrendColor: '#FF0000',
    fillArea: true,
    fillColor: 'rgba(0, 255, 0, 0.1)',
    disableZeroProbability: true,
    showStatisticPanel: true,
    alertOptions: [
        'symbol' => 'DOTUSDT', // Usar el símbolo proporcionado
    ],
    logger: $logger
);

// Inyectar la instancia de NotificacionesAction
//$indicator->setNotificacionesAction($notificacionesAction);

// Obtener datos de precios desde la API
$apiResponse = new ResponseApi();
$json = $apiResponse->getKlines('15m', 1500);
/*
$result = $json;
$openTime = $json[0]['openTime'];
$fechaope = (new DateTime(date('m/d/Y H:i:s',intval($openTime)/1000)))->format('Y-m-d H:i:s');
//print($fechaope . chr(10));

$factor = 432000000;
$from = $openTime - $factor;
$to = $openTime;
for ($i = 0; $i < 13; $i++) {
    $jsonr = $apiResponse->getKlinesTime('15m', $from, $to);
    $openTime = $jsonr[0]['openTime'];
    $fechaope = (new DateTime(date('m/d/Y H:i:s',intval($openTime)/1000)))->format('Y-m-d H:i:s');
    //print($fechaope . chr(10));
    $from = $openTime - $factor;
    $to = $openTime;
    $result = array_merge($jsonr, $result);
}

$json = $result;
*/
$logger->log('warning',count($json));
// Procesar los datos de la API y agregarlos al indicador
if (!empty($json)) {
    foreach ($json as $klines) {
        $indicator->addPrice(
            (float) $klines["open"],
            (float) $klines["high"],
            (float) $klines["low"],
            (float) $klines["close"]
        );
    }

    // Calcular niveles y probabilidades
    $levels = $indicator->calculateBreakoutLevels();

    // Generar alertas
    $indicator->generateAlerts($levels);

    // Obtener datos para visualización
    $indicatorData = $indicator->getIndicatorData();
    $logger->log('warning',$indicatorData . PHP_EOL);

    // Obtener y mostrar las estadísticas
    $statistics = $indicator->getStatistics();
    print_r($statistics);
} else {
    echo "No se pudieron obtener datos de la API." . PHP_EOL;
}