<?php
chdir(__DIR__);
include './vendor/autoload.php';
use App\AlgoritApi;
use App\SetOrdersBuySel;
use App\Settings;
use App\DailyRotatingLogger;
$params = new Settings();
$settings = $params->settings; 
$symbol = 'DOTUSDT';
$currency = 'USDT';
$resp = 1;
$togetData  = $settings['togetData'];
$config = $settings['config'];
$order = $settings['order'];
$porini = $settings['porini'];
$comnandval = getopt(null, ["type:"]);
$LOG_RETENTION_DAYS = 7; // Días de retención de logs
$LOG_DIR = __DIR__ . '/logs';
//$qalgorit = isset($comnandval['type'])?$comnandval['type']:'MdiAdx';
//$qalgorit = isset($comnandval['type'])?$comnandval['type']:'RsiMacd';
//$qalgorit = isset($comnandval['type'])?$comnandval['type']:'ImpulseMacd';
$qalgorit = isset($comnandval['type'])?$comnandval['type']:'ImpulseMacdEma100';
$config['algorit'] = $qalgorit;
$time_start = 30;
$apiSetOrdersBuySel = new SetOrdersBuySel($config);
$logPath = $LOG_DIR . '/indexbi.log';
$logger = new DailyRotatingLogger($logPath, $LOG_RETENTION_DAYS);
$account = $apiSetOrdersBuySel->getAccount($symbol, $currency);
$porini['porLe']= $account['leverage'];
$algResp = [];
// get time to sleep
function getTimeToSleep($microt, $intervalo){
    $sleep = 60;
    $date = (new \DateTime(date('m/d/Y H:i:s',$microt)));
    $date->setTimeZone(new \DateTimeZone("Europe/Lisbon"));
    $h = ($date)->format('H');
    $m = ($date)->format('i');
    $rest = ($m / $intervalo) - floor($m / $intervalo);
    $next = $intervalo - round($rest * $intervalo,0);
    $sleep = $next * 60;
    //print($date->format('Y-m-d H:i:s') . ' esperando:' . $sleep / 60 . chr(10));
    return $sleep;
} 
// get out time after sleep
function getOutTime($mesg){
    $microt = intval(round(microtime(true)));
    $date = (new \DateTime(date('m/d/Y H:i:s',$microt)));
    $date->setTimeZone(new \DateTimeZone("Europe/Lisbon"));
    $h = ($date)->format('H');
    $m = ($date)->format('i');
    //print($date->format('Y-m-d H:i:s') . " " . $mesg . $h . ' Min: ' . $m .chr(10));
}
$apiAlgoritmo = new AlgoritApi($config);
while(true)
{
    $status = $apiSetOrdersBuySel->getStatus();
    if($status === 0){
        $algResp = [];
        switch ($qalgorit) {
            case 'RsiMacd':
                $apiAlgoritmo->runAlgoritRsiMacd();
                break;	
            case 'ImpulseMacd':
                $apiAlgoritmo->runAlgorithmAnalysis();
                break;
            case 'ImpulseMacdEma100':
                $apiAlgoritmo->runAlgorithmImpulseMacdEMA100();
                break;   
            case 'ImpulseMacdBreakPro':
                $apiAlgoritmo->runAlgorithmImpulseMacdBreakPro();
                break;                             
            default:
                $apiAlgoritmo->runAlgorithmImpulseMacdEMA100();
        }
        $algResp = $apiAlgoritmo->getAlgResp();
        // Para EmaRsi START
        if($qalgorit === "RsiMacd"){
            $CV = isset($algResp['CV'])?$algResp['CV']:0;
            $RSI = isset($algResp['RSI'])?$algResp['RSI']:0;
            $ACT = isset($algResp['ACT'])?$algResp['ACT']:0;
            $config['cv'] = $CV;
            $config['rsi'] = $RSI;
            $config['act'] = $ACT;
            $porini['porTp'] = isset($algResp["tokentel"]["potp"])?$algResp["tokentel"]["potp"]:$porini['porTp'];
            $porini['porSm'] = isset($algResp["tokentel"]["posl"])?$algResp["tokentel"]["posl"]:$porini['porSm']; 
        }else{
            $porini['porTp'] = isset($algResp["tokentel"]["potp"])?$algResp["tokentel"]["potp"]:$porini['porTp'];
            $porini['porSm'] = isset($algResp["tokentel"]["posl"])?$algResp["tokentel"]["posl"]:$porini['porSm']; 
            $CV = isset($algResp['CV'])?$algResp['CV']:0;
            $config['cv'] = $CV;
        }

        // Para EmaRsi END
        $emitir = isset($algResp["emitir"])?$algResp["emitir"]:0;
        $tokentel = isset($algResp["tokentel"])?$algResp["tokentel"]:[];
        //if(($time_start) >= 30 ){
            //print('Status:' . $status . ' CV:' . $CV . ' emitir:' . $emitir . ' acción:' . $tokentel['accion'] . chr(10));
            //$time_start = 0;
        //}
        //$time_start = $time_start + 1;
        //$emitir = 1;
        //$CV = 1;
        if ($emitir === 1){
            $data = [
                'order' => $order,
                'symbol' => $symbol,
                'currency' => $currency,
                'porini' => $porini,
                'tokentel' => $tokentel
            ];
            $apiSetOrdersBuySel->setData($data, $CV); 
            $balance = $apiSetOrdersBuySel->getBalanceAva();
            if($balance > 0){ 
                $resp = $apiSetOrdersBuySel->optTrade($CV);
                if($qalgorit === "EmaRsi"){
                    $config['istp'] = $apiSetOrdersBuySel->getISTP();
                    print("en index.RSI back setord.:{$config['rsi']} ISTP:{$config['istp']}" . chr(10));
                }
                sleep(getTimeToSleep($resp, 1));
                getOutTime('Saliendo Hora:');
            }else{
                getOutTime('Saliendo, Error de Balance Hora:');
            }
            //exit; //quitar
        }else{
            $intervalo = 15; 
            $resp = intval(round(microtime(true)));
            sleep(getTimeToSleep($resp, $intervalo));
            getOutTime('Saliendo No Emitir Hora:');
            //sleep(60);
        }
    }else{
        $intervalo = 15; 
        $resp = intval(round(microtime(true)));
        sleep(getTimeToSleep($resp, $intervalo));
        getOutTime('Saliendo Status != 0 Hora:');
    }
}
