<?php
#!/usr/bin/env php
/**
 * Script de Despliegue de Bots de Trading convertido de Bash a PHP
 * 
 * USO:
 * php deploy_bot.php /var/www/your_bot_project trading-bot
 * php deploy_bot.php /var/www/another_bot_project another-platform-bot
 */

// Verificar argumentos de línea de comandos
if ($argc < 3) {
    echo "Uso: {$argv[0]} <RUTA_ABSOLUTA_DEL_PROYECTO> <NOMBRE_BASE_SERVICIO_SYSTEMD>\n";
    echo "Ej: {$argv[0]} /var/www/my_bot_project trading-bot\n";
    exit(1);
}

$projectDir = $argv[1];
$systemdServiceName = $argv[2];

// Configuración
$phpExecutable = "/usr/bin/php"; // Ruta a tu ejecutable PHP

// --- CONFIGURACIÓN DE VAULT (MISMAS CREDENCIALES PARA TODAS LAS INSTANCIAS) ---
// Estas variables se inyectarán en cada servicio systemd.
// ¡REEMPLAZA CON TUS VALORES REALES DE VAULT!
$vaultAddrGlobal = "http://127.0.0.1:8200";
$vaultApproleRoleIdGlobal = "tu_role_id_unico_aqui";
$vaultApproleSecretIdGlobal = "tu_secret_id_unico_aqui";

echo "--- Script de Despliegue de Bots de Trading (Desde Imagen Pre-configurada) ---\n";
echo "Desplegando bot para el directorio: {$projectDir} con servicio base: {$systemdServiceName}\n";

// Verificar que el directorio del proyecto existe
if (!is_dir($projectDir)) {
    echo "Error: El directorio del proyecto {$projectDir} no existe.\n";
    exit(1);
}
/*
// 1. (Opcional) Instalar dependencias de Composer
echo "Verificando/actualizando dependencias de Composer en {$projectDir} ...\n";

// Cambiar al directorio del proyecto
$oldDir = getcwd();
if (!chdir($projectDir)) {
    echo "Error: No se pudo cambiar al directorio del proyecto {$projectDir}.\n";
    exit(1);
}

// Ejecutar composer install
$composerCommand = "composer install --no-dev --optimize-autoloader 2>&1";
$composerOutput = [];
$composerReturnVar = 0;

exec($composerCommand, $composerOutput, $composerReturnVar);

if ($composerReturnVar !== 0) {
    echo "Error: Fallo al ejecutar 'composer install' para {$projectDir}.\n";
    echo "Salida del comando:\n" . implode("\n", $composerOutput) . "\n";
    chdir($oldDir);
    exit(1);
}

echo "Dependencias de Composer verificadas/actualizadas para {$projectDir}.\n";

// Volver al directorio original
chdir($oldDir);
*/
// 2. Crear el template de servicio Systemd
echo "Copiando el template de servicio Systemd para {$systemdServiceName} ...\n";

$serviceTemplatePath = "/etc/systemd/system/{$systemdServiceName}@.service";

// Obtener información del usuario actual
$currentUser = trim(shell_exec('whoami'));
$currentGroup = trim(shell_exec('id -gn'));

// --- CREAR EL ARCHIVO DE SECRETOS SEPARADO Y SEGURO ---
$secretsDir = "/etc/{$systemdServiceName}"; // Ej: /etc/trading-bot
if (!is_dir($secretsDir)) {
    executeCommand("sudo mkdir -p {$secretsDir}", "Error al crear directorio de secretos.");
    executeCommand("sudo chmod 700 {$secretsDir}", "Error al establecer permisos en directorio de secretos.");
    executeCommand("sudo chown {$currentUser}:{$currentGroup} {$secretsDir}", "Error al cambiar propietario de directorio de secretos."); // Asegurarse de que el usuario del servicio pueda leerlo
}

$secretIdFilePath = "{$secretsDir}/vcm_secret_id.env"; // Nombre del archivo de secretos

$secretIdContent = "VAULT_APPROLE_SECRET_ID=\"tu_secret_id_unico_aqui\"\n"; // EL VALOR DEL SECRET ID REAL

$tempSecretFile = tempnam(sys_get_temp_dir(), 'secret_id_');
if (file_put_contents($tempSecretFile, $secretIdContent) === false) {
    echo "Error: No se pudo crear el archivo temporal para el SecretID.\n";
    exit(1);
}

// Copiar el archivo de secretos con sudo y establecer permisos estrictos
$sudoCopySecretCommand = "sudo cp {$tempSecretFile} {$secretIdFilePath} && sudo chmod 600 {$secretIdFilePath} && sudo chown {$currentUser}:{$currentGroup} {$secretIdFilePath}";
$secretCopyOutput = [];
$secretCopyReturnVar = 0;
exec($sudoCopySecretCommand, $secretCopyOutput, $secretCopyReturnVar);
unlink($tempSecretFile); // Limpiar archivo temporal

if ($secretCopyReturnVar !== 0) {
    echo "Error: Fallo al crear y asegurar el archivo de SecretID inicial. ¿Tienes permisos sudo?\n";
    echo "Salida del comando:\n" . implode("\n", $secretCopyOutput) . "\n";
    exit(1);
}
echo "Archivo de SecretID seguro creado en {$secretIdFilePath}\n";

$serviceTemplate = <<<EOF
[Unit]
Description=Trading Bot Instance: %i for {$systemdServiceName}
After=network.target

[Service]
Type=simple
User={$currentUser}
Group={$currentGroup}
WorkingDirectory={$projectDir}
ExecStart={$phpExecutable} {$projectDir}/TradingBot.php --config=%i.php

# Variables de Entorno para Vault AppRole (Compartidas por todas las instancias)
Environment="VAULT_ADDR={$vaultAddrGlobal}"
Environment="VAULT_APPROLE_ROLE_ID={$vaultApproleRoleIdGlobal}"
EnvironmentFile={$secretIdFilePath} # <-- ¡Usar el archivo seguro para el SecretID!
Environment="VAULT_APPROLE_ROLE_NAME=trading-bot"
Environment="VAULT_NAMESPACE=null"
Environment="VAULT_CA_CERT_PATH=/etc/vault.d/certs"q
Environment="VAULT_TRADING_BOT_APPROLE_NAME=trading-bot"
Environment="BOT_ENV_FILE_DIR={$projectDir}/bots"
Environment="BOT_ENV_FILE_PREFIX=bot"
Restart=always
RestartSec=5s
StandardOutput=append:{$projectDir}/logs/service.log
StandardError=append:{$projectDir}/logs/service_error.log
SyslogIdentifier={$systemdServiceName}-%i

[Install]
WantedBy=multi-user.target
EOF;

// Escribir el archivo de servicio usando sudo
$tempFile = tempnam(sys_get_temp_dir(), 'systemd_service_');
if (file_put_contents($tempFile, $serviceTemplate) === false) {
    echo "Error: No se pudo crear el archivo temporal para el servicio.\n";
    exit(1);
}

$sudoCommand = "sudo cp {$tempFile} {$serviceTemplatePath}";
$sudoOutput = [];
$sudoReturnVar = 0;

exec($sudoCommand, $sudoOutput, $sudoReturnVar);
unlink($tempFile); // Limpiar archivo temporal

if ($sudoReturnVar !== 0) {
    echo "Error: Fallo al crear el template de servicio Systemd para {$systemdServiceName}. ¿Tienes permisos sudo?\n";
    echo "Salida del comando:\n" . implode("\n", $sudoOutput) . "\n";
    exit(1);
}

echo "Template de servicio Systemd creado en {$serviceTemplatePath}\n";

// 3. Recargar Systemd Daemon
echo "Recargando Systemd daemon...\n";

$reloadCommand = "sudo systemctl daemon-reload 2>&1";
$reloadOutput = [];
$reloadReturnVar = 0;

exec($reloadCommand, $reloadOutput, $reloadReturnVar);

if ($reloadReturnVar !== 0) {
    echo "Error: Fallo al recargar systemd daemon.\n";
    echo "Salida del comando:\n" . implode("\n", $reloadOutput) . "\n";
    exit(1);
}

echo "Systemd daemon recargado.\n";

echo "--- Despliegue completado. ---\n";
echo "Para el bot en {$projectDir}, los servicios Systemd serán de la forma: {$systemdServiceName}@<instancia>.service\n";
echo "Ejemplo de uso:\n";
echo "  sudo systemctl start {$systemdServiceName}@bot1.service\n";
echo "  sudo systemctl status {$systemdServiceName}@bot1.service\n";
echo "  sudo journalctl -u {$systemdServiceName}@bot1.service -f\n";
echo "\n";

/**
 * Función auxiliar para ejecutar comandos con manejo de errores mejorado
 */
function executeCommand($command, $errorMessage = null) {
    $output = [];
    $returnVar = 0;
    
    exec($command . " 2>&1", $output, $returnVar);
    
    if ($returnVar !== 0) {
        if ($errorMessage) {
            echo $errorMessage . "\n";
        }
        echo "Comando fallido: {$command}\n";
        echo "Código de salida: {$returnVar}\n";
        echo "Salida:\n" . implode("\n", $output) . "\n";
        return false;
    }
    
    return $output;
}
?>