    private function buildQuery($params = [])
    {
        $new_arr = array();
        $query_add = '';
        foreach ($params as $label=>$item) {
            if ( gettype($item) == 'array' ) {
                foreach ($item as $arritem) {
                    $query_add = $label . '=' . $arritem . '&' . $query_add;
                }
            } else {
                $new_arr[$label] = $item;
            }
        }
        $query = http_build_query($new_arr, '', '&');
        $query = $query_add . $query;
        return $query;
    } 
    private function signedRequest($path, $method, $parameters) {
        $keys = $this->signatureRSA();
        $secret = $keys->SecKey;
        $ApiKey = $keys->APIKey;
        //$timestamp = floor(microtime(true) * 1000);
        $timestamp = $this->getTime();
        $query = $this->buildQuery($parameters);
        if (is_array($parameters)) {
            $body = empty($parameters) ? '' : json_encode($parameters, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
        } else {
            $body = (string)$parameters;
        }
        $auth = $timestamp . $method. $path . $body;
        $signatureGen = base64_encode(hash_hmac('sha256', $auth , $keys->SecKey, true));
        $headers = [
            'KC-API-KEY'        => $keys->APIKey,
            'KC-API-TIMESTAMP'  => $timestamp,
            'KC-API-PASSPHRASE' => $keys->Passwd,
            'KC-API-SIGN'       => $signatureGen,
            //'KC-API-KEY-VERSION' => '2',
            'User-Agent' => 'KuCoin-Futures-PHP-SDK/1.0.22',
            'Content-Type' => 'application/json'

        ];
        return $headers;
    }
    private function signatureRSA() {
        $publickey = openssl_pkey_get_public("file://app/src/Public_key");
        $filename = "./app/src/encrypted.txt";
        $encrypted = file_get_contents($filename);
        openssl_public_decrypt(file_get_contents($filename), $decrypted, $publickey);
        $json = json_decode($decrypted);
        openssl_free_key($publickey);
        return $json;
    }   
    public function getTime(){
        $client = $this->getClient(static::$config);
        $result = $client->request(self::METHOD_GET, 'timestamp');
        return $this->getApiData($result);
    }
    private function cntrOrdersNew($CV){
        $this->printLog("in cntlOrders" .chr(10));
        while(true){
            $statusLi = $this->getOrderStatusMa();
            $statusTp = $this->getOrderStatusTp();
            $statusSm = $this->getOrderStatusSl(); 
            $this->printLog(" 3.- statusLi:" . $statusLi . chr(10)); 
            if($statusLi === 0){ 
                if($statusTp === 'done'){
                    $this->retval['Tp'] = true;
                    $this->retval['Sm'] = false;                    
                }else{
                    $this->retval['Sm'] = true;                      
                    $this->retval['Tp'] = false;                    
                }
                if($statusTp === 'done' and $statusSm !== 'done'){
                    $resp = $this->delOneOrder($this->slOrderId);
                    $this->printLog(" 3.OK- del SL - statusTp:" . $statusTp . " statusSm:" . $statusSm . chr(10));
                }elseif($statusSm ===  'done'  and $statusTp !== 'done'){
                    $resp = $this->delOneOrder($this->tpOrderId);
                    $this->printLog(" 3.OK - del TP - statusTp:" . $statusTp . " statusSm:" . $statusSm . chr(10));
                }elseif($statusSm ===  'done'  and $statusTp == 'done'){
                    $this->printLog(" 3.OK - statusTp:" . $statusTp . " statusSm:" . $statusSm . chr(10));
                }else{
                    $this->printLog(" 3.OK - del ALL statusTp:" . $statusTp . " statusSm:" . $statusSm . chr(10));
                    //$this->delAllOrders(false);
                }
                $this->printLog(" 4.- statusTp:" . $statusTp . " statusSm:" . $statusSm . " statusLi:" . $statusLi . chr(10));
                $this->retval['doit'] = 1;
                break;    
            }elseif($statusLi < 0){
                printLog('statusLi < 0:' . $statusLi);
            }else{

                if($statusTp === 'done' and $statusSm !== 'done'){ 
                    $this->printLog(" TP 2.- statusTp:" . $statusTp . " statusSm:" . $statusSm . chr(10));
                    $this->printLog(" 4.1-KO- statusTp:" . $statusTp . " statusSm:" . $statusSm . " statusLi:" . $statusLi . chr(10));
                    $this->sendAlert(2, $statusTp, $statusSm, "cntlOrders");  
                }elseif($statusSm ===  'done' and $statusTp !== 'done'){
                    $this->printLog("SL 2.- statusTp:" . $statusTp . " statusSm:" . $statusSm . chr(10));
                    $this->printLog(" 4.2-KO- statusTp:" . $statusTp . " statusSm:" . $statusSm . " statusLi:" . $statusLi . chr(10));
                    $this->sendAlert(2, $statusTp, $statusSm, "cntlOrders");  
                    $this->retval['doit'] = 0;
                }elseif($statusTp === 'done' and $statusSm === 'done'){ 
                    $this->printLog(" TP/SL 2.- statusTp:" . $statusTp . " statusSm:" . $statusSm . chr(10));
                    $this->printLog(" 4.3-KO- statusTp:" . $statusTp . " statusSm:" . $statusSm . " statusLi:" . $statusLi . chr(10));
                    $this->sendAlert(2, $statusTp, $statusSm, "cntlOrders");  
                    //$this->retval['doit'] = 0;
                    //break;                
                }else{
                    if(!$this->retval['camSm']){
                        $resp = $this->calcVaria($CV, $statusTp, $statusSm);
                        sleep(5);
                    }
                }
            }            

        }
        //}
    }    
    private function cntrOrdersOrg($CV){
        $this->printLog("in cntlOrders" .chr(10));
        while(true){
            $statusLi = $this->getOrderStatusMa();
            $statusTp = $this->getOrderStatusTp();
            $statusSm = $this->getOrderStatusSl(); 
            $this->printLog(" 3.- statusTp:" . $statusTp . " statusSm:" . $statusSm . " statusLi:" . $statusLi . chr(10)); 
            if($statusTp ===  'done' or $statusSm === "done"){ 
                if($statusTp === 'done'){
                    $this->retval['Tp'] = true;
                    $this->retval['Sm'] = false;                    
                }else{
                    $this->retval['Sm'] = true;                      
                    $this->retval['Tp'] = false;                    
                }
                
                if($statusTp === 'done' and $statusSm !== 'done'){
                    //$resp = $this->delOneOrder($this->slOrderId);
                    $this->printLog(" 3.OK - statusTp:" . $statusTp . " statusSm:" . $statusSm . chr(10));
                }elseif($statusSm ===  'done'  and $statusTp !== 'done'){
                    //$resp = $this->delOneOrder($this->tpOrderId);
                    $this->printLog(" 3.OK - statusTp:" . $statusTp . " statusSm:" . $statusSm . chr(10));
                }elseif($statusSm ===  'done'  and $statusTp == 'done'){
                    $this->printLog(" 3.OK - statusTp:" . $statusTp . " statusSm:" . $statusSm . chr(10));
                }else{
                    $this->delAllOrders(false);
                }
                sleep(5);
                $statusLi = $this->getOrderStatusMa();
                if($statusLi === 0){
                    $this->printLog(" 4.- statusTp:" . $statusTp . " statusSm:" . $statusSm . " statusLi:" . $statusLi . chr(10));
                    $this->retval['doit'] = 1;
                    break;
                }else{
                    $this->printLog(" 4.KO- statusTp:" . $statusTp . " statusSm:" . $statusSm . " statusLi:" . $statusLi . chr(10));
                    $this->sendAlert(2, $statusTp, $statusSm, "cntlOrders");  
                    $this->retval['doit'] = 0;
                    //break;
                }
            }elseif($statusTp === "false"){ 
                $this->printLog(" TP 2.- statusTp:" . $statusTp . " statusSm:" . $statusSm . chr(10));
                $statusLi = $this->getOrderStatusMa();
                if($statusLi === 0){
                    $this->delAllOrders(false);
                    $this->sendAlert(0, $statusTp, $statusSm, "cntlOrders");
                    $this->retval['doit'] = 1;
                    break;
                }else{
                    $this->sendAlert(1, $statusTp, $statusSm, "cntlOrders");
                    //$this->retval['doit'] = 0;
                    //break;                  
                }
            }elseif($statusSm === "false"){
                $this->printLog("SL 2.- statusTp:" . $statusTp . " statusSm:" . $statusSm . chr(10));
                $statusLi = $this->getOrderStatusMa();
                if($statusLi === 0){
                    $this->delAllOrders(false);
                    $this->sendAlert(0, $statusTp, $statusSm, "cntlOrders");
                    $this->retval['doit'] = 1;
                    break;
                }else{
                    $this->sendAlert(1, $statusTp, $statusSm, "cntlOrders");
                    //$this->retval['doit'] = 0;
                    //break;                  
                }
            }else{
                if(!$this->retval['camSm']){
                    $resp = $this->calcVaria($CV, $statusTp, $statusSm);
                    sleep(5);
                }
            }
        }
        //}
    }

    public function sendAlertTelegram($valret)
    {
        $this->telegramTempl = new TelegramTemplate();
        $token = "296248250";
        //$tokenall = $valret['telusers']; //array(0 => "270879319", 1 => "296248250"); 
        /*
        $body = '';
        $body = "<b>******* " . "Alerta" . " ********</b>" . chr(10);      
        $body = $body . "<b>*** intervalo: 15m DMI ***</b>" . chr(10);     
        $body = $body . $tokentel . chr(10); 
        */  
        $body = $this->telegramTempl->getTemplateAlert($valret);    
        $disable_web_page_preview = true;
        $reply_to_message_id = false;
        $reply_markup = null;
        $parse_mode = "HTML";  

        $data = array(
            'chat_id' => urlencode($token),
            'text' => $body,
            'disable_web_page_preview' => urlencode($disable_web_page_preview),
            'reply_to_message_id' => urlencode($reply_to_message_id),
            'reply_markup' => urlencode($reply_markup),
            'parse_mode' => urlencode($parse_mode)            
        );
        $con = $this->createTrdTelegramAsync($data); 
    }

    public function sendTrdTelegram($valret)
    {
        $this->telegramTempl = new TelegramTemplate();
        $body = $this->telegramTempl->getTemplateOrder($valret); 
        //$tokenall = $valret['telusers']; //array(0 => "270879319", 1 => "296248250");   
        $tokenall = array(0 => "296248250"); 
        /*  
        //$tokenall = array(0 => "1439504606", 1 => "1982512292", 2 => "1567169349"); //Alejandro y flia
        if($valret["init"] === 0){
            $body = "<b>**** " . "Apertura de ordenes con DMI". " ****</b>" . chr(10);
            $body = $body . "<b>**** " . $valret["accion"] . " ****</b>" . chr(10);
            $body = $body . "UTC - Apertura: " . $valret["fechaope"] . "  Cierre:" . $valret["fechaclo"] . chr(10);
            $orgDate = intval($valret['tim']);        
            $date = new \DateTime(date('m/d/Y H:i:s',$orgDate));
            $date->setTimeZone(new \DateTimeZone($valret['timezone']));
            $body = $body . $valret['locale'].$date->format('Y-m-d H:i:s') . chr(10); 
            $body = $body . "<b>*** intervalo: ". $valret['interval'] . " ***" . chr(10); 
            $body = $body . "DMI3: " . $valret["dmi3"] .  chr(10);
            $body = $body . "DMI15: " . $valret["dmi15"]  . " </b>" . chr(10);        
            $body = $body . "<b>*** intervalo: ". $valret['interlow'] . " ***</b>" . chr(10); 
            $body = $body . "<b>ADX3m: " . $valret["adx3m"] . " ADX3ma: " . $valret["adx3ma"] . chr(10);
            $body = $body . "ape. precio: " . number_format($valret["open"], 2, ',', '.') . " |" .         
            " ult. precio: " . number_format($valret["close"], 2, ',', '.') . "</b>" . chr(10);
        }else{
            $body = "<b>**** " . "Cierre de ordenes" . " ****</b>" . chr(10);
            $date = new \DateTime('now');
            $date->setTimeZone(new \DateTimeZone($valret['timezone']));
            $body = $body . $valret['locale'] . '- Cierre : '. $date->format('Y-m-d H:i:s') . chr(10); 
            $resCV = $valret['resCV'];
            if($resCV['doit'] === 1){
                $body = $body . "<b>******* " . $valret["accion"] . " ordenada" .  " ********</b>" . chr(10);
                $body = $body . "95 % balance diponible * : " . $resCV["avBal"] . chr(10);        
                $body = $body . "precio: " . $resCV["price"] . chr(10);
                $body = $body . "cantidad: " . $resCV["qty"] . chr(10);
                $body = $body . "total ordenado: " . ($resCV["price"] * $resCV["porLe"]) . chr(10);
                $body = $body . "Apalancamiento: " . $resCV["porLe"] . chr(10);
                if ($resCV["Tp"]){
                    $body = $body . " ****** Tp Protegido ******" . chr(10);
                    $body = $body . "TP: %" . $resCV["porTp"] . " precio: " . $resCV["impTp"] . chr(10);
                    $body = $body . "SL: %" . $resCV["porSm"] . " precio: " . $resCV["impSm"] . chr(10);
                }else{
                    if ($resCV["camSm"]){
                        $body = $body . "****** Sl Protegido ******" . chr(10);
                        $body = $body . "SL: %" . $resCV["porSm"] . " precio: " . $resCV["impSm"] . chr(10);
                        $body = $body . "TP: %" . $resCV["porTp"] . " precio: " . $resCV["impTp"] . chr(10);
                    }else{
                        $body = $body . " ****** Sl Pérdida ******" . chr(10);
                        $body = $body . "SL: %" . $resCV["porSm"] . " precio: " . $resCV["impSm"] . chr(10);    
                        $body = $body . "TP: %" . $resCV["porTp"] . " precio: " . $resCV["impTp"] . chr(10);                
                    }
                }
                $body = $body . "balance diponible al final: " . $resCV["enBal"] . chr(10);
            }else{
                $body = $body . "<b>**** " . $valret["accion"] . " cancelada" .  " ****</b>" . chr(10);  
            }
        }
        */
    
        $disable_web_page_preview = true;
        $reply_to_message_id = false;
        $reply_markup = null;
        $parse_mode = "HTML";  
/*
        $data = array(
            'chat_id' => urlencode($token),
            'text' => $body,
            'disable_web_page_preview' => urlencode($disable_web_page_preview),
            'reply_to_message_id' => urlencode($reply_to_message_id),
            'reply_markup' => urlencode($reply_markup),
            'parse_mode' => urlencode($parse_mode)            
        );
        $con = $this->createTrdTelegramAsync($data); 
           */  
    
        for ($i = 0; $i < count($tokenall); $i++) {
            $data = array(
                'chat_id' => urlencode($tokenall[$i]),
                'text' => $body,
                'disable_web_page_preview' => urlencode($disable_web_page_preview),
                'reply_to_message_id' => urlencode($reply_to_message_id),
                'reply_markup' => urlencode($reply_markup),
                'parse_mode' => urlencode($parse_mode)            
            );
            $con = $this->createTrdTelegramAsync($data);  
        }  
      
    }



    private function calcVariaOrg($CV, $statusTp = 'NEW', $statusSm = 'NEW'){
        $priceNow = $this->getPrice();
        $respocal = true;
        if ($priceNow > 0) {  
            if($CV === 1){ //Compras
                //SI EL PRECIO ES>= PRECIO DE ENTRADA + 0,5% CAMBIA EL SL DE -0,5% A PRECIO DE ENTRADA (FILTRO PROTECCION DE SL)
                //CAMBIO A 1% EL 27/12/2023
                $preOpe = number_format(round($this->maOrderPrice +  (($this->maOrderPrice * 1) / 100),3), 3, '.', ',');
                if($priceNow  >= $preOpe){
                    $this->retval['camSm'] = true;
                    print(' Compras - priceNow:' . $priceNow . ' preOpe:' . $preOpe .chr(10)); 
                    $respDel = $this->delAllOrders(false);
                    var_dump('>>>>>>>>respuesta delAllOrders:' . $respDel);
                    if($respDel){
                        sleep(5);
                        $respTp = $this->createTpOrder();
                        var_dump('>>>>>>>>respuesta createTpOrder' . $respTp);
                        if($respTp){
                            $this->slorder['stopPrice'] = $this->maOrderPrice;
                            $this->slorder['newClientOrderId'] = uniqid() . 'SLC';
                            $respSl = $this->createSlOrder();
                            var_dump('>>>>>>>>respuesta createSlOrder' . $respSl);
                            if($respSl){
                                $this->apiTelegram->sendAlertTelegram("Cambia precio de Sl en Compras a $this->maOrderPrice");
                                $this->retval["porSm"] = 1.0;
                                $this->retval['impSm'] = $this->maOrderPrice;
                                $this->printLog(" Comp.- preOpe:" . $preOpe . chr(10)); 
                            }else{
                                $this->apiTelegram->sendAlertTelegram("Not Create SL Order on protected Sl");
                                $this->delAllOrders(true);
                                $this->retval['doit'] = 0;
                                $respocal = false;
                            }
                        }else{
                            $this->apiTelegram->sendAlertTelegram("Not Create TP Order on protected Sl");
                            $this->delAllOrders(true);
                            $this->retval['doit'] = 0;
                            $respocal = false;
                        }
                    }
                    /*
                    $respSl = $this->createSlOrderPro();
                    var_dump('****** respuesta de vuelta de createSlOrder *****');
                    var_dump($respSl);
                    if($respSl){

                        $resp = $this->delOneOrder($delslOrderId );
                        var_dump('****** respuesta de vuelta de delOneOrder *****');
                        var_dump($resp);
    
                        if ($resp){
                            $this->printLog(" Eliminada slOrderId:" . $delslOrderId  . chr(10)); 
                            $this->printLog(" Nueva slOrderId:" . $this->slOrderId  . chr(10)); 
                            $this->apiTelegram->sendAlertTelegram("Cambia precio de Sl en Compras a $this->maOrderPrice");
                            $this->retval["porSm"] = 1.0;
                            $this->retval['camSm'] = true;
                            $this->retval['impSm'] = $this->maOrderPrice;
                            $this->printLog(" Comp.- preOpe:" . $preOpe . chr(10)); 
                            $camSm = true;
                        }
                    }else{
                        $this->retval['camSm'] = false;
                        $this->apiTelegram->sendAlertTelegram("No es posible cambiar precio de Sl en Compras a $this->maOrderPrice");                                
                    }
*/
                }
            }else{ //Ventas
                //SI EL PRECIO ES<= PRECIO DE ENTRADA - 0,5% CAMBIA EL SL DE +0,5% A PRECIO DE ENTRADA (FILTRO PROTECCION DE SL)
                //CAMBIO A 1% EL 27/12/2023
                $preOpe = number_format(round($this->maOrderPrice -  (($this->maOrderPrice * 1) / 100),3), 3, '.', ',');
                if($priceNow  <= $preOpe){
                    $this->retval['camSm'] = true;
                    print(' Ventas - priceNow:' . $priceNow . ' preOpe:' . $preOpe .chr(10)); 
                    $respDel = $this->delAllOrders(false);
                    var_dump('>>>>>>>>respuesta delAllOrders:' . $respDel);
                    if($respDel){
                        sleep(5);
                        $respTp = $this->createTpOrder();
                        var_dump('>>>>>>>>respuesta createTpOrder' . $respTp);
                        if($respTp){
                            $this->slorder['stopPrice'] = $this->maOrderPrice;
                            $this->slorder['newClientOrderId'] = uniqid() . 'SLC';
                            $respSl = $this->createSlOrder();
                            var_dump('>>>>>>>>respuesta createSlOrder' . $respSl);
                            if($respSl){
                                $this->apiTelegram->sendAlertTelegram("Cambia precio de Sl en Ventas a $this->maOrderPrice");
                                $this->retval["porSm"] = 1.0;
                                $this->retval['impSm'] = $this->maOrderPrice;
                                $this->printLog(" Comp.- preOpe:" . $preOpe . chr(10)); 
                            }else{
                                $this->apiTelegram->sendAlertTelegram("Not Create SL Order on protected Sl");
                                $this->delAllOrders(true);
                                $this->retval['doit'] = 0;
                                $respocal = false;
                            }
                        }else{
                            $this->apiTelegram->sendAlertTelegram("Not Create TP Order on protected Sl");
                            $this->delAllOrders(true);
                            $this->retval['doit'] = 0;
                            $respocal = false;
                        }
                    }
                }
/*
                    print(' Ventas - priceNow:' . $priceNow . ' preOpe:' . $preOpe .chr(10)); 
                    $delslOrderId = $this->slOrderId;
                    $this->slorder['stopPrice'] = $this->maOrderPrice; //quitar
                    $this->slorder['newClientOrderId'] = str_replace("SL", "SLC", $this->slorder['newClientOrderId']);
                    $respSl = $this->createSlOrder();
                    if($respSl){
                        $resp = $this->delOneOrder($delslOrderId );
                        if ($resp){
                            $this->printLog(" Eliminada slOrderId:" . $this->slOrderId  . chr(10)); 
                            $this->printLog(" Nueva slOrderId:" . $this->slOrderId  . chr(10)); 
                            $this->apiTelegram->sendAlertTelegram("Cambia precio de Sl en Ventas a $this->maOrderPrice");
                            $this->retval["porSm"] = 1.0;
                            $this->retval['camSm'] = true;
                            $this->retval['impSm'] = $this->maOrderPrice;
                            $this->printLog(" Comp.- preOpe:" . $preOpe . chr(10)); 
                            $camSm = true;
                        }
                    }else{
                        $this->retval['camSm'] = false;
                        $this->sendAlertTelegram("No es posible cambiar precio de Sl en Ventas a $this->maOrderPrice");                                
                    }
                }  */                                           
            }
        }
        //return $this->retval['camSm'];
        $respocal = true;
    }