<?php
namespace App;
use App\PivotCalculator;
use App\ATRCalculator;
class TrendCalculator
{
    /**
     * @var atrCalculator
     */
    protected $config;  
 
    public function __construct()
    {
        require_once __DIR__ . '/Settings.php';
        $params = new Settings();
        $config = $params->settings['config'];        
        $this->config = $config;
    }

    public function getPivotClassic($highs, $lows, $closes, $idx){
        $pivResp = [];
        $ppcal = [];
        $pplh = [];
        $factor = 3;
        $pd = 14;
    
        for ($x = 1; $x <= $idx; $x++) {
            $pp = round((($highs[$x-1] + $closes[$x-1] + $lows[$x-1]) / 3), 3);
            $range = round(($highs[$x-1] - $lows[$x-1]),3);
            $ppcal = [
                'r1' => round(($pp * 2) - $lows[$x-1],3),
                'r2' => round($pp + $range,3),
                'r3' => round(($pp + ($range * 2)),3),
                'r4' => round(($pp + ($range * 3)),3),
                's1' => round((($pp * 2) - $highs[$x-1]), 3),
                's2' => round($pp - $range,3),
                's3' => round(($pp - ($range * 2)),3),
                's4' => round(($pp - ($range * 3)),3),
            ];
            $pplh[] = $pp;
            $pivResp[] = $ppcal;
        }
        $pivotCalculator = new PivotCalculator(5,5);
        $pivots_low = $pivotCalculator->pivot($pplh,  'low',5,5);
        $pivots_high = $pivotCalculator->pivot($pplh, 'high',5,5);
        $bands = $pivotCalculator->calculate_bands($pivots_high, $pivots_low, $factor, $pd, $highs, $lows, $closes);
        $ntrend = $this->calcTrend($pivots_low, $pivots_high);
        $idl = $this->array_key_last($pivResp);
        $idb = $this->array_key_last($bands[0]);
        // ATR
        $this->atrCalculator = new ATRCalculator($pd);
        $atr = $this->atrCalculator->update($highs, $lows, $closes);
        $iat = $this->array_key_last($atr);
        $dsupo = $this->array_key_last($bands[0]);
        $dresi = $this->array_key_last($bands[1]);
        $dtren = $this->array_key_last($bands[2]);
        $dtrai = $this->array_key_last($bands[3]);  
        $resp = [
            'r1' => $pivResp[$idl]['r1'],
            's1' => $pivResp[$idl]['s1'],
            'supo' => $bands[0][$dsupo],
            'resi' => $bands[1][$dresi],
            'tren' => $ntrend, //$bands[2][$dtren],
            'trai' => $bands[3][$dtrai],  
            'atr'  => $atr[$iat]       
        ];
        return $resp;
    }
    private function calcTrend($pivots_low, $pivots_high){
        $pplow = [];
        $pphigh = [];
        $dlow = $this->array_key_last($pivots_low);
        $hlow = $this->array_key_first($pivots_low);
        for ($x = $dlow; $x >= $hlow; $x--) {
            if($pivots_low[$x] > 0){
                $pplow[] = $pivots_low[$x];
            }
        }
        // calcula la tendencia de lows
        $totlow = 0;
        $dlow = $this->array_key_first($pplow);
        $hlow = $this->array_key_last($pplow);
        if($pplow[0] > $pplow[1]){        
            $trendlow = 'up';
        }elseif($pplow[0] < $pplow[1]){
            $trendlow = 'do';
        }else{
            $trendlow = 'ho';
        }
        
        /*
        $tr = [];
        for ($x = $dlow; $x < $hlow; $x++) {
            if($pplow[$x] > $pplow[$x+1]){
                $tr[] = 1;
            }else{
                $tr[] = -1;
            }
        }
        if($tr[0] === 1 and $tr[1] === 1){        
            $trendlow = 'up';
        }elseif($tr[0] === -1 and $tr[1] === -1){
            $trendlow = 'do';
        }else{
            $trendlow = 'ho';
        }
        */
        $dhigh = $this->array_key_last($pivots_high);
        $hhigh = $this->array_key_first($pivots_high);
        for ($x = $dhigh; $x >= $hhigh; $x--) {
            if($pivots_high[$x] > 0){
                $pphigh[] = $pivots_high[$x];
            }
        }
        // calcula la tendencia de highs

        $tothigh = 0;
        $dhigh = $this->array_key_first($pphigh);
        $hhigh = $this->array_key_last($pphigh);
        if($pphigh[0] > $pphigh[1]){        
            $trendhigh = 'up';
        }elseif($pphigh[0] < $pphigh[1]){
            $trendhigh = 'do';
        }else{
            $trendhigh = 'ho';
        }
        /*
        $tr = [];
        for ($x = $dhigh; $x < $hhigh; $x++) {
            if($pphigh[$x] > $pphigh[$x+1]){
                $tr[] = 1;
            }else{
                $tr[] = -1;
            }
        } 
        if($tr[0] === 1 and $tr[1] === 1){        
            $trendhigh = 'up';
        }elseif($tr[0] === -1 and $tr[1] === -1){
            $trendhigh = 'do';
        }else{
            $trendhigh = 'ho';
        }
        */
        if($trendlow === "up" and $trendhigh === "up"){
            $trend = 'up';
        }elseif($trendlow === "do" and $trendhigh === "do"){
            $trend = 'do';
        }else{
            $trend = 'ho';
        }
        print("trendlo:{$trendlow} trendhi:{$trendhigh} trend:{$trend} ");
        return $trend;
    }
    private function array_key_last(array $arr) {
        $i = 0;
        foreach($arr as $key  => $unused) {
            $i = $i +1;
            //return $key;
        }
        return $key;
    }
    private function array_key_first(array $arr) {
        foreach($arr as $key => $unused) {
            return $key;
        }
        return NULL;
    }    
    private function printLog($from){
        $date = (new \DateTime('now'))->format('Y-m-d H:i:s');
        print( "Now: " . $date . "|" . $from );
    }

}