<?php
namespace App;

class Trader {
    /**
     * Calcula el MACD (Moving Average Convergence Divergence).
     *
     * @param array $prices Array de precios.
     * @param int $fastPeriod Período rápido.
     * @param int $slowPeriod Período lento.
     * @param int $signalPeriod Período de señal.
     * @return array|false Retorna un array con los valores MACD, Signal y Histograma o false en caso de error.
     */
    public static function MACD(array $prices, int $fastPeriod = 12, int $slowPeriod = 26, int $signalPeriod = 9) {
        if (!function_exists('trader_macd')) {
            return false;
        }
        return trader_macd($prices, $fastPeriod, $slowPeriod, $signalPeriod);
    }

    /**
     * Calcula el RSI (Relative Strength Index).
     *
     * @param array $prices Array de precios.
     * @param int $timePeriod Período de tiempo.
     * @return array|false Retorna un array con los valores RSI o false en caso de error.
     */
    public static function RSI(array $prices, int $timePeriod = 14) {
        if (!function_exists('trader_rsi')) {
            return false;
        }
        return trader_rsi($prices, $timePeriod);
    }

    /**
     * Calcula el ATR (Average True Range).
     *
     * @param array $high Array de precios máximos.
     * @param array $low Array de precios mínimos.
     * @param array $close Array de precios de cierre.
     * @param int $timePeriod Período de tiempo.
     * @return array|false Retorna un array con los valores ATR o false en caso de error.
     */
    public static function ATR(array $high, array $low, array $close, int $timePeriod = 14) {
        if (!function_exists('trader_atr')) {
            return false;
        }
        return trader_atr($high, $low, $close, $timePeriod);
    }

    /**
     * Calcula el EMA (Exponential Moving Average).
     *
     * @param array $prices Array de precios.
     * @param int $timePeriod Período de tiempo.
     * @return array|false Retorna un array con los valores EMA o false en caso de error.
     */
    public static function EMA(array $prices, int $timePeriod = 14) {
        if (!function_exists('trader_ema')) {
            return false;
        }
        return trader_ema($prices, $timePeriod);
    }

    /**
     * Calcula el SMA (Simple Moving Average).
     *
     * @param array $prices Array de precios.
     * @param int $timePeriod Período de tiempo.
     * @return array|false Retorna un array con los valores SMA o false en caso de error.
     */
    public static function SMA(array $prices, int $timePeriod = 14) {
        if (!function_exists('trader_sma')) {
            return false;
        }
        return trader_sma($prices, $timePeriod);
    }
    
    /**
     * Calcula la Desviación Estándar.
     *
     * @param array $prices Array de datos.
     * @param int $timePeriod Período de tiempo.
     * @param float $nbDev Número de desviaciones estándar (por defecto: 1.0).
     * @return array|false Retorna un array con los valores de desviación estándar o false en caso de error.
     */
    public static function STDDEV(array $prices, int $timePeriod = 14, float $nbDev = 1.0) {
        if (!function_exists('trader_stddev')) {
            return false;
        }
        return trader_stddev($prices, $timePeriod, $nbDev);
    }    
}
