<?php
namespace App;
use App\ResponseApi;
use App\SendTelegram;
use App\Alerts;
use App\gesSnifer;
use App\CancelPosition;
include  'OrdersModel.php';
class SetOrdersBuySel
{
    /**
     * @var ResponseApi
     */
    protected $apiResponse;
    /**
     * @var SendTelegram
     */
     protected $apiTelegram;
    /**
     * @var Alerts
     */
    protected $apiAlerts;
    /**
     * @var gesSnifer
     */
    protected $gesSnifer;
    /**
     * @var cancelPosition
     */
    protected $cancelPosition;    
    /**
     * @var OneMaOrder
     */
    protected $oneMaOrder;
    protected $maOrderId;

    protected $oneTpOrder;
    protected $tpOrderId;
    protected $oneSlOrder;
    protected $slOrderId;
    protected $avaBalance;
    protected $maOrderPrice;
    protected $currentPrice;
    protected $orderQty;
    protected $orderLev;
    protected $maSide;
    protected $otSide;
    protected $symbol = '';
    protected $currency = '';
    protected $status;
    protected $balance;  
    protected $leverage;    
    protected $porIni = [];
    protected $done = true;
    protected $microt = 0;
    protected $initialm = 0;
    protected $breakevenprice = 0;
    protected $inact = 0;
    protected $prorder; 
    protected $tokentel;
    protected $ISTP = 0;
    protected $snifer = false;
    protected $retval = [
        "price" => 0,
        "avBal" => 0,    
        "qty" => 0,
        "porLe" => 2,
        "porAv" => 0,
        "porTp"  => 0,
        "porSm"  => 0,
        "impTp" => 0,
        "impSm" => 0,
        "camSm" => false,
        "doit" => 0,
        "delor" => 0,
        "enBal" => 0,
        "tpSta" => '',
        "slSta" => '',
        "Tp" => false,
        "Sm" => false,
        'cierre' => ''
    ];
    /**
     * @var OneMaOrder $marorder
     */
    protected $maorder;
    /**
     * @var OneTpOrder $tporder
     */
    protected $tporder;
    /**
     * @var OneSlOrder $slorder
     */
    protected $slorder; 
    /**
     * @var OneSlOrder $prorder
     */
    public function __construct()
    {
        require_once __DIR__ . '/Settings.php';
        $params = new Settings();
        $config = $params->settings['config'];
        $this->apiResponse = new ResponseApi();
        $this->apiTelegram = new SendTelegram();
        $this->apiAlert = new Alerts(); 
        $this->gesSnifer = new gesSnifer("closeposrsimac");   
        $this->cancelPosition = new CancelPosition();   
        $this->ISTP = $config['istp'];   
        $this->snifer = $config['snifer'];     
     }
     private function getOrderById($orderId){
        $times = 0;
        $price = 0;
        while(true){
            $result = $this->apiResponse->getOrderById(['symbol' => $this->symbol, 'orderId' => $orderId], $times, 'fapi/v1/order');
            if (array_key_exists('avgPrice', $result)) {
                $price = $result['avgPrice']; 
                break;
            }else{
                $times = $times + 1;
                if ($times > 5){
                    $price = 0; 
                    break;
                }
            }            
        } 
        return $price;       
     }  
    private function createMaOrder(){
        $times = 0;
        while(true){

            $result = $this->apiResponse->createOrder($this->maorder, $times);
            if (array_key_exists("orderId", $result)) {
                $this->maOrderId = $result['orderId'];
                sleep(5);
                $price = $this->getOrderById($this->maOrderId);
                if($price > 0){
                    $this->retval['doit'] = 1;   
                    $this->retval['price'] = $price; 
                }else{
                    $this->retval['doit'] = 0;   
                    $this->retval['price'] = 0; 
                }
                break;
            }else{
                $times = $times + 1;
                if (array_key_exists("code", $result)) {
                    if($result['code'] === -2019 or $result['code'] === -2022  or $result['code'] === -1102){
                        if($this->maorder['quantity'] <= 0.8){
                            $this->sendAlert(6, 'FALSE', 'FALSE');
                            $this->retval['doit'] = 0;   
                            $this->retval['price'] = 0;
                            break;
                        }else{
                            //$this->apiTelegram->sendAlertTelegram("Margen insuficiente para esta cantidad:{$this->maorder['quantity']}");
                            $this->maorder['quantity'] = round($this->maorder['quantity'] - 0.1, 1);
                            $this->orderQty = $this->maorder['quantity'];
                            $this->setQty();
                            $this->printLog('crear maorder - update qty:' . $this->maorder['quantity'] . chr(10));
                            //break;
                        }
                    }else{
                        if ($times > 5){
                            $this->printLog('error - crear maorder' .chr(10));
                            $this->sendAlert(3, 'FALSE', 'FALSE');
                            $this->retval['doit'] = 0;   
                            $this->retval['price'] = 0; 
                            break;
                        }
                    }
                }else{
                    if ($times > 5){
                        $this->printLog('error - crear maorder' .chr(10));
                        $this->sendAlert(3, 'FALSE', 'FALSE');
                        $this->retval['doit'] = 0;   
                        $this->retval['price'] = 0; 
                        break;
                    }

                }

            }
        }
        return $this->retval;
     }
     private function createTpOrder($CV){
        $times = 0;
        $resp = false;
        while(true){
            $result = $this->apiResponse->createOrder($this->tporder, $times);
            if (array_key_exists("orderId", $result)) {
                $this->tpOrderId = $result['orderId'];
                $resp = true;
                break;
            }else{
                $times = $times + 1;
                if (array_key_exists("code", $result)) {
                    if($result['code'] === -2021){
                        $this->tporder['stopPrice'] = round($this->tporder['stopPrice'] + 0.01,3);
                        if ($times > 5){
                            $resp = false;
                            break;
                        }  
                    }else{
                        if ($times > 5){
                            $resp = false;
                            break;
                        }                        
                    }
                }else{
                    if ($times > 5){
                        $resp = false;
                        break;
                    }
                }

            }
        }
        return $resp;
     }
     private function createSlOrder($CV){
        $times = 0;
        $resp = false;
        while(true){
            $result = $this->apiResponse->createOrder($this->slorder, $times);
            if (array_key_exists("orderId", $result)) {
                $this->slOrderId = $result['orderId'];
                $resp = true;
                break;
            }else{
                $times = $times + 1;
                if (array_key_exists("code", $result)) {
                    if($result['code'] === -2021){
                        $this->slorder['stopPrice'] =  round($this->slorder['stopPrice'] - 0.01, 3);
                        if ($times > 3){
                            $resp = false;
                            break;
                        } 
                    }else{
                        if ($times > 5){
                            $resp = false;
                            break;
                        }                        
                    }
                }else{
                    if ($times > 5){
                        $resp = false;
                        break;
                    }
                }
            }
        }
        return $resp;
     }
     private function getOrderStatusMa(){
        $times = 0;
        $status = 0;
        while(true){
            $result = $this->apiResponse->getStatus(['symbol' => $this->symbol], $times);
            if (array_key_exists("positions", $result)) {
                foreach($result['positions'] as $posit)  {
                    if($posit['symbol'] === $this->symbol){
                        if(floatval($posit['initialMargin']) > 0){
                            $status = 1;
                        }        
                    }
                }
                break;
            }else{
                $times = $times + 1;
                if ($times > 5){
                    $status = 1;
                    break;
                }
            }
        }
        return $status;      
     }
     private function getOrderStatusTp(){
        $times = 0;
        $status= 'NEW';
        while(true){
            $result = $this->apiResponse->getOrderById(['symbol' => $this->symbol, 'orderId' =>$this->tpOrderId], $times);
            if (array_key_exists("status", $result)) {
                $status = $result['status'];
                break;
            }else{
                $times = $times + 1;
                if ($times > 5){
                    $status= "FALSE";
                    break;
                }
            }
        }
        return $status;
     }
     private function getOrderStatusSl(){
        $times = 0;
        $status= 'NEW';
        while(true){
            $result = $this->apiResponse->getOrderById(['symbol' => $this->symbol, 'orderId' =>$this->slOrderId], $times);
            if (array_key_exists("status", $result)) {
                $status = $result['status'];
                break;
            }else{
                $times = $times + 1;
                if ($times > 5){
                    $status= "FALSE";
                    break;
                }
            }
        }
        return $status;
    }
  
    private function cntrOrders($CV){ //WebSocket
        $this->printLog("in cntlOrdersWs" .chr(10));
        $resp = false;
        $wsparams["pingInterval"] = 1800;
        $wsparams['maeprice'] = $this->maOrderPrice;
        $wsparams['maorder'] = $this->maorder;
        $wsparams['countup'] = 1800;
        $wsparams['slp'] = false;
        $wsparams['isprice'] = false;
        $wsparams['symbol'] = $this->symbol;
        $wsparams['CV'] = $CV;  
        $wsparams['inact'] = $this->inact;         
        $wsparams['breakevenprice'] = $this->breakevenprice; 
        $resp = $this->apiResponse->getWebSocket(['connectId' => uniqid('', true)], $wsparams);
        if($resp['istp']){
            $this->retval['Tp'] = true;
            $this->retval['Sm'] = false; 
            //$this->setLastLeverage(1);                   
        }else{
            $this->retval['Sm'] = true;                      
            $this->retval['Tp'] = false;        
        }
        if($resp['statusma'] !== 0){
            $statusLi = $this->getOrderStatusMa();
        }else{
            $statusLi = $resp['statusma'];
        }
        //$statusLi = $this->getOrderStatusMa();
        $statusTp = $resp['resulttp'];
        $statusSm = $resp['resultsl'];
        $this->retval['tpSta'] = $statusTp;
        $this->retval['slSta'] = $statusSm;
        //$this->printLog("now:".  date("Y-m-d H:i:s") . " 4.-B statusTp:" . $statusTp . " statusSm:" . $statusSm . " statusLi:" . $statusLi . chr(10));  
        $resp = $this->delMaOrder($this->maorder, true);     
        if($statusTp ===  'FILLED' or $statusTp === "EXPIRED" or $statusSm === "FILLED" or $statusSm === "EXPIRED"){ 
            $this->printLog(" 4.- statusTp:" . $statusTp . " statusSm:" . $statusSm . " statusLi:" . $statusLi . chr(10));
            $statusLi = $this->getOrderStatusMa(); //ojo q pasa
            if($statusLi !== 0){
                $this->delMaOrder($this->maorder, false);
            } 
        }elseif($statusTp === "CANCELED" and $statusSm === "CANCELED"){ 
            $this->printLog(" 5.KO- statusTp:" . $statusTp . " statusSm:" . $statusSm . chr(10));
            if($statusLi === 0){
                $this->sendAlert(0, $statusTp, $statusSm);
            }else{
                $this->delMaOrder($this->maorder, false);
                $this->sendAlert(1, $statusTp, $statusSm);
            }                 
        }elseif($statusTp === "FALSE" or $statusSm === "FALSE"){
            $this->printLog("SL 2.- statusTp:" . $statusTp . " statusSm:" . $statusSm . chr(10));
            if($statusLi === 0){
                $this->sendAlert(0, $statusTp, $statusSm);
            }else{
                $this->delMaOrder($this->maorder, false);
                $this->sendAlert(1, $statusTp, $statusSm);             
            }  
        }    
        $this->retval['doit'] = 1;
        return $this->retval['doit'];
    }
    private function sendAlert($type, $statusTp, $statusSm){
        $tokentel = $this->apiAlert->getAlerts($type,$statusTp,$statusSm);
        $this->apiTelegram->sendAlertTelegram($tokentel);
    }
    private function getStopOrder(){
        $times = 0;
        $allget = false;
        while(true){
            $result = $this->apiResponse->getStopOrder(['symbol' => $this->symbol],$times);
            if (array_key_exists("items", $result)) {
                if(count($result["items"]) > 0){
                    $allget = true;
                }
                break;
            }else{
                $times = $times + 1;
                if ($times > 5){
                    $allget = false;
                    break;
                } 
            }
        }
        return $allget;
    } 
    private function delMaOrder($maorder, $init=true){
        $resp = $this->cancelPosition->closePosition($maorder, true);
        $this->printLog('Respuesta en delMaorder:' .$resp . chr(10));
    }

    private function getPrice(){
        $times = 0;
        while(true){
            $result = $this->apiResponse->getPrice(['symbol' => $this->symbol], $times);
            if (array_key_exists("price", $result)) {
                $this->currentPrice = $result["price"];
                break;
            }else{
                $times = $times + 1;
                if ($times > 5){
                    $this->currentPrice = 0; 
                    break;
                }
            }
        } 
        return $this->currentPrice;              
    }  
    private function setLastLeverage($leverage){
        $times = 0;
        $leverage = 1;
        while(true){
            $result = $this->apiResponse->setLeverage(['symbol' => $this->symbol,'leverage' =>  $leverage], $times);
            if (array_key_exists("leverage", $result)) {
                //$this->printLog('new leverage:' . $result['leverage'] .chr(10));
                break;
            }else{
                $times = $times + 1;
                if ($times > 5){
                    $leverage = 1;
                    break;
                }
            }
        }
    }
    
    private function getLastLeverage($symbol){
        return $this->leverage;
    }
    private function printLog($from){
        $date = (new \DateTime('now'))->format('Y-m-d H:i:s');
        print( $date . ": " . $from );
    }
    private function setQty(){
        $this->maorder['quantity'] = $this->orderQty;
        //$this->tporder['quantity'] = $this->orderQty;
        //$this->slorder['quantity'] = $this->orderQty;
        //$this->prorder['quantity'] = $this->orderQty;
        $this->retval['qty'] = $this->orderQty;
    }
    private function setLev(){
        //$this->maorder['leverage'] = $this->orderLev;
        //$this->tporder['leverage'] = $this->orderLev;
        //$this->slorder['leverage'] = $this->orderLev;
        $this->retval['porLe'] = $this->orderLev;
    }  
    private function setSide($CV){
        if($CV  === 1){
            $maside = 'BUY';
            $otside = 'SELL';
        }elseif($CV  === 2){
            $maside = 'SELL';
            $otside = 'BUY';
        }
        $this->maorder['side'] = $maside;
        $this->tporder['side'] = $otside;
        $this->slorder['side'] = $otside;
        $this->prorder['side'] = $otside;        
        $this->maSide = $maside;
        $this->otSide = $otside;
        $this->retval['cierre'] = $otside === 'BUY'?'compra':'venta';
    }  
    private function setStopPrice($CV,$price){
        if($CV === 1){
            $this->tporder['stopPrice'] = round($price +  (($price * $this->porIni['porTp']) / 100),3);
            $this->slorder['stopPrice'] = round($price -  (($price * $this->porIni['porSm']) / 100),3);
        }else{
            $this->tporder['stopPrice'] = round($price -  (($price * $this->porIni['porTp']) / 100),3);
            $this->slorder['stopPrice'] = round($price +  (($price * $this->porIni['porSm']) / 100),3); 
        }
        $this->prorder['stopPrice'] = $price;
        $this->retval['porAv'] = $this->porIni['porAv'];
        $this->retval['porTp'] = $this->porIni['porTp'];
        $this->retval['porSm'] = $this->porIni['porSm'];
        $this->retval['impTp'] = $this->tporder['stopPrice'];
        $this->retval['impSm'] = $this->slorder['stopPrice'];
        //$this->printLog('impMa:'. $price . chr(10));
        //$this->printLog('impTp:'. $this->tporder['stopPrice'] . chr(10));
        //$this->printLog('impSm:'. $this->slorder['stopPrice'] . chr(10));
    }     
    public function getStatus(){
        $result = $this->getAccount($this->symbol, $this->currency);
        return $this->status;    
    }
    public function getAccount($symbol, $currency){
        $this->status = 0;
        $this->balance = 0;
        $this->leverage = 0;
        $this->initialm  = 0;
        $this->breakevenprice = 0;
        $times = 0;
        while(true){
            $result = $this->apiResponse->getAccount(['symbol' => $this->symbol], $times);
            if ($result === null) {
                return ['status' => 1, 'balance' => 0, 'leverage' => 0, 'initialm' => 0, 'breakevenprice' => 0];

            }
            if (array_key_exists("totalInitialMargin", $result)) {
                $positions = $result['positions'];
                $assets = $result['assets'];
                $this->balance  = floatval($result['availableBalance']);
                foreach($positions as $posit)  {
                    if($posit['symbol'] === $symbol){
                        if(floatval($posit['initialMargin']) > 0){
                            $this->status = 1;
                        }
                        $this->leverage  = intval($posit['leverage']);
                        $this->initialm = floatval($posit['initialMargin']);
                        $this->breakevenprice = $posit['breakEvenPrice'];
                        //print('apalan:' . $this->leverage .chr(10));

                    }
                }                             
                break;
            }else{
                $times = $times + 1;
                if ($times > 5){
                    $this->status = 0;
                    break;
                }
            }
        }
        return ['status' => $this->status, 'balance' => $this->balance, 'leverage' => $this->leverage, 'initialm' => $this->initialm, 'breakevenprice' => $this->breakevenprice];
    }
    public function setData($data, $CV){ 
        $order = $data['order'];
        $order['newClientOrderId'] = uniqid();
        $this->symbol = $data['symbol'];
        $this->maorder = (array) new \OneMaOrder($order);
        $this->tporder = (array) new \OneTpOrder($order);
        $this->slorder = (array) new \OneSlOrder($order);
        $this->prorder = (array) new \OneSlOrder($order); 
        $this->prorder['newClientOrderId'] = $this->prorder['newClientOrderId'] . 'C';      
        $this->currency = $data['currency'];
        $this->porIni = $data['porini'];
        $this->tokentel = $data['tokentel'];
        $this->setSide($CV);       
    }
    public function getBalanceAva(){
        if ($this->balance > 0) {
            $this->avaBalance = $this->balance;
            $this->retval['avBal'] = $this->avaBalance;
            $this->retval['enBal'] = $this->avaBalance;                
            $this->avaBalance = round(($this->avaBalance * $this->porIni['porAv']),3);
            print('avaBalance:' .$this->avaBalance . chr(10)); //quitar
            $locprice =  $this->getPrice();
            //$this->setLastLeverage(5);
            $this->orderLev = $this->leverage; //$this->getLastLeverage($this->symbol);
            if($this->orderLev === 0){
                //$this->setLastLeverage(5);
                $this->orderLev = $this->porIni['porLe'];
            }
            //$actBal = $this->avaBalance * $this->orderLev;
            if ($locprice > 0) {
                $this->orderQty = round(($this->avaBalance / $locprice),1);
                if($this->orderQty === 0){
                    $this->avaBalance = 0;
                };
                $this->orderQty = $this->orderQty * $this->orderLev;
            }else{
                $this->currentPrice = 0;
                $this->orderQty = 0;
                $this->avaBalance = 0; 
            }
        }else{
            $this->currentPrice = 0;
            $this->orderQty = 0;
            $this->avaBalance = 0; 
        }
        $this->setQty();
        $this->setLev();
        if( $this->avaBalance === 0){
            $this->sendAlert(6, false, false);
        }
        $this->retval['avBal'] = $this->avaBalance;
        return $this->avaBalance;
    }
    public function optTrade($CV){
        if($this->getStopOrder()){
            $this->delMaOrder(null, false);
        }
        $respMa = $this->createMaOrder();
        $doitli = $respMa['doit'];
        $this->retval['doit'] = 1;
        $this->microt = intval(round(microtime(true)));
        if($doitli === 1){
            $this->maOrderPrice = $respMa['price'];
            $this->setStopPrice($CV, $this->maOrderPrice);
            $respTp = $this->createTpOrder($CV);
            if($respTp){
                $respSl = $this->createSlOrder($CV);
                if($respSl){
                    $this->tokentel['init'] = 0;
                    //$this->printLog("En proceso" . chr(10));
                    $result = $this->getAccount($this->symbol, $this->currency);
                    $this->tokentel['resCV'] = $this->retval;
                    $this->apiTelegram->sendTrdTelegram($this->tokentel);
                    $this->inact = $this->tokentel['act'];
                    // ************* para llamar snifer-start start
                    if($this->snifer){
                        $sArgs = [
                            "maorder" => $this->maorder,
                            "action" => "start",
                            "inrsi" => $this->tokentel['rsi'],
                            'inact' => $this->tokentel['act'],
                            'breakevenprice' => $this->breakevenprice
                        ];
                        $this->gesSnifer->gesArgument($sArgs);
                    }
                    // ************* para llamar snifer-start end                    
                    $doit = $this->cntrOrders($CV);
                    if($doit === 1){
                        $this->tokentel['init'] = 1;
                        $this->tokentel['resCV'] = $this->retval;
                        $this->microt = intval(round(microtime(true)));  
                        $this->ISTP = $this->retval['Tp'] === true?1:0;
                        $times = 0;
                        $result = $this->getAccount($this->symbol, $this->currency); 
                        $this->tokentel['resCV']['enBal'] = round(($result['balance'] * $this->porIni['porAv']),3); 
                        //$this->tokentel['resCV']['enBal'] = round(($this->balance * $this->porIni['porAv']),3); 
                        $this->apiTelegram->sendTrdTelegram($this->tokentel);
                        // ************* para llamar snifer-kill start
                        if($this->snifer){
                            $sArgs = [
                                "maorder" => $this->maorder,
                                "action" => "kill",
                                "inrsi" => $this->tokentel['rsi'],
                                'inact' => $this->tokentel['act']
                            ];
                            $this->gesSnifer->gesArgument($sArgs);
                        }

                        //************* para llamar snifer-kill end
                    } 
                    //}
                }else{
                    $this->apiTelegram->sendAlertTelegram("No se ha podido generar orden SL");
                    $this->delMaOrder($this->maorder, true);
                    $this->retval['doit'] = 0;
                }
            }else{
                $this->apiTelegram->sendAlertTelegram("No se ha podido generar orden TP");
                $this->delMaOrder($this->maorder, true);
                $this->retval['doit'] = 0;
            }
        }else{
            $this->sendAlert(3, false, false);
            $this->retval['doit'] = 0;
            $doitli = 0;
        }
        //return $this->retval['doit'];
        return $this->microt; // para calcular el sleepen indexbi
    }
    public function sendAlertOut($type, $statusTp, $statusSm){
        $tokentel = $this->apiAlert->getAlerts($type,$statusTp,$statusSm);
        $this->apiTelegram->sendAlertTelegram($tokentel);
    }
    public function getISTP(){
        return $this->ISTP;
    }
}