<?php
namespace App;
use App\ValidResponse;
use GuzzleHttp\Client;
use App\TelegramTemplate;
class SendTelegram
{
    /**
     * @var TelegramTemplate
     */
    protected $telegramTempl;
    protected $configl = [];
    protected $conftel = [ 
        //'base_uri' => 'https://api.telegram.org/bot6790494013:AAGVCyUCLOc1fJNPofONFZjo4UBYgckjlTo/', //AliNesTradebot
        //'base_uri' => 'https://api.telegram.org/bot7820191435:AAHpAbA724C5sx4EsMCKOtwXIV0BzJ7oqO0/', //IlNostroCommercio
        'base_uri' => '',
        'timeout' => 30,
        'connect_timeout' => 30,
        'http_errors'     => false,
        'verify'          => 1,
        'skipVerifyTls' => false
    ];

    public function __construct()
    {
        require_once __DIR__ . '/Settings.php';
        $params = new Settings();
        $this->configl = $params->settings['config'];
        $this->telegramTempl = new TelegramTemplate();
        $this->conftel['base_uri'] = $this->configl['telsock'];
    }
    private function getClient(array $config)
    {
        $key = md5(json_encode($config));

        if (isset($clients[$key])) {
            return $clients[$key];
        }
        $clients[$key] = new Client($this->conftel);
        return $clients[$key];
    }
    public function sendAlertTelegram($valret, $telusers=null)
    {
        $body = $this->telegramTempl->getTemplateAlert($valret); 
        $telusers = $telusers ?? $this->configl['telusers'];  
        $tokenall = $telusers;   
        $disable_web_page_preview = true;
        $reply_to_message_id = false;
        $reply_markup = null;
        $parse_mode = "HTML";  
        for ($i = 0; $i < count($tokenall); $i++) {
            $data = array(
                'chat_id' => urlencode($tokenall[$i]),
                'text' => $body,
                'disable_web_page_preview' => urlencode($disable_web_page_preview),
                'reply_to_message_id' => urlencode($reply_to_message_id),
                'reply_markup' => urlencode($reply_markup),
                'parse_mode' => urlencode($parse_mode)            
            );
            $con = $this->createTrdTelegramAsync($data);  
        }  
    }

    public function sendTrdTelegram($valret)
    {
        $body = $this->telegramTempl->getTemplateOrder($valret); 
        $tokenall = $this->configl['telusers'];   
        $disable_web_page_preview = true;
        $reply_to_message_id = false;
        $reply_markup = null;
        $parse_mode = "HTML";  
        for ($i = 0; $i < count($tokenall); $i++) {
            $data = array(
                'chat_id' => urlencode($tokenall[$i]),
                'text' => $body,
                'disable_web_page_preview' => urlencode($disable_web_page_preview),
                'reply_to_message_id' => urlencode($reply_to_message_id),
                'reply_markup' => urlencode($reply_markup),
                'parse_mode' => urlencode($parse_mode)            
            );
            $con = $this->createTrdTelegramAsync($data);  
        }  
      
    }
    public function createTrdTelegramAsync($data){
        try {
            $client = $this->getClient($this->conftel);
            $result = $client->request(
                'POST',
                'sendMessage',
                [
                    'headers' => ['Content-Type' => 'application/json'],
                    'query' => $data
                ]
            );
            return $result; 
        } catch (HttpException $e) {
            var_dump($e->getMessage());
            return $e->getMessage();
        } catch (BusinessException $e) {
            var_dump($e->getMessage());
            return $e->getMessage();
        }  
    }      
}