<?php
namespace App;
use App\RsiCalculator;
use App\CancelPosition;
use App\ApiPositionRes;
use App\TrendCalculator;
class RsiMacdClosePos
{ 
    /**
    * @var ResponseApi
    */
    protected $apiResponse; 
    /**
    * @var ResponseApi
    */
    protected $rsiCalculator; 
    /**
    * @var CancelPosition
    */
    /**
     * @var trendCalculator
     */
    protected $trendCalculator;        
    protected $cancelPosition; 
    protected $symbol = 'DOTUSDT';
    protected $currency = 'USDT';
    protected $interval = "15m";
    protected $localconf;
    public function __construct()
    {
        require_once __DIR__ . '/Settings.php';
        $params = new Settings();
        $configl = $params->settings['config'];
        $this->interval = $configl['interval'];
        $this->rsiCalculator = new RsiCalculator();
        $this->cancelPosition = new CancelPosition();
        $this->apiResponse = new ApiPositionRes();
        $this->trendCalculator = new TrendCalculator();
    }
    private function getTimeToSleep($microt, $intervalo){
        $sleep = 60;
        $date = (new \DateTime(date('m/d/Y H:i:s',$microt)));
        $date->setTimeZone(new \DateTimeZone("Europe/Lisbon"));
        $h = ($date)->format('H');
        $m = ($date)->format('i');
        $rest = ($m / $intervalo) - floor($m / $intervalo);
        $next = $intervalo - round($rest * $intervalo,0);
        $sleep = $next * 60;
        print($date->format('Y-m-d H:i:s') . ' esperando:' . $sleep / 60 . chr(10));
        return $sleep;
    }
    private function getRsiMacd($interval){
        $highs = [];
        $lows = [];
        $closes = [];
        $json = $this->apiResponse->getKlines($interval);
        for ($x = 0; $x < count($json); $x++) {
            array_push($highs, $json[$x]["high"]);
            array_push($lows, $json[$x]["low"]);
            array_push($closes, $json[$x]["close"]);
        }
        $this->rsiCalculator->setRsiMacd($highs, $lows, $closes, $trend);
        $rsimacdp = $this->rsiCalculator->getRsiMacdParm();
        return ['rsimacd' => $rsimacdp, 'close' => $closes[count($closes)-1]];
        
    }
    private function printLog($from){
        $date = (new \DateTime('now'))->format('Y-m-d H:i:s');
        print( "Now: " . $date . "|" . $from );
    }
    public function calcRsiMacd($params){
        $closep = 0;
        $maorder = $params['maorder'];
        $inact = $params['inact'];
        $beprice = $params['beprice'];
        $cv = $params['cv'];
        $progre = $params['progre'];
        $repeat = $params['repeat'];
        $result = $this->getRsiMacd($this->interval);
        $rsimacdp = $result['rsimacd'];
        $close = $result['close'];
        //if(($close >= $beprice and $cv = 2) or ($close <= $beprice and $cv = 1)){
            //if($repeat > 10){
                //print("cv:{$cv} close:{$close} break:{$beprice}" .chr(10));
                //$closep = 99;
            //}
        //}else{
            if($progre ){
                switch($inact){
                    case 1:
                        if($rsimacdp['isRsiOvSell'] === 0 or $rsimacdp['isMacdBu'] === 0 or $rsimacdp['rsi'] > 50){
                            $closep = 1;
                        }
                        break;
                    case 2:
                        if($rsimacdp['isRsiOvBuy'] === 0 or $rsimacdp['isMacdBu'] === 1 or $rsimacdp['rsi'] < 50){
                            $closep = 2;
                        }                
                        break;
                    case 3:
                        if($rsimacdp['isMacdBu'] === 0  or $rsimacdp['rsiUp'] === 0 or $rsimacdp['rsi'] < $rsimacdp['rsian']){
                            $closep = 3;                
                        }
                        break;
                    case 4:
                        if($rsimacdp['isMacdBu'] === 1  or $rsimacdp['rsiDo'] === 0 or $rsimacdp['rsi'] > $rsimacdp['rsian']){
                            $closep = 4;
                        }
                        break;
                    case 5:
                        if($rsimacdp['isMacdBu'] === 0 or $rsimacdp['rsiUp'] === 0 or $rsimacdp['macUp'] === 0 and $rsimacdp['rsi'] < $rsimacdp['rsian']){
                            $closep = 5;                
                        }
                        break;
                    case 6:
                        if($rsimacdp['isMacdBu'] === 1 or $rsimacdp['rsiDo'] === 0 or $rsimacdp['macDo'] === 0 or $rsimacdp['rsi'] > $rsimacdp['rsian']){
                            $closep = 6;
                        }
                        break;     
                    case 7:
                        if($rsimacdp['rsiUp'] === 0 or $rsimacdp['treUp'] === 0 or $rsimacdp['rsi'] < $rsimacdp['rsian']){
                            $closep = 7;                
                        }
                        break;
                    case 8:
                        if($rsimacdp['rsiDo'] === 0 or $rsimacdp['treUp'] === 1 or $rsimacdp['rsi'] > $rsimacdp['rsian']){
                            $closep = 8;
                        }
                        break;      
                    case 9:
                        if($rsimacdp['rsiUp'] === 0 or $rsimacdp['treUp'] === 1 or $rsimacdp['rsi'] < $rsimacdp['rsian']){
                            $closep = 9;                
                        }
                        break;
                    case 10:
                        if($rsimacdp['rsiDo'] === 0 or $rsimacdp['treUp'] === 0 or $rsimacdp['rsi'] > $rsimacdp['rsian']){
                            $closep = 10;
                        }
                        break;                                              
                }
            }else{
                switch($inact){
                    case 1:
                        if($rsimacdp['isRsiOvSell'] === 0 or $rsimacdp['isMacdBu'] === 0 or $rsimacdp['rsi'] > 50){
                            $closep = 1;
                        }
                        break;
                    case 2:
                        if($rsimacdp['isRsiOvBuy'] === 0 or $rsimacdp['isMacdBu'] === 1  or $rsimacdp['rsi'] < 50){
                            $closep = 2;
                        }                
                        break;     
                }           
            }

        //}
        if($closep > 0){
            $resp = $this->cancelPosition->closePosition($maorder, true);
            return [ 'resp' => $resp, 'closep' => $closep];
        }else{
            return [ 'resp' => false, 'closep' => $closep];
        }
    }

}