<?php
namespace App;
use App\PivotCalculator;
class RsiCalculator{
    protected $pivotCalculator;
    protected $closes = [];
    protected $highs = [];
    protected $lows = [];
    protected $rsiLBR = [];
    protected $rsi = [];
    protected $macd = [];
    protected $sign = [];
    protected $hist = [];
    protected $pd = 14;
    protected $ba = 5;
    protected $trend = '';
    private $lbl = 1;
    private $lbr = 1;
    private $horangeup = 67; //overBuy
    private $horangedo = 33; //overSell
    private $dorangeup = 50; //overBuy Bajista
    private $dorangedo = 33;  //overSell Bajista
    private $uprangeup = 67; //overBuy Alcista
    private $uprangedo = 50;  //overSell Alcista 
    private $alrangeup = 48; //overBuy
    private $alrangedo = 52;  //overSell
    public function __construct() {
    }
    private function array_key_last(array $arr) {
        $i = 0;
        foreach($arr as $key  => $unused) {
            $i = $i +1;
            //return $key;
        }
        return $key;
    }
    private function array_key_first(array $arr) {
        foreach($arr as $key => $unused) {
            return $key;
        }
        return NULL;
    }
    private function valuewhen($valueFound, $valueLBR, $l){
        for ($i = count($valueLBR) -$l; $i > 0; $i--) {
            if($valueFound === $valueLBR[$i]){
                //print("i:{$i} valueFound:{$valueFound}" .chr(10));
                return $i;
            }
        }
        return 0;
    }
    private function inRange($ppFound, $valueLBR){
        $rangeUpper = 60;
        $rangeLower = 5;
        for ($i = count($valueLBR) -1; $i > 0; $i--) {
            if($ppFound === $valueLBR[$i]){
                if($rangeLower < $i and $i <= $rangeUpper){
                    return 1;
                }
            }
        }
        return 0;
    }
    private Function calculateRsiMacd(){
        $this->rsi = [];
        $this->macd = [];
        $this->sign = [];
        $this->hist = [];
        $this->rsiLBR = [];
        // **************** RSI & MACD
        $this->allrsi = trader_rsi($this->closes, $this->pd);
        $this->allmacd = trader_macd($this->closes,12,26,9);
        $drsi = $this->array_key_last($this->allrsi);
        $hrsi = $this->array_key_first($this->allrsi);
        $dmac = $this->array_key_last($this->allmacd[0]);
        $hmac = $this->array_key_first($this->allmacd[0]);
        $dsig = $this->array_key_last($this->allmacd[1]);
        $hsig = $this->array_key_first($this->allmacd[1]);      
        $dhis = $this->array_key_last($this->allmacd[2]);
        $hhis = $this->array_key_first($this->allmacd[2]);    
        for ($i = $drsi; $i >= $hrsi; $i--) {
            $this->rsi[] = $this->allrsi[$i];
        }
        for ($i = $dmac; $i >= $hmac; $i--) {
            $this->macd[] = $this->allmacd[0][$i];
        }
        for ($i = $dsig; $i >= $hsig; $i--) {
            $this->sign[] = $this->allmacd[1][$i];
        }
        for ($i = $dhis; $i >= $hsig; $i--) {
            $this->hist[] = $this->allmacd[2][$i];
        }        
        for ($i = $this->ba; $i < count($this->rsi); $i++) {
            $this->rsiLBR[] = $this->rsi[$i];
        }
    }
    private function getOverBuySell($rangeup, $rangedo){
        $rsiDo = 0;
        $rsiUp = 0;
        $isRsiOvSell = 0;
        $isRsiOvBuy = 0;
        $isRsiOnBand = 0;
        $keyf =  $this->array_key_first($this->rsi);
        for ($i = $keyf; $i < 5; $i++) {
            if($this->rsi[$i] <= $rangedo) {
                $isRsiOvSell = 1;
                $isRsiOvBuy = 0;
                for ($x = ($i + 1); $x >= $keyf;  $x--) {
                    if($this->rsi[$x] > $this->horangedo) {  
                        $isRsiOnBand = 1;
                        if($this->rsi[0] > $this->rsi[$x]){
                            $rsiUp = 1;
                        }
                        break;
                    }
                }
                break;
            }elseif($this->rsi[$i] >= $rangeup) {
                $isRsiOvBuy = 1;
                $isRsiOvSell = 0;
                for ($x = ($i + 1); $x >= $keyf;  $x--) {
                    if($this->rsi[$x] < $this->horangeup) {
                        $isRsiOnBand = 1;
                        if($this->rsi[0] < $this->rsi[$x]){
                            $rsiDo = 1;
                        }
                        break;
                    }
                }
                break;
            }
        }
        return [
            'ovb' => $isRsiOvBuy,
            'ovs' => $isRsiOvSell,
            'ob' =>  $isRsiOnBand,
            'up' => $rsiUp,
            'do' => $rsiDo
        ];
    }
    public function calculateDiv($highlow){
        $plFound = [];
        $val = [];
        $rsiHL = [];
        $price = [];
        $high = [];
        $low = [];
        $lohiLBR = [];
        $resCond = 0;
        $this->pivotCalculator = new PivotCalculator(5,5);
    	if ($highlow == 'low' || $highlow == 'Low'){
            //********** LOW **********
            // Regular Alcista
            // rsi: Higher Low
            $dlows = $this->array_key_last($this->lows);
            $hlows = $this->array_key_first($this->lows);
            for ($i = $dlows; $i >= $hlows; $i--) {
                $low[] = $this->lows[$i];
            }
            for ($i = $this->ba; $i < count($low); $i++) {
                $lohiLBR[] = $low[$i];
            }
        }else{
            //********** HIGH **********
            // Regular Bajista
            // rsi: Lower High
            $dhighs = $this->array_key_last($this->highs);
            $hhighs = $this->array_key_first($this->highs);
            for ($i =$dhighs; $i >=  $hhighs; $i--) {
                $high[] = $this->highs[$i];
            }
            for ($i = $this->ba; $i < count($high); $i++) {
                $lohiLBR[] = $high[$i];
            }
        }
        $plFound = $this->pivotCalculator->pivotRSI($this->rsi,  $highlow,5,5);
        //print_r($plFound);
        //print(chr(10));
        if(count($plFound) >= 2){
            $resCond = 0;
            for ($i = 1 ; $i >=0 ; $i--) {
                if($plFound[$i] > 0){
                    $idx = $this->valuewhen($plFound[$i], $this->rsiLBR,1);
                    $val[] = $idx;
                    $rsiHL[] = $this->rsiLBR[$idx];
                    $price[] = $lohiLBR[$idx];
                }
            }
            $difr = $rsiHL[0] - $rsiHL[1];
            $difp = $price[0] - $price[1];
            switch($difr >= 0){
            case true:
                if($difp >= 0){
                    $resCond = 0;
                }else{
                    $resCond = 1;
                }
                break;
            default:
                if($difp <= 0){
                    $resCond = 0;
                }else{
                    $resCond = 1;
                }
            }
        } 
        /*
        print("val0 {$highlow}:{$val[0]}" .chr(10));
        print("difr {$highlow}:{$difr}" .chr(10));
        print("difp {$highlow}:{$difp}" .chr(10));
        print("resCond {$highlow}:{$resCond}" . chr(10));
        */
        if(count($val) === 0){
            $val[] = 0;
        }
        $response = ['resCond' => $resCond, 'val' => $val];
        return $response;
    }
    public function setRsiMacd($highs, $lows, $closes, $trendal = 'ho'){
        $this->highs = $highs;
        $this->lows = $lows;
        $this->closes = $closes;
        $this->trend = $trendal;
    }
    public function getRsiMacdParm(){
        $this->calculateRsiMacd();
        $reslow = $this->calculateDiv('low');
        $reshig = $this->calculateDiv('high'); 
        //print("macd:{$this->macd[0]} sign:{$this->sign[0]} rsi:{$this->rsi[0]}" . chr(10)); //quitar   
        if($this->macd[0] > 0 or $this->sign[0] > 0) {
            $isMacdHi = 1;
            //buy
        }else{
            $isMacdHi = 0;
            //sell
        }
        $countUp = 0;
        $countDo = 0;
        $macUp = 0;
        $macDo = 0;
        $treUp = 0;
        $treDo = 0;
        for ($i = 5; $i > 0; $i--) {
            if($this->macd[$i-1] > $this->macd[$i]){
                $countUp++;
            }else{
                $countDo++;
            }
        }
        if($countUp > 2){
            $macUp = 1;
            //buy
        }elseif($countDo > 2){
            $macDo = 1;
            //sell
        }

        if($this->macd[0] > $this->sign[0]) {
            $isMacdBu = 1;
            //buy
        }else{
            $isMacdBu = 0;
            //sell
        }   
        if($this->hist[0] > 0 and $this->sign[0] > 0 ){
            $treUp = 1;
            $treDo = 0;            
        }elseif($this->hist[0] < 0 and $this->sign[0] < 0  ){
            $treUp = 0;
            $treDo = 1; 
        }
        if($reslow['val'][0] < $reshig['val'][0]){
            $trendp = 'up';
            if($reslow['resCond'] === 1){
                $diverg = 1;
            }else{
                $diverg = 0; 
            }
        }else{
            $trendp = 'do';
            if($reshig['resCond'] === 1){
                $diverg = 2;
            }else{
                $diverg = 0; 
            }            
        }
        $isRsiOvSellAlg = 0;
        $isRsiOvBuyAlg = 0;
        $isRsiOvSell = 0;
        $isRsiOvBuy = 0;
        $isRsiOnBand = 0;
        $rsiUp = 0;
        $rsiDo = 0;
        $countUp = 0;
        $countDo = 0;
        for ($i = 5; $i > 0; $i--) {
            //print("i:{$i} ant:{$this->rsi[$i-1]} act:{$this->rsi[$i]}" . chr(10));
            if($this->rsi[$i-1] > $this->rsi[$i]){
                $countUp++;
            }else{
                $countDo++;
            }
        }
        if($countUp > 2){
            $rsiUp = 1;
        }elseif($countDo > 2){
            $rsiDo = 1;
        }
        print("trend en RSI:{$this->trend}" .chr(10));
        $respOver = $this->getOverBuySell($this->horangeup, $this->horangedo);
        if($respOver['ovs'] === 1 and $respOver['ob'] === 1 and $respOver['up'] === 1) {
            $isRsiOvSellAlg = 1;
            $isRsiOvBuyAlg = 0;
        }elseif($respOver['ovb'] === 1  and  $respOver['ob'] === 1 and $respOver['do'] === 1) {
            $isRsiOvBuyAlg = 1;
            $isRsiOvSellAlg = 0;
        }else{
            $isRsiOvBuyAlg = 0;
            $isRsiOvSellAlg = 0;
        }
        // Trend Down
        //ovb => isRsiOvBuy, ovs => isRsiOvSell, ob =>  isRsiOnBand, up => rsiUp, do => rsiDo
        $respOver = $this->getOverBuySell($this->dorangeup, $this->dorangedo);
        if($respOver['ovs'] === 1 and $respOver['ob'] === 1 and $respOver['up'] === 1 and $this->trend === 'do') {
            $isDoRsiOvSellAlg = 1;
            $isDoRsiOvBuyAlg = 0;
        }elseif($respOver['ovb'] === 1  and  $respOver['ob'] === 1 and $respOver['do'] === 1 and $this->trend === 'do') {
            $isDoRsiOvBuyAlg = 1;
            $isDoRsiOvSellAlg = 0;
        }else{
            $isDoRsiOvBuyAlg = 0;
            $isDoRsiOvSellAlg = 0;
        }
        // Trend Up
        //ovb => isRsiOvBuy, ovs => isRsiOvSell, ob =>  isRsiOnBand, up => rsiUp, do => rsiDo
        $respOver = $this->getOverBuySell($this->uprangeup, $this->uprangedo);
        if($respOver['ovs'] === 1 and $respOver['ob'] === 1 and $respOver['up'] === 1 and $this->trend === 'up') {
            $isUpRsiOvSellAlg = 1;
            $isUpRsiOvBuyAlg = 0;
        }elseif($respOver['ovb'] === 1  and  $respOver['ob'] === 1 and $respOver['do'] === 1 and $this->trend === 'up') {
            $isUpRsiOvBuyAlg = 1;
            $isUpRsiOvSellAlg = 0;
        }else{
            $isUpRsiOvBuyAlg = 0;
            $isUpRsiOvSellAlg = 0;
        }   
        //Trend Aleg 
        //ovb => isRsiOvBuy, ovs => isRsiOvSell, ob =>  isRsiOnBand, up => rsiUp, do => rsiDo
        $respOver = $this->getOverBuySell($this->alrangeup, $this->alrangedo);
        if($respOver['ovs'] === 1 and $respOver['ob'] === 1 and $respOver['up'] === 1 and $this->trend === 'up') {
            $isAlRsiOvSellAlg = 1;
            $isAlRsiOvBuyAlg = 0;
        }elseif($respOver['ovb'] === 1  and  $respOver['ob'] === 1 and $respOver['do'] === 1 and $this->trend === 'up') {
            $isAlRsiOvBuyAlg = 1;
            $isAlRsiOvSellAlg = 0;
        }else{
            $isAlRsiOvBuyAlg = 0;
            $isAlRsiOvSellAlg = 0;
        }               
        //print("after - ovSell:{$isRsiOvSell} ovBuy:{$isRsiOvBuy} band:{$isRsiOnBand} up:{$rsiUp} do:{$rsiDo} rsi:{$this->rsi[0]}"); //quitar   
        //print(" isMacdBu:{$isMacdBu} isMacdHi:{$isMacdHi}" . chr(10)); //quitar
        $response = [
            'isMacdHi' => $isMacdHi,
            'isMacdBu' => $isMacdBu,
            'trend' => $trendp,
            'diverg' => $diverg,
            'isRsiOvSell' => $isRsiOvSell,
            'isRsiOvBuy' => $isRsiOvBuy,
            'isRsiOvSellAlg' => $isRsiOvSellAlg,
            'isRsiOvBuyAlg' => $isRsiOvBuyAlg,
            'isDoRsiOvSellAlg' => $isDoRsiOvSellAlg,
            'isDoRsiOvBuyAlg' => $isDoRsiOvBuyAlg,
            'isUpRsiOvSellAlg' => $isUpRsiOvSellAlg,
            'isUpRsiOvBuyAlg' => $isUpRsiOvBuyAlg,
            'isAlRsiOvSellAlg' => $isAlRsiOvSellAlg,
            'isAlRsiOvBuyAlg' => $isAlRsiOvBuyAlg,
            'rsi' => $this->rsi[0],
            'rsian' => $this->rsi[1],
            'rsiUp' => $rsiUp,
            'rsiDo' => $rsiDo,
            'macUp' => $macUp,
            'macDo' => $macDo,
            'treUp' => $treUp,
            'treDo' => $treDo
        ];
        /*
        if($isRsiOvSellAlg or $isRsiOvBuyAlg or $isDoRsiOvSellAlg or $isDoRsiOvBuyAlg or $isUpRsiOvSellAlg or $isUpRsiOvBuyAlg){
            print_r($response);
            print(chr(10));
        }
        */
        return $response;              
    }

    public function getRsiMacd(){
        $this->calculateRsiMacd();
        $response = [
            'rsi' => $this->rsi,
            'macd' => $this->macd,
            'sign' => $this->sign,
            'hist' => $this->hist,            
            'rsiLBR' => $this->rsiLBR
        ];
        return $response;
    }

}