<?php
namespace App;

use App\ValidResponse;
use App\FuTrperm;
use App\WebSocketApi;
use Ratchet\Client\WebSocket;
use React\EventLoop\Factory;
use React\EventLoop\LoopInterface;
use GuzzleHttp\Client;
use Psr\Http\Message\ResponseInterface;
use GuzzleHttp\Exception\RequestException;
use App\Exceptions\ResponseApiException;
class ResponseApi
{
    /**
     * @var Request
     */
    protected $request;

    /**
     * @var array
     */
    protected $keys = [];
        /**
     * @var array
     */
    protected $headers = [];

    /**
     * @var string
     */
    protected $body;
    /**
     * @var FuTrperm  $auth
     */
    protected $auth;

    protected $validresponse;
    protected $websocket;
    const METHOD_GET    = 'GET';
    const METHOD_POST   = 'POST';
    const METHOD_PUT    = 'PUT';
    const METHOD_DELETE = 'DELETE';
    protected $statusCode;
    protected $i = 0;
    protected $client;
    protected $testclient;
    protected $symbol;
    protected static $config = [
        'base_uri'        => 'https://fapi.binance.com/', 
        'timeout' => 30,
        'connect_timeout' => 30,
        'http_errors'     => true,
        'verify'          => 1,
        'skipVerifyTls' => false
    ];
    protected static $testconfig = [
        'base_uri'        => 'https://testnet.binancefuture.com/', 
        'timeout' => 30,
        'connect_timeout' => 30,
        'http_errors'     => true,
        'verify'          => 1,
        'skipVerifyTls' => false
    ];    
    protected $ressock  = [
        'resulttp' => 'NEW',
        'istp' => false,
        'statustp' => false, 
        'resultsl' => 'NEW',
        'issl' => false,                   
        'statusma' => 1,
        'statussl' => false, 
        'done' => true,
        'side' => '',
        'fprice' => 0
    ];
    protected $cvparams  = [
        'CV' => "BUY",
        'maeprice' => 0,
        'slprice' =>  0, 
        'tpprice' => 0 
    ];

    public function __construct()
    {
        require_once __DIR__ . '/Settings.php';
        $params = new Settings();
        $config = $params->settings['config'];
        $this->auth = new FuTrperm($config);
        $this->validresponse = new ValidResponse();
        $this->client = $this->getClient(static::$config);
        $this->testclient = $this->getClient(static::$testconfig);
        $this->symbol = $config['symbol'];
        $this->websocket = new WebSocketApi();
    }
    /**
     * @param array $config
     * @return Client
     */
    private function buildQuery($params = [])
    {
        $new_arr = array();
        $query_add = '';
        foreach ($params as $label=>$item) {
            if ( gettype($item) == 'array' ) {
                foreach ($item as $arritem) {
                    $query_add = $label . '=' . $arritem . '&' . $query_add;
                }
            } else {
                $new_arr[$label] = $item;
            }
        }
        $query = http_build_query($new_arr, '', '&');
        $query = $query_add . $query;
        return $query;
    } 
    private function getClient(array $config)
    {
        $key = md5(json_encode($config));
        if (isset($clients[$key])) {
            return $clients[$key];
        }
        $clients[$key] = new Client($config);
        return $clients[$key];
    }
    private function getApiData($result)
    {
        $body = $this->validresponse->getBody(true);
        if (!isset($body['data'])) {
            //var_dump($body);
            return null;
        }
        return $body['data'];
    }
    private function printLog($from){
        $date = (new \DateTime('now'))->format('Y-m-d H:i:s');
        print($date . ": " . $from );
    }
    private function printLogArry($from){
        $date = (new \DateTime('now'))->format('Y-m-d H:i:s');
        print($date . " error:" . json_encode($from) .chr(10));
        //var_dump($date . " error:" . json_encode($from));
    }    
    public function getKlines($interval, $limit=100)
    {
        $params = [
            'symbol' => $this->symbol,
            'interval' => $interval,
            'limit' => $limit]; //original en 300, 100 para pivot, soporte y resistencia
        $query = '?' . http_build_query($params);
        try {
            $i=0;
            $output = [];
            $result = $this->client->request('GET', 'fapi/v1/klines' ,[
                'headers' =>  $this->auth->getHeaders(),
                'query' => $params
            ]);
            $data = $this->validresponse->getApiData(true, $result);
            $interval =  $params['interval'];
            foreach ($data as $tick) {
                list($openTime, $open, $high, $low, $close, $volact, $closeTime, $baseVolume, $trades, $assetBuyVolume, $takerBuyVolume, $ignored) = $tick;
                $output[$i] = [
                    "open" => $open,
                    "high" => $high,
                    "low" => $low,
                    "close" => $close,
                    "volume" => $baseVolume,
                    "openTime" => $openTime, //(new \DateTime(date('m/d/Y H:i:s',intval($openTime)/1000)))->format('Y-m-d H:i:s'),
                    "closeTime" => $closeTime, //(new \DateTime(date('m/d/Y H:i:s',intval($closeTime)/1000)))->format('Y-m-d H:i:s'),
                    "volact" => $volact,
                    "baseVolume" => $baseVolume,
                    "trades" => $trades,
                    "assetBuyVolume" => $assetBuyVolume,
                    "takerBuyVolume" => $takerBuyVolume,
                    "opetype" => 0,
                    "interval" => $interval,
                    "adx" => 0,
                    "adxa" => 0,            
                    "mdi" => 0,
                    "pdi" => 0
                ];
                $i = $i + 1;
            }      
            return $output;
        } catch (RequestException $exp) {
            $message = json_decode(json_decode($exp->getMessage(),true)['summary'], true);
            $this->printLogArry($message);
        } catch (ResponseApiException $exp) {
            $this->printLog($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        }               
    }
    public function getKlinesTime($interval, $start = 0, $end = 0)
    {
        $params = [
            'symbol' => $this->symbol,
            'interval' => $interval,
            'startTime' => $start,
            'endTime' => $end
        ]; //original en 300, 100 para pivot, soporte y resistencia
        $query = '?' . http_build_query($params);
        try {
            $i=0;
            $output = [];
            $result = $this->client->request('GET', 'fapi/v1/klines' ,[
                'headers' =>  $this->auth->getHeaders(),
                'query' => $params
            ]);
            $data = $this->validresponse->getApiData(true, $result);
            $interval =  $params['interval'];
            foreach ($data as $tick) {
                list($openTime, $open, $high, $low, $close, $volact, $closeTime, $baseVolume, $trades, $assetBuyVolume, $takerBuyVolume, $ignored) = $tick;
                $output[$i] = [
                    "open" => $open,
                    "high" => $high,
                    "low" => $low,
                    "close" => $close,
                    "volume" => $baseVolume,
                    "openTime" => $openTime, //(new \DateTime(date('m/d/Y H:i:s',intval($openTime)/1000)))->format('Y-m-d H:i:s'),
                    "closeTime" => $closeTime, //(new \DateTime(date('m/d/Y H:i:s',intval($closeTime)/1000)))->format('Y-m-d H:i:s'),
                    "volact" => $volact,
                    "baseVolume" => $baseVolume,
                    "trades" => $trades,
                    "assetBuyVolume" => $assetBuyVolume,
                    "takerBuyVolume" => $takerBuyVolume,
                    "opetype" => 0,
                    "interval" => $interval,
                    "adx" => 0,
                    "adxa" => 0,            
                    "mdi" => 0,
                    "pdi" => 0
                ];
                $i = $i + 1;
            }      
            return $output;
        } catch (RequestException $exp) {
            $message = json_decode(json_decode($exp->getMessage(),true)['summary'], true);
            $this->printLogArry($message);
        } catch (ResponseApiException $exp) {
            $this->printLog($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        }               
    }
    public function getAccount($params)
    {
        $query = '?' . http_build_query($params);
        $this->headers = $this->auth->getHeaders();
        try{
            $url = $this->auth->signature('fapi/v2/account', self::METHOD_GET, []);
            $result = $this->client->request(self::METHOD_GET, $url, [
                'headers' => $this->headers
            ]);

            /*
            $data =  $this->validresponse->getApiData(true, $result);
            $balance = 0;
            $symbol  = $params['symbol'];
            if (array_key_exists("availableBalance", $data)) {
                $balance  = $data['availableBalance'];
            }else{
                $balance = 0;
            }
            return $balance;
            */ 
            return $this->validresponse->getApiData(true, $result);
        } catch (RequestException $exp) {
            $message = json_decode(json_decode($exp->getMessage(),true)['summary'], true);
            $this->printLogArry($message);            
        } catch (ResponseApiException $exp) {
            $this->printLog($exp->getMessage() .chr(10));
            return 0; //['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        }  
    }
    public function getBalance($params)
    {
        $query = '?' . http_build_query($params);

        $this->headers = $this->auth->getHeaders();

        try{
            //$response = signedRequest('GET', 'fapi/v2/account', 'fapi');
            $url = $this->auth->signature('fapi/v2/balance', self::METHOD_GET, []);
            $result = $this->client->request(self::METHOD_GET, $url, [
                'headers' => $this->headers
            ]);
            $data =  $this->validresponse->getApiData(true, $result);
            $balance = 0;
            $symbol  = $params['currency'];
            if (count($data) > 0) {
                foreach($data as $posit)  {
                    if($posit['asset'] === $symbol){
                        if($posit['availableBalance'] > 0){
                            $balance = $posit['availableBalance'];
                        }        
                    }
                }
            }else{
                $balance = 0;
            }
            return $balance;
            //return $this->validresponse->getApiData(true, $result);
        } catch (RequestException $exp) {
            $message = json_decode(json_decode($exp->getMessage(),true)['summary'], true);
            $this->printLogArry($message);
            return $message;
        } catch (ResponseApiException $exp) {
            $this->printLog($exp->getMessage() .chr(10));
            return -1; //['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        }  
    }
    public function getLeverage($params)
    {
        $query = '?' . http_build_query($params);
        $this->headers = $this->auth->getHeaders();
        try{
            $url = $this->auth->signature('fapi/v2/account', self::METHOD_GET, []);
            $result = $this->client->request(self::METHOD_GET, $url, [
                'headers' => $this->headers
            ]);
            $data =  $this->validresponse->getApiData(true, $result);
            $leverage = 0;
            $symbol  = $params['symbol'];
            if (array_key_exists("positions", $data)) {
                foreach($data['positions'] as $posit)  {
                    if($posit['symbol'] === $symbol){
                        if($posit['leverage'] > 0){
                            $leverage  = intval($posit['leverage']);
                        }        
                    }
                }
            }else{
                $leverage = 0;
            }
            return $leverage;
        } catch (RequestException $exp) {
            $message = json_decode(json_decode($exp->getMessage(),true)['summary'], true);
            $this->printLogArry($message);
            return $message;
        } catch (ResponseApiException $exp) {
            $this->printLog($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        }  
    }
    public function getPosition($params)
    {
        $query = '?' . http_build_query($params);
        $this->headers = $this->auth->getHeaders();
        try{
            $url = $this->auth->signature('fapi/v2/account', self::METHOD_GET, []);
            $result = $this->client->request(self::METHOD_GET, $url, [
                'headers' => $this->headers
            ]);
            $data =  $this->validresponse->getApiData(true, $result);
            $position= 0;
            $symbol  = $params['symbol'];
            if (array_key_exists("positions", $data)) {
                foreach($data['positions'] as $posit)  {
                    if($posit['symbol'] === $symbol){
                        $position  = round(floatval($posit['initialMargin']),2);     
                    }
                }
            }else{
                $position = 0;
            }
            return $position;
        } catch (RequestException $exp) {
            $message = json_decode(json_decode($exp->getMessage(),true)['summary'], true);
            $this->printLogArry($message);
            return $message;
        } catch (ResponseApiException $exp) {
            $this->printLog($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        }  
    }
    public function setLeverage($params)
    {
        $query = '?' . http_build_query($params);
        $this->headers = $this->auth->getHeaders();
        try{
            $url = $this->auth->signature('fapi/v1/leverage', self::METHOD_POST, $params);
            $result = $this->client->request(self::METHOD_POST, $url, [
                'headers' => $this->headers
            ]);
            return $this->validresponse->getApiData(true, $result);
        } catch (RequestException $exp) {
            $message = json_decode(json_decode($exp->getMessage(),true)['summary'], true);
            $this->printLogArry($message);
            return $message;
        } catch (ResponseApiException $exp) {
            $this->printLog($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        }  
    }
    public function getPrice($params, $times)
    {
        $query = '?' . http_build_query($params);
        $this->headers = $this->auth->getHeaders();
        try{
            $url = $this->auth->signature('fapi/v1/ticker/price', self::METHOD_GET, $params);
            $result = $this->client->request(self::METHOD_GET, $url, [
                'headers' => $this->headers
            ]);
            return $this->validresponse->getApiData(true, $result);
        } catch (RequestException $exp) {
            $message = json_decode(json_decode($exp->getMessage(),true)['summary'], true);
            $this->printLogArry($message);
            return $message;
        } catch (ResponseApiException $exp) {
            $this->printLog($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        } 
    }
    // For test Order reate ********
    /**
     * Place a new order.
     *
     * @param array $order
     * @return array
     */
    public function createOrderTest($params, $times)
    {
        $query = '?' . http_build_query($params);
        $this->headers = $this->auth->getTestHeaders();
        try{

            $url = $this->auth->signatureGen('fapi/v1/order', self::METHOD_POST, $params);
            $result = $this->testclient->request(self::METHOD_POST, $url, [
                'headers' => $this->headers
            ]);
            return $this->validresponse->getApiData(true, $result);
        } catch (RequestException $exp) {
            $message = json_decode(json_decode($exp->getMessage(),true)['summary'], true);
            $this->printLogArry($message);            
            return $message;
        } catch (ResponseApiException $exp) {
            $this->printLog('>>>>>:' . $exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        }  
    }
    public function getOrderByTest($params, $times, $path = '')
    {
        $query = '?' . http_build_query($params);
        $locpath = empty($path)?'fapi/v1/order':$path;
        $this->headers = $this->auth->getTestHeaders();
        try{
            $url = $this->auth->signatureGen($locpath, self::METHOD_GET, $params); //fapi/v1/order
            $result = $this->testclient->request(self::METHOD_GET, $url, [
                'headers' => $this->headers
            ]);
            return $this->validresponse->getApiData(true, $result);
        } catch (RequestException $exp) {
            $message = json_decode(json_decode($exp->getMessage(),true)['summary'], true);
            $this->printLogArry($message);
            return $message;
        } catch (ResponseApiException $exp) {
            $this->printLog($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        }   
 
    }
    /** End Test create Order */
    /**
     * Place a new order.
     *
     * @param array $order
     * @return array
     */
    public function createOrder($params, $times)
    {
        $query = '?' . http_build_query($params);
        $this->headers = $this->auth->getHeaders();
        try{

            $url = $this->auth->signature('fapi/v1/order', self::METHOD_POST, $params);
            $result = $this->client->request(self::METHOD_POST, $url, [
                'headers' => $this->headers
            ]);
            return $this->validresponse->getApiData(true, $result);
        } catch (RequestException $exp) {
            $message = json_decode(json_decode($exp->getMessage(),true)['summary'], true);
            $this->printLogArry($message);
            return $message;
        } catch (ResponseApiException $exp) {
            $this->printLog('>>>>>:' . $exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        }  
    }
    /**
     * Cancel an order.
     *
     * @param array $orderID
     * @return array
     */    
    public function cancelOrderById($params, $times)
    {
        $query = '?' . http_build_query($params);
        $this->headers = $this->auth->getHeaders();
        try{
            $url = $this->auth->signature('fapi/v1/order', self::METHOD_DELETE, $params);
            $result = $this->client->request(self::METHOD_DELETE, $url, [
                'headers' => $this->headers
            ]);
            return $this->validresponse->getApiData(true, $result);
        } catch (RequestException $exp) {
            $message = json_decode(json_decode($exp->getMessage(),true)['summary'], true);
            $this->printLogArry($message);
            return $message;
        } catch (ResponseApiException $exp) {
            $this->printLog($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        }   
    }
    public function cancelAllOrders($params, $times)
    {
        $query = '?' . http_build_query($params);
        $this->headers = $this->auth->getHeaders();
        try{
            //$url = $this->auth->signature('/fapi/v1/countdownCancelAll', self::METHOD_POST, $params); 
            $url = $this->auth->signature('/fapi/v1/allOpenOrders', self::METHOD_DELETE, $params);
            $result = $this->client->request(self::METHOD_DELETE, $url, [
                'headers' => $this->headers
            ]);
            return $this->validresponse->getApiData(true, $result);
        } catch (RequestException $exp) {
            $message = json_decode(json_decode($exp->getMessage(),true)['summary'], true);
            $this->printLogArry($message);
            return $message;
        } catch (ResponseApiException $exp) {
            $this->printLog($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        }   
    }
    public function cancelAllOrdersOtr($params, $times)
    {
        $query = '?' . http_build_query($params);
        $this->headers = $this->auth->getHeaders();
        try{
            $url = $this->auth->signature('fapi/v1/countdownCancelAll', self::METHOD_POST, $params);
            $result = $this->client->request(self::METHOD_POST, $url, [
                'headers' => $this->headers
            ]);
            return $this->validresponse->getApiData(true, $result);
        } catch (RequestException $exp) {
            $message = json_decode(json_decode($exp->getMessage(),true)['summary'], true);
            $this->printLogArry($message);
            return $message;
        } catch (ResponseApiException $exp) {
            $this->printLog($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        }   
    }
    public function getOrderById($params, $times, $path = '')
    {
        $query = '?' . http_build_query($params);
        $locpath = empty($path)?'fapi/v1/order':$path;
        $this->headers = $this->auth->getHeaders();
        try{
            $url = $this->auth->signature($locpath, self::METHOD_GET, $params); //fapi/v1/order
            $result = $this->client->request(self::METHOD_GET, $url, [
                'headers' => $this->headers
            ]);
            return $this->validresponse->getApiData(true, $result);
        } catch (RequestException $exp) {
            $message = json_decode(json_decode($exp->getMessage(),true)['summary'], true);
            $this->printLogArry($message);
            return $message;
        } catch (ResponseApiException $exp) {
            $this->printLog($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        }   
 
    }
    public function getListOrder(array $params = [], $times)
    {
        $query = '?' . http_build_query($params);
        $this->headers = $this->auth->getHeaders();
        try{
            $url = $this->auth->signature('/fapi/v1/allOrders', self::METHOD_GET, $params);
            $result = $this->client->request(self::METHOD_GET, $url, [
                'headers' => $this->headers
            ]);
            $items = $this->validresponse->getApiData(true, $result);
            /*
            foreach ($items as $item) {
                $id = $item['orderId'];
                $idc = $item["clientOrderId"];
                $side = $item['side'];
                $value = $item['stopPrice'];
                $stop = $item['type'];
                $createdAt = $item['time'];
                $updatedAt = $item['updateTime'];
                $stat =   $item['status'];  
                $orig  = $item['origType'];      
		        if($stop !== ''){
                    $created = (new \DateTime(date('m/d/Y H:i:s',intval($createdAt)/1000)))->format('Y-m-d H:i:s');
                    $update = (new \DateTime(date('m/d/Y H:i:s',intval($updatedAt)/1000)))->format('Y-m-d H:i:s');  
                    $this->printLog(' update: ' . $update .' id:'.$id .  ' cliId:'.$idc . ' side:' . $side . ' type:' . $stop. ' origen:' . $orig. ' status:' . $stat . ' value:' . $value . chr(10));
                }
            }*/
            return $items;
        } catch (RequestException $exp) {
            $message = json_decode(json_decode($exp->getMessage(),true)['summary'], true);
            $this->printLogArry($message);
            return $message;
        } catch (ResponseApiException $exp) {
            $this->printLog($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        }  
   
    }
    /**
     * List orders.
     *
     * @param array $params -> status
     * @param array $pagination
     * @return array
     */
    public function getStopOrder(array $params = [], $times)
    {
        $query = '?' . http_build_query($params);
        $this->headers = $this->auth->getHeaders();
        try{
            $url = $this->auth->signature('/fapi/v1/openOrders', self::METHOD_GET, $params);
            $result = $this->client->request(self::METHOD_GET, $url, [
                'headers' => $this->headers
            ]);
            $items = $this->validresponse->getApiData(true, $result);
            /*
            foreach ($items as $item) {
                $id = $item['orderId'];
                $side = $item['side'];
                $value = $item['stopPrice'];
                $stop = $item['type'];
                $createdAt = $item['time'];
                $updatedAt = $item['updateTime'];
                $stat =   $item['status'];         
                if($stop !== ''){
                    $created = (new \DateTime(date('m/d/Y H:i:s',intval($createdAt)/1000)))->format('Y-m-d H:i:s');
                    $update = (new \DateTime(date('m/d/Y H:i:s',intval($updatedAt)/1000)))->format('Y-m-d H:i:s');  
                    var_dump('id:'.$id. ' side:' . $side . ' stop:' . $stop. ' status:' . $stat . ' value:' . $value . ' create:' . $created . ' update: ' . $update);
                }

            };
            */
            return ['items' => $items];

        } catch (RequestException $exp) {
            $message = json_decode(json_decode($exp->getMessage(),true)['summary'], true);
            $this->printLogArry($message);
            return $message;
        } catch (ResponseApiException $exp) {
            $this->printLog($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        }  
   
    }  
    public function getStatus(array $params = [], $times){ 
        $query = '?' . http_build_query($params);
        $this->headers = $this->auth->getHeaders();
        try{
            $url = $this->auth->signature('fapi/v2/account', self::METHOD_GET, []);
            $result = $this->client->request(self::METHOD_GET, $url, [
                'headers' => $this->headers
            ]);
            return $this->validresponse->getApiData(true, $result);
        } catch (RequestException $exp) {
            $message = json_decode(json_decode($exp->getMessage(),true)['summary'], true);
            $this->printLogArry($message);
            return $message;
        } catch (ResponseApiException $exp) {
            $this->printLog($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        }  
    }
    public function getRisk(array $params = [], $times){ 
        $query = '?' . http_build_query($params);
        $this->headers = $this->auth->getHeaders();
        try{
            $url = $this->auth->signature('fapi/v2/positionRisk', self::METHOD_GET, $params);
            $result = $this->client->request(self::METHOD_GET, $url, [
                'headers' => $this->headers
            ]);
            $not = $params['qty'];
            $data = $this->validresponse->getApiData(true, $result)[0];
            $lev = $data['leverage'] > 0 ? $data['leverage'] : 1;
            $not = number_format(round(($data['notional'] / $lev) ,3), 3, '.', ',');
            return $not;
        } catch (RequestException $exp) {
            $message = json_decode(json_decode($exp->getMessage(),true)['summary'], true);
            $this->printLogArry($message);
            return $message;
        } catch (ResponseApiException $exp) {
            $this->printLog($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        }  
    }    
    public function getWebSocket(array $params = [], $wsparams)
    {
        $this->ressock['statusma'] = 1;
        $this->cvparams['CV'] = $wsparams['CV'] === 1?"BUY":"SELL";
        $this->cvparams['maeprice'] = $wsparams['maeprice'];
        $query = '?' . http_build_query($params);
        $this->headers = $this->auth->getHeaders();
        try{
            $url = $this->auth->signature('/fapi/v1/listenKey', self::METHOD_POST, []);

            $result = $this->client->request(self::METHOD_POST, $url, [
                'headers' => $this->headers
            ]);
            $datakey = $this->validresponse->getApiData(true, $result);
            $listenKey = '';
            if (array_key_exists('listenKey', $datakey )) {
                $listenKey = $datakey['listenKey'];
                $wsparams['connectId'] = uniqid('', true);
                $wsparams['listenKey'] = $listenKey;
                $sockapi = $this->websocket;
                $sockapi->cntlOrders($wsparams, function (array $message, WebSocket $ws, LoopInterface $loop) {
                    //print("Start-mensaje de apertura" . chr(10));
                    //$this->printLogArry($message);
                    //print("End-mensaje de apertura" . chr(10));
                    $type = $message['e'];
                    switch ($type) {
                        case 'ORDER_TRADE_UPDATE':
                            $otu = $message['o'];
                            $line = sprintf('%s%s%s%s', "ORDER: side: {$otu['S']}", " id: {$otu['c']}", " type: {$otu['o']}", " status: {$otu['x']}", " qty: {$otu['q']}", " price: {$otu['sp']}");
                            $this->printLog($line . chr(10));
                            /*
                            if($otu['o'] === 'TAKE_PROFIT_MARKET' and $otu['X'] !== 'NEW'){
                                $this->ressock['resulttp'] =  $otu['X'];
                                $this->ressock['statustp'] =  true;
                                $this->ressock['statussl'] =  false;
                                if($otu['X'] === 'FILLED'  or $otu['X'] === 'EXPIRED'){
                                    $this->ressock['istp'] = true;
                                    $this->ressock['issl'] = false;
                                    $this->ressock['resultsl'] =  'CANCELED';
                                }
                            }elseif($otu['o'] === 'STOP_MARKET' and $otu['X'] !== 'NEW'){
                                $this->ressock['resultsl'] =  $otu['X'];
                                $this->ressock['statussl'] =  true;
                                $this->ressock['statustp'] =  false;
                                if($otu['X'] === 'FILLED' or $otu['X'] === 'EXPIRED'){
                                    $this->ressock['issl'] = true;
                                    $this->ressock['istp'] = false;
                                    $this->ressock['resulttp'] =  'CANCELED';
                                }
                            }
                            */
                            break;
                        
                        case 'ACCOUNT_UPDATE':
                            //$this->printLogArry($message);
                            $plen = count($message['a']['P']);
                            if ($plen > 0){
                                $acu = $message['a']['P'][0];
                                if(array_key_exists("pa", $acu)){
                                    $line = sprintf('%s%s%s%s', "ACCOUNT qty: {$acu['pa']}", " price: {$acu['ep']}", " PnL: {$acu['up']}", " Isolated Wallet: {$acu['iw']}");
                                    $this->printLog($line . chr(10));
                                    $this->ressock['statusma'] =  intval($acu['pa']);
                                    //$this->printLog( 'statusma_int: ' . $this->ressock['statusma'] . chr(10));
                                //}else{
                                    //$this->printLog( 'Not exist pa:' . chr(10));
                                }
                            //}else{
                                //$this->printLog( 'no vector[P], statusma: ' . $this->ressock['statusma'] . chr(10));
                            }
                            break;
                        case 'TRADE_LITE':
                            $otu = $message;
                            $line = sprintf('%s%s%s%s', "ORDERid:{$otu['c']} side: {$otu['S']}", " id: {$otu['i']}", " type: {$otu['S']}", " status: 'FILLED'", " qty: {$otu['l']}", " price: {$otu['L']}");
                            if (strpos($otu['c'], 'TP') !== false) {
                                $this->ressock['resulttp'] =  'FILLED';
                                $this->ressock['statustp'] =  true;
                                $this->ressock['statussl'] =  false;
                                $this->ressock['istp'] = true;
                                $this->ressock['issl'] = false;
                                $this->ressock['resultsl'] =  'CANCELED';
                                $this->ressock['side'] =  $otu['S'];
                                $this->ressock['fprice'] =  $otu['L'];
                            }elseif(strpos($otu['c'], 'SM') !== false){
                                $this->ressock['resultsl'] =  'FILLED';
                                $this->ressock['statussl'] =  true;
                                $this->ressock['statustp'] =  false;
                                $this->ressock['issl'] = true;
                                $this->ressock['istp'] = false;
                                $this->ressock['resulttp'] =  'CANCELED';
                                $this->ressock['side'] =  $otu['S'];
                                $this->ressock['fprice'] =  $otu['L'];
                            }else{
                                if($this->cvparams['CV'] === 'BUY' and $otu['S'] === 'SELL'){
                                    if($otu['L'] >= $this->cvparams['maeprice'] ){
                                        $this->ressock['resulttp'] =  'FILLED';
                                        $this->ressock['statustp'] =  true;
                                        $this->ressock['statussl'] =  false;
                                        $this->ressock['istp'] = true;
                                        $this->ressock['issl'] = false;
                                        $this->ressock['resultsl'] =  'CANCELED';
                                        $this->ressock['side'] =  $otu['S'];
                                        $this->ressock['fprice'] =  $otu['L'];
                                    }else{
                                        $this->ressock['resultsl'] =  'FILLED';
                                        $this->ressock['statussl'] =  true;
                                        $this->ressock['statustp'] =  false;
                                        $this->ressock['issl'] = true;
                                        $this->ressock['istp'] = false;
                                        $this->ressock['resulttp'] =  'CANCELED';
                                        $this->ressock['side'] =  $otu['S'];
                                        $this->ressock['fprice'] =  $otu['L'];
                                    }
                                }elseif($this->cvparams['CV'] === 'SELL' and $otu['S'] === 'BUY'){
                                    if($otu['L'] <= $this->cvparams['maeprice'] ){
                                        $this->ressock['resulttp'] =  'FILLED';
                                        $this->ressock['statustp'] =  true;
                                        $this->ressock['statussl'] =  false;
                                        $this->ressock['istp'] = true;
                                        $this->ressock['issl'] = false;
                                        $this->ressock['resultsl'] =  'CANCELED';
                                        $this->ressock['side'] =  $otu['S'];
                                        $this->ressock['fprice'] =  $otu['L'];
                                    }else{
                                        $this->ressock['resultsl'] =  'FILLED';
                                        $this->ressock['statussl'] =  true;
                                        $this->ressock['statustp'] =  false;
                                        $this->ressock['issl'] = true;
                                        $this->ressock['istp'] = false;
                                        $this->ressock['resulttp'] =  'CANCELED';
                                        $this->ressock['side'] =  $otu['S'];
                                        $this->ressock['fprice'] =  $otu['L'];
                                    }
                                }

                            }
                            $this->printLog($line . chr(10));
                            break;
                        default:
                            $this->printLog("case default" . chr(10));
                            $this->printLogArry($message);
                    }
                    //print("Start-ressock" . chr(10));
                    //$this->printLogArry($this->ressock);
                    //print("End--ressock" . chr(10));
                    //$this->printLog( 'statusma_o: ' . $this->ressock['statusma'] . chr(10));
                    if($this->ressock['statusma'] === 0) {                    
                    //if(($this->ressock['statustp'] and $this->ressock['statussl']) or $this->ressock['statusma'] === 0) {
                        $msgres = 'Proc end in stop order: tp: ' . $this->ressock['resulttp'] . ' sl: ' . $this->ressock['resultsl'] . chr(10);
                        //$loop->cancelTimer($swresponse['pingInterval']);
                        $ws->close(2424, $msgres);
                    }
                 }, function (array $message, LoopInterface $loop) {
                    if($message['code'] !== 2424){
                        $this->ressock['issl'] = true;
                        $this->ressock['istp'] = false;
                        $this->ressock['statusma'] =  1;
                        $this->ressock['resulttp'] =  'CANCELED';
                        $this->ressock['resultsl'] =  'CANCELED';
                    }
                    //$this->printlog("in 2 function "  .chr(10));
                    $this->printLog($message['reason']  .chr(10));
                    $loop->stop();
                });
            }
            return $this->ressock;
        } catch (RequestException $exp) {
            $message = json_decode(json_decode($exp->getMessage(),true)['summary'], true);
            $this->printLogArry($message);
            return $message;
        } catch (ResponseApiException $exp) {
            $this->printLog($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        } 

    }
}