<?php
namespace App;
use App\Trader;
class RSI {
    private $rsiValues;
    private $horangeup = 70; //overBuy
    private $horangedo = 30; //overSell
    private $alrangeup = 46; //overBuy
    private $alrangedo = 54;  //overSell
    private $atrPeriod = 14;
    public function __construct(array $close) {
        $this->rsiValues = Trader::RSI($close, $this->atrPeriod);
    }

    /**
     * Verifica si hay una salida de sobreventa (rebote desde corrección).
     *
     * @return bool
     */
    public function isOversoldExit(): bool {
        $current = end($this->rsiValues); // Valor actual de RSI
        $last10 = array_slice($this->rsiValues, -11, 10); // Últimos 10 valores de RSI
        
        // Verificar si hubo sobreventa (RSI ≤ $this->alrangedo) en los últimos 10 períodos
        $hadOversoldCondition = in_array(true, array_map(function($v) { return $v <= $this->alrangedo; }, $last10));

        // Verificar si el RSI actual está entre $this->horangedo y $this->horangeup
        return $hadOversoldCondition && ($current >= $this->horangedo && $current <= $this->horangeup);
    }

    /**
     * Verifica si hay una salida de sobrecompra (rebote desde corrección).
     *
     * @return bool
     */
    public function isOverboughtExit(): bool {
        $current = end($this->rsiValues); // Valor actual de RSI
        $last10 = array_slice($this->rsiValues, -11, 10); // Últimos 10 valores de RSI

        // Verificar si hubo sobrecompra (RSI ≥ $this->alrangeup) en los últimos 10 períodos
        $hadOverboughtCondition = in_array(true, array_map(function($v) { return $v >= $this->alrangeup; }, $last10));

        // Verificar si el RSI actual está entre $this->horangedo y $this->horangeup
        return $hadOverboughtCondition && ($current >= $this->horangedo && $current <= $this->horangeup);
    }

    /**
     * Verifica si hay una tendencia alcista.
     *
     * @return bool
     */
    public function isBullishTrend(): bool {
        $current = end($this->rsiValues); // Valor actual de RSI
        $last10 = array_slice($this->rsiValues, -11, 10); // Últimos 10 valores de RSI

        // Verificar si hubo sobreventa (RSI ≤ $this->alrangedo) en los últimos 10 períodos
        $hadOversoldCondition = in_array(true, array_map(function($v) { return $v <= $this->alrangedo; }, $last10));

        // Verificar si el RSI actual está entre $this->horangedo y $this->horangeup
        return $hadOversoldCondition && ($current >= $this->horangedo && $current <= $this->horangeup);
    }

    /**
     * Verifica si hay una tendencia bajista.
     *
     * @return bool
     */
    public function isBearishTrend(): bool {
        $current = end($this->rsiValues); // Valor actual de RSI
        $last10 = array_slice($this->rsiValues, -11, 10); // Últimos 10 valores de RSI

        // Verificar si hubo sobrecompra (RSI ≥ $this->alrangeup) en los últimos 10 períodos
        $hadOverboughtCondition = in_array(true, array_map(function($v) { return $v >= $this->alrangeup; }, $last10));

        // Verificar si el RSI actual está entre $this->horangedo y $this->horangeup
        return $hadOverboughtCondition && ($current >= $this->horangedo && $current <= $this->horangeup);
    }
}