<?php
namespace App;
use App\Trader;
class PivotPoints {
    private $high;
    private $low;
    private $highPivots;
    private $lowPivots;
    private $atr;

    public function __construct(array $high, array $low, float $atr = 0) {
        $this->high = $high;
        $this->low = $low;
        $this->atr = $atr;
        $this->highPivots = $this->detectPivots($high, true);
        $this->lowPivots = $this->detectPivots($low, false);
    }

    private function detectPivots(array $data, bool $isHigh): array {
        $pivots = [];
        $n = count($data);

        for ($i = 5; $i < $n - 5; $i++) {
            $current = $data[$i];
            $prev = array_slice($data, $i - 5, 5);
            $next = array_slice($data, $i + 1, 5);

            if ($isHigh) {
                if (max($prev) <= $current && max($next) <= $current) {
                    // Aplicar filtro de volatilidad (ATR)
                    $vola = $current - min($prev);
                    $min = min($prev);
                    if ($this->atr > 0 && ($current - min($prev)) < $this->atr) {
                        continue; // Ignorar si no supera el umbral de ATR
                    }
                    $pivots[] = round($current,3);
                }
            } else {
                if (min($prev) >= $current && min($next) >= $current) {
                    // Aplicar filtro de volatilidad (ATR)
                    if ($this->atr > 0 && (max($prev) - $current) < $this->atr) {
                        continue; // Ignorar si no supera el umbral de ATR
                    }
                    $pivots[] = round($current,3);
                }
            }
        }
        return $pivots;
    }

    public function isTrendBullish(int $pivotsToCheck = 3): bool {
        if (count($this->highPivots) < $pivotsToCheck || count($this->lowPivots) < $pivotsToCheck) {
            return false;
        }
    
        // Verificar si los últimos $pivotsToCheck pivotes altos son crecientes
        $lastHighs = array_slice($this->highPivots, -$pivotsToCheck);
        $highsBullish = true;
        for ($i = 1; $i < count($lastHighs); $i++) {
            if ($lastHighs[$i - 1] >= $lastHighs[$i]) {
                $highsBullish = false;
                break;
            }
        }
    
        // Verificar si los últimos $pivotsToCheck pivotes bajos son crecientes
        $lastLows = array_slice($this->lowPivots, -$pivotsToCheck);
        $lowsBullish = true;
        for ($i = 1; $i < count($lastLows); $i++) {
            if ($lastLows[$i - 1] >= $lastLows[$i]) {
                $lowsBullish = false;
                break;
            }
        }
    
        return $highsBullish && $lowsBullish;
    }
    
    public function isTrendBearish(int $pivotsToCheck = 3): bool {
        if (count($this->highPivots) < $pivotsToCheck || count($this->lowPivots) < $pivotsToCheck) {
            return false;
        }
    
        // Verificar si los últimos $pivotsToCheck pivotes altos son decrecientes
        $lastHighs = array_slice($this->highPivots, -$pivotsToCheck);
        $highsBearish = true;
        for ($i = 1; $i < count($lastHighs); $i++) {
            if ($lastHighs[$i - 1] <= $lastHighs[$i]) {
                $highsBearish = false;
                break;
            }
        }
    
        // Verificar si los últimos $pivotsToCheck pivotes bajos son decrecientes
        $lastLows = array_slice($this->lowPivots, -$pivotsToCheck);
        $lowsBearish = true;
        for ($i = 1; $i < count($lastLows); $i++) {
            if ($lastLows[$i - 1] <= $lastLows[$i]) {
                $lowsBearish = false;
                break;
            }
        }
    
        return $highsBearish && $lowsBearish;
    }
    
}