<?php
namespace App;
use App\Trader;
class PivotCalculator {
    private $high;
    private $low;
    private $close;
    private $atr = 0;
    private $atrPeriod = 14;
    public function __construct(array $high, array $low, array $close, $atrPeriod = 14) {
        $this->high = $high;
        $this->low = $low;
        $this->close = $close;
        $atr = Trader::ATR($this->high, $this->low, $this->close, $this->atrPeriod);  // Volatilidad (ATR)
        $this->atr = end($atr);
    }


    public function calculateClassicPivots(): array {
        $pivots = [];
        $support1 = [];
        $support2 = [];
        $resistance1 = [];
        $resistance2 = [];
        $pivotsresp = [];
        $n = count($this->high);
        for ($i = 0; $i < $n; $i++) {
            // Calcular el punto pivote clásico
            $pivot = ($this->high[$i] + $this->low[$i] + $this->close[$i]) / 3;
            $range = $this->high[$i] - $this->low[$i];
            $pivots[] = round($pivot,3);
            // Calcular los niveles de soporte y resistencia clásicos
            $s1 = round((2 * $pivot) - $this->high[$i], 3);
            $s2 = round($pivot - $range, 3);
            $r1 = round((2 * $pivot) - $this->low[$i], 3);
            $r2 = round($pivot + $range, 3);

            // Si el ATR es mayor a 0, ajustamos los niveles de soporte y resistencia
            if ($this->atr > 0) {
                $volatility_factor = 1 + ($this->atr / $this->close[$i]);
                $support1[] = round($s1 * $volatility_factor, 3);
                $support2[] = round($s2 * $volatility_factor, 3);
                $resistance1[] = round($r1 * $volatility_factor, 3);
                $resistance2[] = round($r2 * $volatility_factor, 3);
            } else {
                $volatility_factor = 1;
                $support1[] = $s1;
                $support2[] = $s2;
                $resistance1[] = $r1;
                $resistance2[] = $r2;
            }
        }
        $pivotsresp['supports'] = $support1; // Puede personalizarse más dependiendo de la estrategia
        $pivotsresp['resistances'] = $resistance1;
        $pivotsresp['pivots'] = $pivots;
        return $pivotsresp;
    }
    private function calculateAtr(): float {
        $atrValues = Trader::ATR(
            $this->high,
            $this->low,
            $this->close,
            $this->atrPeriod
        );
        return end($atrValues) ?: 0.01;
    }
}
