<?php
namespace App;
use App\ResponseApi;
use App\ATRCalculator;
use App\RsiCalculator;
use App\TrendCalculator;
use App\Analysis;
use App\ImpulseMACDWS;
use App\ImpulseMacdStrategy;
class AlgoritApiOrg
{
    protected $algResp = [
        "CV" => 0,
        "emitir" => 0,
        "tokentel" => []
    ];
    protected $CV;
    protected $FTP;
    protected $FSL;
    protected $RSI;
    protected $ACT;
    protected $PRO = false;
    /**
     * @var ResponseApi
     */
    protected $apiResponse; 
    /**
     * @var rsiCalculator
     */
    protected $rsiCalculator;
    /**
     * @var atrCalculator
     */
    protected $atrCalculator;
    /**
     * @var trendCalculator
     */
    protected $trendCalculator;    
    protected $config;  
    protected $interval;  
    public function __construct()
    {
        require_once __DIR__ . '/Settings.php';
        $params = new Settings();
        $config = $params->settings['config'];        
        $this->config = $config;
        $this->CV = $config['cv'];
        $this->FTP = $config['atrtp'];
        $this->FSL = $config['atrsl'];
        $this->RSI = $config['rsi']; 
        $this->ACT = $config['act'];
        $this->PRO = $config['proge'];
        $this->interval = $config['interval'];
        $this->apiResponse = new ResponseApi();
        $this->trendCalculator = new TrendCalculator();
    }

    public function getAlgoritImpulseMacd(){
        $factor = 3;
        $pd = 14;
        $closes = [/* array de precios de cierre */];
        $highs = [/* array de precios máximos */];
        $lows = [/* array de precios mínimos */];
        $volums = [/* array de volumenes */];
        $this->CV = 0;
        $tp = 0; 
        $sl = 0;
        $potp = 0;
        $posl = 0;
        $result = $this->apiResponse->getPrice(['symbol' => "DOTUSDT"], 0);
        $price = $result["price"];
        $vai = array( 1 => ['interval' => $this->interval,'vre' => []]);
        $adx = 0;   
           for ($i = 1; $i <= 1; $i++) {
            $json = $this->apiResponse->getKlines($vai[$i]['interval'], 300);
        }
        for ($x = 0; $x < count($json); $x++) {
            array_push($highs, $json[$x]["high"]);
            array_push($lows, $json[$x]["low"]);
            array_push($closes, $json[$x]["close"]);
            array_push($volums, $json[$x]["volact"]);
        }
        $data = [
            'close' => $closes,
            'high' => $highs,
            'low' => $lows,
            'volum' => $volums
        ];
        $idm = $this->array_key_last($json);

        $analysis = new Analysis($closes, $highs, $lows, $volums);
        $resp = $analysis->analyze();
        $sl = $resp['stopLoss'];
        $tp = $resp['takeProfit'];
        $actprice = $resp['actPrice'];
        $bands = [
            'supo' => $resp['pivotSu'],
            'resi' => $resp['pivotRe'],
            'trai' => '',
            'tren' => $resp['pivotTrend']
        ];
        if($resp['action'] === 'LONG'){
            $accion = "Comprar"; 
            $emitir = 1;
            $this->CV = 1;     
            $this->ACT = 1; 

        }elseif($resp['action'] === 'SHORT'){
            $accion = "Vender"; 
            $emitir = 1;   
            $this->CV = 2; 
            $this->ACT = 2; 
        }else{
            $accion = "Mantener"; 
            $emitir = 0;   
            $this->CV = 0;
            $this->ACT = 0;            
        }
        $tokentel = $this->setTokenTel($json[$idm],$bands,$vai[1], $this->RSI, $accion, $this->ACT);
        //Calcular porcentaje de sl y tp
        if($tp > 0 and $sl > 0){
            $potp = round((100 - ($tp * 100)/$actprice),2);
            $posl = round((100 - ($sl * 100)/$actprice),2);
        }else{
            $potp = 0;
            $posl = 0;            
        }
        if($potp > 0 and $potp < 0.4){
            $potp = 0.4;
            $posl = $potp * 2;
        }
        $tokentel["potp"] = $potp;
        $tokentel["posl"] = $posl; 
        $this->printLog("Tp/Sl - {$accion}:{$price} tp:{$tp} sl:{$sl} portp:" . $potp . " porsl:" . $posl . chr(10));
        $this->algResp = [
            "CV" => $this->CV,
            "emitir" => $emitir,
            "tokentel" => $tokentel,
            "rsi" => 0,
            "act" => 0
        ];
    }    
    public function getAlgoritImpulseMacdEMa100(){
        $factor = 3;
        $pd = 14;
        $closes = [/* array de precios de cierre */];
        $highs = [/* array de precios máximos */];
        $lows = [/* array de precios mínimos */];
        $volums = [/* array de volumenes */];
        $this->CV = 0;
        $tp = 0; 
        $sl = 0;
        $potp = 0;
        $posl = 0;
        $result = $this->apiResponse->getPrice(['symbol' => "DOTUSDT"], 0);
        $price = $result["price"];
        $vai = array( 1 => ['interval' => $this->interval,'vre' => []]);
        $action = '';
        $adx = 0;   
           for ($i = 1; $i <= 1; $i++) {
            $json = $this->apiResponse->getKlines($vai[$i]['interval'], 300);
        }
        for ($x = 0; $x < count($json); $x++) {
            array_push($highs, $json[$x]["high"]);
            array_push($lows, $json[$x]["low"]);
            array_push($closes, $json[$x]["close"]);
            array_push($volums, $json[$x]["volact"]);
        }
        $data = [
            'close' => $closes,
            'high' => $highs,
            'low' => $lows,
            'volum' => $volums
        ];
        $idm = $this->array_key_last($json);
        // Usar la clase ImpulseMACDWS simple
        try{
            $impulseMacd = new ImpulseMACDWS(
                lengthMA: 34,
                lengthSignal: 9,
                thresholdPeriod: 2 // Activar filtro dinámico
            );
            $impulseMacd->calculate($data); // Calcula OB/OS, MD, SB, SH, shThreshold
        } catch (\Exception $e) {
            die("Error calculando ImpulseMACDWS: " . $e->getMessage() . "\n");
        }
        // --- Crear y Ejecutar la Estrategia ---
        try {
            // Pasar el ImpulseMACDWS simple a la estrategia
            $strategy = new ImpulseMacdStrategy(
                impulseMacd: $impulseMacd, // Pasar el objeto ya calculado
                ohlcData: $data,       // Pasar los datos OHLC de nuevo
                atrPeriod: 14,
                atrMultiplierSL: 2.0,
                rrRatio: 2.5
            );

            // Generar las señales finales (La estrategia caclcula EMA, ATR y aplica filtros)
            $result = $strategy->generateSignals(confirmationPeriods: 2); // Usar 2 barras de confirmación para MACD base
            $resp = end($result);
        } catch (\Exception $e) {
            die("Error ejecutando la estrategia: " . $e->getMessage() . "\n");
        }
        if ($resp['signal'] === 1) {
            $action = 'LONG';

        } elseif ($resp['signal'] === -1) {
            $action = 'SHORT';
        } else {
            $action === '';
        }
        $sl = $resp['stopLoss'];
        $tp = $resp['takeProfit'];
        $actprice = end($data['close']);
        $bands = [
            'supo' => 0,
            'resi' => 0,
            'trai' => '',
            'tren' => ''
        ];
        if($action === 'LONG' and $tp > 0 and $sl > 0){
            $accion = "Comprar"; 
            $emitir = 1;
            $this->CV = 1;     
            $this->ACT = 1; 
            $potp = round((-100 + ($tp * 100)/$actprice),2);                
            $posl = round((100 - ($sl * 100)/$actprice),2);
        }elseif($action === 'SHORT' and $tp > 0 and $sl > 0){
            $accion = "Vender"; 
            $emitir = 1;   
            $this->CV = 2; 
            $this->ACT = 2; 
            $posl = round((-100 + ($sl * 100)/$actprice),2); 
            $potp = round((100 - ($tp * 100)/$actprice),2);              
        }else{
            $accion = "Mantener"; 
            $emitir = 0;   
            $this->CV = 0;
            $this->ACT = 0;            
        }
        $tokentel = $this->setTokenTel($json[$idm],$bands,$vai[1], $this->RSI, $accion, $this->ACT);
        //Calcular porcentaje de sl y tp
        if($potp > 0 and $posl > 0){
            if($potp > 0 and $potp < 0.4){
                $potp = 0.4;
                $posl = $potp * 2;
            } 
            $this->printLog("Tp/Sl - {$accion}:{$price} tp:{$tp} sl:{$sl} portp:" . $potp . " porsl:" . $posl . chr(10));                       
        }else{
            $potp = 0;
            $posl = 0; 
            $accion = "Mantener"; 
            $emitir = 0;   
            $this->CV = 0;
            $this->ACT = 0;                  
        }
        $tokentel["potp"] = $potp;
        $tokentel["posl"] = $posl; 
        $this->algResp = [
            "CV" => $this->CV,
            "emitir" => $emitir,
            "tokentel" => $tokentel,
            "rsi" => 0,
            "act" => 0
        ];
    }   

    public function getAlgResp(){
        return $this->algResp;
    }

    private function array_key_last(array $arr) {
        $i = 0;
        foreach($arr as $key  => $unused) {
            $i = $i +1;
            //return $key;
        }
        return $key;
    }
    private function array_key_first(array $arr) {
        foreach($arr as $key => $unused) {
            return $key;
        }
        return NULL;
    }    
    private function printLog($from){
        $date = (new \DateTime('now'))->format('Y-m-d H:i:s');
        print( "Now: " . $date . "|" . $from );
    }
    private function setTokenTel($json,$bands,$vai,$rsi,$accion, $act){
        $fechaope = (new \DateTime(date('m/d/Y H:i:s',intval($json["openTime"])/1000)))->format('Y-m-d H:i:s');
        $fechaclo = (new \DateTime(date('m/d/Y H:i:s',intval($json["closeTime"])/1000)))->format('Y-m-d H:i:s');
        $interarry = "[" . $vai["interval"]  . "]";
        $tokentel = [
            "fechaope" => $fechaope,
            "fechaclo" => $fechaclo,
            "support" => $bands['supo'],
            "resistance" => $bands['resi'],   
            "potp" => 0,
            "posl" => 0,
            "rsi" => $rsi,
            "act" => $act,
            "close" => $json['close'],
            "open" => $json['open'],
            "interval" => $interarry,
            "interlow" => $vai["interval"],
            "trail" => $bands['trai'],
            "trend" => $bands['tren'],
            "accion" => $accion,
            "may" => '',
            "tim" => $json["closeTime"]/1000,
            "init" => 0,
            'timezone' => $this->config['timezone'],
            'locale' => $this->config['locale'],
            'telusers' => $this->config['telusers'],
            'algorit' => $this->config['algorit'],
            "resCV" => []
        ];
        return $tokentel;
    }
    private function testTpSl($price,$atrlast){
        print("atrlast:{$atrlast} ftp:{$this->FTP} fsl:{$this->FSL}" .chr(10));
        //Test de ATR
        //calculos por ATR para compras
        $tp = ($price + ($this->FTP * $atrlast));
        $sl = ($price - ($this->FSL * $atrlast));
        $potp = round(((100 - ($tp * 100)/$price)*-1),2);
        $posl = round(((100 - ($sl * 100)/$price)*1),2);
        $this->printLog("Tp/Sl - compra:{$price} tp:{$tp} sl:{$sl} portp:" . $potp . " porsl:" . $posl . chr(10));
        //calculos por ATR para ventas
        $tp = ($price - ($this->FTP * $atrlast));
        $sl = ($price + ($this->FSL * $atrlast));
        $potp = round(((100 - ($tp * 100)/$price)*1),2);
        $posl = round(((100 - ($sl * 100)/$price)*-1),2);
        $this->printLog("Tp/Sl - venta:{$price} tp:{$tp} sl:{$sl} portp:" . $potp . " porsl:" . $posl . chr(10));
        //Test de Soporte/Resistencia
        print("soporte:{$bands['s1']} resistencia:{$bands['r1']}" .chr(10));
        //calculos por SR para compras
        $tp = $bands['r1'] - 0.005; 
        $sl = $bands['s1'] - 0.005;
        $potp = round(((100 - ($tp * 100)/$price)*-1),2);
        $posl = round(((100 - ($sl * 100)/$price)*1),2);
        $this->printLog("Tp/Sl - compra:{$price} tp:{$tp} sl:{$sl} portp:" . $potp . " porsl:" . $posl . chr(10));
        //calculos por SR para ventas
        $tp = $bands['s1'] + 0.005;
        $sl = $bands['r1'] + 0.005;
        $potp = round(((100 - ($tp * 100)/$price)*1),2);
        $posl = round(((100 - ($sl * 100)/$price)*-1),2);
        $this->printLog("Tp/Sl - venta:{$price} tp:{$tp} sl:{$sl} portp:" . $potp . " porsl:" . $posl . chr(10));        
    }
}
