<?php
namespace App;
use App\ATRCalculator;
class PivotCalculator {
    private $lbl;
    private $lbr;

    public function __construct(int $LBL, int $LBR) {
        $this->lbl = $LBL;
        $this->lbr = $LBR;
    }

    private function checkhl(array $dataBack, array $dataForward, string $ref, string $hl): bool {
        if (empty($dataBack)) return false;
        $ref = $ref;
        $checkType = strtolower($hl);
        //$dataBackWithoutLast = array_slice($dataBack, 0, -1);
        if ($checkType === 'high') {
            $maxBack = $dataBack ? max($dataBack) : $ref;
            $maxForward = $dataForward ? max($dataForward) : $ref;
            return $ref >= $maxBack && $ref > $maxForward;
        }
        
        if ($checkType === 'low') {
            $minBack = $dataBack ? min($dataBack) : $ref;
            $minForward = $dataForward ? min($dataForward) : $ref;
            return $ref <= $minBack && $ref < $minForward;
        }
        
        return false;
    }

    public function calculate_bands(?array $ph, ?array $pl, float $factor, int $pd, array $highs, array $lows, array $closes): array {
        $allPp = $ph ?? $pl ?? null;
        if (!$allPp) return [null, null];

        $center = [];
        $su = [];
        $re = [];
        $lastPp = 0;
        $init = true;
        foreach ($allPp as $i => $pp) {
            $currentPp = $ph[$i] ?? $pl[$i] ?? 0;
            $lastPp = $currentPp > 0 ? $currentPp : $lastPp;
            
            if ($init) {
                $center[$i] = $lastPp;
                $init = false;
            } else {
                $prevCenter = $center[$i-1] ?? $lastPp;
                $center[$i] = $lastPp > 0 ? ($prevCenter * 2 + $lastPp) / 3 : $prevCenter;
            }

            if ($i === 0) {
                $su[$i] = 0;
                $re[$i] = 0;
            } else {
                $su[$i] = $pl[$i] ?? $su[$i-1] ?? 0;
                $re[$i] = $ph[$i] ?? $re[$i-1] ?? 0;
            }
        }

        $atrCalculator = new ATRCalculator($pd);
        $atr = $atrCalculator->update($highs, $lows, $closes);
        
        $tUp = [];
        $tDown = [];
        $trend = [];
        $trailingSl = [];
        $atrCount = count($atr);

        foreach ($center as $i => $currentCenter) {
            if ($i >= $atrCount) break;
            
            $currentAtr = $atr[max($i, $pd)];
            $up = round($currentCenter - ($factor * $currentAtr), 3);
            $dn = round($currentCenter + ($factor * $currentAtr), 3);
            
            if ($i === 0) {
                $tUp[$i] = $up;
                $tDown[$i] = $dn;
                $trend[$i] = $closes[$i] >= $dn ? 1 : ($closes[$i] <= $up ? -1 : 0);
            } else {
                $prevTUp = $tUp[$i-1] ?? $up;
                $prevTDown = $tDown[$i-1] ?? $dn;
                
                $tUp[$i] = $closes[$i-1] > $prevTUp ? max($up, $prevTUp) : $up;
                $tDown[$i] = $closes[$i-1] < $prevTDown ? min($dn, $prevTDown) : $dn;
                
                $trend[$i] = $closes[$i] >= $prevTDown ? 1 
                            : ($closes[$i] <= $prevTUp ? -1 
                            : $trend[$i-1] ?? 0);
            }
            
            $trailingSl[$i] = ($trend[$i] ?? 0) === 1 ? $tUp[$i] : $tDown[$i];
        }

        return [$su, $re, $trend, $trailingSl, $closes];
    }

    private function calculatePivots(array $osc, string $highLow, bool $rsiMode = false): array {
        if($rsiMode){
            $pivots = array();
        }else{
            $pivots = array_fill(0, count($osc), 0.0);
        }
        $windowSize = $this->lbl + $this->lbr;
        $highLow = strtolower($highLow);
        for ($i = 0; $i < count($osc) - $this->lbr; $i++) {
            $muestr = array_slice($osc, $i, $this->lbl + $this->lbl + 1);
            $left = array_slice($muestr, 0, $this->lbl);
            $ref = array_slice($muestr, $this->lbl, 1)[0];
            $right = array_slice($muestr, $this->lbl +1, $this->lbr);
            $pivotIndex = $i + $this->lbl;
            if ($this->checkhl($left, $right, $ref, $highLow)) {
                if($rsiMode){
                    $pivots[] = $ref;
                }else{
                    $pivots[$pivotIndex] = $osc[$pivotIndex];
                }
            }
        }
        
        return $pivots;
    }

    public function pivotRSI(array $osc, string $highLow): array {
        return $this->calculatePivots($osc, $highLow, true);
    }

    public function pivot(array $osc, string $highLow): array {
        return $this->calculatePivots($osc, $highLow);
    }
}