#!/bin/bash

# Nombre del proceso de tu aplicación
NOMBRE_PROCESO="indexbi"

# Ruta completa al ejecutable de tu aplicación
RUTA_APLICACION=" php /var/www/html/bitrade/indexbi.php "

# Ruta al script PHP para enviar notificaciones
RUTA_PHP_NOTIFICACION="/var/www/html/bitrade/notifsiexec.php"
#date -d 'TZ="America/Argentina/Buenos_Aires" 
DIA=`date +"%d/%m/%Y"`
HORA=`date +"%H:%M"`

# Verificar si el proceso está en ejecución
if pgrep -f "$NOMBRE_PROCESO" > /dev/null; then
  echo "$DIA - $HORA:el bot $NOMBRE_PROCESO se está ejecutando."
else
  MESSAGE="$DIA - $HORA: El bot $NOMBRE_PROCESO NO se está ejecutando. Reiniciando..." 
  #MESSAGE="$MESSAGE La aplicación $NOMBRE_PROCESO se ha reiniciado."
  #echo "La aplicación $NOMBRE_PROCESO NO se está ejecutando. Reiniciando..."
  echo $MESSAGE
  # Reiniciar la aplicación
  cd /var/www/html/bitrade
  nohup php indexbi.php > indexbi.out &
  # Enviar notificación vía PHP
  php $RUTA_PHP_NOTIFICACION "$MESSAGE"
fi