<?php
include './vendor/autoload.php';
$settings = require 'settings.php';
use App\ValidResponse;
use App\FuTrperm;
use App\WebSocketApi;
use GuzzleHttp\Client;
use Psr\Http\Message\ResponseInterface;
use GuzzleHttp\Exception\RequestException;
use App\Exceptions\ResponseApiException;
use Ratchet\Client\WebSocket;
use React\EventLoop\LoopInterface;
$configt = $settings['settings']['config'];
$config = [
    'base_uri'        => 'https://fapi.binance.com/', 
    'timeout' => 30,
    'connect_timeout' => 30,
    'http_errors'     => true,
    'verify'          => 1,
    'skipVerifyTls' => false
];

$auth = new FuTrperm($configt);
$websocket = new WebSocketApi($configt);
$ressock = [];
$client = new Client($config);
$server["endpoint"] =  'wss://fstream.binance.com/ws/';
$server["pingInterval"] = 3;
$server['maePrice'] = 0;
$server['countup'] = 1800;
$server['slp'] = false;
$server['isprice'] = false;
$server['symbol'] = 'DOTUSDT';
$orders = [
    'resulttp' => 'NEW',
    'istp' => false,
    'statustp' => false, 
    'resultsl' => 'NEW',
    'issl' => false,                   
    'statusma' => -1,
    'statussl' => false, 
    'camsm' => 0,
    'done' => true
];
$query = '?' . http_build_query(['connectId' => uniqid('', true)], 'DOTUSDT');
$headers = $auth->getHeaders();
try{
    $url = $auth->signature('/fapi/v1/listenKey', 'POST', []);

    $result = $client->request('POST', $url, [
        'headers' => $headers
    ]);
    $mustresp = new ValidResponse();
    $datakey = $mustresp->getApiData(true, $result);
    $listenKey = '';
    
    if (array_key_exists('listenKey', $datakey )) {

        $listenKey = $datakey['listenKey'];
        //$url = sprintf('%s%s%s', $server['endpoint'] . $listenKey, strpos($server['endpoint'], '?') === false ? '?' : '&', http_build_query($params));                       
        $server['connectUrl'] = $server['endpoint'] . $listenKey;
        $server['connectId'] = uniqid('', true);
        $server['listenKey'] = $listenKey;
        $sockapi = $websocket;
        $sockapi->getWsMessage($server, function (array $message, WebSocket $ws, LoopInterface $loop) use ($orders,$ressock) {
            $type = $message['e'];
            switch ($type) {
                case 'ORDER_TRADE_UPDATE':
                    $otu = $message['o'];
                    $line = sprintf('%s%s%s%s', "ORDER: side: {$otu['S']}", " id: {$otu['c']}", " type: {$otu['o']}", " status: {$otu['x']}", " qty: {$otu['q']}", " price: {$otu['sp']}");
                    print($line . chr(10));
                    if($otu['o'] === 'TAKE_PROFIT_MARKET' and $otu['X'] !== 'NEW'){
                        $orders['resulttp'] =  $otu['X'];
                        $orders['statustp'] =  true;
                        if($otu['X'] === 'FILLED'  or $otu['X'] === 'EXPIRED'){
                            $orders['istp'] = true;
                            $orders['issl'] = false;
                            $orders['resultsl'] =  'CANCELED';
                        }
                    }elseif($otu['o'] === 'STOP_MARKET' and $otu['X'] !== 'NEW'){
                        $orders['resultsl'] =  $otu['X'];
                        $orders['statussl'] =  true;
                        if($otu['X'] === 'FILLED' or $otu['X'] === 'EXPIRED'){
                            $orders['issl'] = true;
                            $orders['istp'] = false;
                            $orders['resulttp'] =  'CANCELED';
                        }
                    }elseif($otu['o'] === 'MARKET' and $otu['X'] === 'NEW'){
                        print('********* START ORDER *********' .chr(10));
                    }
                    break;
                case 'ACCOUNT_UPDATE':
                    print('no es error vvvvvvvvvvvvvvvvvvvvvv' .chr(10));
                    var_dump($message);
                    print('no es error ^^^^^^^^^^^^^^^^^^^^^^' .chr(10));
                    $plen = count($message['a']['P']);
                    if($plen > 0){
                        $acu = $message['a']['P'][0];
                        if(array_key_exists("pa", $acu)){
                            $line = sprintf('%s%s%s%s', "ACCOUNT qty: {$acu['pa']}", " price: {$acu['ep']}", " PnL: {$acu['up']}", " Isolated Wallet: {$acu['iw']}");
                            print($line . chr(10));                        
                            $orders['statusma'] =  intval($acu['pa']);
                        }else{
                            print('no existe pa' .chr(10));
                            var_dump($message);
                        }
                    }else{
                        print('plen <=0' .chr(10));
                        var_dump($message);
                    }

                    break;	 
            }
            if($orders['statusma'] === 0) {                    
                print('Proc end in stop order: tp: ' . $orders['resulttp'] . ' sl: ' . $orders['resultsl'] . chr(10));
                print('RESULT ' .json_encode($orders) .chr(10));
                print('********** STOP ORDER **********' .chr(10));
                //$loop->cancelTimer($swresponse['pingInterval']);
                //$loop->stop();
            }            
        }, function (array $message, LoopInterface $loop) {
            print("prueba 1" .chr(10));
            var_dump($message);
        });
        print("prueba 2" .chr(10)); 
        var_dump($ressock);
    }
} catch (RequestException $exp) {
    print($exp->getMessage() .chr(10));
    $message = json_decode(json_decode($exp->getMessage(),true)['summary'], true);
    return $message;
} catch (ResponseApiException $exp) {
    print($exp->getMessage() .chr(10));
    return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
} 
