<?php
include './vendor/autoload.php';
$settings = require 'settings.php';
$config = $settings['settings']['config'];
use App\ResponseApi;
use App\SetOrdersBuySel;
use App\PivotCalculator;
$apiResponse = new ResponseApi($config);
$apiSetOrdersBuySel = new SetOrdersBuySel($config);
$pivot_calculator = new PivotCalculator(5,5);
$symbol = 'DOTUSDT';
$currency = 'USDT';
$closes = [];
$highs = [];
$lows = [];
$rsiLBR = [];
$pd = 14;
function array_key_last(array $arr) {
    $i = 0;
    foreach($arr as $key  => $unused) {
        $i = $i +1;
        //return $key;
    }
    return $key;
}
function array_key_first(array $arr) {
    foreach($arr as $key => $unused) {
        return $key;
    }
    return NULL;
}
function checkHighOrLow($candlestickList, $candlestick, $numOfCandles, $currentCandleIndex, $checkForHigh) {

    for ($i = 0; $i < $numOfCandles; $i++) {
        $afterCandleStick  = $candlestickList[$currentCandleIndex + $i+1];
        $beforeCandleStick = $candlestickList[$currentCandleIndex - $i - 1];
        if($checkForHigh) {
            if ($afterCandleStick > $candlestick){
                return false;
            }
            if ($beforeCandleStick > $candlestick){
                return false;
            }
        }else{
            if($afterCandleStick < $candlestick){
                return false;
            }
            if($beforeCandleStick < $candlestick){
                return false;
            }
        }
    }
    return true;
}
$json = $apiResponse->getKlines('15m');
for ($x = 0; $x < count($json); $x++) {
    array_push($closes, $json[$x]["close"]);
}
$lengthForCheck = 1;
$numOfCandles = array_key_last($closes);
for($i = $lengthForCheck; $i < ($numOfCandles - $lengthForCheck); $i++)
{
    $currentCandle = $closes[$i];
    print("i:{$i} cC:{$currentCandle} nC:{$numOfCandles}" .chr(10));
    if(checkHighOrLow($closes,$currentCandle,$numOfCandles,$i,true)){
        $highs[$i] = $closes[$i];
    }
    if(checkHighOrLow($closes,$currentCandle,$numOfCandles,$i,false)){
        $lows[$i] = $closes[$i];
    }
}
var_dump($highs);