<?php
include './vendor/autoload.php';
$settings = require 'settings.php';
$config = $settings['settings']['config'];
use App\ResponseApi;
use App\SetOrdersBuySel;
$apiResponse = new ResponseApi($config);
$symbol = 'DOTUSDT';
$currency = 'USDT';
$interval = '15m';
function pivotHigh(array $data, int $period) {
    $ph = [];
    $length = count($data) - $period;
    if ($length < $period) {
        return null; // Not enough data
    }
    $highs = [];
    for ($i = 0; $i <= $length - $period; $i++) {
        print("data i[{$i}]:" . $data[$i] . chr(10));
        $isPivotHigh = true;
        for ($j = $i + 1; $j <= $i + $period; $j++) {
            print("data j[{$j}]:" . $data[$j]. chr(10));
            if ($data[$j] >= $data[$i]) {
                print("data[{$j}]:" . $data[$j] . "  >= data[{$i}]:" . $data[$i] . chr(10));
                $isPivotHigh = false;
                break;
            }
        }
        if ($isPivotHigh) {
            print("data[{$j}]:" . $data[$j] . "  < data[{$i}]:" . $data[$i] . chr(10));
            array_push($ph, $data[$i]);
            //return $data[$i]['high']; // Return the pivot high value
        }
    }
    return $ph; 
}

function pivotLow(array $data, int $period) {
    $pl = [];
    $length = count($data) -2;
    if ($length < $period) {
        return null; // Not enough data
    }

    for ($i = 0; $i <= $length - $period; $i++) {
        $isPivotLow = true;
        for ($j = $i + 1; $j <= $i + $period; $j++) {
            if ($data[$j]['low'] <= $data[$i]['low']) {
                $isPivotLow = false;
                break;
            }
        }
        if ($isPivotLow) {
            array_push($pl, $data[$i]['low']);
            //return $data[$i]['low']; // Return the pivot low value
        }
    }
    return $pl; 
}

// Example usage
$json = $apiResponse->getKlines($interval);
$data = [10.0, 12.5, 11.0, 15.0, 14.5, 16.0, 13.0]; // Example data
$period = 2;

$ph = pivotHigh($data, $period);
//$pl = pivotLow($json, $period);
for ($i = 0; $i < count($ph); $i++) {
    echo "Pivot High: " . $ph[$i] . "\n";
}
//for ($i = 0; $i < count($pl); $i++) {
    //echo "Pivot Low: " . $pl[$i] . "\n";
//}


?>