<?php
include './vendor/autoload.php';
$settings = require 'settings.php';
$config = $settings['settings']['config'];
use App\ResponseApi;
use App\SetOrdersBuySel;
$apiResponse = new ResponseApi($config);
$symbol = 'DOTUSDT';
$currency = 'USDT';
$interval = '15m';
// get getKlines
function getKlines($apiResponse, $interval){

    $json = $apiResponse->getKlines($interval);
    $numk = 0; //count($json);
    $pivResp = [];
    $ppcal = [];
    $idx = count($json) - 0;
    for ($x = 1; $x <= $idx; $x++) {
        $pp = round((($json[$x-1]["high"] + $json[$x-1]["close"] + $json[$x-1]["low"]) / 3), 3);
        $range = round(($json[$x-1]["high"] - $json[$x-1]["low"]),3);
        $clotim = $json[$x-1]['closeTime'] + 1;
        $fechaclo = (new \DateTime(date('m/d/Y H:i:s',intval($clotim)/1000)))->format('Y-m-d H:i:s');     
        $range = round(($json[$x-1]["high"] - $json[$x-1]["low"]),3);
        $ppcal = [
            'optime' => $fechaclo,
            'pp' => $pp,
            'high' => $pp,
            'low' => $pp,
            'close' => $json[$x-1]["close"],
            'r1' => round(($pp * 2) - $json[$x-1]["low"],3),
            'r2' => round($pp + $range,3),
            'r3' => round(($pp + ($range * 2)),3),
            'r4' => round(($pp + ($range * 3)),3),
            's1' => round((($pp * 2) - $json[$x-1]["high"]), 3),
            's2' => round($pp - $range,3),
            's3' => round(($pp - ($range * 2)),3),
            's4' => round(($pp - ($range * 3)),3),
        ];

        array_push($pivResp, $ppcal);
    }
    print_r($pivResp);
    print(chr(10));
    return($pivResp);
}
function checkhl($data_back, $data_forward, $hl) {
    if ($hl == 'high' || $hl == 'High') {
        $ref = $data_back[count($data_back)-1];
        for ($i = 0; $i < count($data_back)-1; $i++) {
            if ($ref < $data_back[$i]) {
                return 0;
            }
        }
        for ($i = 0; $i < count($data_forward); $i++) {
            if ($ref <= $data_forward[$i]) {
                return 0;
            }
        }
        return 1;
    }
    if ($hl == 'low' || $hl == 'Low') {
        $ref = $data_back[count($data_back)-1];
        for ($i = 0; $i < count($data_back)-1; $i++) {
            if ($ref > $data_back[$i]) {
                return 0;
            }
        }
        for ($i = 0; $i < count($data_forward); $i++) {

            if ($ref >= $data_forward[$i]) {
                return 0;
            }
        }
        return 1;
    }
}
function pivotClassic($osc, $highlow) {
    $mxmicl = [];
    $maxpp = max($osc["pp"]); 
    $minpp = min($osc["pp"]); 
    for ($x = 0; $x <= count($osc["pp"]); $x++) {
        if($osc["pp"][$x] === $maxpp){
            print("maxpp:{$maxpp} in {$x}" .chr(10));
            break;
        }
    }
    $desde = $x + 1;
    $hasta = count($osc['pp']) - 1;
    $retval = [  
        "clo" => $osc["closes"][$x],   
        "max" => $maxpp,             
        "min" => $minpp,          
    ];
    array_push($mxmicl,$retval);
    while($desde <= $hasta)
    {
        $varmax = [];
        for ($x = $desde; $x <= $hasta; $x++) {
            array_push($varmax, $osc["pp"][$x]);
        }
        if(count($varmax) > 0){
            $maxvv = max($varmax); 
            $minvv = min($varmax);
            for ($x = $desde; $x < $hasta; $x++) {
                if($osc["pp"][$x] === $maxvv){
                    break;
                }
            }
            $retval = [  
                "clo" => $osc["closes"][$x],   
                "max" => $maxvv,             
                "min" => $minvv,          
            ];
            array_push($mxmicl,$retval);
            $desde = $x + 1;
            if( $desde > $hasta){
                break;
            }
        }else{
            break;
        }

    } 
    return $mxmicl;        
}
function pivot($osc, $LBL, $LBR, $highlow) {
    $left = array();
    $right = array();
    $pivots = array();
    $topen = array();
    for ($i = 0; $i < count($osc); $i++) {
        $pivots[$i] = 0.000;
        $topen[$i] = '';
        if ($highlow == 'high' || $highlow == 'High'){
            if ($i < $LBL + 1) {
                $left[] = $osc[$i]['high'];
            }
            if ($i > $LBL) {
                $right[] = $osc[$i]['high'];
            }

            if ($i > $LBL + $LBR) {
                $left[] = $right[0];
                array_shift($left);
                array_shift($right);
                if (checkhl($left, $right, $highlow)) {
                    $pivots[$i - $LBR] = $osc[$i - $LBR]['high'];
                    $topen[$i - $LBR] = $osc[$i - $LBR]['optime'];
                }
            }

        }else{
            if ($i < $LBL + 1) {
                $left[] = $osc[$i]['low'];
            }
            if ($i > $LBL) {
                $right[] = $osc[$i]['low'];
            }
            if ($i > $LBL + $LBR) {
                $left[] = $right[0];
                array_shift($left);
                array_shift($right);
                if (checkhl($left, $right, $highlow)) {
                    $pivots[$i - $LBR] = $osc[$i - $LBR]['low'];
                    $topen[$i - $LBR] = $osc[$i - $LBR]['optime'];
                }
            }
        }

    }
    $data =[
        'pivots' => $pivots,
        'topen' => $topen
    ];
    return $data;
}
// **************************** para ejecutar procesos desde de aqui *****************************************

$date = (new DateTime('now'));
print('Ahora:' . $date->format('Y-m-d H:i:s') . chr(10));
$json = getKlines($apiResponse, $interval);
$lbl = 5;
$lbr = 5;
$datal = pivot($json, $lbl, $lbr, 'low');
$datah = pivot($json, $lbl, $lbr, 'high');
$pivots_low = $datal['pivots'];
$pivots_high = $datah['pivots'];
$topenl = $datal['topen'];
$topenh = $datah['topen'];
for ($i = 0; $i < count($pivots_low); $i++) {
    if($pivots_high[$i] > 0){
        print("date:{$topenh[$i]} high:{$pivots_high[$i]}" . chr(10));
    }elseif($pivots_low[$i] > 0){
        print("date:{$topenl[$i]} low:{$pivots_low[$i]}" . chr(10));
    }

}
// **************************** para ejecutar procesos hasta de aqui *****************************************


