<?php
include './vendor/autoload.php';
$settings = require 'settings.php';
$config = $settings['settings']['config'];
use App\ResponseApi;
use App\SetOrdersBuySel;
$apiResponse = new ResponseApi($config);
$symbol = 'DOTUSDT';
$currency = 'USDT';
$interval = '15m';
function checkhl($data_back, $data_forward, $hl) {
    if ($hl == 'high' || $hl == 'High') {
        $ref = $data_back[count($data_back)-1];
        for ($i = 0; $i < count($data_back)-1; $i++) {
            if ($ref < $data_back[$i]) {
                return 0;
            }
        }
        for ($i = 0; $i < count($data_forward); $i++) {
            if ($ref <= $data_forward[$i]) {
                return 0;
            }
        }
        return 1;
    }
    if ($hl == 'low' || $hl == 'Low') {
        $ref = $data_back[count($data_back)-1];
        for ($i = 0; $i < count($data_back)-1; $i++) {
            if ($ref > $data_back[$i]) {
                return 0;
            }
        }
        for ($i = 0; $i < count($data_forward); $i++) {
            if ($ref >= $data_forward[$i]) {
                return 0;
            }
        }
        return 1;
    }
}

function pivot($osc, $LBL, $LBR, $highlow) {
    $left = array();
    $right = array();
    $pivots = array();
    for ($i = 0; $i < count($osc); $i++) {
        $pivots[$i] = 0.000;
       if ($highlow == 'high' || $highlow == 'High'){
            if ($i < $LBL + 1) {
                $left[] = $osc[$i]['high'];
            }
            if ($i > $LBL) {
                $right[] = $osc[$i]['high'];
            }
            if ($i > $LBL + $LBR) {
                $left[] = $right[0];
                array_shift($left);
                array_shift($right);
                if (checkhl($left, $right, $highlow)) {
                    $pivots[$i - $LBR] = $osc[$i - $LBR]['high'];
                }
            }
        }else{
            if ($i < $LBL + 1) {
                $left[] = $osc[$i]['low'];
            }
            if ($i > $LBL) {
                $right[] = $osc[$i]['low'];
            }
            if ($i > $LBL + $LBR) {
                $left[] = $right[0];
                array_shift($left);
                array_shift($right);
                if (checkhl($left, $right, $highlow)) {
                    $pivots[$i - $LBR] = $osc[$i - $LBR]['low'];
                }
            }
        }

    }
    return $pivots;
}
// **************************** para ejecutar procesos desde de aqui *****************************************

$date = (new DateTime('now'));
print('Ahora:' . $date->format('Y-m-d H:i:s') . chr(10));


$json = $apiResponse->getKlines($interval);
$lbl = 5;
$lbr = 5;
$pivots_low = pivot($json, $lbl, $lbr, 'low');
$pivots_high = pivot($json, $lbl, $lbr, 'high');

for ($i = 0; $i < count($pivots_low); $i++) {
    if($pivots_high[$i] > 0){
        print("high:{$pivots_high[$i]}" . chr(10));
    }elseif($pivots_low[$i] > 0){
        print("low:{$pivots_low[$i]}" . chr(10));
    }

}

 // **************************** para ejecutar procesos hasta de aqui *****************************************


