<?php
include './vendor/autoload.php';
//include  './app/src/OrdersModel.php';
$settings = require 'settings.php';
$config = $settings['settings']['config'];
$order = $settings['settings']['order'];
use App\ResponseApi;
use App\SetOrdersBuySel;
use App\RsiCalculator;
$apiResponse = new ResponseApi($config);
$apiSetOrdersBuySel = new SetOrdersBuySel($config);
$rsiCalculator = new RsiCalculator();
$symbol = 'DOTUSDT';
$currency = 'USDT';
$interval = "15m";
$pd = 14;
// get orders information  
$sArgs = json_decode(base64_decode($argv[1]), true);
$maorder = $sArgs['maorder'];
$inrsi = $sArgs['inrsi'];
$inact = $sArgs['inact'];
$beprice = $sArgs['breakevenprice'];
//$maorder = json_decode(base64_decode($argv[1]), true);
//$inrsi = json_decode(base64_decode($argv[2]), true);
//$inact = json_decode(base64_decode($argv[3]), true);
$side = $maorder['side'];
$maorder['newClientOrderId'] = $maorder["newClientOrderId"] . "D";
$maorder['side'] = $maorder["side"] === "BUY"?"SELL":"BUY";
$maorder['reduceOnly'] = 'true';

function getTimeToSleep($microt, $intervalo){
    $sleep = 60;
    $date = (new \DateTime(date('m/d/Y H:i:s',$microt)));
    $date->setTimeZone(new \DateTimeZone("Europe/Lisbon"));
    $h = ($date)->format('H');
    $m = ($date)->format('i');
    $rest = ($m / $intervalo) - floor($m / $intervalo);
    $next = $intervalo - round($rest * $intervalo,0);
    $sleep = $next * 60;
    print($date->format('Y-m-d H:i:s') . ' esperando:' . $sleep / 60 . chr(10));
    return $sleep;
}
function getStatus($apiResponse,$symbol){
    $status = 0;
    $times = 0;
    $initialm = 0;
    while(true){
        $result = $apiResponse->getAccount(['symbol' => $symbol], $times);
        if (array_key_exists("totalInitialMargin", $result)) {
            $positions = $result['positions'];
            foreach($positions as $posit)  {
                if($posit['symbol'] === $symbol){
                    if(floatval($posit['initialMargin']) > 0){
                        $status = 1;
                        $initialm = floatval($posit['initialMargin']);
                    }                
                }
            }                             
            break;
        }else{
            $times = $times + 1;
            if ($times > 5){
                $status = 0;
                $initialm = 0;
                break;
            }
        }
    }
    return $status;
}
function getRsiMacd($apiResponse,$rsiCalculator,$interval){
    $highs = [];
    $lows = [];
    $closes = [];
    $json = $apiResponse->getKlines($interval);
    for ($x = 0; $x < count($json); $x++) {
        array_push($highs, $json[$x]["high"]);
        array_push($lows, $json[$x]["low"]);
        array_push($closes, $json[$x]["close"]);
    }
    $close = $closes[count($closes) - 1];
    $rsiCalculator->setRsiMacd($highs, $lows, $closes);
    $rsimacdp = $rsiCalculator->getRsiMacdParm();
    return ['rsimacd' => $rsimacdp, 'close' => $close];
}
function delAllOrders($apiResponse,$symbol,$maorder){
    $times = 0;
    $alldel = false;
    while(true){
        $result = $apiResponse->cancelAllOrders(['symbol' => $symbol],$times);
        if (array_key_exists("code", $result)) {
            if ($result['code'] === 200){
                $alldel = true;
                break;
            }
        }else{
            $times = $times + 1;
            if ($times > 5){
                $alldel= false;
                print('error - cancel all orders' .chr(10)); 
                break;
            } 
        }

    }
    if($alldel){
        $result = createMaOrderForDel($apiResponse,$symbol,$maorder);
        unset($maorder['reduceOnly']);
        $alldel = $result;
    }
    return $alldel;
}
function createMaOrderForDel($apiResponse,$symbol,$maorder){
    $times = 0;
    $result = false;
    while(true){
        $result = $apiResponse->createOrder($maorder, $times);
        if (array_key_exists("orderId", $result)) {
            print('para cancelarId: ' . $result['orderId'] . chr(10));
            $result = true;
            break;
        }else{
            $times = $times + 1;
            if (array_key_exists("code", $result)) {
                if($result['code'] === -2019 or $result['code'] === -2022 or $result['code'] === -1102){
                    if($maorder['quantity'] <= 0.8){
                        $result = false;
                        break;
                    }else{
                        $maorder['quantity'] = $maorder['quantity'] - 0.1;
                        print("cantidad actual: {$maorder['quantity']}" .chr(10));
                    }

                }else{
                    if ($times > 5){
                        print('error - crear maorder for del' .chr(10)); 
                        $result = false;
                        break;
                    }
                }
            }else{
                if ($times > 5){
                    print('error - crear maorder for del' .chr(10));
                    $result = false;
                    break;
                }

            }
        }
    }
    return $result;
}
function printLog($from){
    $date = (new \DateTime('now'))->format('Y-m-d H:i:s');
    print( "Now: " . $date . "|" . $from );
}
// **************************** para ejecutar procesos desde de aqui *****************************************
$date = (new DateTime('now'));
print('***** Ahora:' . $date->format('Y-m-d H:i:s') . '*****' .chr(10));
print("inact:{$inact}" .chr(10));
while(true)
{
    $status = getStatus($apiResponse, $symbol, $currency);
    //print("status:{$status}" .chr(10));
    if($status === 0){
        $microt = intval(round(microtime(true)));
        $intervalo = 1; 
        sleep(getTimeToSleep($microt, $intervalo));
        //sleep(60);
    }else{
        $closep = 0;
        $result = getRsiMacd($apiResponse,$rsiCalculator,$interval);
        $rsimacdp = $result['rsimacd'];
        $close = $result['close'];
        $difprice = 
        print_r($rsimacdp);
        print("close:{$close} beprice:{$beprice}" . chr(10));
        if($close <= $beprice){
            $closep = 7;
        }else{
            switch($inact){
                case 1:
                    if($rsimacdp['isRsiOvSell'] === 0 or $rsimacdp['isMacdBu'] === 0){
                        $closep = 1;
                    }
                    break;
                case 2:
                    if($rsimacdp['isRsiOvBuy'] === 0 or $rsimacdp['isMacdBu'] === 1){
                        $closep = 2;
                    }                
                    break;
                case 3:
                    if($rsimacdp['isMacdBu'] === 0  or $rsimacdp['rsiUp'] === 0 or $rsimacdp['rsi'] < $rsimacdp['rsian']){
                        $closep = 3;                
                    }
                    break;
                case 4:
                    if($rsimacdp['isMacdBu'] === 1  or $rsimacdp['rsiDo'] === 0 or $rsimacdp['rsi'] > $rsimacdp['rsian']){
                        $closep = 4;
                    }
                    break;
                case 5:
                    if($rsimacdp['isMacdBu'] === 0 or $rsimacdp['rsiUp'] === 0 or $rsimacdp['macUp'] === 0 and $rsimacdp['rsi'] < $rsimacdp['rsian']){
                        $closep = 5;                
                    }
                    break;
                case 6:
                    if($rsimacdp['isMacdBu'] === 1 or $rsimacdp['rsiDo'] === 0 or $rsimacdp['macDo'] === 0 or $rsimacdp['rsi'] > $rsimacdp['rsian']){
                        $closep = 6;
                    }
                    break;                
            }
        }
        if($closep > 0){
            $alldel = delAllOrders($apiResponse, $symbol, $maorder);
            $common = "side init: {$side} close : {$closep}";
            if($alldel){
                printLog("close order id:{$maorder['newClientOrderId']} side:{$maorder['side']} qty:{$maorder['quantity']} closep:{$closep}" .chr(10));
                $apiSetOrdersBuySel->sendAlertOut(7, $common, "ordenes cerradas y posición puesta a 0");
            }else{
                $apiSetOrdersBuySel->sendAlertOut(7, $common, "**** Error ****" . "\n" . " No ha sido posible cerrar orden ");
            }
            exit;
        }
        //$microt = intval(round(microtime(true)));
        //sleep(getTimeToSleep($microt, $intervalo));
        //$intervalo = 0; 
        sleep(10);
    }
}
 // **************************** para ejecutar procesos hasta de aqui *****************************************
