<?php
include './vendor/autoload.php';
//include  './app/src/OrdersModel.php';
$settings = require 'settings.php';
$config = $settings['settings']['config'];
$order = $settings['settings']['order'];
use App\ResponseApi;
use App\SetOrdersBuySel;
$apiResponse = new ResponseApi($config);
$apiSetOrdersBuySel = new SetOrdersBuySel($config);
$symbol = 'DOTUSDT';
$currency = 'USDT';
$interval = "15m";
$pd = 14;
$maorder = [
    'newClientOrderId' => uniqid() . 'LID',
    'side'      => '',
    'quantity'  => '', 
    'workingType' => 'CONTRACT_PRICE',
    'recvWindow' => '5000',
    'symbol'    => (string)$symbol,
    'type'      => 'MARKET',
    'reduceOnly' => 'true',
    //'closePosition'  => 'true'
    
];
//$order['newClientOrderId'] = uniqid();
//$maorder = (array) new \OneMaOrder($order);

// get orders information  
function getTimeToSleep($microt, $intervalo){
    $sleep = 60;
    $date = (new \DateTime(date('m/d/Y H:i:s',$microt)));
    $date->setTimeZone(new \DateTimeZone("Europe/Lisbon"));
    $h = ($date)->format('H');
    $m = ($date)->format('i');
    $intser = array(0 => 15, 1 => 30, 2 => 45, 3 => 60);
    switch ($m) {
        case $m < $intser[0]:
            $microt = $microt + ((($intser[0] - $m) + $intervalo) * 60);
            $sleep = (($intser[0] - $m) + $intervalo) * 60;
            break; 
        case $m < $intser[1]:
            $microt = $microt + ((($intser[1] - $m) + $intervalo) * 60);
            $sleep = (($intser[1] - $m) + $intervalo)* 60;
            break;   
        case $m < $intser[2]:
            $microt = $microt + ((($intser[2] - $m) + $intervalo) * 60);
            $sleep = (($intser[2] - $m) + $intervalo) * 60;
            break; 
        default:      
            $microt = $microt + ((($intser[3] - $m) + $intervalo) * 60);
            $sleep = (($intser[3] - $m) + $intervalo) * 60;
            break;                                   
    }
    //print($date->format('Y-m-d H:i:s') . ' esperando:' . $sleep / 60 . chr(10));
    return $sleep;
} 
function openOrders($apiResponse, $symbol){
    $parameters['symbol'] = 'DOTUSDT';
    $response = $apiResponse->getStopOrder(['symbol'  => $symbol], 0);
    if(count($response['items']) === 0){
      print('***** No hay ordenes abiertas *****' .chr(10));
    }
}
function compare_two($a, $b)
{
  // sort by time
  $retval = strnatcmp($a['time'], $b['time']);
  // if time are identical, sort by clientOrderId
  if(!$retval) $retval = strnatcmp($a['clientOrderId'], $b['clientOrderId']);
  return $retval;
}
function compare_orderId($a, $b)
{
    return strnatcmp($a['clientOrderId'], $b['clientOrderId']);
}
function allOrders($apiResponse, $symbol){
  $date = (new DateTime('now'));
  $h = ($date)->format('H');
  $m = ($date)->format('i');
  $tosub = new DateInterval('PT' . $h .'H' . $m . 'M'); // xH
  $date->sub($tosub);
  $from =  strtotime($date->format("Y-m-d H:i:s")) * 1000;
  $response = $apiResponse->getListOrder(['symbol' => $symbol], 0);
  usort($response, 'compare_two');
  $allmarket = array();
  foreach($response as $posit)  {
    $timems = $posit['time'];
    if($timems > $from){
      if ($posit['origType'] === "MARKET"){
        $posit['price'] = $posit['avgPrice'];
      }else{
        $posit['price'] = $posit['stopPrice'];
      } 
      if($posit['origType'] === 'MARKET'){
        $allmarket[] = $posit;
      }
    }  
  }
  $posit =  end($allmarket);
  $result = [
    "clientOrderId" => $posit['clientOrderId'],
    "side" => $posit['side'],
    "qty" => (string)$posit['origQty']
  ];
  return $result;
}
function getStatus($apiResponse,$symbol){
$status = 0;
$times = 0;
$initialm = 0;
while(true){
    $result = $apiResponse->getAccount(['symbol' => $symbol], $times);
    if (array_key_exists("totalInitialMargin", $result)) {
        $positions = $result['positions'];
        foreach($positions as $posit)  {
            if($posit['symbol'] === $symbol){
                if(floatval($posit['initialMargin']) > 0){
                    $status = 1;
                    $initialm = floatval($posit['initialMargin']);
                }                
            }
        }                             
        break;
    }else{
        $times = $times + 1;
        if ($times > 5){
            $status = 0;
            $initialm = 0;
            break;
        }
    }
}
return $status;
}
function delAllOrders($apiResponse,$symbol,$maorder){
    $times = 0;
    $alldel = false;
    while(true){
        $result = $apiResponse->cancelAllOrders(['symbol' => $symbol],$times);
        if (array_key_exists("code", $result)) {
            if ($result['code'] === 200){
                $alldel = true;
                break;
            }
        }else{
            $times = $times + 1;
            if ($times > 5){
                $alldel= false;
                print('error - cancel all orders' .chr(10)); 
                break;
            } 
        }

    }
    if($alldel){
        $result = createMaOrderForDel($apiResponse,$symbol,$maorder);
        unset($maorder['reduceOnly']);
        $alldel = $result;
    }
    return $alldel;
}
function createMaOrderForDel($apiResponse,$symbol,$maorder){
    $times = 0;
    $result = false;
    while(true){
        $result = $apiResponse->createOrder($maorder, $times);
        if (array_key_exists("orderId", $result)) {
            print('para cancelarId: ' . $result['orderId'] . chr(10));
            $result = true;
            break;
        }else{
            $times = $times + 1;
            if (array_key_exists("code", $result)) {
                if($result['code'] === -2019 or $result['code'] === -2022 or $result['code'] === -1102){
                    if($maorder['quantity'] <= 0.8){
                        $result = false;
                        break;
                    }else{
                        $maorder['quantity'] = $maorder['quantity'] - 0.1;
                        print("cantidad actual: {$maorder['quantity']}" .chr(10));
                    }

                }else{
                    if ($times > 5){
                        print('error - crear maorder for del' .chr(10)); 
                        $result = false;
                        break;
                    }
                }
            }else{
                if ($times > 5){
                    print('error - crear maorder for del' .chr(10));
                    $result = false;
                    break;
                }

            }
        }
    }
    return $result;
}
function printLog($from){
    $date = (new \DateTime('now'))->format('Y-m-d H:i:s');
    print( "Now: " . $date . "|" . $from );
}
// **************************** para ejecutar procesos desde de aqui *****************************************
$date = (new DateTime('now'));
print('***** Ahora:' . $date->format('Y-m-d H:i:s') . '*****' .chr(10));
while(true)
{
    $status = getStatus($apiResponse, $symbol, $currency);
    //print("status:{$status}" .chr(10));
    if($status === 0){
        $microt = intval(round(microtime(true)));
        $intervalo = 0; 
        sleep(getTimeToSleep($microt, $intervalo));
        //sleep(60);
    }else{
        $dataorder = allOrders($apiResponse, $symbol);
        $side = $dataorder["side"];

        $closes = [];
        $json = $apiResponse->getKlines($interval);
        for ($x = 0; $x < count($json); $x++) {
            array_push($closes, $json[$x]["close"]);
        }
        $allrsi = trader_rsi($closes, $pd);
        $rsi = end($allrsi); // vela abierts
        //$rsi = prev($allrsi); //vela cerrada

        if(($rsi  <= 30 and $side === "BUY") or ($rsi  >= 70 and $side === "SELL")){
            $maorder['newClientOrderId'] = $dataorder["clientOrderId"] . "D";
            $maorder['side'] = $dataorder["side"] === "BUY"?"SELL":"BUY";
            $maorder['quantity'] = $dataorder["qty"];
            $alldel = delAllOrders($apiResponse, $symbol, $maorder);
            $common = "side init: {$side} RSI: {$rsi}";
            if($alldel){
                printLog("close order id:{$maorder['newClientOrderId']} side:{$maorder['side']} qty:{$maorder['quantity']} rsi:{$rsi}" .chr(10));
                $apiSetOrdersBuySel->sendAlertOut(7, $common, "ordenes cerradas y posición puesta a 0");
            }else{
                $apiSetOrdersBuySel->sendAlertOut(7, $common, "**** Error ****" . "\n" . " No ha sido posible cerrar orden ");
            }
//        }else{
//            print("side:{$side}  RSI: {$rsi}" . chr(10));
        }
        $microt = intval(round(microtime(true)));
        $intervalo = 0; 
        //sleep(getTimeToSleep($microt, $intervalo));
        sleep(60);
    }
}
 // **************************** para ejecutar procesos hasta de aqui *****************************************
