<?php
include './vendor/autoload.php';
include  './app/src/OrdersModel.php';
$settings = require 'settings.php';
$config = $settings['settings']['config'];
$order = $settings['settings']['order'];
use App\ResponseApi;
use App\SetOrdersBuySel;
$apiResponse = new ResponseApi($config);
$symbol = 'DOTUSDT';
$currency = 'USDT';
$maorder = [
    'newClientOrderId' => uniqid() . 'LID',
    'side'      => '',
    'quantity'  => '', 
    'workingType' => 'CONTRACT_PRICE',
    'recvWindow' => '5000',
    'symbol'    => (string)$symbol,
    'type'      => 'MARKET',
    'reduceOnly' => 'true',
    //'closePosition'  => 'true'
    
];
//$order['newClientOrderId'] = uniqid();
//$maorder = (array) new \OneMaOrder($order);

// get orders information  
function openOrders($apiResponse, $symbol){
    $parameters['symbol'] = 'DOTUSDT';
    $response = $apiResponse->getStopOrder(['symbol'  => $symbol], 0);
    if(count($response['items']) === 0){
      print('***** No hay ordenes abiertas *****' .chr(10));
    }else{
      foreach($response['items'] as $posit)  {
        $posit['updateTime'] = (new DateTime(date('m/d/Y H:i:s',intval($posit['updateTime'])/1000)))->format('Y-m-d H:i:s');
        print(
          "side':{$posit['side']} " .
          "stopPrice':{$posit['stopPrice']} " .
          "updateTime:{$posit['updateTime']} " .
          "type:{$posit['type']} " .
          chr(10));
      }
    }
}
function compare_two($a, $b)
{
  // sort by time
  $retval = strnatcmp($a['time'], $b['time']);
  // if time are identical, sort by clientOrderId
  if(!$retval) $retval = strnatcmp($a['clientOrderId'], $b['clientOrderId']);
  return $retval;
}
function compare_orderId($a, $b)
{
    return strnatcmp($a['clientOrderId'], $b['clientOrderId']);
}
function allOrders($apiResponse, $symbol, $data){
  $date = (new DateTime('now'));
  $h = ($date)->format('H');
  $h = 96;
  $m = ($date)->format('i');
  $tosub = new DateInterval('PT' . $h .'H' . $m . 'M'); // xH
  $date->sub($tosub);
  print("from:" . $date->format("Y-m-d H:i:s") .chr(10));
  $from =  strtotime($date->format("Y-m-d H:i:s")) * 1000;

  $response = $apiResponse->getListOrder(['symbol' => $symbol], 0);
  usort($response, 'compare_two');
  $allmarket = array();
  foreach($response as $posit)  {
    $timems = $posit['time'];
    $posit['updateTime'] = (new DateTime(date('m/d/Y H:i:s',intval($posit['updateTime'])/1000)))->format('Y-m-d H:i:s');  
    if($timems > $from){
      if ($posit['origType'] === "MARKET"){
        $posit['price'] = $posit['avgPrice'];
      }else{
        $posit['price'] = $posit['stopPrice'];
      } 
      if($posit['origType'] === 'MARKET'){
        $allmarket[] = $posit;
      }
    }  
  }
  $posit =  end($allmarket);
  print_r($posit);
  print(chr(10));
  $result = [
    "clientOrderId" => $posit['clientOrderId'],
    "side" => $posit['side'],
    "qty" => (string)$posit['origQty']
  ];
  return $result;
}
function getPosition($apiResponse, $symbol){
    $response = $apiResponse->getAccount(['symbol' => $symbol]);
    foreach($response['positions'] as $posit)  {
        if($posit['symbol'] === "DOTUSDT"){
            $date = $posit['updateTime'];
            $entryPrice = $posit['entryPrice'];
            //if(floatval($posit['initialMargin']) > 0){
                $initialm = floatval($posit['initialMargin']);
            //}

          $posit['updateTime'] = (new DateTime(date('m/d/Y H:i:s',intval($posit['updateTime'])/1000)))->format('Y-m-d H:i:s');      
          //print_r($posit);
          print("symbol:" . $posit['symbol'] . " | updateTime:" . $posit['updateTime'] . " | entryPrice:" . $posit['entryPrice'] . 
          " | initialMargin:" . $initialm . " | leverage:" . $posit['leverage'] . " | notional:" . $posit['notional'] . chr(10));
          //print(chr(10));
        }
    }
    if($initialm > 0){
        return ['date' => $date, 'price' => $entryPrice];
    }else{
        return [];
    }
  }
  
function getStatus($apiResponse,$symbol){
$status = 0;
$times = 0;
$initialm = 0;
while(true){
    $result = $apiResponse->getAccount(['symbol' => $symbol], $times);
    if (array_key_exists("totalInitialMargin", $result)) {
        $positions = $result['positions'];
        foreach($positions as $posit)  {
            if($posit['symbol'] === $symbol){
                if(floatval($posit['initialMargin']) > 0){
                    $status = 1;
                    $initialm = floatval($posit['initialMargin']);
                    $breakEvenPrice = $posit['breakEvenPrice'];
                }                
            }
        }                             
        break;
    }else{
        $times = $times + 1;
        if ($times > 5){
            $status = 0;
            $initialm = 0;
            break;
        }
    }
}
return "Status:{$status}, initialMargin:{$initialm}, breakEvenPrice:{$breakEvenPrice}";
}
function delAllOrders($apiResponse,$symbol,$maorder){

    //[entryPrice] => 7.75
    //time: 2024-02-25 12:24:12|orderId: web_st_0qfcqNuVjaIiFrg |status: FILLED|price: 7.7500|origQty: 1|type: MARKET|side: BUY|origType: MARKET
    $times = 0;
    $alldel = false;
    while(true){
        $result = $apiResponse->cancelAllOrders(['symbol' => $symbol],$times);
        if (array_key_exists("symbol", $result)) {
            $alldel = true;
            break;
        }else{
            $times = $times + 1;
            if ($times > 5){
                $alldel= 'false';
                break;
            } 
        }

    }
    $result = createMaOrderForDel($apiResponse,$symbol,$maorder);
    unset($maorder['reduceOnly']);
    return $alldel;
}
function createMaOrderForDel($apiResponse,$symbol,$maorder){
    $times = 0;
    print("cantidad original: {$maorder['quantity']}" .chr(10));
    while(true){
        $result = $apiResponse->createOrder($maorder, $times);
        if (array_key_exists("orderId", $result)) {
            print('para cancelarId: ' . $result['orderId'] . chr(10));
            break;
        }else{
            $times = $times + 1;
            if (array_key_exists("code", $result)) {
                if($result['code'] === -2019 or $result['code'] === -2022 or $result['code'] === -1102){
                    if($maorder['quantity'] <= 0.8){
                        break;
                    }else{
                        $maorder['quantity'] = $maorder['quantity'] - 0.1;
                        print("cantidad actual: {$maorder['quantity']}" .chr(10));
                        break;
                    }

                }else{
                    if ($times > 5){
                        print('error - crear maorder for del' .chr(10)); 
                        break;
                    }
                }
            }else{
                if ($times > 5){
                    print('error - crear maorder for del' .chr(10));
                    break;
                }

            }
        }
    }
    return $times;
}
// **************************** para ejecutar procesos desde de aqui *****************************************
$date = (new DateTime('now'));
print('***** Ahora:' . $date->format('Y-m-d H:i:s') . '*****' .chr(10));
print("---- openOrders ----" . chr(10));
openOrders($apiResponse, $symbol);
print("--- positions ----" . chr(10));
$data = getPosition($apiResponse, $symbol);
print("---- allOrders ----" . chr(10));
$dataorder = allOrders($apiResponse, $symbol, $data);
var_dump($dataorder);
if (array_key_exists('price', $data)) {
    $dataorder = allOrders($apiResponse, $symbol, $data);
    var_dump($dataorder);
    $maorder['newClientOrderId'] = $dataorder["clientOrderId"] . "D";
    $maorder['side'] = $dataorder["side"] === "BUY"?"SELL":"BUY";
    $maorder['quantity'] = $dataorder["qty"];
//var_dump($maorder);
}


print("---- status ----" .chr(10));
$status = getStatus($apiResponse, $symbol, 'USDT');
print($status . chr(10));
//$alldel = delAllOrders($apiResponse, $symbol, $maorder);
//print($alldel . chr(10));
 // **************************** para ejecutar procesos hasta de aqui *****************************************


