<?php
include './vendor/autoload.php';
$settings = require 'settings.php';
$config = $settings['settings']['config'];
use App\ResponseApi;
use App\SetOrdersBuySel;
use App\PivotCalculator;
use App\ATRCalculator;
$apiResponse = new ResponseApi($config);
$symbol = 'DOTUSDT';
$currency = 'USDT';
$interval = '15m';
$factor = 3;
$pd = 14;
$highs = [];
$lows = [];
$closes = [];

$json = $apiResponse->getKlines($interval);    
$pivot_calculator = new PivotCalculator(5,5);
$pivots_low = $pivot_calculator->pivot($json,  'low');
$pivots_high = $pivot_calculator->pivot($json, 'high');
for ($x = 0; $x < count($pivots_high); $x++) {
    print("high:" . $pivots_high[$x] .chr(10));
}
for ($x = 0; $x < count($json)-1; $x++) {
    array_push($highs, $json[$x]["high"]);
    array_push($lows, $json[$x]["low"]);
    array_push($closes, $json[$x]["close"]);
}
$bands = $pivot_calculator->calculate_bands($pivots_high, $pivots_low, $factor, $pd, $highs, $lows, $closes);
print("su:" .count($bands[0]) . " re:". count($bands[1]) . " trend:" .count($bands[2]) . " trail:". count($bands[3]). " closes:". count($bands[4]) . chr(10));

var_dump($bands[2][298] .chr(10));
var_dump($bands[3][298] .chr(10));
var_dump($bands[4][298] .chr(10));
//echo "Upper Band: " . $bands[0] . PHP_EOL;
//echo "Lower Band: " . $bands[1] . PHP_EOL;

?>