<?php
include './vendor/autoload.php';
$settings = require 'settings.php';
$config = $settings['settings']['config'];
use App\ResponseApi;
use App\SetOrdersBuySel;
$apiResponse = new ResponseApi($config);
$symbol = 'DOTUSDT';
$currency = 'USDT';
$interval = '15m';
// Function to calculate the Average True Range (ATR)
function atr(array $prices, int $period)
{
    $atr = [];
    for ($i = 1; $i < count($prices); $i++) {
        $highLow = $prices[$i]['high'] - $prices[$i]['low'];
        $highClose = abs($prices[$i]['high'] - $prices[$i - 1]['close']);
        $lowClose = abs($prices[$i]['low'] - $prices[$i - 1]['close']);
        $trueRange = max($highLow, $highClose, $lowClose);

        if ($i < $period) {
            $atr[] = $trueRange;
        } else {
            $atr[] = ($atr[$i - 1] * ($period - 1) + $trueRange) / $period;
        }
    }
    return $atr;
}

// Function to compute the weighted center
function computeCenter($lastpp, &$center)
{
    if (is_null($lastpp)) return;
    
    if (is_null($center)) {
        $center = $lastpp;
    } else {
        // weighted calculation
        $center = ($center * 2 + $lastpp) / 3;
    }
}

// Configuration settings
$ph = 100.0;
$pl = 90.0;
$highs = [102, 103, 105, 107];
$lows = [95, 96, 94, 93];
$closes = [100, 101, 104, 106];


$Factor = 1.5; // Adjust as needed
$Pd = 14; // Period for ATR calculation
$prices = [ // Sample data structure for prices
    ['high' => 102, 'low' => 95, 'close' => 100],
    ['high' => 103, 'low' => 96, 'close' => 101],
    ['high' => 105, 'low' => 94, 'close' => 104],
    ['high' => 107, 'low' => 93, 'close' => 106],
    // Add more data as required
];
$prices= $apiResponse->getKlines($interval);
$center = null;
$lastpp = !is_null($ph) ? $ph : (!is_null($pl) ? $pl : null);
//var_dump($lastpp);
// Update center value
computeCenter($lastpp, $center);

// Calculate upper and lower bands
if (!is_null($center)) {
    $atrValues = atr($prices, $Pd);
    $lastAtr = end($atrValues);
//var_dump($atrValues);
//var_dump($Factor);
//var_dump($lastAtr);
    $Up = $center - $Factor * $lastAtr;
    $Dn = $center + $Factor * $lastAtr;

    // Print results
    echo "Upper Band: " . $Up . "\n";
    echo "Lower Band: " . $Dn . "\n";
} else {
    echo "Center is undefined.\n";
}
?>