<?php
include './vendor/autoload.php';
$settings = require 'settings.php';
$config = $settings['settings']['config'];
use App\ResponseApi;
use App\SetOrdersBuySel;
$apiResponse = new ResponseApi($config);
$symbol = 'DOTUSDT';
$currency = 'USDT';
$interval = '15m';
class PivotCalculator{

    private $lbl = 1;
    private $lbr = 1;
    public function __construct($LBL, $LBR) {
        $this->lbl = $LBL;
        $this->lbr = $LBR;
    }
    private function checkhl($data_back, $data_forward, $hl) {
        if ($hl == 'high' || $hl == 'High') {
            $ref = $data_back[count($data_back)-1];
            for ($i = 0; $i < count($data_back)-1; $i++) {
                if ($ref < $data_back[$i]) {
                    return 0;
                }
            }
            for ($i = 0; $i < count($data_forward); $i++) {
                if ($ref <= $data_forward[$i]) {
                    return 0;
                }
            }
            return 1;
        }
        if ($hl == 'low' || $hl == 'Low') {
            $ref = $data_back[count($data_back)-1];
            for ($i = 0; $i < count($data_back)-1; $i++) {
                if ($ref > $data_back[$i]) {
                    return 0;
                }
            }
            for ($i = 0; $i < count($data_forward); $i++) {
                if ($ref >= $data_forward[$i]) {
                    return 0;
                }
            }
            return 1;
        }
    }
    public function pivot($osc, $highlow) {
        $left = array();
        $right = array();
        $pivots = array();
        $dateo = array();
        for ($i = 0; $i < count($osc); $i++) {
            $pivots[$i] = 0.000;
           if ($highlow == 'high' || $highlow == 'High'){
                if ($i < $this->lbl + 1) {
                    $left[] = $osc[$i]['high'];
                }
                if ($i > $this->lbl) {
                    $right[] = $osc[$i]['high'];
                }
                if ($i > $this->lbl + $this->lbr) {
                    $left[] = $right[0];
                    array_shift($left);
                    array_shift($right);
                    if ($this->checkhl($left, $right, $highlow)) {
                        $pivots[$i - $this->lbr] = $osc[$i - $this->lbr]['high'];
                        $dateo[$i - $this->lbr] = $osc[$i - $this->lbr]['closeTime'];
                    }
                }
            }else{
                if ($i < $this->lbl + 1) {
                    $left[] = $osc[$i]['low'];
                }
                if ($i > $this->lbl) {
                    $right[] = $osc[$i]['low'];
                }
                if ($i > $this->lbl + $this->lbr) {
                    $left[] = $right[0];
                    array_shift($left);
                    array_shift($right);
                    if ($this->checkhl($left, $right, $highlow)) {
                        $pivots[$i - $this->lbr] = $osc[$i - $this->lbr]['low'];
                        $dateo[$i - $this->lbr] = $osc[$i - $this->lbr]['closeTime'];
                    }
                }
            }
    
        }
        return [$pivots, $dateo];        
    }

}
class ATRCalculator {
    private $period;
    private $tr = null;
    public function __construct($period) {
        $this->period = $period;
    }

    public function updateorg($high, $low, $close) {
        $rtr = null;
        for ($i = 0; $i < count($high); $i++) {
            //if ($i < $this->period) {
                if ($i == 0) {
                    $this->tr[$i] = $high[$i] - $low[$i];
                } else {
                    $previous_close = $close[$i-1];
                    $this->tr[$i] = max($high[$i] - $low[$i], abs($high[$i] - $previous_close), abs($low[$i] - $previous_close));
                }
            /*} else {
                $prev_tr = $this->tr[$i-1];
                $new_tr = max($high[$i] - $low[$i], abs($high[$i] - $close[$i]), abs($low[$i] - $close[$i]));
                $this->tr[$i] = (($prev_tr * ($this->period - 1) + $new_tr) / $this->period);
            }*/
            $nro = $this->tr[$i];
            //$rotr = floatval(intval($this->tr[$i] * 1000))/1000;
            $rotr = round($this->tr[$i],3);
            //print("i:{$i} tr:{$rotr}" .chr(10));
        }
        $atr = trader_ema($this->tr, $this->period);
        print_r($atr);
        print(chr(10));
        return  $this->tr;
    }

    public function update($high, $low, $close) {
        for ($i = 0; $i < count($high); $i++) {
            if ($i == 0) {
                $this->tr[$i] = $high[$i] - $low[$i];
            } else {
                $previous_close = $close[$i-1];
                $this->tr[$i] = max($high[$i] - $low[$i], abs($high[$i] - $previous_close), abs($low[$i] - $previous_close));
            }
        }
        $atr = trader_ema($this->tr, $this->period);
        return  $atr;
    }

    private function mean($array) {
        return array_sum($array) / count($array);
    }
}

function calculate_bands($ph, $pl, $factor, $pd, $highs, $lows, $closes) {
    $center = null;
    $init = 1;
    $re = null;
    $su = null;

    $all_pp = $ph !== null ? $ph : $pl !== null ? $pl : null;
    if ($all_pp !== null) {
        for ($i = 0; $i < count($ph); $i++) {

            if($ph[$i] > 0){
                $last_pp = $ph[$i];
            }elseif($pl[$i] > 0){
                $last_pp = $pl[$i];
            }else{
                $last_pp = 0; 
            }
            // calc center
                // Weighted calculation
                if($last_pp > 0){
                    if($init === 1){
                        $init = 0;
                        $center[$i] = $last_pp;

                    }else{
                        $center[$i] = ($center[$i-1] * 2 + $last_pp) / 3;
                    }
                }else{
                    $center[$i] = $center[$i-1];
                }


            if($i > 0){
                $su[$i] = $pl[$i] !== 0 ? $pl[$i] : $su[$i-1]; 
                $re[$i] = $ph[$i] !== 0 ? $ph[$i] : $re[$i-1];
                if($su[$i] == 0){
                    $su[$i] = $su[$i-1];
                }
                if($re[$i] == 0){
                    $re[$i] = $re[$i-1];
                }             
            }else{
                $su[0] = 0;
                $re[0] = 0;
            }            
            //$cenrou = round($center[$i],3);
            //$center[$i] = $cenrou;

        }
/*
        for ($i = 0; $i < count($pl); $i++) {
            if($i > 0){
                $su[$i] = $pl[$i] !== 0 ? $pl[$i] : $su[$i-1]; 
                $re[$i] = $ph[$i] !== 0 ? $ph[$i] : $re[$i-1];
                if($su[$i] == 0){
                    $su[$i] = $su[$i-1];
                }
                if($re[$i] == 0){
                    $re[$i] = $re[$i-1];
                }             
            }else{
                $su[0] = 0;
                $re[0] = 0;
            }
        }
*/
        $atr_calculator = new ATRCalculator($pd);
        $atr = $atr_calculator->update($highs, $lows, $closes);

        $TUp = null;
        $TDown = null;
        $Trend = null;
        for ($i = 0; $i < count($atr) -1; $i++) {
            if($i < $pd){
                $atr[$i] = $atr[$pd];
            }

            $Up = $center[$i] - ($factor * $atr[$i]);
            $Dn = $center[$i] + ($factor * $atr[$i]);
            $Up = floatval(intval($Up * 1000))/1000;
            $Dn = floatval(intval($Dn * 1000))/1000;
            //echo "Upper Band: " . $Up . PHP_EOL;
            //echo "Lower Band: " . $Dn . PHP_EOL;
            $centr = round($center[$i],3);
            $center[$i] = $centr;
            if($i > 0){

                $TUp[$i] = $closes[$i-1] > $TUp[$i-1] ? max($Up, $TUp[$i-1]) : $Up;
                $TDown[$i] = $closes[$i-1] < $TDown[$i-1] ? min($Dn, $TDown[$i-1]) : $Dn;
                //print("center:" . $center[$i] . " factor:" . $factor . " atr:" . $atr[$i] . " Up:" . $Up . " Dn:" . $Dn . PHP_EOL);
                if($closes[$i] >= $TDown[$i-1]){
                    $Trend[$i] = 1;
                }elseif($closes[$i] <= $TUp[$i-1]){
                    $Trend[$i] = -1;
                }else{
                    $Trend[$i] = $Trend[$i-1];

                }
                //$Trend[$i] = $closes[$i] > $TDown[$i-1] ? 1 : $closes[$i] < $TUp[$i-1] ? -1 : isset($Trend[$i-1]) ? $Trend[$i-1] : 1;
                $Trailingsl[$i] = $Trend[$i] == 1 ? $TUp[$i] : $TDown[$i];
                print("center:" . $center[$i] . " TUp: " . $TUp[$i] . " TDown: " . $TDown[$i] . " close:" . $closes[$i] . " Trailingsl: " 
                . $Trailingsl[$i]. " Trend:" . $Trend[$i] . ($Trend[$i] == 1?" Comprar":" Vender") . PHP_EOL);
            }else{
                $TUp[0] = $Up;
                $TDown[0] = $Dn;
                if($closes[$i] >= $TDown[$i]){
                    $Trend[$i] = 1;
                }elseif($closes[$i] <= $TUp[$i]){
                    $Trend[$i] = -1;
                }
            }

        }
        // get the trend



/*
// get the trend
float TUp = na
float TDown = na
Trend = 0
TUp := close[1] > TUp[1] ? math.max(Up, TUp[1]) : Up
TDown := close[1] < TDown[1] ? math.min(Dn, TDown[1]) : Dn
Trend := close > TDown[1] ? 1 : close < TUp[1] ? -1 : nz(Trend[1], 1)
Trailingsl = Trend == 1 ? TUp : TDown
*/
        //$up = $center - $factor * $atr;
        //$dn = $center + $factor * $atr;

        //return [$up, $dn];
    }
    return [null, null];
}

$factor = 3;
$pd = 14;
//$highs = [102, 103, 105, 107];
//$lows = [95, 96, 94, 93];
//$closes = [100, 101, 104, 106];
$highs = [];
$lows = [];
$closes = [];
$json = $apiResponse->getKlines($interval);    
$pivot_calculator = new PivotCalculator(5,5);
$pivots_low = $pivot_calculator->pivot($json,  'low')[0];
$pivots_high = $pivot_calculator->pivot($json, 'high')[0];
$dateoh = $pivot_calculator->pivot($json,  'high')[1];
$dateol = $pivot_calculator->pivot($json,  'low')[1];
for ($x = 0; $x <= (count($json) -1); $x++) {
    array_push($highs, $json[$x]["high"]);
    array_push($lows, $json[$x]["low"]);
    array_push($closes, $json[$x]["close"]);
}
for ($x = 0; $x <= (count($pivots_high)-1); $x++) {
    if($pivots_high[$x]> 0){
        $date = new \DateTime(date('m/d/Y H:i:s',(intval($dateoh[$x])/1000) + 1));
        $date->setTimeZone(new \DateTimeZone('Europe/Lisbon'));
        $fechaclo = $date->format('Y-m-d H:i:s'); 
        print("fecha:{$fechaclo} high:{$pivots_high[$x]}" .chr(10));
    }
}
for ($x = 0; $x <= (count($pivots_low)-1); $x++) {
    if($pivots_low[$x]> 0){
        $date = new \DateTime(date('m/d/Y H:i:s',(intval($dateol[$x])/1000) + 1));
        $date->setTimeZone(new \DateTimeZone('Europe/Lisbon'));
        $fechaclo = $date->format('Y-m-d H:i:s'); 
        print("fecha:{$fechaclo} low:{$pivots_low[$x]}" .chr(10));
    }
}
$bands = calculate_bands($pivots_high, $pivots_low, $factor, $pd, $highs, $lows, $closes);
//echo "Upper Band: " . $bands[0] . PHP_EOL;
//echo "Lower Band: " . $bands[1] . PHP_EOL;

?>