<?php

function calculateTrend($closes, $Up, $Dn) {
    // Initialize variables
    $TUp = null;
    $TDown = null;
    $Trend = 0;
    $trailingSl = null;

    // Loop through the close prices
    foreach ($closes as $index => $close) {
        // Use previous values for TUp and TDown
        $prevTUp = $index > 0 ? $TUp : null;
        $prevTDown = $index > 0 ? $TDown : null;
        $prevTrend = $index > 0 ? $Trend : 1; // Default to 1 if no previous trend

        // Calculate TUp and TDown
        if ($prevTUp === null || $close > $prevTUp) {
            $TUp = ($prevTUp === null) ? $Up : max($Up, $prevTUp);
        } else {
            $TUp = $prevTUp;
        }

        if ($prevTDown === null || $close < $prevTDown) {
            $TDown = ($prevTDown === null) ? $Dn : min($Dn, $prevTDown);
        } else {
            $TDown = $prevTDown;
        }

        // Calculate Trend
        if ($close > $prevTDown) {
            $Trend = 1;
        } elseif ($close < $prevTUp) {
            $Trend = -1;
        } else {
            $Trend = $prevTrend; // Retain previous trend if within bounds
        }

        // Set trailing stop loss based on trend
        $trailingSl = ($Trend == 1) ? $TUp : $TDown;

        // Print the values for debugging (optional)
        echo "Close: $close, TUp: $TUp, TDown: $TDown, Trend: $Trend, TrailingSL: $trailingSl\n";
    }

    return $trailingSl;
}

// Sample data
$closes = [100, 102, 101, 105, 104, 107, 110];
$Up = 109; // Sample upward threshold
$Dn = 95;  // Sample downward threshold

// Calculate trailing stop loss
$trailingStopLoss = calculateTrend($closes, $Up, $Dn);

?>