<?php
include './vendor/autoload.php';
$settings = require 'settings.php';
$config = $settings['settings']['config'];
use App\ResponseApi;
$apiResponse = new ResponseApi($config);
$pd = 14;
$ba = 5;
$closes = [];
$highs = [];
$lows = [];
function array_key_last(array $arr) {
    $i = 0;
    foreach($arr as $key  => $unused) {
        $i = $i +1;
        //return $key;
    }
    return $key;
}
function array_key_first(array $arr) {
    foreach($arr as $key => $unused) {
        return $key;
    }
    return NULL;
}
// Función para calcular el RSI
function calculateRSI($prices, $period = 14) {
    $gains = [];
    $losses = [];

    // Calcular las ganancias y pérdidas iniciales
    for ($i = 1; $i <= $period; $i++) {
        $change = $prices[$i] - $prices[$i - 1];
        if ($change > 0) {
            $gains[] = $change;
            $losses[] = 0;
        } else {
            $gains[] = 0;
            $losses[] = abs($change);
        }
    }

    // Calcular las ganancias y pérdidas promedio iniciales
    $averageGain = array_sum($gains) / $period;
    $averageLoss = array_sum($losses) / $period;

    // Array para almacenar los valores de RSI
    $rsi = [];
    $rsi[] = 100 - (100 / (1 + ($averageGain / $averageLoss)));

    // Calcular el RSI para el resto de los datos
    for ($i = $period + 1; $i < count($prices); $i++) {
        $change = $prices[$i] - $prices[$i - 1];
        if ($change > 0) {
            $gain = $change;
            $loss = 0;
        } else {
            $gain = 0;
            $loss = abs($change);
        }

        $averageGain = (($averageGain * ($period - 1)) + $gain) / $period;
        $averageLoss = (($averageLoss * ($period - 1)) + $loss) / $period;

        $rs = $averageGain / $averageLoss;
        $rsi[] = 100 - (100 / (1 + $rs));
    }

    return $rsi;
}

// Ejemplo de uso
//$prices = [44, 44.1, 44.3, 44.4, 44.2, 44.5, 44.6, 44.7, 44.8, 44.9, 45, 45.1, 45.2, 45.3, 45.4, 45.5, 45.6, 45.7, 45.8, 45.9];
$json = $apiResponse->getKlines('15m');

for ($x = 0; $x < count($json); $x++) {
    array_push($closes, $json[$x]["close"]);
    array_push($highs, $json[$x]["high"]);
    array_push($lows, $json[$x]["low"]);
}
$allrsi = calculateRSI($closes, 14);
for ($i = array_key_last($allrsi); $i >= array_key_first($allrsi); $i--) {
    $rsi[] = round($allrsi[$i],3);
}
print_r($rsi);
echo  "\n";
?>